/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyRemapAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyRemapAttributes
//
// Purpose: 
//   Atts for Remap operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a RemapAttributes.
//
struct RemapAttributesObject
{
    PyObject_HEAD
    RemapAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewRemapAttributes(int);

std::string
PyRemapAttributes_ToString(const RemapAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetUseExtents())
        SNPRINTF(tmpStr, 1000, "%suseExtents = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseExtents = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartX = %g\n", prefix, atts->GetStartX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendX = %g\n", prefix, atts->GetEndX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scellsX = %d\n", prefix, atts->GetCellsX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartY = %g\n", prefix, atts->GetStartY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendY = %g\n", prefix, atts->GetEndY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scellsY = %d\n", prefix, atts->GetCellsY());
    str += tmpStr;
    if(atts->GetIs3D())
        SNPRINTF(tmpStr, 1000, "%sis3D = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sis3D = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartZ = %g\n", prefix, atts->GetStartZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendZ = %g\n", prefix, atts->GetEndZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scellsZ = %d\n", prefix, atts->GetCellsZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdefaultValue = %g\n", prefix, atts->GetDefaultValue());
    str += tmpStr;
    const char *variableType_names = "intrinsic, extrinsic";
    switch (atts->GetVariableType())
    {
      case RemapAttributes::intrinsic:
          SNPRINTF(tmpStr, 1000, "%svariableType = %sintrinsic  # %s\n", prefix, prefix, variableType_names);
          str += tmpStr;
          break;
      case RemapAttributes::extrinsic:
          SNPRINTF(tmpStr, 1000, "%svariableType = %sextrinsic  # %s\n", prefix, prefix, variableType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
RemapAttributes_Notify(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_SetUseExtents(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useExtents in the object.
    obj->data->SetUseExtents(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetUseExtents(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseExtents()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetStartX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startX in the object.
    obj->data->SetStartX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetStartX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartX());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetEndX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endX in the object.
    obj->data->SetEndX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetEndX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndX());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetCellsX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellsX in the object.
    obj->data->SetCellsX((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetCellsX(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCellsX()));
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetStartY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startY in the object.
    obj->data->SetStartY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetStartY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartY());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetEndY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endY in the object.
    obj->data->SetEndY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetEndY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndY());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetCellsY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellsY in the object.
    obj->data->SetCellsY((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetCellsY(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCellsY()));
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetIs3D(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the is3D in the object.
    obj->data->SetIs3D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetIs3D(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIs3D()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetStartZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the startZ in the object.
    obj->data->SetStartZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetStartZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStartZ());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetEndZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endZ in the object.
    obj->data->SetEndZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetEndZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndZ());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetCellsZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellsZ in the object.
    obj->data->SetCellsZ((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetCellsZ(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCellsZ()));
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetDefaultValue(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the defaultValue in the object.
    obj->data->SetDefaultValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetDefaultValue(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDefaultValue());
    return retval;
}

/*static*/ PyObject *
RemapAttributes_SetVariableType(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the variableType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetVariableType(RemapAttributes::VariableTypes(ival));
    else
    {
        fprintf(stderr, "An invalid variableType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "intrinsic, extrinsic.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemapAttributes_GetVariableType(PyObject *self, PyObject *args)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVariableType()));
    return retval;
}



PyMethodDef PyRemapAttributes_methods[REMAPATTRIBUTES_NMETH] = {
    {"Notify", RemapAttributes_Notify, METH_VARARGS},
    {"SetUseExtents", RemapAttributes_SetUseExtents, METH_VARARGS},
    {"GetUseExtents", RemapAttributes_GetUseExtents, METH_VARARGS},
    {"SetStartX", RemapAttributes_SetStartX, METH_VARARGS},
    {"GetStartX", RemapAttributes_GetStartX, METH_VARARGS},
    {"SetEndX", RemapAttributes_SetEndX, METH_VARARGS},
    {"GetEndX", RemapAttributes_GetEndX, METH_VARARGS},
    {"SetCellsX", RemapAttributes_SetCellsX, METH_VARARGS},
    {"GetCellsX", RemapAttributes_GetCellsX, METH_VARARGS},
    {"SetStartY", RemapAttributes_SetStartY, METH_VARARGS},
    {"GetStartY", RemapAttributes_GetStartY, METH_VARARGS},
    {"SetEndY", RemapAttributes_SetEndY, METH_VARARGS},
    {"GetEndY", RemapAttributes_GetEndY, METH_VARARGS},
    {"SetCellsY", RemapAttributes_SetCellsY, METH_VARARGS},
    {"GetCellsY", RemapAttributes_GetCellsY, METH_VARARGS},
    {"SetIs3D", RemapAttributes_SetIs3D, METH_VARARGS},
    {"GetIs3D", RemapAttributes_GetIs3D, METH_VARARGS},
    {"SetStartZ", RemapAttributes_SetStartZ, METH_VARARGS},
    {"GetStartZ", RemapAttributes_GetStartZ, METH_VARARGS},
    {"SetEndZ", RemapAttributes_SetEndZ, METH_VARARGS},
    {"GetEndZ", RemapAttributes_GetEndZ, METH_VARARGS},
    {"SetCellsZ", RemapAttributes_SetCellsZ, METH_VARARGS},
    {"GetCellsZ", RemapAttributes_GetCellsZ, METH_VARARGS},
    {"SetDefaultValue", RemapAttributes_SetDefaultValue, METH_VARARGS},
    {"GetDefaultValue", RemapAttributes_GetDefaultValue, METH_VARARGS},
    {"SetVariableType", RemapAttributes_SetVariableType, METH_VARARGS},
    {"GetVariableType", RemapAttributes_GetVariableType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RemapAttributes_dealloc(PyObject *v)
{
   RemapAttributesObject *obj = (RemapAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
RemapAttributes_compare(PyObject *v, PyObject *w)
{
    RemapAttributes *a = ((RemapAttributesObject *)v)->data;
    RemapAttributes *b = ((RemapAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyRemapAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useExtents") == 0)
        return RemapAttributes_GetUseExtents(self, NULL);
    if(strcmp(name, "startX") == 0)
        return RemapAttributes_GetStartX(self, NULL);
    if(strcmp(name, "endX") == 0)
        return RemapAttributes_GetEndX(self, NULL);
    if(strcmp(name, "cellsX") == 0)
        return RemapAttributes_GetCellsX(self, NULL);
    if(strcmp(name, "startY") == 0)
        return RemapAttributes_GetStartY(self, NULL);
    if(strcmp(name, "endY") == 0)
        return RemapAttributes_GetEndY(self, NULL);
    if(strcmp(name, "cellsY") == 0)
        return RemapAttributes_GetCellsY(self, NULL);
    if(strcmp(name, "is3D") == 0)
        return RemapAttributes_GetIs3D(self, NULL);
    if(strcmp(name, "startZ") == 0)
        return RemapAttributes_GetStartZ(self, NULL);
    if(strcmp(name, "endZ") == 0)
        return RemapAttributes_GetEndZ(self, NULL);
    if(strcmp(name, "cellsZ") == 0)
        return RemapAttributes_GetCellsZ(self, NULL);
    if(strcmp(name, "defaultValue") == 0)
        return RemapAttributes_GetDefaultValue(self, NULL);
    if(strcmp(name, "variableType") == 0)
        return RemapAttributes_GetVariableType(self, NULL);
    if(strcmp(name, "intrinsic") == 0)
        return PyInt_FromLong(long(RemapAttributes::intrinsic));
    if(strcmp(name, "extrinsic") == 0)
        return PyInt_FromLong(long(RemapAttributes::extrinsic));


    return Py_FindMethod(PyRemapAttributes_methods, self, name);
}

int
PyRemapAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "useExtents") == 0)
        obj = RemapAttributes_SetUseExtents(self, tuple);
    else if(strcmp(name, "startX") == 0)
        obj = RemapAttributes_SetStartX(self, tuple);
    else if(strcmp(name, "endX") == 0)
        obj = RemapAttributes_SetEndX(self, tuple);
    else if(strcmp(name, "cellsX") == 0)
        obj = RemapAttributes_SetCellsX(self, tuple);
    else if(strcmp(name, "startY") == 0)
        obj = RemapAttributes_SetStartY(self, tuple);
    else if(strcmp(name, "endY") == 0)
        obj = RemapAttributes_SetEndY(self, tuple);
    else if(strcmp(name, "cellsY") == 0)
        obj = RemapAttributes_SetCellsY(self, tuple);
    else if(strcmp(name, "is3D") == 0)
        obj = RemapAttributes_SetIs3D(self, tuple);
    else if(strcmp(name, "startZ") == 0)
        obj = RemapAttributes_SetStartZ(self, tuple);
    else if(strcmp(name, "endZ") == 0)
        obj = RemapAttributes_SetEndZ(self, tuple);
    else if(strcmp(name, "cellsZ") == 0)
        obj = RemapAttributes_SetCellsZ(self, tuple);
    else if(strcmp(name, "defaultValue") == 0)
        obj = RemapAttributes_SetDefaultValue(self, tuple);
    else if(strcmp(name, "variableType") == 0)
        obj = RemapAttributes_SetVariableType(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
RemapAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)v;
    fprintf(fp, "%s", PyRemapAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
RemapAttributes_str(PyObject *v)
{
    RemapAttributesObject *obj = (RemapAttributesObject *)v;
    return PyString_FromString(PyRemapAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *RemapAttributes_Purpose = "Atts for Remap operator";
#else
static char *RemapAttributes_Purpose = "Atts for Remap operator";
#endif

//
// The type description structure
//
static PyTypeObject RemapAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RemapAttributes",                    // tp_name
    sizeof(RemapAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RemapAttributes_dealloc,  // tp_dealloc
    (printfunc)RemapAttributes_print,     // tp_print
    (getattrfunc)PyRemapAttributes_getattr, // tp_getattr
    (setattrfunc)PyRemapAttributes_setattr, // tp_setattr
    (cmpfunc)RemapAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RemapAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RemapAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RemapAttributes *defaultAtts = 0;
static RemapAttributes *currentAtts = 0;

static PyObject *
NewRemapAttributes(int useCurrent)
{
    RemapAttributesObject *newObject;
    newObject = PyObject_NEW(RemapAttributesObject, &RemapAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new RemapAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new RemapAttributes(*defaultAtts);
    else
        newObject->data = new RemapAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapRemapAttributes(const RemapAttributes *attr)
{
    RemapAttributesObject *newObject;
    newObject = PyObject_NEW(RemapAttributesObject, &RemapAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RemapAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RemapAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewRemapAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RemapAttributesMethods[] = {
    {"RemapAttributes", RemapAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RemapAttributesObserver = 0;

std::string
PyRemapAttributes_GetLogString()
{
    std::string s("RemapAtts = RemapAttributes()\n");
    if(currentAtts != 0)
        s += PyRemapAttributes_ToString(currentAtts, "RemapAtts.");
    return s;
}

static void
PyRemapAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("RemapAtts = RemapAttributes()\n");
        s += PyRemapAttributes_ToString(currentAtts, "RemapAtts.");
        cb(s);
    }
}

void
PyRemapAttributes_StartUp(RemapAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyRemapAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RemapAttributesObserver == 0)
    {
        RemapAttributesObserver = new ObserverToCallback(subj,
            PyRemapAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyRemapAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RemapAttributesObserver;
    RemapAttributesObserver = 0;
}

PyMethodDef *
PyRemapAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RemapAttributesMethods;
}

bool
PyRemapAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RemapAttributesType);
}

RemapAttributes *
PyRemapAttributes_FromPyObject(PyObject *obj)
{
    RemapAttributesObject *obj2 = (RemapAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRemapAttributes_New()
{
    return NewRemapAttributes(0);
}

PyObject *
PyRemapAttributes_Wrap(const RemapAttributes *attr)
{
    return WrapRemapAttributes(attr);
}

void
PyRemapAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    RemapAttributesObject *obj2 = (RemapAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyRemapAttributes_SetDefaults(const RemapAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RemapAttributes(*atts);
}

