/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ProjectAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ProjectAttributes::ProjectionType
//

static const char *ProjectionType_strings[] = {
"ZYCartesian", "XZCartesian", "XYCartesian", 
"XRCylindrical", "YRCylindrical", "ZRCylindrical"
};

std::string
ProjectAttributes::ProjectionType_ToString(ProjectAttributes::ProjectionType t)
{
    int index = int(t);
    if(index < 0 || index >= 6) index = 0;
    return ProjectionType_strings[index];
}

std::string
ProjectAttributes::ProjectionType_ToString(int t)
{
    int index = (t < 0 || t >= 6) ? 0 : t;
    return ProjectionType_strings[index];
}

bool
ProjectAttributes::ProjectionType_FromString(const std::string &s, ProjectAttributes::ProjectionType &val)
{
    val = ProjectAttributes::ZYCartesian;
    for(int i = 0; i < 6; ++i)
    {
        if(s == ProjectionType_strings[i])
        {
            val = (ProjectionType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ProjectAttributes::VectorTransformMethod
//

static const char *VectorTransformMethod_strings[] = {
"None", "AsPoint", "AsDisplacement", 
"AsDirection"};

std::string
ProjectAttributes::VectorTransformMethod_ToString(ProjectAttributes::VectorTransformMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return VectorTransformMethod_strings[index];
}

std::string
ProjectAttributes::VectorTransformMethod_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return VectorTransformMethod_strings[index];
}

bool
ProjectAttributes::VectorTransformMethod_FromString(const std::string &s, ProjectAttributes::VectorTransformMethod &val)
{
    val = ProjectAttributes::None;
    for(int i = 0; i < 4; ++i)
    {
        if(s == VectorTransformMethod_strings[i])
        {
            val = (VectorTransformMethod)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Init utility for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProjectAttributes::Init()
{
    projectionType = XYCartesian;
    vectorTransformMethod = AsDirection;

    ProjectAttributes::SelectAll();
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Copy utility for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ProjectAttributes::Copy(const ProjectAttributes &obj)
{
    projectionType = obj.projectionType;
    vectorTransformMethod = obj.vectorTransformMethod;

    ProjectAttributes::SelectAll();
}

// Type map format string
const char *ProjectAttributes::TypeMapFormatString = PROJECTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ProjectAttributes::TmfsStruct = {PROJECTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Default constructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes() : 
    AttributeSubject(ProjectAttributes::TypeMapFormatString)
{
    ProjectAttributes::Init();
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Constructor for the derived classes of ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProjectAttributes::Init();
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Copy constructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes(const ProjectAttributes &obj) : 
    AttributeSubject(ProjectAttributes::TypeMapFormatString)
{
    ProjectAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProjectAttributes::ProjectAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::ProjectAttributes(const ProjectAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ProjectAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ProjectAttributes::~ProjectAttributes
//
// Purpose: 
//   Destructor for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes::~ProjectAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ProjectAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ProjectAttributes& 
ProjectAttributes::operator = (const ProjectAttributes &obj)
{
    if (this == &obj) return *this;

    ProjectAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ProjectAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::operator == (const ProjectAttributes &obj) const
{
    // Create the return value
    return ((projectionType == obj.projectionType) &&
            (vectorTransformMethod == obj.vectorTransformMethod));
}

// ****************************************************************************
// Method: ProjectAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::operator != (const ProjectAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ProjectAttributes::TypeName
//
// Purpose: 
//   Type name method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ProjectAttributes::TypeName() const
{
    return "ProjectAttributes";
}

// ****************************************************************************
// Method: ProjectAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ProjectAttributes *tmp = (const ProjectAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ProjectAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProjectAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ProjectAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ProjectAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ProjectAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ProjectAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ProjectAttributes(*this);
    else
        retval = new ProjectAttributes;

    return retval;
}

// ****************************************************************************
// Method: ProjectAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ProjectAttributes::SelectAll()
{
    Select(ID_projectionType,        (void *)&projectionType);
    Select(ID_vectorTransformMethod, (void *)&vectorTransformMethod);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProjectAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ProjectAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ProjectAttributes.
    DataNode *node = new DataNode("ProjectAttributes");

    if(completeSave || !FieldsEqual(ID_projectionType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("projectionType", ProjectionType_ToString(projectionType)));
    }

    if(completeSave || !FieldsEqual(ID_vectorTransformMethod, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("vectorTransformMethod", VectorTransformMethod_ToString(vectorTransformMethod)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ProjectAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ProjectAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ProjectAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("projectionType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 6)
                SetProjectionType(ProjectionType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ProjectionType value;
            if(ProjectionType_FromString(node->AsString(), value))
                SetProjectionType(value);
        }
    }
    if((node = searchNode->GetNode("vectorTransformMethod")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetVectorTransformMethod(VectorTransformMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            VectorTransformMethod value;
            if(VectorTransformMethod_FromString(node->AsString(), value))
                SetVectorTransformMethod(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ProjectAttributes::SetProjectionType(ProjectAttributes::ProjectionType projectionType_)
{
    projectionType = projectionType_;
    Select(ID_projectionType, (void *)&projectionType);
}

void
ProjectAttributes::SetVectorTransformMethod(ProjectAttributes::VectorTransformMethod vectorTransformMethod_)
{
    vectorTransformMethod = vectorTransformMethod_;
    Select(ID_vectorTransformMethod, (void *)&vectorTransformMethod);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ProjectAttributes::ProjectionType
ProjectAttributes::GetProjectionType() const
{
    return ProjectionType(projectionType);
}

ProjectAttributes::VectorTransformMethod
ProjectAttributes::GetVectorTransformMethod() const
{
    return VectorTransformMethod(vectorTransformMethod);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ProjectAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProjectAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_projectionType:        return "projectionType";
    case ID_vectorTransformMethod: return "vectorTransformMethod";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProjectAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ProjectAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_projectionType:        return FieldType_enum;
    case ID_vectorTransformMethod: return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ProjectAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ProjectAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_projectionType:        return "enum";
    case ID_vectorTransformMethod: return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ProjectAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ProjectAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ProjectAttributes &obj = *((const ProjectAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_projectionType:
        {  // new scope
        retval = (projectionType == obj.projectionType);
        }
        break;
    case ID_vectorTransformMethod:
        {  // new scope
        retval = (vectorTransformMethod == obj.vectorTransformMethod);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

