/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LineoutAttributes.h>
#include <DataNode.h>
#include <Line.h>
#include <GlobalLineoutAttributes.h>

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Init utility for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LineoutAttributes::Init()
{
    point1[0] = 0;
    point1[1] = 0;
    point1[2] = 0;
    point2[0] = 1;
    point2[1] = 1;
    point2[2] = 0;
    interactive = false;
    ignoreGlobal = false;
    samplingOn = false;
    numberOfSamplePoints = 50;
    reflineLabels = false;

    LineoutAttributes::SelectAll();
}

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Copy utility for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LineoutAttributes::Copy(const LineoutAttributes &obj)
{
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];

    interactive = obj.interactive;
    ignoreGlobal = obj.ignoreGlobal;
    samplingOn = obj.samplingOn;
    numberOfSamplePoints = obj.numberOfSamplePoints;
    reflineLabels = obj.reflineLabels;
    designator = obj.designator;

    LineoutAttributes::SelectAll();
}

// Type map format string
const char *LineoutAttributes::TypeMapFormatString = LINEOUTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t LineoutAttributes::TmfsStruct = {LINEOUTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Default constructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes() : 
    AttributeSubject(LineoutAttributes::TypeMapFormatString)
{
    LineoutAttributes::Init();
}

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Constructor for the derived classes of LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LineoutAttributes::Init();
}

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Copy constructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes(const LineoutAttributes &obj) : 
    AttributeSubject(LineoutAttributes::TypeMapFormatString)
{
    LineoutAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LineoutAttributes::LineoutAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::LineoutAttributes(const LineoutAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LineoutAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LineoutAttributes::~LineoutAttributes
//
// Purpose: 
//   Destructor for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes::~LineoutAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LineoutAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineoutAttributes& 
LineoutAttributes::operator = (const LineoutAttributes &obj)
{
    if (this == &obj) return *this;

    LineoutAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LineoutAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::operator == (const LineoutAttributes &obj) const
{
    // Compare the point1 arrays.
    bool point1_equal = true;
    for(int i = 0; i < 3 && point1_equal; ++i)
        point1_equal = (point1[i] == obj.point1[i]);

    // Compare the point2 arrays.
    bool point2_equal = true;
    for(int i = 0; i < 3 && point2_equal; ++i)
        point2_equal = (point2[i] == obj.point2[i]);

    // Create the return value
    return (point1_equal &&
            point2_equal &&
            (interactive == obj.interactive) &&
            (ignoreGlobal == obj.ignoreGlobal) &&
            (samplingOn == obj.samplingOn) &&
            (numberOfSamplePoints == obj.numberOfSamplePoints) &&
            (reflineLabels == obj.reflineLabels) &&
            (designator == obj.designator));
}

// ****************************************************************************
// Method: LineoutAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::operator != (const LineoutAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LineoutAttributes::TypeName
//
// Purpose: 
//   Type name method for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LineoutAttributes::TypeName() const
{
    return "LineoutAttributes";
}

// ****************************************************************************
//
// Modifications:
//   Kathleen Bonnell, Thu Nov 18 17:46:02 PST 2004
//   Copy ReflineLabels.
//
//   Kathleen Bonnell, Tue Nov 23 09:19:32 PST 2004
//   Added ability to copy GlobalLineoutAttributes, as long as we aren't
//   ignoring them. 
//
//   Kathleen Bonnell, Tue May 15 14:22:23 PDT 2007 
//   Allow Line to copy SamplingOn. 
//
// ****************************************************************************
bool
LineoutAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const LineoutAttributes *tmp = (const LineoutAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "Line")
    {
        const Line *tmp = (const Line*)atts;
        SetPoint1(tmp->GetPoint1());
        SetPoint2(tmp->GetPoint2());
        SetDesignator(tmp->GetDesignator());
        SetNumberOfSamplePoints(tmp->GetNumSamples());
        SetSamplingOn(GetSamplingOn() || tmp->GetSamplingOn());
        retval = true;
    }
    else if(atts->TypeName() == "GlobalLineoutAttributes")
    {
        if (!ignoreGlobal)
        {
            const GlobalLineoutAttributes *tmp = 
                   (const GlobalLineoutAttributes*)atts;
            SetReflineLabels(tmp->GetCreateReflineLabels());
            SetSamplingOn(tmp->GetSamplingOn());
            SetNumberOfSamplePoints(tmp->GetNumSamples());
            retval = true;
        }
    }

    return retval;
}

AttributeSubject *
LineoutAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new LineoutAttributes(*this);
    }
    else if(tname == "Line")
    {
        Line *line = new Line;

        line->SetPoint1(GetPoint1());
        line->SetPoint2(GetPoint2());
        line->SetInteractive(GetInteractive());
        line->SetReflineLabels(GetReflineLabels());
        line->SetDesignator(GetDesignator());
        line->SetSamplingOn(GetSamplingOn());
        line->SetNumSamples(GetNumberOfSamplePoints());
        retval = line;
    }

    return retval;
}

// ****************************************************************************
// Method: LineoutAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LineoutAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LineoutAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LineoutAttributes(*this);
    else
        retval = new LineoutAttributes;

    return retval;
}

// ****************************************************************************
// Method: LineoutAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LineoutAttributes::SelectAll()
{
    Select(ID_point1,               (void *)point1, 3);
    Select(ID_point2,               (void *)point2, 3);
    Select(ID_interactive,          (void *)&interactive);
    Select(ID_ignoreGlobal,         (void *)&ignoreGlobal);
    Select(ID_samplingOn,           (void *)&samplingOn);
    Select(ID_numberOfSamplePoints, (void *)&numberOfSamplePoints);
    Select(ID_reflineLabels,        (void *)&reflineLabels);
    Select(ID_designator,           (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineoutAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LineoutAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LineoutAttributes.
    DataNode *node = new DataNode("LineoutAttributes");

    if(completeSave || !FieldsEqual(ID_point1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point1", point1, 3));
    }

    if(completeSave || !FieldsEqual(ID_point2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point2", point2, 3));
    }

    if(completeSave || !FieldsEqual(ID_interactive, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }

    if(completeSave || !FieldsEqual(ID_ignoreGlobal, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ignoreGlobal", ignoreGlobal));
    }

    if(completeSave || !FieldsEqual(ID_samplingOn, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("samplingOn", samplingOn));
    }

    if(completeSave || !FieldsEqual(ID_numberOfSamplePoints, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numberOfSamplePoints", numberOfSamplePoints));
    }

    if(completeSave || !FieldsEqual(ID_reflineLabels, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("reflineLabels", reflineLabels));
    }

    if(completeSave || !FieldsEqual(ID_designator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LineoutAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LineoutAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LineoutAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("point1")) != 0)
        SetPoint1(node->AsDoubleArray());
    if((node = searchNode->GetNode("point2")) != 0)
        SetPoint2(node->AsDoubleArray());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
    if((node = searchNode->GetNode("ignoreGlobal")) != 0)
        SetIgnoreGlobal(node->AsBool());
    if((node = searchNode->GetNode("samplingOn")) != 0)
        SetSamplingOn(node->AsBool());
    if((node = searchNode->GetNode("numberOfSamplePoints")) != 0)
        SetNumberOfSamplePoints(node->AsInt());
    if((node = searchNode->GetNode("reflineLabels")) != 0)
        SetReflineLabels(node->AsBool());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::SetPoint1(const double *point1_)
{
    point1[0] = point1_[0];
    point1[1] = point1_[1];
    point1[2] = point1_[2];
    Select(ID_point1, (void *)point1, 3);
}

void
LineoutAttributes::SetPoint2(const double *point2_)
{
    point2[0] = point2_[0];
    point2[1] = point2_[1];
    point2[2] = point2_[2];
    Select(ID_point2, (void *)point2, 3);
}

void
LineoutAttributes::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(ID_interactive, (void *)&interactive);
}

void
LineoutAttributes::SetIgnoreGlobal(bool ignoreGlobal_)
{
    ignoreGlobal = ignoreGlobal_;
    Select(ID_ignoreGlobal, (void *)&ignoreGlobal);
}

void
LineoutAttributes::SetSamplingOn(bool samplingOn_)
{
    samplingOn = samplingOn_;
    Select(ID_samplingOn, (void *)&samplingOn);
}

void
LineoutAttributes::SetNumberOfSamplePoints(int numberOfSamplePoints_)
{
    numberOfSamplePoints = numberOfSamplePoints_;
    Select(ID_numberOfSamplePoints, (void *)&numberOfSamplePoints);
}

void
LineoutAttributes::SetReflineLabels(bool reflineLabels_)
{
    reflineLabels = reflineLabels_;
    Select(ID_reflineLabels, (void *)&reflineLabels);
}

void
LineoutAttributes::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(ID_designator, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
LineoutAttributes::GetPoint1() const
{
    return point1;
}

double *
LineoutAttributes::GetPoint1()
{
    return point1;
}

const double *
LineoutAttributes::GetPoint2() const
{
    return point2;
}

double *
LineoutAttributes::GetPoint2()
{
    return point2;
}

bool
LineoutAttributes::GetInteractive() const
{
    return interactive;
}

bool
LineoutAttributes::GetIgnoreGlobal() const
{
    return ignoreGlobal;
}

bool
LineoutAttributes::GetSamplingOn() const
{
    return samplingOn;
}

int
LineoutAttributes::GetNumberOfSamplePoints() const
{
    return numberOfSamplePoints;
}

bool
LineoutAttributes::GetReflineLabels() const
{
    return reflineLabels;
}

const std::string &
LineoutAttributes::GetDesignator() const
{
    return designator;
}

std::string &
LineoutAttributes::GetDesignator()
{
    return designator;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::SelectPoint1()
{
    Select(ID_point1, (void *)point1, 3);
}

void
LineoutAttributes::SelectPoint2()
{
    Select(ID_point2, (void *)point2, 3);
}

void
LineoutAttributes::SelectDesignator()
{
    Select(ID_designator, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineoutAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LineoutAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_point1:               return "point1";
    case ID_point2:               return "point2";
    case ID_interactive:          return "interactive";
    case ID_ignoreGlobal:         return "ignoreGlobal";
    case ID_samplingOn:           return "samplingOn";
    case ID_numberOfSamplePoints: return "numberOfSamplePoints";
    case ID_reflineLabels:        return "reflineLabels";
    case ID_designator:           return "designator";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineoutAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LineoutAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_point1:               return FieldType_doubleArray;
    case ID_point2:               return FieldType_doubleArray;
    case ID_interactive:          return FieldType_bool;
    case ID_ignoreGlobal:         return FieldType_bool;
    case ID_samplingOn:           return FieldType_bool;
    case ID_numberOfSamplePoints: return FieldType_int;
    case ID_reflineLabels:        return FieldType_bool;
    case ID_designator:           return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LineoutAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LineoutAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_point1:               return "doubleArray";
    case ID_point2:               return "doubleArray";
    case ID_interactive:          return "bool";
    case ID_ignoreGlobal:         return "bool";
    case ID_samplingOn:           return "bool";
    case ID_numberOfSamplePoints: return "int";
    case ID_reflineLabels:        return "bool";
    case ID_designator:           return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineoutAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineoutAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LineoutAttributes &obj = *((const LineoutAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_point1:
        {  // new scope
        // Compare the point1 arrays.
        bool point1_equal = true;
        for(int i = 0; i < 3 && point1_equal; ++i)
            point1_equal = (point1[i] == obj.point1[i]);

        retval = point1_equal;
        }
        break;
    case ID_point2:
        {  // new scope
        // Compare the point2 arrays.
        bool point2_equal = true;
        for(int i = 0; i < 3 && point2_equal; ++i)
            point2_equal = (point2[i] == obj.point2[i]);

        retval = point2_equal;
        }
        break;
    case ID_interactive:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    case ID_ignoreGlobal:
        {  // new scope
        retval = (ignoreGlobal == obj.ignoreGlobal);
        }
        break;
    case ID_samplingOn:
        {  // new scope
        retval = (samplingOn == obj.samplingOn);
        }
        break;
    case ID_numberOfSamplePoints:
        {  // new scope
        retval = (numberOfSamplePoints == obj.numberOfSamplePoints);
        }
        break;
    case ID_reflineLabels:
        {  // new scope
        retval = (reflineLabels == obj.reflineLabels);
        }
        break;
    case ID_designator:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
LineoutAttributes::Print(ostream &out, bool selected_only) const
{
    out << "LineoutAttributes" << "\n";
    out << "{";
    const double *pt;
    int i;
    for(i = 0; i < NumAttributes(); ++i)
    {
        if(selected_only && !IsSelected(i))
            continue;

        switch(i)
        {
          case  0: pt = GetPoint1();
                   out << "point1=" << pt[0] << " " 
                                    << pt[1] << " "
                                    << pt[2] << endl;          break;
          case  1: pt = GetPoint2();
                   out << "point2=" << pt[0] << " " 
                                    << pt[1] << " "
                                    << pt[2] << endl;          break;
          case  2: out << "sampling on? " << GetSamplingOn();  break;
          case  3: out << "numberOfSamplePoints=" 
                       << GetNumberOfSamplePoints();    break;
        }
        out << ",";
    }

    out << "}";

}

