/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisContextWindow.h"

#include <ContextAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisContextWindow::QvisContextWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisContextWindow::QvisContextWindow(const int type,
                         ContextAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisContextWindow::~QvisContextWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisContextWindow::~QvisContextWindow()
{
}


// ****************************************************************************
// Method: QvisContextWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisContextWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    offsetLabel = new QLabel(tr("Offset the primary variable by "), central);
    mainLayout->addWidget(offsetLabel,0,0);
    offset = new QLineEdit(central);
    connect(offset, SIGNAL(returnPressed()),
            this, SLOT(offsetProcessText()));
    mainLayout->addWidget(offset, 0,1);

    lowLabel = new QLabel(tr("Use the primary variable if it is above "), central);
    mainLayout->addWidget(lowLabel,1,0);
    low = new QLineEdit(central);
    connect(low, SIGNAL(returnPressed()),
            this, SLOT(lowProcessText()));
    mainLayout->addWidget(low, 1,1);

    hiLabel = new QLabel(tr("Use the primary variable if it is below "), central);
    mainLayout->addWidget(hiLabel,2,0);
    hi = new QLineEdit(central);
    connect(hi, SIGNAL(returnPressed()),
            this, SLOT(hiProcessText()));
    mainLayout->addWidget(hi, 2,1);

    contextLabel = new QLabel(tr("Context Variable"), central);
    mainLayout->addWidget(contextLabel,3,0);
    int contextMask = QvisVariableButton::Scalars;
    context = new QvisVariableButton(true, true, true, contextMask, central);
    connect(context, SIGNAL(activated(const QString&)),
            this, SLOT(contextChanged(const QString&)));
    mainLayout->addWidget(context, 3,1);

    cutoffLabel = new QLabel(tr("Cutoff for context variable"), central);
    mainLayout->addWidget(cutoffLabel,4,0);
    cutoff = new QLineEdit(central);
    connect(cutoff, SIGNAL(returnPressed()),
            this, SLOT(cutoffProcessText()));
    mainLayout->addWidget(cutoff, 4,1);

    belowLabel = new QLabel(tr("Map values below the cutoff to "), central);
    mainLayout->addWidget(belowLabel,5,0);
    below = new QLineEdit(central);
    connect(below, SIGNAL(returnPressed()),
            this, SLOT(belowProcessText()));
    mainLayout->addWidget(below, 5,1);

    aboveLabel = new QLabel(tr("Map values above the cutoff to "), central);
    mainLayout->addWidget(aboveLabel,6,0);
    above = new QLineEdit(central);
    connect(above, SIGNAL(returnPressed()),
            this, SLOT(aboveProcessText()));
    mainLayout->addWidget(above, 6,1);

}


// ****************************************************************************
// Method: QvisContextWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisContextWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ContextAttributes::ID_offset:
            offset->setText(DoubleToQString(atts->GetOffset()));
            break;
          case ContextAttributes::ID_low:
            low->setText(DoubleToQString(atts->GetLow()));
            break;
          case ContextAttributes::ID_hi:
            hi->setText(DoubleToQString(atts->GetHi()));
            break;
          case ContextAttributes::ID_context:
            context->blockSignals(true);
            context->setText(QString(atts->GetContext().c_str()));
            context->blockSignals(false);
            break;
          case ContextAttributes::ID_cutoff:
            cutoff->setText(DoubleToQString(atts->GetCutoff()));
            break;
          case ContextAttributes::ID_below:
            below->setText(DoubleToQString(atts->GetBelow()));
            break;
          case ContextAttributes::ID_above:
            above->setText(DoubleToQString(atts->GetAbove()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisContextWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisContextWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);
    QString msg, temp;

    // Do offset
    if(which_widget == ContextAttributes::ID_offset || doAll)
    {
        double val;
        if(LineEditGetDouble(offset, val))
            atts->SetOffset(val);
        else
        {
            ResettingError(tr("Offset the primary variable by "),
                DoubleToQString(atts->GetOffset()));
            atts->SetOffset(atts->GetOffset());
        }
    }

    // Do low
    if(which_widget == ContextAttributes::ID_low || doAll)
    {
        double val;
        if(LineEditGetDouble(low, val))
            atts->SetLow(val);
        else
        {
            ResettingError(tr("Use the primary variable if it is above "),
                DoubleToQString(atts->GetLow()));
            atts->SetLow(atts->GetLow());
        }
    }

    // Do hi
    if(which_widget == ContextAttributes::ID_hi || doAll)
    {
        double val;
        if(LineEditGetDouble(hi, val))
            atts->SetHi(val);
        else
        {
            ResettingError(tr("Use the primary variable if it is below "),
                DoubleToQString(atts->GetHi()));
            atts->SetHi(atts->GetHi());
        }
    }

    // Do cutoff
    if(which_widget == ContextAttributes::ID_cutoff || doAll)
    {
        double val;
        if(LineEditGetDouble(cutoff, val))
            atts->SetCutoff(val);
        else
        {
            ResettingError(tr("Cutoff for context variable"),
                DoubleToQString(atts->GetCutoff()));
            atts->SetCutoff(atts->GetCutoff());
        }
    }

    // Do below
    if(which_widget == ContextAttributes::ID_below || doAll)
    {
        double val;
        if(LineEditGetDouble(below, val))
            atts->SetBelow(val);
        else
        {
            ResettingError(tr("Map values below the cutoff to "),
                DoubleToQString(atts->GetBelow()));
            atts->SetBelow(atts->GetBelow());
        }
    }

    // Do above
    if(which_widget == ContextAttributes::ID_above || doAll)
    {
        double val;
        if(LineEditGetDouble(above, val))
            atts->SetAbove(val);
        else
        {
            ResettingError(tr("Map values above the cutoff to "),
                DoubleToQString(atts->GetAbove()));
            atts->SetAbove(atts->GetAbove());
        }
    }

}


//
// Qt Slot functions
//


void
QvisContextWindow::offsetProcessText()
{
    GetCurrentValues(ContextAttributes::ID_offset);
    Apply();
}


void
QvisContextWindow::lowProcessText()
{
    GetCurrentValues(ContextAttributes::ID_low);
    Apply();
}


void
QvisContextWindow::hiProcessText()
{
    GetCurrentValues(ContextAttributes::ID_hi);
    Apply();
}


void
QvisContextWindow::contextChanged(const QString &varName)
{
    atts->SetContext(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisContextWindow::cutoffProcessText()
{
    GetCurrentValues(ContextAttributes::ID_cutoff);
    Apply();
}


void
QvisContextWindow::belowProcessText()
{
    GetCurrentValues(ContextAttributes::ID_below);
    Apply();
}


void
QvisContextWindow::aboveProcessText()
{
    GetCurrentValues(ContextAttributes::ID_above);
    Apply();
}


