/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ZipWrapperPluginInfo.h>
#include <avtZipWrapperFileFormatInterface.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtZipWrapperOptions.h>


// ****************************************************************************
//  Method:  ZipWrapperCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ZipWrapper database.
//
//  Programmer:  miller -- generated by xml2info
//  Creation:    Sat Jul 7 18:54:59 PST 2007
//
// ****************************************************************************
DatabaseType
ZipWrapperCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ZipWrapper database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ZipWrapper database from list.
//
//  Programmer: miller -- generated by xml2info
//  Creation:   Sat Jul 7 18:54:59 PST 2007
//
//  Modifications:
//    Brad Whitlock, Tue Jun 24 16:41:08 PDT 2008
//    Pass this into the file format interface so it can use the plugin manager.
//
// ****************************************************************************
avtDatabase *
ZipWrapperCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtZipWrapperFileFormatInterface(list, nList, nBlock,
                                                    readOptions, this));
}

// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: miller -- generated by xml2info
//  Creation:   Tue Apr 29 15:53:01 PST 2008
//
// ****************************************************************************

DBOptionsAttributes *
ZipWrapperCommonPluginInfo::GetReadOptions() const
{
    return GetZipWrapperReadOptions();
}
// ****************************************************************************
//  Method: ZipWrapperCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: miller -- generated by xml2info
//  Creation:   Tue Apr 29 15:53:01 PST 2008
//
// ****************************************************************************

DBOptionsAttributes *
ZipWrapperCommonPluginInfo::GetWriteOptions() const
{
    return GetZipWrapperWriteOptions();
}
