/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAnimationAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyAnimationAttributes
//
// Purpose: 
//   This class contains the animation attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AnimationAttributes.
//
struct AnimationAttributesObject
{
    PyObject_HEAD
    AnimationAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAnimationAttributes(int);

std::string
PyAnimationAttributes_ToString(const AnimationAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *animationMode_names = "ReversePlayMode, StopMode, PlayMode";
    switch (atts->GetAnimationMode())
    {
      case AnimationAttributes::ReversePlayMode:
          SNPRINTF(tmpStr, 1000, "%sanimationMode = %sReversePlayMode  # %s\n", prefix, prefix, animationMode_names);
          str += tmpStr;
          break;
      case AnimationAttributes::StopMode:
          SNPRINTF(tmpStr, 1000, "%sanimationMode = %sStopMode  # %s\n", prefix, prefix, animationMode_names);
          str += tmpStr;
          break;
      case AnimationAttributes::PlayMode:
          SNPRINTF(tmpStr, 1000, "%sanimationMode = %sPlayMode  # %s\n", prefix, prefix, animationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPipelineCachingMode())
        SNPRINTF(tmpStr, 1000, "%spipelineCachingMode = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spipelineCachingMode = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sframeIncrement = %d\n", prefix, atts->GetFrameIncrement());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeout = %d\n", prefix, atts->GetTimeout());
    str += tmpStr;
    const char *playbackMode_names = "Looping, PlayOnce, Swing";
    switch (atts->GetPlaybackMode())
    {
      case AnimationAttributes::Looping:
          SNPRINTF(tmpStr, 1000, "%splaybackMode = %sLooping  # %s\n", prefix, prefix, playbackMode_names);
          str += tmpStr;
          break;
      case AnimationAttributes::PlayOnce:
          SNPRINTF(tmpStr, 1000, "%splaybackMode = %sPlayOnce  # %s\n", prefix, prefix, playbackMode_names);
          str += tmpStr;
          break;
      case AnimationAttributes::Swing:
          SNPRINTF(tmpStr, 1000, "%splaybackMode = %sSwing  # %s\n", prefix, prefix, playbackMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
AnimationAttributes_Notify(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_SetAnimationMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the animationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetAnimationMode(AnimationAttributes::AnimationMode(ival));
    else
    {
        fprintf(stderr, "An invalid animationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ReversePlayMode, StopMode, PlayMode.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_GetAnimationMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnimationMode()));
    return retval;
}

/*static*/ PyObject *
AnimationAttributes_SetPipelineCachingMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pipelineCachingMode in the object.
    obj->data->SetPipelineCachingMode(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_GetPipelineCachingMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPipelineCachingMode()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AnimationAttributes_SetFrameIncrement(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the frameIncrement in the object.
    obj->data->SetFrameIncrement((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_GetFrameIncrement(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFrameIncrement()));
    return retval;
}

/*static*/ PyObject *
AnimationAttributes_SetTimeout(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeout in the object.
    obj->data->SetTimeout((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_GetTimeout(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeout()));
    return retval;
}

/*static*/ PyObject *
AnimationAttributes_SetPlaybackMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the playbackMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetPlaybackMode(AnimationAttributes::PlaybackMode(ival));
    else
    {
        fprintf(stderr, "An invalid playbackMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Looping, PlayOnce, Swing.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnimationAttributes_GetPlaybackMode(PyObject *self, PyObject *args)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPlaybackMode()));
    return retval;
}



PyMethodDef PyAnimationAttributes_methods[ANIMATIONATTRIBUTES_NMETH] = {
    {"Notify", AnimationAttributes_Notify, METH_VARARGS},
    {"SetAnimationMode", AnimationAttributes_SetAnimationMode, METH_VARARGS},
    {"GetAnimationMode", AnimationAttributes_GetAnimationMode, METH_VARARGS},
    {"SetPipelineCachingMode", AnimationAttributes_SetPipelineCachingMode, METH_VARARGS},
    {"GetPipelineCachingMode", AnimationAttributes_GetPipelineCachingMode, METH_VARARGS},
    {"SetFrameIncrement", AnimationAttributes_SetFrameIncrement, METH_VARARGS},
    {"GetFrameIncrement", AnimationAttributes_GetFrameIncrement, METH_VARARGS},
    {"SetTimeout", AnimationAttributes_SetTimeout, METH_VARARGS},
    {"GetTimeout", AnimationAttributes_GetTimeout, METH_VARARGS},
    {"SetPlaybackMode", AnimationAttributes_SetPlaybackMode, METH_VARARGS},
    {"GetPlaybackMode", AnimationAttributes_GetPlaybackMode, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AnimationAttributes_dealloc(PyObject *v)
{
   AnimationAttributesObject *obj = (AnimationAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AnimationAttributes_compare(PyObject *v, PyObject *w)
{
    AnimationAttributes *a = ((AnimationAttributesObject *)v)->data;
    AnimationAttributes *b = ((AnimationAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAnimationAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "animationMode") == 0)
        return AnimationAttributes_GetAnimationMode(self, NULL);
    if(strcmp(name, "ReversePlayMode") == 0)
        return PyInt_FromLong(long(AnimationAttributes::ReversePlayMode));
    if(strcmp(name, "StopMode") == 0)
        return PyInt_FromLong(long(AnimationAttributes::StopMode));
    if(strcmp(name, "PlayMode") == 0)
        return PyInt_FromLong(long(AnimationAttributes::PlayMode));

    if(strcmp(name, "pipelineCachingMode") == 0)
        return AnimationAttributes_GetPipelineCachingMode(self, NULL);
    if(strcmp(name, "frameIncrement") == 0)
        return AnimationAttributes_GetFrameIncrement(self, NULL);
    if(strcmp(name, "timeout") == 0)
        return AnimationAttributes_GetTimeout(self, NULL);
    if(strcmp(name, "playbackMode") == 0)
        return AnimationAttributes_GetPlaybackMode(self, NULL);
    if(strcmp(name, "Looping") == 0)
        return PyInt_FromLong(long(AnimationAttributes::Looping));
    if(strcmp(name, "PlayOnce") == 0)
        return PyInt_FromLong(long(AnimationAttributes::PlayOnce));
    if(strcmp(name, "Swing") == 0)
        return PyInt_FromLong(long(AnimationAttributes::Swing));


    return Py_FindMethod(PyAnimationAttributes_methods, self, name);
}

int
PyAnimationAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "animationMode") == 0)
        obj = AnimationAttributes_SetAnimationMode(self, tuple);
    else if(strcmp(name, "pipelineCachingMode") == 0)
        obj = AnimationAttributes_SetPipelineCachingMode(self, tuple);
    else if(strcmp(name, "frameIncrement") == 0)
        obj = AnimationAttributes_SetFrameIncrement(self, tuple);
    else if(strcmp(name, "timeout") == 0)
        obj = AnimationAttributes_SetTimeout(self, tuple);
    else if(strcmp(name, "playbackMode") == 0)
        obj = AnimationAttributes_SetPlaybackMode(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AnimationAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)v;
    fprintf(fp, "%s", PyAnimationAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AnimationAttributes_str(PyObject *v)
{
    AnimationAttributesObject *obj = (AnimationAttributesObject *)v;
    return PyString_FromString(PyAnimationAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AnimationAttributes_Purpose = "This class contains the animation attributes.";
#else
static char *AnimationAttributes_Purpose = "This class contains the animation attributes.";
#endif

//
// The type description structure
//
static PyTypeObject AnimationAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AnimationAttributes",                    // tp_name
    sizeof(AnimationAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AnimationAttributes_dealloc,  // tp_dealloc
    (printfunc)AnimationAttributes_print,     // tp_print
    (getattrfunc)PyAnimationAttributes_getattr, // tp_getattr
    (setattrfunc)PyAnimationAttributes_setattr, // tp_setattr
    (cmpfunc)AnimationAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AnimationAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AnimationAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AnimationAttributes *defaultAtts = 0;
static AnimationAttributes *currentAtts = 0;

static PyObject *
NewAnimationAttributes(int useCurrent)
{
    AnimationAttributesObject *newObject;
    newObject = PyObject_NEW(AnimationAttributesObject, &AnimationAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AnimationAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AnimationAttributes(*defaultAtts);
    else
        newObject->data = new AnimationAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAnimationAttributes(const AnimationAttributes *attr)
{
    AnimationAttributesObject *newObject;
    newObject = PyObject_NEW(AnimationAttributesObject, &AnimationAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AnimationAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AnimationAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAnimationAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AnimationAttributesMethods[] = {
    {"AnimationAttributes", AnimationAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AnimationAttributesObserver = 0;

std::string
PyAnimationAttributes_GetLogString()
{
    std::string s("AnimationAtts = AnimationAttributes()\n");
    if(currentAtts != 0)
        s += PyAnimationAttributes_ToString(currentAtts, "AnimationAtts.");
    return s;
}

static void
PyAnimationAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AnimationAtts = AnimationAttributes()\n");
        s += PyAnimationAttributes_ToString(currentAtts, "AnimationAtts.");
        cb(s);
    }
}

void
PyAnimationAttributes_StartUp(AnimationAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAnimationAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AnimationAttributesObserver == 0)
    {
        AnimationAttributesObserver = new ObserverToCallback(subj,
            PyAnimationAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyAnimationAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AnimationAttributesObserver;
    AnimationAttributesObserver = 0;
}

PyMethodDef *
PyAnimationAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AnimationAttributesMethods;
}

bool
PyAnimationAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AnimationAttributesType);
}

AnimationAttributes *
PyAnimationAttributes_FromPyObject(PyObject *obj)
{
    AnimationAttributesObject *obj2 = (AnimationAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAnimationAttributes_New()
{
    return NewAnimationAttributes(0);
}

PyObject *
PyAnimationAttributes_Wrap(const AnimationAttributes *attr)
{
    return WrapAnimationAttributes(attr);
}

void
PyAnimationAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    AnimationAttributesObject *obj2 = (AnimationAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyAnimationAttributes_SetDefaults(const AnimationAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AnimationAttributes(*atts);
}

