/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                            avtMOABFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_MOAB_FILE_FORMAT_H
#define AVT_MOAB_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>
#include <set>
class DBOptionsAttributes;

namespace moab
{
  class Core;
  class ParallelComm;
}
struct mhdf_FileDesc ;

// ****************************************************************************
//  Class: avtMOABFileFormat
//
//  Purpose:
//      Reads in MOAB files as a plugin to VisIt.
//
//  Programmer: vijaysm -- generated by xml2avt
//  Creation:   Wed Jan 20 13:02:35 PST 2016
//
// ****************************************************************************

class avtMOABFileFormat : public avtSTMDFileFormat
{
  public:
                       avtMOABFileFormat(const char *, DBOptionsAttributes *);
    virtual           ~avtMOABFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //

    virtual const char    *GetType(void)   { return "MOAB"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    void                   gatherMhdfInformation();
    vtkDataArray*          GetPartitionTagAsEnumScalar();
    vtkDataArray*          GetMaterialTagAsEnumScalar();
    vtkDataArray*          GetNeumannSetsVar();
    vtkDataArray*          GetDirichletSetsVar();
    vtkDataArray*          GetGeometrySetsVar();
    moab::Core*            mbCore;
    const char*            fileName;
    DBOptionsAttributes *  readOptions;
    bool                   fileLoaded;
    struct mhdf_FileDesc *       file_descriptor;
    std::set<int>          materials;
    std::set<int>          neumannsets;
    std::set<int>          dirichsets;
    std::set<std::string>       elemTags;
    std::vector<std::string>    nodeTags;
    int                    rank, nProcs;
    int                    num_parts; // PARALLEL_PARTITIONs
    int                    num_mats; // MATERIAL_SETs
    int                    num_neumann; // NEUMANN_SETs
    int                    num_diri;    // DIRICHLET_SETs
    int                    num_geom;    // geometry dimension sets
    moab::ParallelComm*    pcomm;
};



#endif
