/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyWellBoreAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPointList.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>

// ****************************************************************************
// Module: PyWellBoreAttributes
//
// Purpose: 
//   This class contains the plot attributes for the well bore plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a WellBoreAttributes.
//
struct WellBoreAttributesObject
{
    PyObject_HEAD
    WellBoreAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewWellBoreAttributes(int);

std::string
PyWellBoreAttributes_ToString(const WellBoreAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "defaultPalette.";
        str += PyColorControlPointList_ToString(&atts->GetDefaultPalette(), objPrefix.c_str());
    }
    {   const unsignedCharVector &changedColors = atts->GetChangedColors();
        SNPRINTF(tmpStr, 1000, "%schangedColors = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < changedColors.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(changedColors[i]));
            str += tmpStr;
            if(i < changedColors.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case WellBoreAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::ColorByMultipleColors:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    const char *drawWellsAs_names = "Lines, Cylinders";
    switch (atts->GetDrawWellsAs())
    {
      case WellBoreAttributes::Lines:
          SNPRINTF(tmpStr, 1000, "%sdrawWellsAs = %sLines  # %s\n", prefix, prefix, drawWellsAs_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::Cylinders:
          SNPRINTF(tmpStr, 1000, "%sdrawWellsAs = %sCylinders  # %s\n", prefix, prefix, drawWellsAs_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *wellCylinderQuality_names = "Low, Medium, High, Super";
    switch (atts->GetWellCylinderQuality())
    {
      case WellBoreAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%swellCylinderQuality = %sLow  # %s\n", prefix, prefix, wellCylinderQuality_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%swellCylinderQuality = %sMedium  # %s\n", prefix, prefix, wellCylinderQuality_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::High:
          SNPRINTF(tmpStr, 1000, "%swellCylinderQuality = %sHigh  # %s\n", prefix, prefix, wellCylinderQuality_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::Super:
          SNPRINTF(tmpStr, 1000, "%swellCylinderQuality = %sSuper  # %s\n", prefix, prefix, wellCylinderQuality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%swellRadius = %g\n", prefix, atts->GetWellRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swellLineWidth = %d\n", prefix, atts->GetWellLineWidth());
    str += tmpStr;
    const char *wellAnnotation_names = "None, StemOnly, NameOnly, StemAndName";
    switch (atts->GetWellAnnotation())
    {
      case WellBoreAttributes::None:
          SNPRINTF(tmpStr, 1000, "%swellAnnotation = %sNone  # %s\n", prefix, prefix, wellAnnotation_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::StemOnly:
          SNPRINTF(tmpStr, 1000, "%swellAnnotation = %sStemOnly  # %s\n", prefix, prefix, wellAnnotation_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::NameOnly:
          SNPRINTF(tmpStr, 1000, "%swellAnnotation = %sNameOnly  # %s\n", prefix, prefix, wellAnnotation_names);
          str += tmpStr;
          break;
      case WellBoreAttributes::StemAndName:
          SNPRINTF(tmpStr, 1000, "%swellAnnotation = %sStemAndName  # %s\n", prefix, prefix, wellAnnotation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%swellStemHeight = %g\n", prefix, atts->GetWellStemHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swellNameScale = %g\n", prefix, atts->GetWellNameScale());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snWellBores = %d\n", prefix, atts->GetNWellBores());
    str += tmpStr;
    {   const intVector &wellBores = atts->GetWellBores();
        SNPRINTF(tmpStr, 1000, "%swellBores = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < wellBores.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", wellBores[i]);
            str += tmpStr;
            if(i < wellBores.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &wellNames = atts->GetWellNames();
        SNPRINTF(tmpStr, 1000, "%swellNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < wellNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", wellNames[i].c_str());
            str += tmpStr;
            if(i < wellNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
WellBoreAttributes_Notify(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_SetDefaultPalette(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyColorControlPointList_Check(newValue))
    {
        fprintf(stderr, "The defaultPalette field can only be set with ColorControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetDefaultPalette(*PyColorControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetDefaultPalette(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPointList_Wrap(&obj->data->GetDefaultPalette());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetChangedColors(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    unsignedCharVector  &vec = obj->data->GetChangedColors();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the changedColors in the object as modified.
    obj->data->SelectChangedColors();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetChangedColors(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the changedColors.
    const unsignedCharVector &changedColors = obj->data->GetChangedColors();
    PyObject *retval = PyTuple_New(changedColors.size());
    for(size_t i = 0; i < changedColors.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(changedColors[i])));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetColorType(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(WellBoreAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetColorType(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetDrawWellsAs(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawWellsAs in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetDrawWellsAs(WellBoreAttributes::WellRenderingMode(ival));
    else
    {
        fprintf(stderr, "An invalid drawWellsAs value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Lines, Cylinders.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetDrawWellsAs(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawWellsAs()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellCylinderQuality(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wellCylinderQuality in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetWellCylinderQuality(WellBoreAttributes::DetailLevel(ival));
    else
    {
        fprintf(stderr, "An invalid wellCylinderQuality value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Low, Medium, High, Super.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellCylinderQuality(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWellCylinderQuality()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellRadius(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the wellRadius in the object.
    obj->data->SetWellRadius(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellRadius(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetWellRadius()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellLineWidth(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wellLineWidth in the object.
    obj->data->SetWellLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellLineWidth(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWellLineWidth()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellAnnotation(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wellAnnotation in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetWellAnnotation(WellBoreAttributes::WellAnnotation(ival));
    else
    {
        fprintf(stderr, "An invalid wellAnnotation value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, StemOnly, NameOnly, StemAndName.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellAnnotation(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWellAnnotation()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellStemHeight(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the wellStemHeight in the object.
    obj->data->SetWellStemHeight(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellStemHeight(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetWellStemHeight()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellNameScale(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the wellNameScale in the object.
    obj->data->SetWellNameScale(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellNameScale(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetWellNameScale()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetNWellBores(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nWellBores in the object.
    obj->data->SetNWellBores((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetNWellBores(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNWellBores()));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellBores(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    intVector  &vec = obj->data->GetWellBores();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the wellBores in the object as modified.
    obj->data->SelectWellBores();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellBores(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wellBores.
    const intVector &wellBores = obj->data->GetWellBores();
    PyObject *retval = PyTuple_New(wellBores.size());
    for(size_t i = 0; i < wellBores.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(wellBores[i])));
    return retval;
}

/*static*/ PyObject *
WellBoreAttributes_SetWellNames(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;

    stringVector  &vec = obj->data->GetWellNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the wellNames in the object as modified.
    obj->data->SelectWellNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WellBoreAttributes_GetWellNames(PyObject *self, PyObject *args)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wellNames.
    const stringVector &wellNames = obj->data->GetWellNames();
    PyObject *retval = PyTuple_New(wellNames.size());
    for(size_t i = 0; i < wellNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(wellNames[i].c_str()));
    return retval;
}



PyMethodDef PyWellBoreAttributes_methods[WELLBOREATTRIBUTES_NMETH] = {
    {"Notify", WellBoreAttributes_Notify, METH_VARARGS},
    {"SetDefaultPalette", WellBoreAttributes_SetDefaultPalette, METH_VARARGS},
    {"GetDefaultPalette", WellBoreAttributes_GetDefaultPalette, METH_VARARGS},
    {"SetChangedColors", WellBoreAttributes_SetChangedColors, METH_VARARGS},
    {"GetChangedColors", WellBoreAttributes_GetChangedColors, METH_VARARGS},
    {"SetColorType", WellBoreAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", WellBoreAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", WellBoreAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", WellBoreAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", WellBoreAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", WellBoreAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetSingleColor", WellBoreAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", WellBoreAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", WellBoreAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", WellBoreAttributes_GetMultiColor, METH_VARARGS},
    {"SetDrawWellsAs", WellBoreAttributes_SetDrawWellsAs, METH_VARARGS},
    {"GetDrawWellsAs", WellBoreAttributes_GetDrawWellsAs, METH_VARARGS},
    {"SetWellCylinderQuality", WellBoreAttributes_SetWellCylinderQuality, METH_VARARGS},
    {"GetWellCylinderQuality", WellBoreAttributes_GetWellCylinderQuality, METH_VARARGS},
    {"SetWellRadius", WellBoreAttributes_SetWellRadius, METH_VARARGS},
    {"GetWellRadius", WellBoreAttributes_GetWellRadius, METH_VARARGS},
    {"SetWellLineWidth", WellBoreAttributes_SetWellLineWidth, METH_VARARGS},
    {"GetWellLineWidth", WellBoreAttributes_GetWellLineWidth, METH_VARARGS},
    {"SetWellAnnotation", WellBoreAttributes_SetWellAnnotation, METH_VARARGS},
    {"GetWellAnnotation", WellBoreAttributes_GetWellAnnotation, METH_VARARGS},
    {"SetWellStemHeight", WellBoreAttributes_SetWellStemHeight, METH_VARARGS},
    {"GetWellStemHeight", WellBoreAttributes_GetWellStemHeight, METH_VARARGS},
    {"SetWellNameScale", WellBoreAttributes_SetWellNameScale, METH_VARARGS},
    {"GetWellNameScale", WellBoreAttributes_GetWellNameScale, METH_VARARGS},
    {"SetLegendFlag", WellBoreAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", WellBoreAttributes_GetLegendFlag, METH_VARARGS},
    {"SetNWellBores", WellBoreAttributes_SetNWellBores, METH_VARARGS},
    {"GetNWellBores", WellBoreAttributes_GetNWellBores, METH_VARARGS},
    {"SetWellBores", WellBoreAttributes_SetWellBores, METH_VARARGS},
    {"GetWellBores", WellBoreAttributes_GetWellBores, METH_VARARGS},
    {"SetWellNames", WellBoreAttributes_SetWellNames, METH_VARARGS},
    {"GetWellNames", WellBoreAttributes_GetWellNames, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
WellBoreAttributes_dealloc(PyObject *v)
{
   WellBoreAttributesObject *obj = (WellBoreAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
WellBoreAttributes_compare(PyObject *v, PyObject *w)
{
    WellBoreAttributes *a = ((WellBoreAttributesObject *)v)->data;
    WellBoreAttributes *b = ((WellBoreAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyWellBoreAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "defaultPalette") == 0)
        return WellBoreAttributes_GetDefaultPalette(self, NULL);
    if(strcmp(name, "changedColors") == 0)
        return WellBoreAttributes_GetChangedColors(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return WellBoreAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::ColorByMultipleColors));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return WellBoreAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return WellBoreAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return WellBoreAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return WellBoreAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "drawWellsAs") == 0)
        return WellBoreAttributes_GetDrawWellsAs(self, NULL);
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::Lines));
    if(strcmp(name, "Cylinders") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::Cylinders));

    if(strcmp(name, "wellCylinderQuality") == 0)
        return WellBoreAttributes_GetWellCylinderQuality(self, NULL);
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::High));
    if(strcmp(name, "Super") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::Super));

    if(strcmp(name, "wellRadius") == 0)
        return WellBoreAttributes_GetWellRadius(self, NULL);
    if(strcmp(name, "wellLineWidth") == 0)
        return WellBoreAttributes_GetWellLineWidth(self, NULL);
    if(strcmp(name, "wellAnnotation") == 0)
        return WellBoreAttributes_GetWellAnnotation(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::None));
    if(strcmp(name, "StemOnly") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::StemOnly));
    if(strcmp(name, "NameOnly") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::NameOnly));
    if(strcmp(name, "StemAndName") == 0)
        return PyInt_FromLong(long(WellBoreAttributes::StemAndName));

    if(strcmp(name, "wellStemHeight") == 0)
        return WellBoreAttributes_GetWellStemHeight(self, NULL);
    if(strcmp(name, "wellNameScale") == 0)
        return WellBoreAttributes_GetWellNameScale(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return WellBoreAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "nWellBores") == 0)
        return WellBoreAttributes_GetNWellBores(self, NULL);
    if(strcmp(name, "wellBores") == 0)
        return WellBoreAttributes_GetWellBores(self, NULL);
    if(strcmp(name, "wellNames") == 0)
        return WellBoreAttributes_GetWellNames(self, NULL);

    // Try and handle legacy fields

    // wellLineStyle and it's possible enumerations
    bool wellLineStyleFound = false;
    if (strcmp(name, "wellLineStyle") == 0)
    {
        wellLineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        wellLineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        wellLineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        wellLineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        wellLineStyleFound = true;
    }

    if (wellLineStyleFound)
    {
        fprintf(stdout, "wellLineStyle is no longer a valid WellBore "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyWellBoreAttributes_methods, self, name);
}

int
PyWellBoreAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "defaultPalette") == 0)
        obj = WellBoreAttributes_SetDefaultPalette(self, tuple);
    else if(strcmp(name, "changedColors") == 0)
        obj = WellBoreAttributes_SetChangedColors(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = WellBoreAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = WellBoreAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = WellBoreAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = WellBoreAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = WellBoreAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "drawWellsAs") == 0)
        obj = WellBoreAttributes_SetDrawWellsAs(self, tuple);
    else if(strcmp(name, "wellCylinderQuality") == 0)
        obj = WellBoreAttributes_SetWellCylinderQuality(self, tuple);
    else if(strcmp(name, "wellRadius") == 0)
        obj = WellBoreAttributes_SetWellRadius(self, tuple);
    else if(strcmp(name, "wellLineWidth") == 0)
        obj = WellBoreAttributes_SetWellLineWidth(self, tuple);
    else if(strcmp(name, "wellAnnotation") == 0)
        obj = WellBoreAttributes_SetWellAnnotation(self, tuple);
    else if(strcmp(name, "wellStemHeight") == 0)
        obj = WellBoreAttributes_SetWellStemHeight(self, tuple);
    else if(strcmp(name, "wellNameScale") == 0)
        obj = WellBoreAttributes_SetWellNameScale(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = WellBoreAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "nWellBores") == 0)
        obj = WellBoreAttributes_SetNWellBores(self, tuple);
    else if(strcmp(name, "wellBores") == 0)
        obj = WellBoreAttributes_SetWellBores(self, tuple);
    else if(strcmp(name, "wellNames") == 0)
        obj = WellBoreAttributes_SetWellNames(self, tuple);

    // Try and handle legacy fields
    if(obj == NULL)
    {
        if(strcmp(name, "wellLineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
WellBoreAttributes_print(PyObject *v, FILE *fp, int flags)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)v;
    fprintf(fp, "%s", PyWellBoreAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
WellBoreAttributes_str(PyObject *v)
{
    WellBoreAttributesObject *obj = (WellBoreAttributesObject *)v;
    return PyString_FromString(PyWellBoreAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *WellBoreAttributes_Purpose = "This class contains the plot attributes for the well bore plot.";
#else
static char *WellBoreAttributes_Purpose = "This class contains the plot attributes for the well bore plot.";
#endif

//
// The type description structure
//
static PyTypeObject WellBoreAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "WellBoreAttributes",                    // tp_name
    sizeof(WellBoreAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)WellBoreAttributes_dealloc,  // tp_dealloc
    (printfunc)WellBoreAttributes_print,     // tp_print
    (getattrfunc)PyWellBoreAttributes_getattr, // tp_getattr
    (setattrfunc)PyWellBoreAttributes_setattr, // tp_setattr
    (cmpfunc)WellBoreAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)WellBoreAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    WellBoreAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static WellBoreAttributes *defaultAtts = 0;
static WellBoreAttributes *currentAtts = 0;

static PyObject *
NewWellBoreAttributes(int useCurrent)
{
    WellBoreAttributesObject *newObject;
    newObject = PyObject_NEW(WellBoreAttributesObject, &WellBoreAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new WellBoreAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new WellBoreAttributes(*defaultAtts);
    else
        newObject->data = new WellBoreAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapWellBoreAttributes(const WellBoreAttributes *attr)
{
    WellBoreAttributesObject *newObject;
    newObject = PyObject_NEW(WellBoreAttributesObject, &WellBoreAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (WellBoreAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
WellBoreAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewWellBoreAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef WellBoreAttributesMethods[] = {
    {"WellBoreAttributes", WellBoreAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *WellBoreAttributesObserver = 0;

std::string
PyWellBoreAttributes_GetLogString()
{
    std::string s("WellBoreAtts = WellBoreAttributes()\n");
    if(currentAtts != 0)
        s += PyWellBoreAttributes_ToString(currentAtts, "WellBoreAtts.");
    return s;
}

static void
PyWellBoreAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("WellBoreAtts = WellBoreAttributes()\n");
        s += PyWellBoreAttributes_ToString(currentAtts, "WellBoreAtts.");
        cb(s);
    }
}

void
PyWellBoreAttributes_StartUp(WellBoreAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyWellBoreAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(WellBoreAttributesObserver == 0)
    {
        WellBoreAttributesObserver = new ObserverToCallback(subj,
            PyWellBoreAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyWellBoreAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete WellBoreAttributesObserver;
    WellBoreAttributesObserver = 0;
}

PyMethodDef *
PyWellBoreAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return WellBoreAttributesMethods;
}

bool
PyWellBoreAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &WellBoreAttributesType);
}

WellBoreAttributes *
PyWellBoreAttributes_FromPyObject(PyObject *obj)
{
    WellBoreAttributesObject *obj2 = (WellBoreAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyWellBoreAttributes_New()
{
    return NewWellBoreAttributes(0);
}

PyObject *
PyWellBoreAttributes_Wrap(const WellBoreAttributes *attr)
{
    return WrapWellBoreAttributes(attr);
}

void
PyWellBoreAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    WellBoreAttributesObject *obj2 = (WellBoreAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyWellBoreAttributes_SetDefaults(const WellBoreAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new WellBoreAttributes(*atts);
}

