/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <FiveFoldTetSubdivisionAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Init utility for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void FiveFoldTetSubdivisionAttributes::Init()
{
    oddParityHasSixNeighborhood = true;
    addComponentInformation = false;
    isovalue = 0;

    FiveFoldTetSubdivisionAttributes::SelectAll();
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Copy utility for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void FiveFoldTetSubdivisionAttributes::Copy(const FiveFoldTetSubdivisionAttributes &obj)
{
    oddParityHasSixNeighborhood = obj.oddParityHasSixNeighborhood;
    addComponentInformation = obj.addComponentInformation;
    idVar = obj.idVar;
    valueVar = obj.valueVar;
    contourTreeFilename = obj.contourTreeFilename;
    isovalue = obj.isovalue;
    selectedIds = obj.selectedIds;
    highlightedIds = obj.highlightedIds;

    FiveFoldTetSubdivisionAttributes::SelectAll();
}

// Type map format string
const char *FiveFoldTetSubdivisionAttributes::TypeMapFormatString = FIVEFOLDTETSUBDIVISIONATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t FiveFoldTetSubdivisionAttributes::TmfsStruct = {FIVEFOLDTETSUBDIVISIONATTRIBUTES_TMFS};


// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Default constructor for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes() : 
    AttributeSubject(FiveFoldTetSubdivisionAttributes::TypeMapFormatString),
    idVar("default"), valueVar("default")
{
    FiveFoldTetSubdivisionAttributes::Init();
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Constructor for the derived classes of FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    idVar("default"), valueVar("default")
{
    FiveFoldTetSubdivisionAttributes::Init();
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Copy constructor for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes(const FiveFoldTetSubdivisionAttributes &obj) : 
    AttributeSubject(FiveFoldTetSubdivisionAttributes::TypeMapFormatString)
{
    FiveFoldTetSubdivisionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes::FiveFoldTetSubdivisionAttributes(const FiveFoldTetSubdivisionAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    FiveFoldTetSubdivisionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::~FiveFoldTetSubdivisionAttributes
//
// Purpose: 
//   Destructor for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes::~FiveFoldTetSubdivisionAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

FiveFoldTetSubdivisionAttributes& 
FiveFoldTetSubdivisionAttributes::operator = (const FiveFoldTetSubdivisionAttributes &obj)
{
    if (this == &obj) return *this;

    FiveFoldTetSubdivisionAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FiveFoldTetSubdivisionAttributes::operator == (const FiveFoldTetSubdivisionAttributes &obj) const
{
    // Create the return value
    return ((oddParityHasSixNeighborhood == obj.oddParityHasSixNeighborhood) &&
            (addComponentInformation == obj.addComponentInformation) &&
            (idVar == obj.idVar) &&
            (valueVar == obj.valueVar) &&
            (contourTreeFilename == obj.contourTreeFilename) &&
            (isovalue == obj.isovalue) &&
            (selectedIds == obj.selectedIds) &&
            (highlightedIds == obj.highlightedIds));
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FiveFoldTetSubdivisionAttributes::operator != (const FiveFoldTetSubdivisionAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::TypeName
//
// Purpose: 
//   Type name method for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
FiveFoldTetSubdivisionAttributes::TypeName() const
{
    return "FiveFoldTetSubdivisionAttributes";
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FiveFoldTetSubdivisionAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const FiveFoldTetSubdivisionAttributes *tmp = (const FiveFoldTetSubdivisionAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
FiveFoldTetSubdivisionAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new FiveFoldTetSubdivisionAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the FiveFoldTetSubdivisionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
FiveFoldTetSubdivisionAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new FiveFoldTetSubdivisionAttributes(*this);
    else
        retval = new FiveFoldTetSubdivisionAttributes;

    return retval;
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
FiveFoldTetSubdivisionAttributes::SelectAll()
{
    Select(ID_oddParityHasSixNeighborhood, (void *)&oddParityHasSixNeighborhood);
    Select(ID_addComponentInformation,     (void *)&addComponentInformation);
    Select(ID_idVar,                       (void *)&idVar);
    Select(ID_valueVar,                    (void *)&valueVar);
    Select(ID_contourTreeFilename,         (void *)&contourTreeFilename);
    Select(ID_isovalue,                    (void *)&isovalue);
    Select(ID_selectedIds,                 (void *)&selectedIds);
    Select(ID_highlightedIds,              (void *)&highlightedIds);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FiveFoldTetSubdivisionAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    FiveFoldTetSubdivisionAttributes defaultObject;
    bool addToParent = false;
    // Create a node for FiveFoldTetSubdivisionAttributes.
    DataNode *node = new DataNode("FiveFoldTetSubdivisionAttributes");

    if(completeSave || !FieldsEqual(ID_oddParityHasSixNeighborhood, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("oddParityHasSixNeighborhood", oddParityHasSixNeighborhood));
    }

    if(completeSave || !FieldsEqual(ID_addComponentInformation, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("addComponentInformation", addComponentInformation));
    }

    if(completeSave || !FieldsEqual(ID_idVar, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("idVar", idVar));
    }

    if(completeSave || !FieldsEqual(ID_valueVar, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("valueVar", valueVar));
    }

    if(completeSave || !FieldsEqual(ID_contourTreeFilename, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("contourTreeFilename", contourTreeFilename));
    }

    if(completeSave || !FieldsEqual(ID_isovalue, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("isovalue", isovalue));
    }

    if(completeSave || !FieldsEqual(ID_selectedIds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("selectedIds", selectedIds));
    }

    if(completeSave || !FieldsEqual(ID_highlightedIds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("highlightedIds", highlightedIds));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
FiveFoldTetSubdivisionAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("FiveFoldTetSubdivisionAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("oddParityHasSixNeighborhood")) != 0)
        SetOddParityHasSixNeighborhood(node->AsBool());
    if((node = searchNode->GetNode("addComponentInformation")) != 0)
        SetAddComponentInformation(node->AsBool());
    if((node = searchNode->GetNode("idVar")) != 0)
        SetIdVar(node->AsString());
    if((node = searchNode->GetNode("valueVar")) != 0)
        SetValueVar(node->AsString());
    if((node = searchNode->GetNode("contourTreeFilename")) != 0)
        SetContourTreeFilename(node->AsString());
    if((node = searchNode->GetNode("isovalue")) != 0)
        SetIsovalue(node->AsDouble());
    if((node = searchNode->GetNode("selectedIds")) != 0)
        SetSelectedIds(node->AsIntVector());
    if((node = searchNode->GetNode("highlightedIds")) != 0)
        SetHighlightedIds(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
FiveFoldTetSubdivisionAttributes::SetOddParityHasSixNeighborhood(bool oddParityHasSixNeighborhood_)
{
    oddParityHasSixNeighborhood = oddParityHasSixNeighborhood_;
    Select(ID_oddParityHasSixNeighborhood, (void *)&oddParityHasSixNeighborhood);
}

void
FiveFoldTetSubdivisionAttributes::SetAddComponentInformation(bool addComponentInformation_)
{
    addComponentInformation = addComponentInformation_;
    Select(ID_addComponentInformation, (void *)&addComponentInformation);
}

void
FiveFoldTetSubdivisionAttributes::SetIdVar(const std::string &idVar_)
{
    idVar = idVar_;
    Select(ID_idVar, (void *)&idVar);
}

void
FiveFoldTetSubdivisionAttributes::SetValueVar(const std::string &valueVar_)
{
    valueVar = valueVar_;
    Select(ID_valueVar, (void *)&valueVar);
}

void
FiveFoldTetSubdivisionAttributes::SetContourTreeFilename(const std::string &contourTreeFilename_)
{
    contourTreeFilename = contourTreeFilename_;
    Select(ID_contourTreeFilename, (void *)&contourTreeFilename);
}

void
FiveFoldTetSubdivisionAttributes::SetIsovalue(double isovalue_)
{
    isovalue = isovalue_;
    Select(ID_isovalue, (void *)&isovalue);
}

void
FiveFoldTetSubdivisionAttributes::SetSelectedIds(const intVector &selectedIds_)
{
    selectedIds = selectedIds_;
    Select(ID_selectedIds, (void *)&selectedIds);
}

void
FiveFoldTetSubdivisionAttributes::SetHighlightedIds(const intVector &highlightedIds_)
{
    highlightedIds = highlightedIds_;
    Select(ID_highlightedIds, (void *)&highlightedIds);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
FiveFoldTetSubdivisionAttributes::GetOddParityHasSixNeighborhood() const
{
    return oddParityHasSixNeighborhood;
}

bool
FiveFoldTetSubdivisionAttributes::GetAddComponentInformation() const
{
    return addComponentInformation;
}

const std::string &
FiveFoldTetSubdivisionAttributes::GetIdVar() const
{
    return idVar;
}

std::string &
FiveFoldTetSubdivisionAttributes::GetIdVar()
{
    return idVar;
}

const std::string &
FiveFoldTetSubdivisionAttributes::GetValueVar() const
{
    return valueVar;
}

std::string &
FiveFoldTetSubdivisionAttributes::GetValueVar()
{
    return valueVar;
}

const std::string &
FiveFoldTetSubdivisionAttributes::GetContourTreeFilename() const
{
    return contourTreeFilename;
}

std::string &
FiveFoldTetSubdivisionAttributes::GetContourTreeFilename()
{
    return contourTreeFilename;
}

double
FiveFoldTetSubdivisionAttributes::GetIsovalue() const
{
    return isovalue;
}

const intVector &
FiveFoldTetSubdivisionAttributes::GetSelectedIds() const
{
    return selectedIds;
}

intVector &
FiveFoldTetSubdivisionAttributes::GetSelectedIds()
{
    return selectedIds;
}

const intVector &
FiveFoldTetSubdivisionAttributes::GetHighlightedIds() const
{
    return highlightedIds;
}

intVector &
FiveFoldTetSubdivisionAttributes::GetHighlightedIds()
{
    return highlightedIds;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
FiveFoldTetSubdivisionAttributes::SelectIdVar()
{
    Select(ID_idVar, (void *)&idVar);
}

void
FiveFoldTetSubdivisionAttributes::SelectValueVar()
{
    Select(ID_valueVar, (void *)&valueVar);
}

void
FiveFoldTetSubdivisionAttributes::SelectContourTreeFilename()
{
    Select(ID_contourTreeFilename, (void *)&contourTreeFilename);
}

void
FiveFoldTetSubdivisionAttributes::SelectSelectedIds()
{
    Select(ID_selectedIds, (void *)&selectedIds);
}

void
FiveFoldTetSubdivisionAttributes::SelectHighlightedIds()
{
    Select(ID_highlightedIds, (void *)&highlightedIds);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
FiveFoldTetSubdivisionAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_oddParityHasSixNeighborhood: return "oddParityHasSixNeighborhood";
    case ID_addComponentInformation:     return "addComponentInformation";
    case ID_idVar:                       return "idVar";
    case ID_valueVar:                    return "valueVar";
    case ID_contourTreeFilename:         return "contourTreeFilename";
    case ID_isovalue:                    return "isovalue";
    case ID_selectedIds:                 return "selectedIds";
    case ID_highlightedIds:              return "highlightedIds";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
FiveFoldTetSubdivisionAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_oddParityHasSixNeighborhood: return FieldType_bool;
    case ID_addComponentInformation:     return FieldType_bool;
    case ID_idVar:                       return FieldType_variablename;
    case ID_valueVar:                    return FieldType_variablename;
    case ID_contourTreeFilename:         return FieldType_string;
    case ID_isovalue:                    return FieldType_double;
    case ID_selectedIds:                 return FieldType_intVector;
    case ID_highlightedIds:              return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
FiveFoldTetSubdivisionAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_oddParityHasSixNeighborhood: return "bool";
    case ID_addComponentInformation:     return "bool";
    case ID_idVar:                       return "variablename";
    case ID_valueVar:                    return "variablename";
    case ID_contourTreeFilename:         return "string";
    case ID_isovalue:                    return "double";
    case ID_selectedIds:                 return "intVector";
    case ID_highlightedIds:              return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: FiveFoldTetSubdivisionAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
FiveFoldTetSubdivisionAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const FiveFoldTetSubdivisionAttributes &obj = *((const FiveFoldTetSubdivisionAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_oddParityHasSixNeighborhood:
        {  // new scope
        retval = (oddParityHasSixNeighborhood == obj.oddParityHasSixNeighborhood);
        }
        break;
    case ID_addComponentInformation:
        {  // new scope
        retval = (addComponentInformation == obj.addComponentInformation);
        }
        break;
    case ID_idVar:
        {  // new scope
        retval = (idVar == obj.idVar);
        }
        break;
    case ID_valueVar:
        {  // new scope
        retval = (valueVar == obj.valueVar);
        }
        break;
    case ID_contourTreeFilename:
        {  // new scope
        retval = (contourTreeFilename == obj.contourTreeFilename);
        }
        break;
    case ID_isovalue:
        {  // new scope
        retval = (isovalue == obj.isovalue);
        }
        break;
    case ID_selectedIds:
        {  // new scope
        retval = (selectedIds == obj.selectedIds);
        }
        break;
    case ID_highlightedIds:
        {  // new scope
        retval = (highlightedIds == obj.highlightedIds);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

