/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySaveWindowAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PySaveSubWindowsAttributes.h>

// ****************************************************************************
// Module: PySaveWindowAttributes
//
// Purpose: 
//   This class contains the attributes used for saving windows.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SaveWindowAttributes.
//
struct SaveWindowAttributesObject
{
    PyObject_HEAD
    SaveWindowAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSaveWindowAttributes(int);

std::string
PySaveWindowAttributes_ToString(const SaveWindowAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetOutputToCurrentDirectory())
        SNPRINTF(tmpStr, 1000, "%soutputToCurrentDirectory = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soutputToCurrentDirectory = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soutputDirectory = \"%s\"\n", prefix, atts->GetOutputDirectory().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfileName = \"%s\"\n", prefix, atts->GetFileName().c_str());
    str += tmpStr;
    if(atts->GetFamily())
        SNPRINTF(tmpStr, 1000, "%sfamily = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfamily = 0\n", prefix);
    str += tmpStr;
    const char *format_names = "BMP, CURVE, JPEG, OBJ, PNG, "
        "POSTSCRIPT, POVRAY, PPM, RGB, "
        "STL, TIFF, ULTRA, VTK, "
        "PLY";
    switch (atts->GetFormat())
    {
      case SaveWindowAttributes::BMP:
          SNPRINTF(tmpStr, 1000, "%sformat = %sBMP  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::CURVE:
          SNPRINTF(tmpStr, 1000, "%sformat = %sCURVE  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::JPEG:
          SNPRINTF(tmpStr, 1000, "%sformat = %sJPEG  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::OBJ:
          SNPRINTF(tmpStr, 1000, "%sformat = %sOBJ  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::PNG:
          SNPRINTF(tmpStr, 1000, "%sformat = %sPNG  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::POSTSCRIPT:
          SNPRINTF(tmpStr, 1000, "%sformat = %sPOSTSCRIPT  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::POVRAY:
          SNPRINTF(tmpStr, 1000, "%sformat = %sPOVRAY  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::PPM:
          SNPRINTF(tmpStr, 1000, "%sformat = %sPPM  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::RGB:
          SNPRINTF(tmpStr, 1000, "%sformat = %sRGB  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::STL:
          SNPRINTF(tmpStr, 1000, "%sformat = %sSTL  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::TIFF:
          SNPRINTF(tmpStr, 1000, "%sformat = %sTIFF  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::ULTRA:
          SNPRINTF(tmpStr, 1000, "%sformat = %sULTRA  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::VTK:
          SNPRINTF(tmpStr, 1000, "%sformat = %sVTK  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::PLY:
          SNPRINTF(tmpStr, 1000, "%sformat = %sPLY  # %s\n", prefix, prefix, format_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%swidth = %d\n", prefix, atts->GetWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sheight = %d\n", prefix, atts->GetHeight());
    str += tmpStr;
    if(atts->GetScreenCapture())
        SNPRINTF(tmpStr, 1000, "%sscreenCapture = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sscreenCapture = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSaveTiled())
        SNPRINTF(tmpStr, 1000, "%ssaveTiled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssaveTiled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squality = %d\n", prefix, atts->GetQuality());
    str += tmpStr;
    if(atts->GetProgressive())
        SNPRINTF(tmpStr, 1000, "%sprogressive = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sprogressive = 0\n", prefix);
    str += tmpStr;
    if(atts->GetBinary())
        SNPRINTF(tmpStr, 1000, "%sbinary = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sbinary = 0\n", prefix);
    str += tmpStr;
    if(atts->GetStereo())
        SNPRINTF(tmpStr, 1000, "%sstereo = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sstereo = 0\n", prefix);
    str += tmpStr;
    const char *compression_names = "None, PackBits, Jpeg, Deflate";
    switch (atts->GetCompression())
    {
      case SaveWindowAttributes::None:
          SNPRINTF(tmpStr, 1000, "%scompression = %sNone  # %s\n", prefix, prefix, compression_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::PackBits:
          SNPRINTF(tmpStr, 1000, "%scompression = %sPackBits  # %s\n", prefix, prefix, compression_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::Jpeg:
          SNPRINTF(tmpStr, 1000, "%scompression = %sJpeg  # %s\n", prefix, prefix, compression_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::Deflate:
          SNPRINTF(tmpStr, 1000, "%scompression = %sDeflate  # %s\n", prefix, prefix, compression_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetForceMerge())
        SNPRINTF(tmpStr, 1000, "%sforceMerge = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sforceMerge = 0\n", prefix);
    str += tmpStr;
    const char *resConstraint_names = "NoConstraint, EqualWidthHeight, ScreenProportions";
    switch (atts->GetResConstraint())
    {
      case SaveWindowAttributes::NoConstraint:
          SNPRINTF(tmpStr, 1000, "%sresConstraint = %sNoConstraint  # %s\n", prefix, prefix, resConstraint_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::EqualWidthHeight:
          SNPRINTF(tmpStr, 1000, "%sresConstraint = %sEqualWidthHeight  # %s\n", prefix, prefix, resConstraint_names);
          str += tmpStr;
          break;
      case SaveWindowAttributes::ScreenProportions:
          SNPRINTF(tmpStr, 1000, "%sresConstraint = %sScreenProportions  # %s\n", prefix, prefix, resConstraint_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetAdvancedMultiWindowSave())
        SNPRINTF(tmpStr, 1000, "%sadvancedMultiWindowSave = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sadvancedMultiWindowSave = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAdvancedMultiWindowSave())
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "subWindowAtts.";
        str += PySaveSubWindowsAttributes_ToString(&atts->GetSubWindowAtts(), objPrefix.c_str());
    }
    return str;
}

static PyObject *
SaveWindowAttributes_Notify(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_SetOutputToCurrentDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputToCurrentDirectory in the object.
    obj->data->SetOutputToCurrentDirectory(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetOutputToCurrentDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOutputToCurrentDirectory()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetOutputDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outputDirectory in the object.
    obj->data->SetOutputDirectory(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetOutputDirectory(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutputDirectory().c_str());
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetFileName(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the fileName in the object.
    obj->data->SetFileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetFileName(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFileName().c_str());
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetFamily(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the family in the object.
    obj->data->SetFamily(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetFamily(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFamily()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetFormat(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the format in the object.
    if(ival >= 0 && ival < 14)
        obj->data->SetFormat(SaveWindowAttributes::FileFormat(ival));
    else
    {
        fprintf(stderr, "An invalid format value was given. "
                        "Valid values are in the range of [0,13]. "
                        "You can also use the following names: "
                        "BMP, CURVE, JPEG, OBJ, PNG, "
                        "POSTSCRIPT, POVRAY, PPM, RGB, "
                        "STL, TIFF, ULTRA, VTK, "
                        "PLY.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetFormat(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFormat()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetWidth(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
    obj->data->SetWidth((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetWidth(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWidth()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetHeight(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the height in the object.
    obj->data->SetHeight((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetHeight(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHeight()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetScreenCapture(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the screenCapture in the object.
    obj->data->SetScreenCapture(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetScreenCapture(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScreenCapture()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetSaveTiled(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the saveTiled in the object.
    obj->data->SetSaveTiled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetSaveTiled(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSaveTiled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetQuality(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quality in the object.
    obj->data->SetQuality((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetQuality(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuality()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetProgressive(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the progressive in the object.
    obj->data->SetProgressive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetProgressive(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetProgressive()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetBinary(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the binary in the object.
    obj->data->SetBinary(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetBinary(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBinary()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetStereo(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereo in the object.
    obj->data->SetStereo(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetStereo(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStereo()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetCompression(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the compression in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetCompression(SaveWindowAttributes::CompressionType(ival));
    else
    {
        fprintf(stderr, "An invalid compression value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, PackBits, Jpeg, Deflate.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetCompression(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCompression()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetForceMerge(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceMerge in the object.
    obj->data->SetForceMerge(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetForceMerge(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceMerge()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetResConstraint(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resConstraint in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetResConstraint(SaveWindowAttributes::ResConstraint(ival));
    else
    {
        fprintf(stderr, "An invalid resConstraint value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "NoConstraint, EqualWidthHeight, ScreenProportions.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetResConstraint(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetResConstraint()));
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetAdvancedMultiWindowSave(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the advancedMultiWindowSave in the object.
    obj->data->SetAdvancedMultiWindowSave(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetAdvancedMultiWindowSave(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAdvancedMultiWindowSave()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SaveWindowAttributes_SetSubWindowAtts(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowsAttributes_Check(newValue))
    {
        fprintf(stderr, "The subWindowAtts field can only be set with SaveSubWindowsAttributes objects.\n");
        return NULL;
    }

    obj->data->SetSubWindowAtts(*PySaveSubWindowsAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveWindowAttributes_GetSubWindowAtts(PyObject *self, PyObject *args)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowsAttributes_Wrap(&obj->data->GetSubWindowAtts());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowsAttributes_SetParent(retval, self);

    return retval;
}



PyMethodDef PySaveWindowAttributes_methods[SAVEWINDOWATTRIBUTES_NMETH] = {
    {"Notify", SaveWindowAttributes_Notify, METH_VARARGS},
    {"SetOutputToCurrentDirectory", SaveWindowAttributes_SetOutputToCurrentDirectory, METH_VARARGS},
    {"GetOutputToCurrentDirectory", SaveWindowAttributes_GetOutputToCurrentDirectory, METH_VARARGS},
    {"SetOutputDirectory", SaveWindowAttributes_SetOutputDirectory, METH_VARARGS},
    {"GetOutputDirectory", SaveWindowAttributes_GetOutputDirectory, METH_VARARGS},
    {"SetFileName", SaveWindowAttributes_SetFileName, METH_VARARGS},
    {"GetFileName", SaveWindowAttributes_GetFileName, METH_VARARGS},
    {"SetFamily", SaveWindowAttributes_SetFamily, METH_VARARGS},
    {"GetFamily", SaveWindowAttributes_GetFamily, METH_VARARGS},
    {"SetFormat", SaveWindowAttributes_SetFormat, METH_VARARGS},
    {"GetFormat", SaveWindowAttributes_GetFormat, METH_VARARGS},
    {"SetWidth", SaveWindowAttributes_SetWidth, METH_VARARGS},
    {"GetWidth", SaveWindowAttributes_GetWidth, METH_VARARGS},
    {"SetHeight", SaveWindowAttributes_SetHeight, METH_VARARGS},
    {"GetHeight", SaveWindowAttributes_GetHeight, METH_VARARGS},
    {"SetScreenCapture", SaveWindowAttributes_SetScreenCapture, METH_VARARGS},
    {"GetScreenCapture", SaveWindowAttributes_GetScreenCapture, METH_VARARGS},
    {"SetSaveTiled", SaveWindowAttributes_SetSaveTiled, METH_VARARGS},
    {"GetSaveTiled", SaveWindowAttributes_GetSaveTiled, METH_VARARGS},
    {"SetQuality", SaveWindowAttributes_SetQuality, METH_VARARGS},
    {"GetQuality", SaveWindowAttributes_GetQuality, METH_VARARGS},
    {"SetProgressive", SaveWindowAttributes_SetProgressive, METH_VARARGS},
    {"GetProgressive", SaveWindowAttributes_GetProgressive, METH_VARARGS},
    {"SetBinary", SaveWindowAttributes_SetBinary, METH_VARARGS},
    {"GetBinary", SaveWindowAttributes_GetBinary, METH_VARARGS},
    {"SetStereo", SaveWindowAttributes_SetStereo, METH_VARARGS},
    {"GetStereo", SaveWindowAttributes_GetStereo, METH_VARARGS},
    {"SetCompression", SaveWindowAttributes_SetCompression, METH_VARARGS},
    {"GetCompression", SaveWindowAttributes_GetCompression, METH_VARARGS},
    {"SetForceMerge", SaveWindowAttributes_SetForceMerge, METH_VARARGS},
    {"GetForceMerge", SaveWindowAttributes_GetForceMerge, METH_VARARGS},
    {"SetResConstraint", SaveWindowAttributes_SetResConstraint, METH_VARARGS},
    {"GetResConstraint", SaveWindowAttributes_GetResConstraint, METH_VARARGS},
    {"SetAdvancedMultiWindowSave", SaveWindowAttributes_SetAdvancedMultiWindowSave, METH_VARARGS},
    {"GetAdvancedMultiWindowSave", SaveWindowAttributes_GetAdvancedMultiWindowSave, METH_VARARGS},
    {"SetSubWindowAtts", SaveWindowAttributes_SetSubWindowAtts, METH_VARARGS},
    {"GetSubWindowAtts", SaveWindowAttributes_GetSubWindowAtts, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SaveWindowAttributes_dealloc(PyObject *v)
{
   SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SaveWindowAttributes_compare(PyObject *v, PyObject *w)
{
    SaveWindowAttributes *a = ((SaveWindowAttributesObject *)v)->data;
    SaveWindowAttributes *b = ((SaveWindowAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySaveWindowAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "outputToCurrentDirectory") == 0)
        return SaveWindowAttributes_GetOutputToCurrentDirectory(self, NULL);
    if(strcmp(name, "outputDirectory") == 0)
        return SaveWindowAttributes_GetOutputDirectory(self, NULL);
    if(strcmp(name, "fileName") == 0)
        return SaveWindowAttributes_GetFileName(self, NULL);
    if(strcmp(name, "family") == 0)
        return SaveWindowAttributes_GetFamily(self, NULL);
    if(strcmp(name, "format") == 0)
        return SaveWindowAttributes_GetFormat(self, NULL);
    if(strcmp(name, "BMP") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::BMP));
    if(strcmp(name, "CURVE") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::CURVE));
    if(strcmp(name, "JPEG") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::JPEG));
    if(strcmp(name, "OBJ") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::OBJ));
    if(strcmp(name, "PNG") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PNG));
    if(strcmp(name, "POSTSCRIPT") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::POSTSCRIPT));
    if(strcmp(name, "POVRAY") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::POVRAY));
    if(strcmp(name, "PPM") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PPM));
    if(strcmp(name, "RGB") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::RGB));
    if(strcmp(name, "STL") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::STL));
    if(strcmp(name, "TIFF") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::TIFF));
    if(strcmp(name, "ULTRA") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::ULTRA));
    if(strcmp(name, "VTK") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::VTK));
    if(strcmp(name, "PLY") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PLY));

    if(strcmp(name, "width") == 0)
        return SaveWindowAttributes_GetWidth(self, NULL);
    if(strcmp(name, "height") == 0)
        return SaveWindowAttributes_GetHeight(self, NULL);
    if(strcmp(name, "screenCapture") == 0)
        return SaveWindowAttributes_GetScreenCapture(self, NULL);
    if(strcmp(name, "saveTiled") == 0)
        return SaveWindowAttributes_GetSaveTiled(self, NULL);
    if(strcmp(name, "quality") == 0)
        return SaveWindowAttributes_GetQuality(self, NULL);
    if(strcmp(name, "progressive") == 0)
        return SaveWindowAttributes_GetProgressive(self, NULL);
    if(strcmp(name, "binary") == 0)
        return SaveWindowAttributes_GetBinary(self, NULL);
    if(strcmp(name, "stereo") == 0)
        return SaveWindowAttributes_GetStereo(self, NULL);
    if(strcmp(name, "compression") == 0)
        return SaveWindowAttributes_GetCompression(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::None));
    if(strcmp(name, "PackBits") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::PackBits));
    if(strcmp(name, "Jpeg") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::Jpeg));
    if(strcmp(name, "Deflate") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::Deflate));

    if(strcmp(name, "forceMerge") == 0)
        return SaveWindowAttributes_GetForceMerge(self, NULL);
    if(strcmp(name, "resConstraint") == 0)
        return SaveWindowAttributes_GetResConstraint(self, NULL);
    if(strcmp(name, "NoConstraint") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::NoConstraint));
    if(strcmp(name, "EqualWidthHeight") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::EqualWidthHeight));
    if(strcmp(name, "ScreenProportions") == 0)
        return PyInt_FromLong(long(SaveWindowAttributes::ScreenProportions));

    if(strcmp(name, "advancedMultiWindowSave") == 0)
        return SaveWindowAttributes_GetAdvancedMultiWindowSave(self, NULL);
    if(strcmp(name, "subWindowAtts") == 0)
        return SaveWindowAttributes_GetSubWindowAtts(self, NULL);

    return Py_FindMethod(PySaveWindowAttributes_methods, self, name);
}

int
PySaveWindowAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "outputToCurrentDirectory") == 0)
        obj = SaveWindowAttributes_SetOutputToCurrentDirectory(self, tuple);
    else if(strcmp(name, "outputDirectory") == 0)
        obj = SaveWindowAttributes_SetOutputDirectory(self, tuple);
    else if(strcmp(name, "fileName") == 0)
        obj = SaveWindowAttributes_SetFileName(self, tuple);
    else if(strcmp(name, "family") == 0)
        obj = SaveWindowAttributes_SetFamily(self, tuple);
    else if(strcmp(name, "format") == 0)
        obj = SaveWindowAttributes_SetFormat(self, tuple);
    else if(strcmp(name, "width") == 0)
        obj = SaveWindowAttributes_SetWidth(self, tuple);
    else if(strcmp(name, "height") == 0)
        obj = SaveWindowAttributes_SetHeight(self, tuple);
    else if(strcmp(name, "screenCapture") == 0)
        obj = SaveWindowAttributes_SetScreenCapture(self, tuple);
    else if(strcmp(name, "saveTiled") == 0)
        obj = SaveWindowAttributes_SetSaveTiled(self, tuple);
    else if(strcmp(name, "quality") == 0)
        obj = SaveWindowAttributes_SetQuality(self, tuple);
    else if(strcmp(name, "progressive") == 0)
        obj = SaveWindowAttributes_SetProgressive(self, tuple);
    else if(strcmp(name, "binary") == 0)
        obj = SaveWindowAttributes_SetBinary(self, tuple);
    else if(strcmp(name, "stereo") == 0)
        obj = SaveWindowAttributes_SetStereo(self, tuple);
    else if(strcmp(name, "compression") == 0)
        obj = SaveWindowAttributes_SetCompression(self, tuple);
    else if(strcmp(name, "forceMerge") == 0)
        obj = SaveWindowAttributes_SetForceMerge(self, tuple);
    else if(strcmp(name, "resConstraint") == 0)
        obj = SaveWindowAttributes_SetResConstraint(self, tuple);
    else if(strcmp(name, "advancedMultiWindowSave") == 0)
        obj = SaveWindowAttributes_SetAdvancedMultiWindowSave(self, tuple);
    else if(strcmp(name, "subWindowAtts") == 0)
        obj = SaveWindowAttributes_SetSubWindowAtts(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SaveWindowAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;
    fprintf(fp, "%s", PySaveWindowAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SaveWindowAttributes_str(PyObject *v)
{
    SaveWindowAttributesObject *obj = (SaveWindowAttributesObject *)v;
    return PyString_FromString(PySaveWindowAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SaveWindowAttributes_Purpose = "This class contains the attributes used for saving windows.";
#else
static char *SaveWindowAttributes_Purpose = "This class contains the attributes used for saving windows.";
#endif

//
// The type description structure
//
static PyTypeObject SaveWindowAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SaveWindowAttributes",                    // tp_name
    sizeof(SaveWindowAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SaveWindowAttributes_dealloc,  // tp_dealloc
    (printfunc)SaveWindowAttributes_print,     // tp_print
    (getattrfunc)PySaveWindowAttributes_getattr, // tp_getattr
    (setattrfunc)PySaveWindowAttributes_setattr, // tp_setattr
    (cmpfunc)SaveWindowAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SaveWindowAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SaveWindowAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SaveWindowAttributes *defaultAtts = 0;
static SaveWindowAttributes *currentAtts = 0;

static PyObject *
NewSaveWindowAttributes(int useCurrent)
{
    SaveWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveWindowAttributesObject, &SaveWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SaveWindowAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SaveWindowAttributes(*defaultAtts);
    else
        newObject->data = new SaveWindowAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSaveWindowAttributes(const SaveWindowAttributes *attr)
{
    SaveWindowAttributesObject *newObject;
    newObject = PyObject_NEW(SaveWindowAttributesObject, &SaveWindowAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SaveWindowAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SaveWindowAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSaveWindowAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SaveWindowAttributesMethods[] = {
    {"SaveWindowAttributes", SaveWindowAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SaveWindowAttributesObserver = 0;

std::string
PySaveWindowAttributes_GetLogString()
{
    std::string s("SaveWindowAtts = SaveWindowAttributes()\n");
    if(currentAtts != 0)
        s += PySaveWindowAttributes_ToString(currentAtts, "SaveWindowAtts.");
    return s;
}

static void
PySaveWindowAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SaveWindowAtts = SaveWindowAttributes()\n");
        s += PySaveWindowAttributes_ToString(currentAtts, "SaveWindowAtts.");
        cb(s);
    }
}

void
PySaveWindowAttributes_StartUp(SaveWindowAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySaveWindowAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SaveWindowAttributesObserver == 0)
    {
        SaveWindowAttributesObserver = new ObserverToCallback(subj,
            PySaveWindowAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySaveWindowAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SaveWindowAttributesObserver;
    SaveWindowAttributesObserver = 0;
}

PyMethodDef *
PySaveWindowAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SaveWindowAttributesMethods;
}

bool
PySaveWindowAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SaveWindowAttributesType);
}

SaveWindowAttributes *
PySaveWindowAttributes_FromPyObject(PyObject *obj)
{
    SaveWindowAttributesObject *obj2 = (SaveWindowAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySaveWindowAttributes_New()
{
    return NewSaveWindowAttributes(0);
}

PyObject *
PySaveWindowAttributes_Wrap(const SaveWindowAttributes *attr)
{
    return WrapSaveWindowAttributes(attr);
}

void
PySaveWindowAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SaveWindowAttributesObject *obj2 = (SaveWindowAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySaveWindowAttributes_SetDefaults(const SaveWindowAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SaveWindowAttributes(*atts);
}

