/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                            avtExodusOptions.h                             //
// ************************************************************************* //

#ifndef AVT_Exodus_OPTIONS_H
#define AVT_Exodus_OPTIONS_H

class DBOptionsAttributes;

#include <string>

namespace ExodusDBOptions
{
    typedef enum _mat_conv_t
    {
        None,
        Alegra,
        CTH,
        Custom
    } mat_conv_t;

    // Read options labels
    char const * const EXODUS_DETECT_COMPOUND_VARS = "Automagically Detect Compound Variables";
    char const * const EXODUS_MATERIAL_CONVENTION = "Use Material Convention";
    char const * const EXODUS_MATERIAL_COUNT = "Material Count (-1=guess)";
    char const * const EXODUS_VOLFRAC_NAMESCHEME = "Namescheme for material volume fractions"; 
    char const * const EXODUS_MATSPEC_NAMESCHEME = "Namescheme for material specific variables"; 

    // Read options default values
    // Note that the n>0 path specifies a namescheme sub-expression bracketed by '&' chars.
    char const * const EXODUS_VOLFRAC_NAMESCHEME_ALEGRA = "@%s@n?'&VOLFRC_%d&n&':'VOID_FRC':@";
    char const * const EXODUS_MATSPEC_NAMESCHEME_ALEGRA = "@%V_%d@n";

    char const * const EXODUS_VOLFRAC_NAMESCHEME_CTH = "@%s@n?'&VOLM_%d&n&':'VOID_FRC':@";
    char const * const EXODUS_MATSPEC_NAMESCHEME_CTH = "@%V_%d@n";
}

// ****************************************************************************
//  Functions: avtExodusOptions
//
//  Purpose:
//      Creates the options for  Exodus readers and/or writers.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 14:10:56 PST 2007
//
// ****************************************************************************

DBOptionsAttributes *GetExodusReadOptions(void);
DBOptionsAttributes *GetExodusWriteOptions(void);


#endif
