/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SelectionSummary.h>
#include <DataNode.h>
#include <SelectionVariableSummary.h>

// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Init utility for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SelectionSummary::Init()
{
    cellCount = 0;
    totalCellCount = 0;
    histogramMinBin = 0;
    histogramMaxBin = 1;

    SelectionSummary::SelectAll();
}

// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Copy utility for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SelectionSummary::Copy(const SelectionSummary &obj)
{
    AttributeGroupVector::const_iterator pos;

    name = obj.name;
    // *** Copy the variables field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = variables.begin(); pos != variables.end(); ++pos)
        delete *pos;
    variables.clear();
    if(obj.variables.size() > 0)
        variables.reserve(obj.variables.size());
    // Duplicate the variables from obj.
    for(pos = obj.variables.begin(); pos != obj.variables.end(); ++pos)
    {
        SelectionVariableSummary *oldSelectionVariableSummary = (SelectionVariableSummary *)(*pos);
        SelectionVariableSummary *newSelectionVariableSummary = new SelectionVariableSummary(*oldSelectionVariableSummary);
        variables.push_back(newSelectionVariableSummary);
    }

    cellCount = obj.cellCount;
    totalCellCount = obj.totalCellCount;
    histogramValues = obj.histogramValues;
    histogramMinBin = obj.histogramMinBin;
    histogramMaxBin = obj.histogramMaxBin;

    SelectionSummary::SelectAll();
}

// Type map format string
const char *SelectionSummary::TypeMapFormatString = SELECTIONSUMMARY_TMFS;
const AttributeGroup::private_tmfs_t SelectionSummary::TmfsStruct = {SELECTIONSUMMARY_TMFS};


// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Default constructor for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary::SelectionSummary() : 
    AttributeSubject(SelectionSummary::TypeMapFormatString)
{
    SelectionSummary::Init();
}

// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Constructor for the derived classes of SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary::SelectionSummary(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SelectionSummary::Init();
}

// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Copy constructor for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary::SelectionSummary(const SelectionSummary &obj) : 
    AttributeSubject(SelectionSummary::TypeMapFormatString)
{
    SelectionSummary::Copy(obj);
}

// ****************************************************************************
// Method: SelectionSummary::SelectionSummary
//
// Purpose: 
//   Copy constructor for derived classes of the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary::SelectionSummary(const SelectionSummary &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SelectionSummary::Copy(obj);
}

// ****************************************************************************
// Method: SelectionSummary::~SelectionSummary
//
// Purpose: 
//   Destructor for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary::~SelectionSummary()
{
    AttributeGroupVector::iterator pos;

    // Destroy the variables field.
    for(pos = variables.begin(); pos != variables.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: SelectionSummary::operator = 
//
// Purpose: 
//   Assignment operator for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary& 
SelectionSummary::operator = (const SelectionSummary &obj)
{
    if (this == &obj) return *this;

    SelectionSummary::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SelectionSummary::operator == 
//
// Purpose: 
//   Comparison operator == for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionSummary::operator == (const SelectionSummary &obj) const
{
    bool variables_equal = (obj.variables.size() == variables.size());
    for(size_t i = 0; (i < variables.size()) && variables_equal; ++i)
    {
        // Make references to SelectionVariableSummary from AttributeGroup *.
        const SelectionVariableSummary &variables1 = *((const SelectionVariableSummary *)(variables[i]));
        const SelectionVariableSummary &variables2 = *((const SelectionVariableSummary *)(obj.variables[i]));
        variables_equal = (variables1 == variables2);
    }

    // Create the return value
    return ((name == obj.name) &&
            variables_equal &&
            (cellCount == obj.cellCount) &&
            (totalCellCount == obj.totalCellCount) &&
            (histogramValues == obj.histogramValues) &&
            (histogramMinBin == obj.histogramMinBin) &&
            (histogramMaxBin == obj.histogramMaxBin));
}

// ****************************************************************************
// Method: SelectionSummary::operator != 
//
// Purpose: 
//   Comparison operator != for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionSummary::operator != (const SelectionSummary &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SelectionSummary::TypeName
//
// Purpose: 
//   Type name method for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SelectionSummary::TypeName() const
{
    return "SelectionSummary";
}

// ****************************************************************************
// Method: SelectionSummary::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionSummary::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SelectionSummary *tmp = (const SelectionSummary *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SelectionSummary::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SelectionSummary::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SelectionSummary(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SelectionSummary::NewInstance
//
// Purpose: 
//   NewInstance method for the SelectionSummary class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SelectionSummary::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SelectionSummary(*this);
    else
        retval = new SelectionSummary;

    return retval;
}

// ****************************************************************************
// Method: SelectionSummary::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionSummary::SelectAll()
{
    Select(ID_name,            (void *)&name);
    Select(ID_variables,       (void *)&variables);
    Select(ID_cellCount,       (void *)&cellCount);
    Select(ID_totalCellCount,  (void *)&totalCellCount);
    Select(ID_histogramValues, (void *)&histogramValues);
    Select(ID_histogramMinBin, (void *)&histogramMinBin);
    Select(ID_histogramMaxBin, (void *)&histogramMaxBin);
}

// ****************************************************************************
// Method: SelectionSummary::CreateSubAttributeGroup
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
SelectionSummary::CreateSubAttributeGroup(int)
{
    return new SelectionVariableSummary;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionSummary::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionSummary::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SelectionSummary defaultObject;
    bool addToParent = false;
    // Create a node for SelectionSummary.
    DataNode *node = new DataNode("SelectionSummary");

    if(completeSave || !FieldsEqual(ID_name, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("name", name));
    }

    if(completeSave || !FieldsEqual(ID_variables, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < variables.size(); ++i)
            variables[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_cellCount, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cellCount", cellCount));
    }

    if(completeSave || !FieldsEqual(ID_totalCellCount, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("totalCellCount", totalCellCount));
    }

    if(completeSave || !FieldsEqual(ID_histogramValues, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("histogramValues", histogramValues));
    }

    if(completeSave || !FieldsEqual(ID_histogramMinBin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("histogramMinBin", histogramMinBin));
    }

    if(completeSave || !FieldsEqual(ID_histogramMaxBin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("histogramMaxBin", histogramMaxBin));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SelectionSummary::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionSummary::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SelectionSummary");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    if((node = searchNode->GetNode("name")) != 0)
        SetName(node->AsString());

    // Clear all the SelectionVariableSummarys if we got any.
    bool clearedVariables = false;
    // Go through all of the children and construct a new
    // SelectionVariableSummary for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("SelectionVariableSummary"))
            {
                if (!clearedVariables)
                {
                    ClearVariables();
                    clearedVariables = true;
                }
                SelectionVariableSummary temp;
                temp.SetFromNode(children[i]);
                AddVariables(temp);
            }
        }
    }

    if((node = searchNode->GetNode("cellCount")) != 0)
        SetCellCount(node->AsInt());
    if((node = searchNode->GetNode("totalCellCount")) != 0)
        SetTotalCellCount(node->AsInt());
    if((node = searchNode->GetNode("histogramValues")) != 0)
        SetHistogramValues(node->AsDoubleVector());
    if((node = searchNode->GetNode("histogramMinBin")) != 0)
        SetHistogramMinBin(node->AsDouble());
    if((node = searchNode->GetNode("histogramMaxBin")) != 0)
        SetHistogramMaxBin(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionSummary::SetName(const std::string &name_)
{
    name = name_;
    Select(ID_name, (void *)&name);
}

void
SelectionSummary::SetCellCount(int cellCount_)
{
    cellCount = cellCount_;
    Select(ID_cellCount, (void *)&cellCount);
}

void
SelectionSummary::SetTotalCellCount(int totalCellCount_)
{
    totalCellCount = totalCellCount_;
    Select(ID_totalCellCount, (void *)&totalCellCount);
}

void
SelectionSummary::SetHistogramValues(const doubleVector &histogramValues_)
{
    histogramValues = histogramValues_;
    Select(ID_histogramValues, (void *)&histogramValues);
}

void
SelectionSummary::SetHistogramMinBin(double histogramMinBin_)
{
    histogramMinBin = histogramMinBin_;
    Select(ID_histogramMinBin, (void *)&histogramMinBin);
}

void
SelectionSummary::SetHistogramMaxBin(double histogramMaxBin_)
{
    histogramMaxBin = histogramMaxBin_;
    Select(ID_histogramMaxBin, (void *)&histogramMaxBin);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SelectionSummary::GetName() const
{
    return name;
}

std::string &
SelectionSummary::GetName()
{
    return name;
}

const AttributeGroupVector &
SelectionSummary::GetVariables() const
{
    return variables;
}

AttributeGroupVector &
SelectionSummary::GetVariables()
{
    return variables;
}

int
SelectionSummary::GetCellCount() const
{
    return cellCount;
}

int
SelectionSummary::GetTotalCellCount() const
{
    return totalCellCount;
}

const doubleVector &
SelectionSummary::GetHistogramValues() const
{
    return histogramValues;
}

doubleVector &
SelectionSummary::GetHistogramValues()
{
    return histogramValues;
}

double
SelectionSummary::GetHistogramMinBin() const
{
    return histogramMinBin;
}

double
SelectionSummary::GetHistogramMaxBin() const
{
    return histogramMaxBin;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionSummary::SelectName()
{
    Select(ID_name, (void *)&name);
}

void
SelectionSummary::SelectVariables()
{
    Select(ID_variables, (void *)&variables);
}

void
SelectionSummary::SelectHistogramValues()
{
    Select(ID_histogramValues, (void *)&histogramValues);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionSummary::AddVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionSummary::AddVariables(const SelectionVariableSummary &obj)
{
    SelectionVariableSummary *newSelectionVariableSummary = new SelectionVariableSummary(obj);
    variables.push_back(newSelectionVariableSummary);

    // Indicate that things have changed by selecting it.
    Select(ID_variables, (void *)&variables);
}

// ****************************************************************************
// Method: SelectionSummary::ClearVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionSummary::ClearVariables()
{
    AttributeGroupVector::iterator pos;

    for(pos = variables.begin(); pos != variables.end(); ++pos)
        delete *pos;
    variables.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_variables, (void *)&variables);
}

// ****************************************************************************
// Method: SelectionSummary::RemoveVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionSummary::RemoveVariables(int index)
{
    AttributeGroupVector::iterator pos = variables.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != variables.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != variables.end())
    {
        delete *pos;
        variables.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_variables, (void *)&variables);
}

// ****************************************************************************
// Method: SelectionSummary::GetNumVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SelectionSummary::GetNumVariables() const
{
    return (int)variables.size();
}

// ****************************************************************************
// Method: SelectionSummary::GetVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionVariableSummary &
SelectionSummary::GetVariables(int i)
{
    return *((SelectionVariableSummary *)variables[i]);
}

// ****************************************************************************
// Method: SelectionSummary::GetVariables
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SelectionVariableSummary &
SelectionSummary::GetVariables(int i) const
{
    return *((SelectionVariableSummary *)variables[i]);
}

// ****************************************************************************
// Method: SelectionSummary::operator []
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionVariableSummary &
SelectionSummary::operator [] (int i)
{
    return *((SelectionVariableSummary *)variables[i]);
}

// ****************************************************************************
// Method: SelectionSummary::operator []
//
// Purpose: 
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SelectionVariableSummary &
SelectionSummary::operator [] (int i) const
{
    return *((SelectionVariableSummary *)variables[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionSummary::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SelectionSummary::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_name:            return "name";
    case ID_variables:       return "variables";
    case ID_cellCount:       return "cellCount";
    case ID_totalCellCount:  return "totalCellCount";
    case ID_histogramValues: return "histogramValues";
    case ID_histogramMinBin: return "histogramMinBin";
    case ID_histogramMaxBin: return "histogramMaxBin";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SelectionSummary::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SelectionSummary::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_name:            return FieldType_string;
    case ID_variables:       return FieldType_attVector;
    case ID_cellCount:       return FieldType_int;
    case ID_totalCellCount:  return FieldType_int;
    case ID_histogramValues: return FieldType_doubleVector;
    case ID_histogramMinBin: return FieldType_double;
    case ID_histogramMaxBin: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SelectionSummary::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SelectionSummary::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_name:            return "string";
    case ID_variables:       return "attVector";
    case ID_cellCount:       return "int";
    case ID_totalCellCount:  return "int";
    case ID_histogramValues: return "doubleVector";
    case ID_histogramMinBin: return "double";
    case ID_histogramMaxBin: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SelectionSummary::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionSummary::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SelectionSummary &obj = *((const SelectionSummary*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_name:
        {  // new scope
        retval = (name == obj.name);
        }
        break;
    case ID_variables:
        {  // new scope
        bool variables_equal = (obj.variables.size() == variables.size());
        for(size_t i = 0; (i < variables.size()) && variables_equal; ++i)
        {
            // Make references to SelectionVariableSummary from AttributeGroup *.
            const SelectionVariableSummary &variables1 = *((const SelectionVariableSummary *)(variables[i]));
            const SelectionVariableSummary &variables2 = *((const SelectionVariableSummary *)(obj.variables[i]));
            variables_equal = (variables1 == variables2);
        }

        retval = variables_equal;
        }
        break;
    case ID_cellCount:
        {  // new scope
        retval = (cellCount == obj.cellCount);
        }
        break;
    case ID_totalCellCount:
        {  // new scope
        retval = (totalCellCount == obj.totalCellCount);
        }
        break;
    case ID_histogramValues:
        {  // new scope
        retval = (histogramValues == obj.histogramValues);
        }
        break;
    case ID_histogramMinBin:
        {  // new scope
        retval = (histogramMinBin == obj.histogramMinBin);
        }
        break;
    case ID_histogramMaxBin:
        {  // new scope
        retval = (histogramMaxBin == obj.histogramMaxBin);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

