/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisLagrangianWindow.h"

#include <LagrangianAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisLagrangianWindow::QvisLagrangianWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLagrangianWindow::QvisLagrangianWindow(const int type,
                         LagrangianAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisLagrangianWindow::~QvisLagrangianWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLagrangianWindow::~QvisLagrangianWindow()
{
}


// ****************************************************************************
// Method: QvisLagrangianWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLagrangianWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    seedPointLabel = new QLabel(tr("Seed Point"), central);
    mainLayout->addWidget(seedPointLabel,0,0);
    seedPoint = new QLineEdit(central);
    connect(seedPoint, SIGNAL(returnPressed()),
            this, SLOT(seedPointProcessText()));
    mainLayout->addWidget(seedPoint, 0,1);

    numStepsLabel = new QLabel(tr("Number of steps"), central);
    mainLayout->addWidget(numStepsLabel,1,0);
    numSteps = new QLineEdit(central);
    connect(numSteps, SIGNAL(returnPressed()),
            this, SLOT(numStepsProcessText()));
    mainLayout->addWidget(numSteps, 1,1);

    XAxisSampleLabel = new QLabel(tr("X Axis Sample"), central);
    mainLayout->addWidget(XAxisSampleLabel,2,0);
    XAxisSample = new QWidget(central);
    XAxisSampleButtonGroup= new QButtonGroup(XAxisSample);
    QHBoxLayout *XAxisSampleLayout = new QHBoxLayout(XAxisSample);
    XAxisSampleLayout->setMargin(0);
    XAxisSampleLayout->setSpacing(10);
    QRadioButton *XAxisSamplesampleTypeStep = new QRadioButton(tr("Step"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeStep,0);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeStep);
    QRadioButton *XAxisSamplesampleTypeTime = new QRadioButton(tr("Time"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeTime,1);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeTime);
    QRadioButton *XAxisSamplesampleTypeArcLength = new QRadioButton(tr("ArcLength"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeArcLength,2);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeArcLength);
    QRadioButton *XAxisSamplesampleTypeSpeed = new QRadioButton(tr("Speed"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeSpeed,3);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeSpeed);
    QRadioButton *XAxisSamplesampleTypeVorticity = new QRadioButton(tr("Vorticity"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeVorticity,4);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeVorticity);
    QRadioButton *XAxisSamplesampleTypeVariable = new QRadioButton(tr("Variable"), XAxisSample);
    XAxisSampleButtonGroup->addButton(XAxisSamplesampleTypeVariable,5);
    XAxisSampleLayout->addWidget(XAxisSamplesampleTypeVariable);
    connect(XAxisSampleButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(XAxisSampleChanged(int)));
    mainLayout->addWidget(XAxisSample, 2,1);

    YAxisSampleLabel = new QLabel(tr("Y Axis Sample"), central);
    mainLayout->addWidget(YAxisSampleLabel,3,0);
    YAxisSample = new QWidget(central);
    YAxisSampleButtonGroup= new QButtonGroup(YAxisSample);
    QHBoxLayout *YAxisSampleLayout = new QHBoxLayout(YAxisSample);
    YAxisSampleLayout->setMargin(0);
    YAxisSampleLayout->setSpacing(10);
    QRadioButton *YAxisSamplesampleTypeStep = new QRadioButton(tr("Step"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeStep,0);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeStep);
    QRadioButton *YAxisSamplesampleTypeTime = new QRadioButton(tr("Time"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeTime,1);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeTime);
    QRadioButton *YAxisSamplesampleTypeArcLength = new QRadioButton(tr("ArcLength"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeArcLength,2);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeArcLength);
    QRadioButton *YAxisSamplesampleTypeSpeed = new QRadioButton(tr("Speed"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeSpeed,3);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeSpeed);
    QRadioButton *YAxisSamplesampleTypeVorticity = new QRadioButton(tr("Vorticity"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeVorticity,4);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeVorticity);
    QRadioButton *YAxisSamplesampleTypeVariable = new QRadioButton(tr("Variable"), YAxisSample);
    YAxisSampleButtonGroup->addButton(YAxisSamplesampleTypeVariable,5);
    YAxisSampleLayout->addWidget(YAxisSamplesampleTypeVariable);
    connect(YAxisSampleButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(YAxisSampleChanged(int)));
    mainLayout->addWidget(YAxisSample, 3,1);

    variableLabel = new QLabel(tr("Variable"), central);
    mainLayout->addWidget(variableLabel,4,0);
    int variableMask = QvisVariableButton::Scalars;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 4,1);

}


// ****************************************************************************
// Method: QvisLagrangianWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLagrangianWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case LagrangianAttributes::ID_seedPoint:
            seedPoint->setText(DoublesToQString(atts->GetSeedPoint(), 3));
            break;
          case LagrangianAttributes::ID_numSteps:
            numSteps->setText(IntToQString(atts->GetNumSteps()));
            break;
          case LagrangianAttributes::ID_XAxisSample:
            XAxisSampleButtonGroup->blockSignals(true);
            if(XAxisSampleButtonGroup->button((int)atts->GetXAxisSample()) != 0)
                XAxisSampleButtonGroup->button((int)atts->GetXAxisSample())->setChecked(true);
            XAxisSampleButtonGroup->blockSignals(false);
            break;
          case LagrangianAttributes::ID_YAxisSample:
            if (atts->GetYAxisSample() == LagrangianAttributes::Variable)
            {
                variable->setEnabled(true);
                if(variableLabel)
                    variableLabel->setEnabled(true);
            }
            else
            {
                variable->setEnabled(false);
                if(variableLabel)
                    variableLabel->setEnabled(false);
            }
            YAxisSampleButtonGroup->blockSignals(true);
            if(YAxisSampleButtonGroup->button((int)atts->GetYAxisSample()) != 0)
                YAxisSampleButtonGroup->button((int)atts->GetYAxisSample())->setChecked(true);
            YAxisSampleButtonGroup->blockSignals(false);
            break;
          case LagrangianAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisLagrangianWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLagrangianWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do seedPoint
    if(which_widget == LagrangianAttributes::ID_seedPoint || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(seedPoint, val, 3))
            atts->SetSeedPoint(val);
        else
        {
            ResettingError(tr("Seed Point"),
                DoublesToQString(atts->GetSeedPoint(),3));
            atts->SetSeedPoint(atts->GetSeedPoint());
        }
    }

    // Do numSteps
    if(which_widget == LagrangianAttributes::ID_numSteps || doAll)
    {
        int val;
        if(LineEditGetInt(numSteps, val))
            atts->SetNumSteps(val);
        else
        {
            ResettingError(tr("Number of steps"),
                IntToQString(atts->GetNumSteps()));
            atts->SetNumSteps(atts->GetNumSteps());
        }
    }

}


//
// Qt Slot functions
//


void
QvisLagrangianWindow::seedPointProcessText()
{
    GetCurrentValues(LagrangianAttributes::ID_seedPoint);
    Apply();
}


void
QvisLagrangianWindow::numStepsProcessText()
{
    GetCurrentValues(LagrangianAttributes::ID_numSteps);
    Apply();
}


void
QvisLagrangianWindow::XAxisSampleChanged(int val)
{
    if(val != atts->GetXAxisSample())
    {
        atts->SetXAxisSample(LagrangianAttributes::sampleType(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisLagrangianWindow::YAxisSampleChanged(int val)
{
    if(val != atts->GetYAxisSample())
    {
        atts->SetYAxisSample(LagrangianAttributes::sampleType(val));
        Apply();
    }
}


void
QvisLagrangianWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


