/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef VIEWERRPC_H
#define VIEWERRPC_H
#include <viewerrpc_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ViewerRPC
//
// Purpose:
//    This class contains the attributes for controlling the viewer.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class VIEWER_RPC_API ViewerRPC : public AttributeSubject
{
public:
    enum ViewerRPCType
    {
        CloseRPC,
        DetachRPC,
        AddWindowRPC,
        DeleteWindowRPC,
        SetWindowLayoutRPC,
        SetActiveWindowRPC,
        ClearWindowRPC,
        ClearAllWindowsRPC,
        OpenDatabaseRPC,
        CloseDatabaseRPC,
        ActivateDatabaseRPC,
        CheckForNewStatesRPC,
        CreateDatabaseCorrelationRPC,
        AlterDatabaseCorrelationRPC,
        DeleteDatabaseCorrelationRPC,
        ReOpenDatabaseRPC,
        ReplaceDatabaseRPC,
        OverlayDatabaseRPC,
        OpenComputeEngineRPC,
        CloseComputeEngineRPC,
        AnimationSetNFramesRPC,
        AnimationPlayRPC,
        AnimationReversePlayRPC,
        AnimationStopRPC,
        TimeSliderNextStateRPC,
        TimeSliderPreviousStateRPC,
        SetTimeSliderStateRPC,
        SetActiveTimeSliderRPC,
        AddPlotRPC,
        AddEmbeddedPlotRPC,
        SetPlotFrameRangeRPC,
        DeletePlotKeyframeRPC,
        MovePlotKeyframeRPC,
        DeleteActivePlotsRPC,
        HideActivePlotsRPC,
        DrawPlotsRPC,
        DisableRedrawRPC,
        RedrawRPC,
        SetActivePlotsRPC,
        ChangeActivePlotsVarRPC,
        AddOperatorRPC,
        AddInitializedOperatorRPC,
        PromoteOperatorRPC,
        DemoteOperatorRPC,
        RemoveOperatorRPC,
        RemoveLastOperatorRPC,
        RemoveAllOperatorsRPC,
        SaveWindowRPC,
        SetDefaultPlotOptionsRPC,
        SetPlotOptionsRPC,
        SetDefaultOperatorOptionsRPC,
        SetOperatorOptionsRPC,
        WriteConfigFileRPC,
        ConnectToMetaDataServerRPC,
        IconifyAllWindowsRPC,
        DeIconifyAllWindowsRPC,
        ShowAllWindowsRPC,
        HideAllWindowsRPC,
        UpdateColorTableRPC,
        SetAnnotationAttributesRPC,
        SetDefaultAnnotationAttributesRPC,
        ResetAnnotationAttributesRPC,
        SetKeyframeAttributesRPC,
        SetPlotSILRestrictionRPC,
        SetViewAxisArrayRPC,
        SetViewCurveRPC,
        SetView2DRPC,
        SetView3DRPC,
        ResetPlotOptionsRPC,
        ResetOperatorOptionsRPC,
        SetAppearanceRPC,
        ProcessExpressionsRPC,
        SetLightListRPC,
        SetDefaultLightListRPC,
        ResetLightListRPC,
        SetAnimationAttributesRPC,
        SetWindowAreaRPC,
        PrintWindowRPC,
        ResetViewRPC,
        RecenterViewRPC,
        ToggleAllowPopupRPC,
        ToggleMaintainViewModeRPC,
        ToggleBoundingBoxModeRPC,
        ToggleCameraViewModeRPC,
        TogglePerspectiveViewRPC,
        ToggleSpinModeRPC,
        ToggleLockTimeRPC,
        ToggleLockToolsRPC,
        ToggleLockViewModeRPC,
        ToggleFullFrameRPC,
        UndoViewRPC,
        RedoViewRPC,
        InvertBackgroundRPC,
        ClearPickPointsRPC,
        SetWindowModeRPC,
        EnableToolRPC,
        SetToolUpdateModeRPC,
        CopyViewToWindowRPC,
        CopyLightingToWindowRPC,
        CopyAnnotationsToWindowRPC,
        CopyPlotsToWindowRPC,
        ClearCacheRPC,
        ClearCacheForAllEnginesRPC,
        SetViewExtentsTypeRPC,
        ClearRefLinesRPC,
        SetRenderingAttributesRPC,
        QueryRPC,
        CloneWindowRPC,
        SetMaterialAttributesRPC,
        SetDefaultMaterialAttributesRPC,
        ResetMaterialAttributesRPC,
        SetPlotDatabaseStateRPC,
        DeletePlotDatabaseKeyframeRPC,
        MovePlotDatabaseKeyframeRPC,
        ClearViewKeyframesRPC,
        DeleteViewKeyframeRPC,
        MoveViewKeyframeRPC,
        SetViewKeyframeRPC,
        OpenMDServerRPC,
        EnableToolbarRPC,
        HideToolbarsRPC,
        HideToolbarsForAllWindowsRPC,
        ShowToolbarsRPC,
        ShowToolbarsForAllWindowsRPC,
        SetToolbarIconSizeRPC,
        SaveViewRPC,
        SetGlobalLineoutAttributesRPC,
        SetPickAttributesRPC,
        ExportColorTableRPC,
        ExportEntireStateRPC,
        ImportEntireStateRPC,
        ImportEntireStateWithDifferentSourcesRPC,
        ResetPickAttributesRPC,
        AddAnnotationObjectRPC,
        HideActiveAnnotationObjectsRPC,
        DeleteActiveAnnotationObjectsRPC,
        RaiseActiveAnnotationObjectsRPC,
        LowerActiveAnnotationObjectsRPC,
        SetAnnotationObjectOptionsRPC,
        SetDefaultAnnotationObjectListRPC,
        ResetAnnotationObjectListRPC,
        ResetPickLetterRPC,
        SetDefaultPickAttributesRPC,
        ChooseCenterOfRotationRPC,
        SetCenterOfRotationRPC,
        SetQueryOverTimeAttributesRPC,
        SetDefaultQueryOverTimeAttributesRPC,
        ResetQueryOverTimeAttributesRPC,
        ResetLineoutColorRPC,
        SetInteractorAttributesRPC,
        SetDefaultInteractorAttributesRPC,
        ResetInteractorAttributesRPC,
        GetProcInfoRPC,
        SendSimulationCommandRPC,
        UpdateDBPluginInfoRPC,
        ExportDBRPC,
        SetTryHarderCyclesTimesRPC,
        OpenClientRPC,
        OpenGUIClientRPC,
        OpenCLIClientRPC,
        SuppressQueryOutputRPC,
        SetQueryFloatFormatRPC,
        SetMeshManagementAttributesRPC,
        SetDefaultMeshManagementAttributesRPC,
        ResetMeshManagementAttributesRPC,
        ResizeWindowRPC,
        MoveWindowRPC,
        MoveAndResizeWindowRPC,
        SetStateLoggingRPC,
        ConstructDataBinningRPC,
        RequestMetaDataRPC,
        SetTreatAllDBsAsTimeVaryingRPC,
        SetCreateMeshQualityExpressionsRPC,
        SetCreateTimeDerivativeExpressionsRPC,
        SetCreateVectorMagnitudeExpressionsRPC,
        SetPrecisionTypeRPC,
        SetBackendTypeRPC,
        CopyActivePlotsRPC,
        SetPlotFollowsTimeRPC,
        TurnOffAllLocksRPC,
        SetDefaultFileOpenOptionsRPC,
        SetSuppressMessagesRPC,
        ApplyNamedSelectionRPC,
        CreateNamedSelectionRPC,
        DeleteNamedSelectionRPC,
        LoadNamedSelectionRPC,
        SaveNamedSelectionRPC,
        SetNamedSelectionAutoApplyRPC,
        UpdateNamedSelectionRPC,
        InitializeNamedSelectionVariablesRPC,
        MenuQuitRPC,
        SetPlotDescriptionRPC,
        MovePlotOrderTowardFirstRPC,
        MovePlotOrderTowardLastRPC,
        SetPlotOrderToFirstRPC,
        SetPlotOrderToLastRPC,
        RenamePickLabelRPC,
        GetQueryParametersRPC,
        DDTConnectRPC,
        DDTFocusRPC,
        ReleaseToDDTRPC,
        PlotDDTVispointVariablesRPC,
        ExportRPC,
        ExportHostProfileRPC,
        ReadHostProfilesFromDirectoryRPC,
        SetRemoveDuplicateNodesRPC,
        MaxRPC
    };

    // These constructors are for objects of this class
    ViewerRPC();
    ViewerRPC(const ViewerRPC &obj);
protected:
    // These constructors are for objects derived from this class
    ViewerRPC(private_tmfs_t tmfs);
    ViewerRPC(const ViewerRPC &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewerRPC();

    virtual ViewerRPC& operator = (const ViewerRPC &obj);
    virtual bool operator == (const ViewerRPC &obj) const;
    virtual bool operator != (const ViewerRPC &obj) const;
private:
    void Init();
    void Copy(const ViewerRPC &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectWindowArea();
    void SelectDatabase();
    void SelectProgramHost();
    void SelectProgramSim();
    void SelectProgramOptions();
    void SelectFrameRange();
    void SelectVariable();
    void SelectActivePlotIds();
    void SelectActiveOperatorIds();
    void SelectExpandedPlotIds();
    void SelectColorTableName();
    void SelectQueryName();
    void SelectQueryPoint1();
    void SelectStringArg1();
    void SelectStringArg2();
    void SelectQueryParams();

    // Property setting methods
    void SetRPCType(ViewerRPCType RPCType_);
    void SetWindowLayout(int windowLayout_);
    void SetWindowId(int windowId_);
    void SetWindowMode(int windowMode_);
    void SetWindowArea(const std::string &windowArea_);
    void SetDatabase(const std::string &database_);
    void SetProgramHost(const std::string &programHost_);
    void SetProgramSim(const std::string &programSim_);
    void SetProgramOptions(const stringVector &programOptions_);
    void SetNFrames(int nFrames_);
    void SetStateNumber(int stateNumber_);
    void SetFrameRange(const int *frameRange_);
    void SetFrame(int frame_);
    void SetPlotType(int plotType_);
    void SetOperatorType(int operatorType_);
    void SetVariable(const std::string &variable_);
    void SetActivePlotIds(const intVector &activePlotIds_);
    void SetActiveOperatorIds(const intVector &activeOperatorIds_);
    void SetExpandedPlotIds(const intVector &expandedPlotIds_);
    void SetColorTableName(const std::string &colorTableName_);
    void SetQueryName(const std::string &queryName_);
    void SetQueryPoint1(const double *queryPoint1_);
    void SetToolId(int toolId_);
    void SetEmbeddedPlotId(int embeddedPlotId_);
    void SetBoolFlag(bool boolFlag_);
    void SetIntArg1(int intArg1_);
    void SetIntArg2(int intArg2_);
    void SetIntArg3(int intArg3_);
    void SetStringArg1(const std::string &stringArg1_);
    void SetStringArg2(const std::string &stringArg2_);
    void SetToolUpdateMode(int toolUpdateMode_);
    void SetQueryParams(const MapNode &queryParams_);

    // Property getting methods
    ViewerRPCType      GetRPCType() const;
    int                GetWindowLayout() const;
    int                GetWindowId() const;
    int                GetWindowMode() const;
    const std::string  &GetWindowArea() const;
          std::string  &GetWindowArea();
    const std::string  &GetDatabase() const;
          std::string  &GetDatabase();
    const std::string  &GetProgramHost() const;
          std::string  &GetProgramHost();
    const std::string  &GetProgramSim() const;
          std::string  &GetProgramSim();
    const stringVector &GetProgramOptions() const;
          stringVector &GetProgramOptions();
    int                GetNFrames() const;
    int                GetStateNumber() const;
    const int          *GetFrameRange() const;
          int          *GetFrameRange();
    int                GetFrame() const;
    int                GetPlotType() const;
    int                GetOperatorType() const;
    const std::string  &GetVariable() const;
          std::string  &GetVariable();
    const intVector    &GetActivePlotIds() const;
          intVector    &GetActivePlotIds();
    const intVector    &GetActiveOperatorIds() const;
          intVector    &GetActiveOperatorIds();
    const intVector    &GetExpandedPlotIds() const;
          intVector    &GetExpandedPlotIds();
    const std::string  &GetColorTableName() const;
          std::string  &GetColorTableName();
    const std::string  &GetQueryName() const;
          std::string  &GetQueryName();
    const double       *GetQueryPoint1() const;
          double       *GetQueryPoint1();
    int                GetToolId() const;
    int                GetEmbeddedPlotId() const;
    bool               GetBoolFlag() const;
    int                GetIntArg1() const;
    int                GetIntArg2() const;
    int                GetIntArg3() const;
    const std::string  &GetStringArg1() const;
          std::string  &GetStringArg1();
    const std::string  &GetStringArg2() const;
          std::string  &GetStringArg2();
    int                GetToolUpdateMode() const;
    const MapNode      &GetQueryParams() const;
          MapNode      &GetQueryParams();

    // Enum conversion functions
    static std::string ViewerRPCType_ToString(ViewerRPCType);
    static bool ViewerRPCType_FromString(const std::string &, ViewerRPCType &);
protected:
    static std::string ViewerRPCType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void SetWindowArea(int x, int y, int w, int h);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_RPCType = 0,
        ID_windowLayout,
        ID_windowId,
        ID_windowMode,
        ID_windowArea,
        ID_database,
        ID_programHost,
        ID_programSim,
        ID_programOptions,
        ID_nFrames,
        ID_stateNumber,
        ID_frameRange,
        ID_frame,
        ID_plotType,
        ID_operatorType,
        ID_variable,
        ID_activePlotIds,
        ID_activeOperatorIds,
        ID_expandedPlotIds,
        ID_colorTableName,
        ID_queryName,
        ID_queryPoint1,
        ID_toolId,
        ID_embeddedPlotId,
        ID_boolFlag,
        ID_intArg1,
        ID_intArg2,
        ID_intArg3,
        ID_stringArg1,
        ID_stringArg2,
        ID_toolUpdateMode,
        ID_queryParams,
        ID__LAST
    };

private:
    int          RPCType;
    int          windowLayout;
    int          windowId;
    int          windowMode;
    std::string  windowArea;
    std::string  database;
    std::string  programHost;
    std::string  programSim;
    stringVector programOptions;
    int          nFrames;
    int          stateNumber;
    int          frameRange[2];
    int          frame;
    int          plotType;
    int          operatorType;
    std::string  variable;
    intVector    activePlotIds;
    intVector    activeOperatorIds;
    intVector    expandedPlotIds;
    std::string  colorTableName;
    std::string  queryName;
    double       queryPoint1[3];
    int          toolId;
    int          embeddedPlotId;
    bool         boolFlag;
    int          intArg1;
    int          intArg2;
    int          intArg3;
    std::string  stringArg1;
    std::string  stringArg2;
    int          toolUpdateMode;
    MapNode      queryParams;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWERRPC_TMFS "iiiisssss*iiIiiisi*i*i*ssDiibiiissim"

#endif
