/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisConeWindow.h"

#include <ConeAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisConeWindow::QvisConeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConeWindow::QvisConeWindow(const int type,
                         ConeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisConeWindow::~QvisConeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisConeWindow::~QvisConeWindow()
{
}


// ****************************************************************************
// Method: QvisConeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 09:28:38 PDT 2008
//   Qt4 Port - Autogen + changed some label titles, and removed lengthLabel.
//
// ****************************************************************************

void
QvisConeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    angleLabel = new QLabel(tr("Angle"), central);
    mainLayout->addWidget(angleLabel,0,0);
    angle = new QLineEdit(central);
    connect(angle, SIGNAL(returnPressed()),
            this, SLOT(angleProcessText()));
    mainLayout->addWidget(angle, 0,1);

    originLabel = new QLabel(tr("Origin"), central);
    mainLayout->addWidget(originLabel,1,0);
    origin = new QLineEdit(central);
    connect(origin, SIGNAL(returnPressed()),
            this, SLOT(originProcessText()));
    mainLayout->addWidget(origin, 1,1);

    normalLabel = new QLabel(tr("Direction"), central);
    mainLayout->addWidget(normalLabel,2,0);
    normal = new QLineEdit(central);
    connect(normal, SIGNAL(returnPressed()),
            this, SLOT(normalProcessText()));
    mainLayout->addWidget(normal, 2,1);

    representationLabel = new QLabel(tr("Representation"), central);
    mainLayout->addWidget(representationLabel,3,0);
    QWidget *representationWidget = new QWidget(central);
    representation = new QButtonGroup(representationWidget);
    QHBoxLayout *representationLayout = new QHBoxLayout(representationWidget);
    representationLayout->setMargin(0);
    representationLayout->setSpacing(10);
    QRadioButton *representationRepresentationThreeD = new QRadioButton(tr("In 3D"), representationWidget);
    representation->addButton(representationRepresentationThreeD,0);
    representationLayout->addWidget(representationRepresentationThreeD);
    QRadioButton *representationRepresentationFlattened = new QRadioButton(tr("Projected to 2D"), representationWidget);
    representation->addButton(representationRepresentationFlattened,1);
    representationLayout->addWidget(representationRepresentationFlattened);
    QRadioButton *representationRepresentationR_Theta = new QRadioButton(tr("Cylindrical"), representationWidget);
    representation->addButton(representationRepresentationR_Theta,2);
    representationLayout->addWidget(representationRepresentationR_Theta);
    connect(representation, SIGNAL(buttonClicked(int)),
            this, SLOT(representationChanged(int)));
    mainLayout->addWidget(representationWidget, 3,1);

    upAxisLabel = new QLabel(tr("Up Axis"), central);
    mainLayout->addWidget(upAxisLabel,4,0);
    upAxis = new QLineEdit(central);
    connect(upAxis, SIGNAL(returnPressed()),
            this, SLOT(upAxisProcessText()));
    mainLayout->addWidget(upAxis, 4,1);

    cutByLength = new QCheckBox(tr("Cut cone off?   Length"), central);
    connect(cutByLength, SIGNAL(toggled(bool)),
            this, SLOT(cutByLengthChanged(bool)));
    mainLayout->addWidget(cutByLength, 5,0);

    length = new QLineEdit(central);
    connect(length, SIGNAL(returnPressed()),
            this, SLOT(lengthProcessText()));
    mainLayout->addWidget(length,5,1);
}


// ****************************************************************************
// Method: QvisConeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 09:28:38 PDT 2008
//   Qt4 Port - Autogen + removed lengthLabel.
//
// ****************************************************************************

void
QvisConeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ConeAttributes::ID_angle:
            angle->setText(DoubleToQString(atts->GetAngle()));
            break;
          case ConeAttributes::ID_origin:
            origin->setText(DoublesToQString(atts->GetOrigin(), 3));
            break;
          case ConeAttributes::ID_normal:
            normal->setText(DoublesToQString(atts->GetNormal(), 3));
            break;
          case ConeAttributes::ID_representation:
            if (atts->GetRepresentation() == ConeAttributes::Flattened || atts->GetRepresentation() == ConeAttributes::R_Theta)
            {
                upAxis->setEnabled(true);
                if(upAxisLabel)
                    upAxisLabel->setEnabled(true);
            }
            else
            {
                upAxis->setEnabled(false);
                if(upAxisLabel)
                    upAxisLabel->setEnabled(false);
            }
            representation->blockSignals(true);
            if(representation->button((int)atts->GetRepresentation()) != 0)
                representation->button((int)atts->GetRepresentation())->setChecked(true);
            representation->blockSignals(false);
            break;
          case ConeAttributes::ID_upAxis:
            upAxis->setText(DoublesToQString(atts->GetUpAxis(), 3));
            break;
          case ConeAttributes::ID_cutByLength:
            if (atts->GetCutByLength() == true)
            {
                length->setEnabled(true);
            }
            else
            {
                length->setEnabled(false);
            }
            cutByLength->blockSignals(true);
            cutByLength->setChecked(atts->GetCutByLength());
            cutByLength->blockSignals(false);
            break;
          case ConeAttributes::ID_length:
            length->setText(DoubleToQString(atts->GetLength()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisConeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisConeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do angle
    if(which_widget == ConeAttributes::ID_angle || doAll)
    {
        double val;
        if(LineEditGetDouble(angle, val))
            atts->SetAngle(val);
        else
        {
            ResettingError(tr("Angle"),
                DoubleToQString(atts->GetAngle()));
            atts->SetAngle(atts->GetAngle());
        }
    }

    // Do origin
    if(which_widget == ConeAttributes::ID_origin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(origin, val, 3))
            atts->SetOrigin(val);
        else
        {
            ResettingError(tr("Origin"),
                DoublesToQString(atts->GetOrigin(),3));
            atts->SetOrigin(atts->GetOrigin());
        }
    }

    // Do normal
    if(which_widget == ConeAttributes::ID_normal || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(normal, val, 3))
            atts->SetNormal(val);
        else
        {
            ResettingError(tr("Direction"),
                DoublesToQString(atts->GetNormal(),3));
            atts->SetNormal(atts->GetNormal());
        }
    }

    // Do upAxis
    if(which_widget == ConeAttributes::ID_upAxis || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(upAxis, val, 3))
            atts->SetUpAxis(val);
        else
        {
            ResettingError(tr("Up Axis"),
                DoublesToQString(atts->GetUpAxis(),3));
            atts->SetUpAxis(atts->GetUpAxis());
        }
    }

    // Do length
    if(which_widget == ConeAttributes::ID_length || doAll)
    {
        double val;
        if(LineEditGetDouble(length, val))
            atts->SetLength(val);
        else
        {
            ResettingError(tr("Cone Length"),
                DoubleToQString(atts->GetLength()));
            atts->SetLength(atts->GetLength());
        }
    }

}


//
// Qt Slot functions
//


void
QvisConeWindow::angleProcessText()
{
    GetCurrentValues(ConeAttributes::ID_angle);
    Apply();
}


void
QvisConeWindow::originProcessText()
{
    GetCurrentValues(ConeAttributes::ID_origin);
    Apply();
}


void
QvisConeWindow::normalProcessText()
{
    GetCurrentValues(ConeAttributes::ID_normal);
    Apply();
}


void
QvisConeWindow::representationChanged(int val)
{
    if(val != atts->GetRepresentation())
    {
        atts->SetRepresentation(ConeAttributes::Representation(val));
        Apply();
    }
}


void
QvisConeWindow::upAxisProcessText()
{
    GetCurrentValues(ConeAttributes::ID_upAxis);
    Apply();
}


void
QvisConeWindow::cutByLengthChanged(bool val)
{
    atts->SetCutByLength(val);
    Apply();
}


void
QvisConeWindow::lengthProcessText()
{
    GetCurrentValues(ConeAttributes::ID_length);
    Apply();
}


