/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisTubeWindow.h"

#include <TubeAttributes.h>

#include <QCheckBox>
#include <QComboBox>
#include <QGroupBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisTubeWindow::QvisTubeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisTubeWindow::QvisTubeWindow(const int type,
                         TubeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisTubeWindow::~QvisTubeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisTubeWindow::~QvisTubeWindow()
{
}


// ****************************************************************************
// Method: QvisTubeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//
//   Hank Childs, Thu Oct 21 06:34:02 PDT 2010
//   Customize interface beyond what xml2window provides.
//
// ****************************************************************************

void
QvisTubeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    QGroupBox *radiusGroup = new QGroupBox(central);
    radiusGroup->setTitle(tr("Tube radius"));
    mainLayout->addWidget(radiusGroup);
    QGridLayout *radiusLayout = new QGridLayout(radiusGroup);

    scaleByVarFlag = new QCheckBox(tr("Scale width by variable?  (Nodal variables work best)"), central);
    connect(scaleByVarFlag, SIGNAL(toggled(bool)),
            this, SLOT(scaleByVarFlagChanged(bool)));
    radiusLayout->addWidget(scaleByVarFlag, 0,0, 1, 3);

    scaleVariableLabel = new QLabel(tr("Variable"), central);
    radiusLayout->addWidget(scaleVariableLabel,1,0);
    int scaleVariableMask = QvisVariableButton::Scalars;
    scaleVariable = new QvisVariableButton(true, true, true, scaleVariableMask, central);
    connect(scaleVariable, SIGNAL(activated(const QString&)),
            this, SLOT(scaleVariableChanged(const QString&)));
    radiusLayout->addWidget(scaleVariable, 1,1, 1, 2);

    radiusLabel = new QLabel(tr("Radius"), central);
    radiusLayout->addWidget(radiusLabel,2,0);
    radius = new QLineEdit(central);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    radiusLayout->addWidget(radius, 2,1);

    radiusType = new QComboBox(radiusGroup);
    radiusType->addItem("Fraction of Bounding Box");
    radiusType->addItem("Absolute");
    connect(radiusType, SIGNAL(activated(int)),
            this, SLOT(radiusTypeChanged(int)));
    radiusLayout->addWidget(radiusType, 2,2);

    QGroupBox *formGroup = new QGroupBox(central);
    formGroup->setTitle(tr("Tube form"));
    mainLayout->addWidget(formGroup);
    QGridLayout *formLayout = new QGridLayout(formGroup);

    finenessLabel = new QLabel(tr("Fineness of tube"), central);
    formLayout->addWidget(finenessLabel,0,0);
    fineness = new QLineEdit(central);
    connect(fineness, SIGNAL(returnPressed()),
            this, SLOT(finenessProcessText()));
    formLayout->addWidget(fineness, 0,1);

    capping = new QCheckBox(tr("Cap ends of the tubes"), central);
    connect(capping, SIGNAL(toggled(bool)),
            this, SLOT(cappingChanged(bool)));
    formLayout->addWidget(capping, 1,0);
}


// ****************************************************************************
// Method: QvisTubeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Hank Childs, Thu Oct 21 06:34:02 PDT 2010
//   Customize interface beyond what xml2window provides.
//
// ****************************************************************************

void
QvisTubeWindow::UpdateWindow(bool doAll)
{
    int index = 0;

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case TubeAttributes::ID_scaleByVarFlag:
            if (atts->GetScaleByVarFlag() == true)
            {
                scaleVariable->setEnabled(true);
                if(scaleVariableLabel)
                    scaleVariableLabel->setEnabled(true);
                radiusLabel->setEnabled(false);
                radius->setEnabled(false);
                radiusType->setEnabled(false);
            }
            else
            {
                scaleVariable->setEnabled(false);
                if(scaleVariableLabel)
                    scaleVariableLabel->setEnabled(false);
                radiusLabel->setEnabled(true);
                radius->setEnabled(true);
                radiusType->setEnabled(true);
            }
            scaleByVarFlag->blockSignals(true);
            scaleByVarFlag->setChecked(atts->GetScaleByVarFlag());
            scaleByVarFlag->blockSignals(false);
            break;
          case TubeAttributes::ID_tubeRadiusType:
            if (atts->GetTubeRadiusType() == TubeAttributes::FractionOfBBox)
            {
                radius->setText(DoubleToQString(atts->GetRadiusFractionBBox()));
                index = 0; // First entry in combo box
            }
            else
            {
                radius->setText(DoubleToQString(atts->GetRadiusAbsolute()));
                index = 1; // Second entry in combo box
            }
            radiusType->blockSignals(true);
            radiusType->setCurrentIndex(index);
            radiusType->blockSignals(false);
            break;
          case TubeAttributes::ID_radiusFractionBBox:
            if (atts->GetTubeRadiusType() == TubeAttributes::FractionOfBBox)
                radius->setText(DoubleToQString(atts->GetRadiusFractionBBox()));
            break;
          case TubeAttributes::ID_radiusAbsolute:
            if (atts->GetTubeRadiusType() == TubeAttributes::Absolute)
                radius->setText(DoubleToQString(atts->GetRadiusAbsolute()));
            break;
          case TubeAttributes::ID_scaleVariable:
            scaleVariable->blockSignals(true);
            scaleVariable->setText(QString(atts->GetScaleVariable().c_str()));
            scaleVariable->blockSignals(false);
            break;
          case TubeAttributes::ID_fineness:
            fineness->setText(IntToQString(atts->GetFineness()));
            break;
          case TubeAttributes::ID_capping:
            capping->blockSignals(true);
            capping->setChecked(atts->GetCapping());
            capping->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisTubeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Hank Childs, Thu Oct 21 06:34:02 PDT 2010
//   Customize interface beyond what xml2window provides.
//
// ****************************************************************************

void
QvisTubeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do radiusFractionBBox
    if(which_widget == TubeAttributes::ID_radiusFractionBBox || doAll)
    {
        double val;
        if (atts->GetTubeRadiusType() == TubeAttributes::FractionOfBBox)
        {
            if(LineEditGetDouble(radius, val))
                atts->SetRadiusFractionBBox(val);
            else
            {
                ResettingError(tr("Radius"),
                    DoubleToQString(atts->GetRadiusFractionBBox()));
                atts->SetRadiusFractionBBox(atts->GetRadiusFractionBBox());
            }
        }
    }

    // Do radiusAbsolute
    if(which_widget == TubeAttributes::ID_radiusAbsolute || doAll)
    {
        double val;
        if (atts->GetTubeRadiusType() == TubeAttributes::Absolute)
        {
            if(LineEditGetDouble(radius, val))
                atts->SetRadiusAbsolute(val);
            else
            {
                ResettingError(tr("Radius"),
                    DoubleToQString(atts->GetRadiusAbsolute()));
                atts->SetRadiusAbsolute(atts->GetRadiusAbsolute());
            }
        }
    }

    // Do fineness
    if(which_widget == TubeAttributes::ID_fineness || doAll)
    {
        int val;
        if(LineEditGetInt(fineness, val))
            atts->SetFineness(val);
        else
        {
            ResettingError(tr("Fineness of tube"),
                IntToQString(atts->GetFineness()));
            atts->SetFineness(atts->GetFineness());
        }
    }

}


//
// Qt Slot functions
//


void
QvisTubeWindow::scaleByVarFlagChanged(bool val)
{
    atts->SetScaleByVarFlag(val);
    Apply();
}


void
QvisTubeWindow::radiusTypeChanged(int val)
{
    TubeAttributes::TubeRadiusType t;

    if (val == 0)
        t = TubeAttributes::FractionOfBBox;
    else
        t = TubeAttributes::Absolute;

    if(t != atts->GetTubeRadiusType())
    {
        atts->SetTubeRadiusType(t);
        Apply();
    }
}


void
QvisTubeWindow::radiusProcessText()
{
    GetCurrentValues(TubeAttributes::ID_radiusFractionBBox);
    GetCurrentValues(TubeAttributes::ID_radiusAbsolute);
    Apply();
}


void
QvisTubeWindow::scaleVariableChanged(const QString &varName)
{
    atts->SetScaleVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisTubeWindow::finenessProcessText()
{
    GetCurrentValues(TubeAttributes::ID_fineness);
    Apply();
}


void
QvisTubeWindow::cappingChanged(bool val)
{
    atts->SetCapping(val);
    SetUpdate(false);
    Apply();
}


