/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisCylinderWindow.h"

#include <CylinderAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisCylinderWindow::QvisCylinderWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCylinderWindow::QvisCylinderWindow(const int type,
                         CylinderAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisCylinderWindow::~QvisCylinderWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisCylinderWindow::~QvisCylinderWindow()
{
}


// ****************************************************************************
// Method: QvisCylinderWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    point1Label = new QLabel(tr("Endpoint 1"), central);
    mainLayout->addWidget(point1Label,0,0);
    point1 = new QLineEdit(central);
    connect(point1, SIGNAL(returnPressed()),
            this, SLOT(point1ProcessText()));
    mainLayout->addWidget(point1, 0,1);

    point2Label = new QLabel(tr("Endpoint 2"), central);
    mainLayout->addWidget(point2Label,1,0);
    point2 = new QLineEdit(central);
    connect(point2, SIGNAL(returnPressed()),
            this, SLOT(point2ProcessText()));
    mainLayout->addWidget(point2, 1,1);

    radiusLabel = new QLabel(tr("Radius"), central);
    mainLayout->addWidget(radiusLabel,2,0);
    radius = new QLineEdit(central);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    mainLayout->addWidget(radius, 2,1);

    inverse = new QCheckBox(tr("Inverse"), central);
    connect(inverse, SIGNAL(toggled(bool)),
            this, SLOT(inverseChanged(bool)));
    mainLayout->addWidget(inverse, 3,0);

}


// ****************************************************************************
// Method: QvisCylinderWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case CylinderAttributes::ID_point1:
            point1->setText(DoublesToQString(atts->GetPoint1(), 3));
            break;
          case CylinderAttributes::ID_point2:
            point2->setText(DoublesToQString(atts->GetPoint2(), 3));
            break;
          case CylinderAttributes::ID_radius:
            radius->setText(DoubleToQString(atts->GetRadius()));
            break;
          case CylinderAttributes::ID_inverse:
            inverse->blockSignals(true);
            inverse->setChecked(atts->GetInverse());
            inverse->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisCylinderWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisCylinderWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do point1
    if(which_widget == CylinderAttributes::ID_point1 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point1, val, 3))
            atts->SetPoint1(val);
        else
        {
            ResettingError(tr("Endpoint 1"),
                DoublesToQString(atts->GetPoint1(),3));
            atts->SetPoint1(atts->GetPoint1());
        }
    }

    // Do point2
    if(which_widget == CylinderAttributes::ID_point2 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point2, val, 3))
            atts->SetPoint2(val);
        else
        {
            ResettingError(tr("Endpoint 2"),
                DoublesToQString(atts->GetPoint2(),3));
            atts->SetPoint2(atts->GetPoint2());
        }
    }

    // Do radius
    if(which_widget == CylinderAttributes::ID_radius || doAll)
    {
        double val;
        if(LineEditGetDouble(radius, val))
            atts->SetRadius(val);
        else
        {
            ResettingError(tr("Radius"),
                DoubleToQString(atts->GetRadius()));
            atts->SetRadius(atts->GetRadius());
        }
    }

}


//
// Qt Slot functions
//


void
QvisCylinderWindow::point1ProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_point1);
    Apply();
}


void
QvisCylinderWindow::point2ProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_point2);
    Apply();
}


void
QvisCylinderWindow::radiusProcessText()
{
    GetCurrentValues(CylinderAttributes::ID_radius);
    Apply();
}


void
QvisCylinderWindow::inverseChanged(bool val)
{
    atts->SetInverse(val);
    SetUpdate(false);
    Apply();
}


