/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyClipAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyClipAttributes
//
// Purpose: 
//   This class contains attributes for the clip operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ClipAttributes.
//
struct ClipAttributesObject
{
    PyObject_HEAD
    ClipAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewClipAttributes(int);

std::string
PyClipAttributes_ToString(const ClipAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *quality_names = "Fast, Accurate";
    switch (atts->GetQuality())
    {
      case ClipAttributes::Fast:
          SNPRINTF(tmpStr, 1000, "%squality = %sFast  # %s\n", prefix, prefix, quality_names);
          str += tmpStr;
          break;
      case ClipAttributes::Accurate:
          SNPRINTF(tmpStr, 1000, "%squality = %sAccurate  # %s\n", prefix, prefix, quality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *funcType_names = "Plane, Sphere";
    switch (atts->GetFuncType())
    {
      case ClipAttributes::Plane:
          SNPRINTF(tmpStr, 1000, "%sfuncType = %sPlane  # %s\n", prefix, prefix, funcType_names);
          str += tmpStr;
          break;
      case ClipAttributes::Sphere:
          SNPRINTF(tmpStr, 1000, "%sfuncType = %sSphere  # %s\n", prefix, prefix, funcType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPlane1Status())
        SNPRINTF(tmpStr, 1000, "%splane1Status = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%splane1Status = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPlane2Status())
        SNPRINTF(tmpStr, 1000, "%splane2Status = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%splane2Status = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPlane3Status())
        SNPRINTF(tmpStr, 1000, "%splane3Status = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%splane3Status = 0\n", prefix);
    str += tmpStr;
    {   const double *plane1Origin = atts->GetPlane1Origin();
        SNPRINTF(tmpStr, 1000, "%splane1Origin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane1Origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *plane2Origin = atts->GetPlane2Origin();
        SNPRINTF(tmpStr, 1000, "%splane2Origin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane2Origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *plane3Origin = atts->GetPlane3Origin();
        SNPRINTF(tmpStr, 1000, "%splane3Origin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane3Origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *plane1Normal = atts->GetPlane1Normal();
        SNPRINTF(tmpStr, 1000, "%splane1Normal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane1Normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *plane2Normal = atts->GetPlane2Normal();
        SNPRINTF(tmpStr, 1000, "%splane2Normal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane2Normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *plane3Normal = atts->GetPlane3Normal();
        SNPRINTF(tmpStr, 1000, "%splane3Normal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plane3Normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetPlaneInverse())
        SNPRINTF(tmpStr, 1000, "%splaneInverse = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%splaneInverse = 0\n", prefix);
    str += tmpStr;
    const char *planeToolControlledClipPlane_names = "None, Plane1, Plane2, Plane3";
    switch (atts->GetPlaneToolControlledClipPlane())
    {
      case ClipAttributes::None:
          SNPRINTF(tmpStr, 1000, "%splaneToolControlledClipPlane = %sNone  # %s\n", prefix, prefix, planeToolControlledClipPlane_names);
          str += tmpStr;
          break;
      case ClipAttributes::Plane1:
          SNPRINTF(tmpStr, 1000, "%splaneToolControlledClipPlane = %sPlane1  # %s\n", prefix, prefix, planeToolControlledClipPlane_names);
          str += tmpStr;
          break;
      case ClipAttributes::Plane2:
          SNPRINTF(tmpStr, 1000, "%splaneToolControlledClipPlane = %sPlane2  # %s\n", prefix, prefix, planeToolControlledClipPlane_names);
          str += tmpStr;
          break;
      case ClipAttributes::Plane3:
          SNPRINTF(tmpStr, 1000, "%splaneToolControlledClipPlane = %sPlane3  # %s\n", prefix, prefix, planeToolControlledClipPlane_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *center = atts->GetCenter();
        SNPRINTF(tmpStr, 1000, "%scenter = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", center[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    if(atts->GetSphereInverse())
        SNPRINTF(tmpStr, 1000, "%ssphereInverse = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssphereInverse = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ClipAttributes_Notify(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_SetQuality(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quality in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetQuality(ClipAttributes::Quality(ival));
    else
    {
        fprintf(stderr, "An invalid quality value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Fast, Accurate.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetQuality(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuality()));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetFuncType(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the funcType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetFuncType(ClipAttributes::ClipStyle(ival));
    else
    {
        fprintf(stderr, "An invalid funcType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Plane, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetFuncType(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFuncType()));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane1Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane1Status in the object.
    obj->data->SetPlane1Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane1Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane1Status()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane2Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane2Status in the object.
    obj->data->SetPlane2Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane2Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane2Status()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane3Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plane3Status in the object.
    obj->data->SetPlane3Status(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane3Status(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlane3Status()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane1Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane1Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane1Origin in the object as modified.
    obj->data->SelectPlane1Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane1Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane1Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane1Origin = obj->data->GetPlane1Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane1Origin[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane2Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane2Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane2Origin in the object as modified.
    obj->data->SelectPlane2Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane2Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane2Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane2Origin = obj->data->GetPlane2Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane2Origin[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane3Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane3Origin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane3Origin in the object as modified.
    obj->data->SelectPlane3Origin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane3Origin(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane3Origin.
    PyObject *retval = PyTuple_New(3);
    const double *plane3Origin = obj->data->GetPlane3Origin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane3Origin[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane1Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane1Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane1Normal in the object as modified.
    obj->data->SelectPlane1Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane1Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane1Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane1Normal = obj->data->GetPlane1Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane1Normal[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane2Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane2Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane2Normal in the object as modified.
    obj->data->SelectPlane2Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane2Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane2Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane2Normal = obj->data->GetPlane2Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane2Normal[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlane3Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetPlane3Normal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the plane3Normal in the object as modified.
    obj->data->SelectPlane3Normal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlane3Normal(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the plane3Normal.
    PyObject *retval = PyTuple_New(3);
    const double *plane3Normal = obj->data->GetPlane3Normal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(plane3Normal[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlaneInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the planeInverse in the object.
    obj->data->SetPlaneInverse(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlaneInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPlaneInverse()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetPlaneToolControlledClipPlane(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the planeToolControlledClipPlane in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPlaneToolControlledClipPlane(ClipAttributes::WhichClipPlane(ival));
    else
    {
        fprintf(stderr, "An invalid planeToolControlledClipPlane value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, Plane1, Plane2, Plane3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetPlaneToolControlledClipPlane(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPlaneToolControlledClipPlane()));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetCenter(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double *dvals = obj->data->GetCenter();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the center in the object as modified.
    obj->data->SelectCenter();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetCenter(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the center.
    PyObject *retval = PyTuple_New(3);
    const double *center = obj->data->GetCenter();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(center[i]));
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetRadius(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetRadius(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

/*static*/ PyObject *
ClipAttributes_SetSphereInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sphereInverse in the object.
    obj->data->SetSphereInverse(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ClipAttributes_GetSphereInverse(PyObject *self, PyObject *args)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSphereInverse()?1L:0L);
    return retval;
}



PyMethodDef PyClipAttributes_methods[CLIPATTRIBUTES_NMETH] = {
    {"Notify", ClipAttributes_Notify, METH_VARARGS},
    {"SetQuality", ClipAttributes_SetQuality, METH_VARARGS},
    {"GetQuality", ClipAttributes_GetQuality, METH_VARARGS},
    {"SetFuncType", ClipAttributes_SetFuncType, METH_VARARGS},
    {"GetFuncType", ClipAttributes_GetFuncType, METH_VARARGS},
    {"SetPlane1Status", ClipAttributes_SetPlane1Status, METH_VARARGS},
    {"GetPlane1Status", ClipAttributes_GetPlane1Status, METH_VARARGS},
    {"SetPlane2Status", ClipAttributes_SetPlane2Status, METH_VARARGS},
    {"GetPlane2Status", ClipAttributes_GetPlane2Status, METH_VARARGS},
    {"SetPlane3Status", ClipAttributes_SetPlane3Status, METH_VARARGS},
    {"GetPlane3Status", ClipAttributes_GetPlane3Status, METH_VARARGS},
    {"SetPlane1Origin", ClipAttributes_SetPlane1Origin, METH_VARARGS},
    {"GetPlane1Origin", ClipAttributes_GetPlane1Origin, METH_VARARGS},
    {"SetPlane2Origin", ClipAttributes_SetPlane2Origin, METH_VARARGS},
    {"GetPlane2Origin", ClipAttributes_GetPlane2Origin, METH_VARARGS},
    {"SetPlane3Origin", ClipAttributes_SetPlane3Origin, METH_VARARGS},
    {"GetPlane3Origin", ClipAttributes_GetPlane3Origin, METH_VARARGS},
    {"SetPlane1Normal", ClipAttributes_SetPlane1Normal, METH_VARARGS},
    {"GetPlane1Normal", ClipAttributes_GetPlane1Normal, METH_VARARGS},
    {"SetPlane2Normal", ClipAttributes_SetPlane2Normal, METH_VARARGS},
    {"GetPlane2Normal", ClipAttributes_GetPlane2Normal, METH_VARARGS},
    {"SetPlane3Normal", ClipAttributes_SetPlane3Normal, METH_VARARGS},
    {"GetPlane3Normal", ClipAttributes_GetPlane3Normal, METH_VARARGS},
    {"SetPlaneInverse", ClipAttributes_SetPlaneInverse, METH_VARARGS},
    {"GetPlaneInverse", ClipAttributes_GetPlaneInverse, METH_VARARGS},
    {"SetPlaneToolControlledClipPlane", ClipAttributes_SetPlaneToolControlledClipPlane, METH_VARARGS},
    {"GetPlaneToolControlledClipPlane", ClipAttributes_GetPlaneToolControlledClipPlane, METH_VARARGS},
    {"SetCenter", ClipAttributes_SetCenter, METH_VARARGS},
    {"GetCenter", ClipAttributes_GetCenter, METH_VARARGS},
    {"SetRadius", ClipAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", ClipAttributes_GetRadius, METH_VARARGS},
    {"SetSphereInverse", ClipAttributes_SetSphereInverse, METH_VARARGS},
    {"GetSphereInverse", ClipAttributes_GetSphereInverse, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ClipAttributes_dealloc(PyObject *v)
{
   ClipAttributesObject *obj = (ClipAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ClipAttributes_compare(PyObject *v, PyObject *w)
{
    ClipAttributes *a = ((ClipAttributesObject *)v)->data;
    ClipAttributes *b = ((ClipAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyClipAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "quality") == 0)
        return ClipAttributes_GetQuality(self, NULL);
    if(strcmp(name, "Fast") == 0)
        return PyInt_FromLong(long(ClipAttributes::Fast));
    if(strcmp(name, "Accurate") == 0)
        return PyInt_FromLong(long(ClipAttributes::Accurate));

    if(strcmp(name, "funcType") == 0)
        return ClipAttributes_GetFuncType(self, NULL);
    if(strcmp(name, "Plane") == 0)
        return PyInt_FromLong(long(ClipAttributes::Plane));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(ClipAttributes::Sphere));

    if(strcmp(name, "plane1Status") == 0)
        return ClipAttributes_GetPlane1Status(self, NULL);
    if(strcmp(name, "plane2Status") == 0)
        return ClipAttributes_GetPlane2Status(self, NULL);
    if(strcmp(name, "plane3Status") == 0)
        return ClipAttributes_GetPlane3Status(self, NULL);
    if(strcmp(name, "plane1Origin") == 0)
        return ClipAttributes_GetPlane1Origin(self, NULL);
    if(strcmp(name, "plane2Origin") == 0)
        return ClipAttributes_GetPlane2Origin(self, NULL);
    if(strcmp(name, "plane3Origin") == 0)
        return ClipAttributes_GetPlane3Origin(self, NULL);
    if(strcmp(name, "plane1Normal") == 0)
        return ClipAttributes_GetPlane1Normal(self, NULL);
    if(strcmp(name, "plane2Normal") == 0)
        return ClipAttributes_GetPlane2Normal(self, NULL);
    if(strcmp(name, "plane3Normal") == 0)
        return ClipAttributes_GetPlane3Normal(self, NULL);
    if(strcmp(name, "planeInverse") == 0)
        return ClipAttributes_GetPlaneInverse(self, NULL);
    if(strcmp(name, "planeToolControlledClipPlane") == 0)
        return ClipAttributes_GetPlaneToolControlledClipPlane(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ClipAttributes::None));
    if(strcmp(name, "Plane1") == 0)
        return PyInt_FromLong(long(ClipAttributes::Plane1));
    if(strcmp(name, "Plane2") == 0)
        return PyInt_FromLong(long(ClipAttributes::Plane2));
    if(strcmp(name, "Plane3") == 0)
        return PyInt_FromLong(long(ClipAttributes::Plane3));

    if(strcmp(name, "center") == 0)
        return ClipAttributes_GetCenter(self, NULL);
    if(strcmp(name, "radius") == 0)
        return ClipAttributes_GetRadius(self, NULL);
    if(strcmp(name, "sphereInverse") == 0)
        return ClipAttributes_GetSphereInverse(self, NULL);

    return Py_FindMethod(PyClipAttributes_methods, self, name);
}

int
PyClipAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "quality") == 0)
        obj = ClipAttributes_SetQuality(self, tuple);
    else if(strcmp(name, "funcType") == 0)
        obj = ClipAttributes_SetFuncType(self, tuple);
    else if(strcmp(name, "plane1Status") == 0)
        obj = ClipAttributes_SetPlane1Status(self, tuple);
    else if(strcmp(name, "plane2Status") == 0)
        obj = ClipAttributes_SetPlane2Status(self, tuple);
    else if(strcmp(name, "plane3Status") == 0)
        obj = ClipAttributes_SetPlane3Status(self, tuple);
    else if(strcmp(name, "plane1Origin") == 0)
        obj = ClipAttributes_SetPlane1Origin(self, tuple);
    else if(strcmp(name, "plane2Origin") == 0)
        obj = ClipAttributes_SetPlane2Origin(self, tuple);
    else if(strcmp(name, "plane3Origin") == 0)
        obj = ClipAttributes_SetPlane3Origin(self, tuple);
    else if(strcmp(name, "plane1Normal") == 0)
        obj = ClipAttributes_SetPlane1Normal(self, tuple);
    else if(strcmp(name, "plane2Normal") == 0)
        obj = ClipAttributes_SetPlane2Normal(self, tuple);
    else if(strcmp(name, "plane3Normal") == 0)
        obj = ClipAttributes_SetPlane3Normal(self, tuple);
    else if(strcmp(name, "planeInverse") == 0)
        obj = ClipAttributes_SetPlaneInverse(self, tuple);
    else if(strcmp(name, "planeToolControlledClipPlane") == 0)
        obj = ClipAttributes_SetPlaneToolControlledClipPlane(self, tuple);
    else if(strcmp(name, "center") == 0)
        obj = ClipAttributes_SetCenter(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = ClipAttributes_SetRadius(self, tuple);
    else if(strcmp(name, "sphereInverse") == 0)
        obj = ClipAttributes_SetSphereInverse(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ClipAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)v;
    fprintf(fp, "%s", PyClipAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ClipAttributes_str(PyObject *v)
{
    ClipAttributesObject *obj = (ClipAttributesObject *)v;
    return PyString_FromString(PyClipAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ClipAttributes_Purpose = "This class contains attributes for the clip operator.";
#else
static char *ClipAttributes_Purpose = "This class contains attributes for the clip operator.";
#endif

//
// The type description structure
//
static PyTypeObject ClipAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ClipAttributes",                    // tp_name
    sizeof(ClipAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ClipAttributes_dealloc,  // tp_dealloc
    (printfunc)ClipAttributes_print,     // tp_print
    (getattrfunc)PyClipAttributes_getattr, // tp_getattr
    (setattrfunc)PyClipAttributes_setattr, // tp_setattr
    (cmpfunc)ClipAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ClipAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ClipAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ClipAttributes *defaultAtts = 0;
static ClipAttributes *currentAtts = 0;

static PyObject *
NewClipAttributes(int useCurrent)
{
    ClipAttributesObject *newObject;
    newObject = PyObject_NEW(ClipAttributesObject, &ClipAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ClipAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ClipAttributes(*defaultAtts);
    else
        newObject->data = new ClipAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapClipAttributes(const ClipAttributes *attr)
{
    ClipAttributesObject *newObject;
    newObject = PyObject_NEW(ClipAttributesObject, &ClipAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ClipAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ClipAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewClipAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ClipAttributesMethods[] = {
    {"ClipAttributes", ClipAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ClipAttributesObserver = 0;

std::string
PyClipAttributes_GetLogString()
{
    std::string s("ClipAtts = ClipAttributes()\n");
    if(currentAtts != 0)
        s += PyClipAttributes_ToString(currentAtts, "ClipAtts.");
    return s;
}

static void
PyClipAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ClipAtts = ClipAttributes()\n");
        s += PyClipAttributes_ToString(currentAtts, "ClipAtts.");
        cb(s);
    }
}

void
PyClipAttributes_StartUp(ClipAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyClipAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ClipAttributesObserver == 0)
    {
        ClipAttributesObserver = new ObserverToCallback(subj,
            PyClipAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyClipAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ClipAttributesObserver;
    ClipAttributesObserver = 0;
}

PyMethodDef *
PyClipAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ClipAttributesMethods;
}

bool
PyClipAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ClipAttributesType);
}

ClipAttributes *
PyClipAttributes_FromPyObject(PyObject *obj)
{
    ClipAttributesObject *obj2 = (ClipAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyClipAttributes_New()
{
    return NewClipAttributes(0);
}

PyObject *
PyClipAttributes_Wrap(const ClipAttributes *attr)
{
    return WrapClipAttributes(attr);
}

void
PyClipAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ClipAttributesObject *obj2 = (ClipAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyClipAttributes_SetDefaults(const ClipAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ClipAttributes(*atts);
}

