/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AnimationAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for AnimationAttributes::AnimationMode
//

static const char *AnimationMode_strings[] = {
"ReversePlayMode", "StopMode", "PlayMode"
};

std::string
AnimationAttributes::AnimationMode_ToString(AnimationAttributes::AnimationMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return AnimationMode_strings[index];
}

std::string
AnimationAttributes::AnimationMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return AnimationMode_strings[index];
}

bool
AnimationAttributes::AnimationMode_FromString(const std::string &s, AnimationAttributes::AnimationMode &val)
{
    val = AnimationAttributes::ReversePlayMode;
    for(int i = 0; i < 3; ++i)
    {
        if(s == AnimationMode_strings[i])
        {
            val = (AnimationMode)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnimationAttributes::PlaybackMode
//

static const char *PlaybackMode_strings[] = {
"Looping", "PlayOnce", "Swing"
};

std::string
AnimationAttributes::PlaybackMode_ToString(AnimationAttributes::PlaybackMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return PlaybackMode_strings[index];
}

std::string
AnimationAttributes::PlaybackMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return PlaybackMode_strings[index];
}

bool
AnimationAttributes::PlaybackMode_FromString(const std::string &s, AnimationAttributes::PlaybackMode &val)
{
    val = AnimationAttributes::Looping;
    for(int i = 0; i < 3; ++i)
    {
        if(s == PlaybackMode_strings[i])
        {
            val = (PlaybackMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Init utility for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AnimationAttributes::Init()
{
    animationMode = StopMode;
    pipelineCachingMode = false;
    frameIncrement = 1;
    timeout = 1;
    playbackMode = Looping;

    AnimationAttributes::SelectAll();
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Copy utility for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AnimationAttributes::Copy(const AnimationAttributes &obj)
{
    animationMode = obj.animationMode;
    pipelineCachingMode = obj.pipelineCachingMode;
    frameIncrement = obj.frameIncrement;
    timeout = obj.timeout;
    playbackMode = obj.playbackMode;

    AnimationAttributes::SelectAll();
}

// Type map format string
const char *AnimationAttributes::TypeMapFormatString = ANIMATIONATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t AnimationAttributes::TmfsStruct = {ANIMATIONATTRIBUTES_TMFS};


// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Default constructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes() : 
    AttributeSubject(AnimationAttributes::TypeMapFormatString)
{
    AnimationAttributes::Init();
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Constructor for the derived classes of AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AnimationAttributes::Init();
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Copy constructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes(const AnimationAttributes &obj) : 
    AttributeSubject(AnimationAttributes::TypeMapFormatString)
{
    AnimationAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AnimationAttributes::AnimationAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::AnimationAttributes(const AnimationAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AnimationAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AnimationAttributes::~AnimationAttributes
//
// Purpose: 
//   Destructor for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes::~AnimationAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AnimationAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnimationAttributes& 
AnimationAttributes::operator = (const AnimationAttributes &obj)
{
    if (this == &obj) return *this;

    AnimationAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AnimationAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::operator == (const AnimationAttributes &obj) const
{
    // Create the return value
    return ((animationMode == obj.animationMode) &&
            (pipelineCachingMode == obj.pipelineCachingMode) &&
            (frameIncrement == obj.frameIncrement) &&
            (timeout == obj.timeout) &&
            (playbackMode == obj.playbackMode));
}

// ****************************************************************************
// Method: AnimationAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::operator != (const AnimationAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnimationAttributes::TypeName
//
// Purpose: 
//   Type name method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnimationAttributes::TypeName() const
{
    return "AnimationAttributes";
}

// ****************************************************************************
// Method: AnimationAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnimationAttributes *tmp = (const AnimationAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnimationAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnimationAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnimationAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnimationAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AnimationAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnimationAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnimationAttributes(*this);
    else
        retval = new AnimationAttributes;

    return retval;
}

// ****************************************************************************
// Method: AnimationAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnimationAttributes::SelectAll()
{
    Select(ID_animationMode,       (void *)&animationMode);
    Select(ID_pipelineCachingMode, (void *)&pipelineCachingMode);
    Select(ID_frameIncrement,      (void *)&frameIncrement);
    Select(ID_timeout,             (void *)&timeout);
    Select(ID_playbackMode,        (void *)&playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnimationAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AnimationAttributes.
    DataNode *node = new DataNode("AnimationAttributes");

    if(completeSave || !FieldsEqual(ID_animationMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("animationMode", AnimationMode_ToString(animationMode)));
    }

    if(completeSave || !FieldsEqual(ID_pipelineCachingMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pipelineCachingMode", pipelineCachingMode));
    }

    if(completeSave || !FieldsEqual(ID_frameIncrement, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("frameIncrement", frameIncrement));
    }

    if(completeSave || !FieldsEqual(ID_timeout, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeout", timeout));
    }

    if(completeSave || !FieldsEqual(ID_playbackMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("playbackMode", PlaybackMode_ToString(playbackMode)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnimationAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnimationAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnimationAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("animationMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetAnimationMode(AnimationMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            AnimationMode value;
            if(AnimationMode_FromString(node->AsString(), value))
                SetAnimationMode(value);
        }
    }
    if((node = searchNode->GetNode("pipelineCachingMode")) != 0)
        SetPipelineCachingMode(node->AsBool());
    if((node = searchNode->GetNode("frameIncrement")) != 0)
        SetFrameIncrement(node->AsInt());
    if((node = searchNode->GetNode("timeout")) != 0)
        SetTimeout(node->AsInt());
    if((node = searchNode->GetNode("playbackMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetPlaybackMode(PlaybackMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PlaybackMode value;
            if(PlaybackMode_FromString(node->AsString(), value))
                SetPlaybackMode(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AnimationAttributes::SetAnimationMode(AnimationAttributes::AnimationMode animationMode_)
{
    animationMode = animationMode_;
    Select(ID_animationMode, (void *)&animationMode);
}

void
AnimationAttributes::SetPipelineCachingMode(bool pipelineCachingMode_)
{
    pipelineCachingMode = pipelineCachingMode_;
    Select(ID_pipelineCachingMode, (void *)&pipelineCachingMode);
}

void
AnimationAttributes::SetFrameIncrement(int frameIncrement_)
{
    frameIncrement = frameIncrement_;
    Select(ID_frameIncrement, (void *)&frameIncrement);
}

void
AnimationAttributes::SetTimeout(int timeout_)
{
    timeout = timeout_;
    Select(ID_timeout, (void *)&timeout);
}

void
AnimationAttributes::SetPlaybackMode(AnimationAttributes::PlaybackMode playbackMode_)
{
    playbackMode = playbackMode_;
    Select(ID_playbackMode, (void *)&playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

AnimationAttributes::AnimationMode
AnimationAttributes::GetAnimationMode() const
{
    return AnimationMode(animationMode);
}

bool
AnimationAttributes::GetPipelineCachingMode() const
{
    return pipelineCachingMode;
}

int
AnimationAttributes::GetFrameIncrement() const
{
    return frameIncrement;
}

int
AnimationAttributes::GetTimeout() const
{
    return timeout;
}

AnimationAttributes::PlaybackMode
AnimationAttributes::GetPlaybackMode() const
{
    return PlaybackMode(playbackMode);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AnimationAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_animationMode:       return "animationMode";
    case ID_pipelineCachingMode: return "pipelineCachingMode";
    case ID_frameIncrement:      return "frameIncrement";
    case ID_timeout:             return "timeout";
    case ID_playbackMode:        return "playbackMode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnimationAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnimationAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_animationMode:       return FieldType_enum;
    case ID_pipelineCachingMode: return FieldType_bool;
    case ID_frameIncrement:      return FieldType_int;
    case ID_timeout:             return FieldType_int;
    case ID_playbackMode:        return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnimationAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AnimationAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_animationMode:       return "enum";
    case ID_pipelineCachingMode: return "bool";
    case ID_frameIncrement:      return "int";
    case ID_timeout:             return "int";
    case ID_playbackMode:        return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnimationAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnimationAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AnimationAttributes &obj = *((const AnimationAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_animationMode:
        {  // new scope
        retval = (animationMode == obj.animationMode);
        }
        break;
    case ID_pipelineCachingMode:
        {  // new scope
        retval = (pipelineCachingMode == obj.pipelineCachingMode);
        }
        break;
    case ID_frameIncrement:
        {  // new scope
        retval = (frameIncrement == obj.frameIncrement);
        }
        break;
    case ID_timeout:
        {  // new scope
        retval = (timeout == obj.timeout);
        }
        break;
    case ID_playbackMode:
        {  // new scope
        retval = (playbackMode == obj.playbackMode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnimationAttributes::ProcessOldVersions
//
// Purpose: 
//   This method creates modifies a DataNode representation of the object
//   so it conforms to the newest representation of the object, which can
//   can be read back in.
//
// Programmer: Kathleen Bonnell 
// Creation:   January 12, 2005 
//
// Modifications:
//
// ****************************************************************************
void
AnimationAttributes::ProcessOldVersions(DataNode *parentNode,
                                       const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnimationAttributes");
    if(searchNode == 0)
        return;

    DataNode *pcNode = searchNode->GetNode("pipelineCachingMode");
    if (pcNode == 0)
        return;

    if (VersionLessThan(configVersion, "1.1.5"))
        searchNode->RemoveNode("pipelineCachingMode");
}

