/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLCSAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyLCSAttributes
//
// Purpose: 
//   Attributes for LCS
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LCSAttributes.
//
struct LCSAttributesObject
{
    PyObject_HEAD
    LCSAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLCSAttributes(int);

std::string
PyLCSAttributes_ToString(const LCSAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *sourceType_names = "NativeMesh, RegularGrid";
    switch (atts->GetSourceType())
    {
      case LCSAttributes::NativeMesh:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sNativeMesh  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case LCSAttributes::RegularGrid:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sRegularGrid  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const int *Resolution = atts->GetResolution();
        SNPRINTF(tmpStr, 1000, "%sResolution = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", Resolution[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *UseDataSetStart_names = "Full, Subset";
    switch (atts->GetUseDataSetStart())
    {
      case LCSAttributes::Full:
          SNPRINTF(tmpStr, 1000, "%sUseDataSetStart = %sFull  # %s\n", prefix, prefix, UseDataSetStart_names);
          str += tmpStr;
          break;
      case LCSAttributes::Subset:
          SNPRINTF(tmpStr, 1000, "%sUseDataSetStart = %sSubset  # %s\n", prefix, prefix, UseDataSetStart_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *StartPosition = atts->GetStartPosition();
        SNPRINTF(tmpStr, 1000, "%sStartPosition = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", StartPosition[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *UseDataSetEnd_names = "Full, Subset";
    switch (atts->GetUseDataSetEnd())
    {
      case LCSAttributes::Full:
          SNPRINTF(tmpStr, 1000, "%sUseDataSetEnd = %sFull  # %s\n", prefix, prefix, UseDataSetEnd_names);
          str += tmpStr;
          break;
      case LCSAttributes::Subset:
          SNPRINTF(tmpStr, 1000, "%sUseDataSetEnd = %sSubset  # %s\n", prefix, prefix, UseDataSetEnd_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *EndPosition = atts->GetEndPosition();
        SNPRINTF(tmpStr, 1000, "%sEndPosition = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", EndPosition[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *integrationDirection_names = "Forward, Backward, Both";
    switch (atts->GetIntegrationDirection())
    {
      case LCSAttributes::Forward:
          SNPRINTF(tmpStr, 1000, "%sintegrationDirection = %sForward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LCSAttributes::Backward:
          SNPRINTF(tmpStr, 1000, "%sintegrationDirection = %sBackward  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      case LCSAttributes::Both:
          SNPRINTF(tmpStr, 1000, "%sintegrationDirection = %sBoth  # %s\n", prefix, prefix, integrationDirection_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *auxiliaryGrid_names = "None, TwoDim, ThreeDim";
    switch (atts->GetAuxiliaryGrid())
    {
      case LCSAttributes::None:
          SNPRINTF(tmpStr, 1000, "%sauxiliaryGrid = %sNone  # %s\n", prefix, prefix, auxiliaryGrid_names);
          str += tmpStr;
          break;
      case LCSAttributes::TwoDim:
          SNPRINTF(tmpStr, 1000, "%sauxiliaryGrid = %sTwoDim  # %s\n", prefix, prefix, auxiliaryGrid_names);
          str += tmpStr;
          break;
      case LCSAttributes::ThreeDim:
          SNPRINTF(tmpStr, 1000, "%sauxiliaryGrid = %sThreeDim  # %s\n", prefix, prefix, auxiliaryGrid_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sauxiliaryGridSpacing = %g\n", prefix, atts->GetAuxiliaryGridSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxSteps = %d\n", prefix, atts->GetMaxSteps());
    str += tmpStr;
    const char *operationType_names = "IntegrationTime, ArcLength, AverageDistanceFromSeed, EigenValue, EigenVector, "
        "Lyapunov";
    switch (atts->GetOperationType())
    {
      case LCSAttributes::IntegrationTime:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sIntegrationTime  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::ArcLength:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sArcLength  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::AverageDistanceFromSeed:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sAverageDistanceFromSeed  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::EigenValue:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sEigenValue  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::EigenVector:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sEigenVector  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Lyapunov:
          SNPRINTF(tmpStr, 1000, "%soperationType = %sLyapunov  # %s\n", prefix, prefix, operationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *cauchyGreenTensor_names = "Left, Right";
    switch (atts->GetCauchyGreenTensor())
    {
      case LCSAttributes::Left:
          SNPRINTF(tmpStr, 1000, "%scauchyGreenTensor = %sLeft  # %s\n", prefix, prefix, cauchyGreenTensor_names);
          str += tmpStr;
          break;
      case LCSAttributes::Right:
          SNPRINTF(tmpStr, 1000, "%scauchyGreenTensor = %sRight  # %s\n", prefix, prefix, cauchyGreenTensor_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *eigenComponent_names = "Smallest, Intermediate, Largest, PosShearVector, NegShearVector, "
        "PosLambdaShearVector, NegLambdaShearVector";
    switch (atts->GetEigenComponent())
    {
      case LCSAttributes::Smallest:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sSmallest  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::Intermediate:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sIntermediate  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::Largest:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sLargest  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::PosShearVector:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sPosShearVector  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::NegShearVector:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sNegShearVector  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::PosLambdaShearVector:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sPosLambdaShearVector  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      case LCSAttributes::NegLambdaShearVector:
          SNPRINTF(tmpStr, 1000, "%seigenComponent = %sNegLambdaShearVector  # %s\n", prefix, prefix, eigenComponent_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%seigenWeight = %g\n", prefix, atts->GetEigenWeight());
    str += tmpStr;
    const char *operatorType_names = "BaseValue, Gradient";
    switch (atts->GetOperatorType())
    {
      case LCSAttributes::BaseValue:
          SNPRINTF(tmpStr, 1000, "%soperatorType = %sBaseValue  # %s\n", prefix, prefix, operatorType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Gradient:
          SNPRINTF(tmpStr, 1000, "%soperatorType = %sGradient  # %s\n", prefix, prefix, operatorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *terminationType_names = "Time, Distance, Size";
    switch (atts->GetTerminationType())
    {
      case LCSAttributes::Time:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sTime  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Distance:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sDistance  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Size:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sSize  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetTerminateBySize())
        SNPRINTF(tmpStr, 1000, "%sterminateBySize = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sterminateBySize = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stermSize = %g\n", prefix, atts->GetTermSize());
    str += tmpStr;
    if(atts->GetTerminateByDistance())
        SNPRINTF(tmpStr, 1000, "%sterminateByDistance = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sterminateByDistance = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stermDistance = %g\n", prefix, atts->GetTermDistance());
    str += tmpStr;
    if(atts->GetTerminateByTime())
        SNPRINTF(tmpStr, 1000, "%sterminateByTime = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sterminateByTime = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stermTime = %g\n", prefix, atts->GetTermTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    if(atts->GetLimitMaximumTimestep())
        SNPRINTF(tmpStr, 1000, "%slimitMaximumTimestep = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slimitMaximumTimestep = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxTimeStep = %g\n", prefix, atts->GetMaxTimeStep());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    const char *absTolSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetAbsTolSizeType())
    {
      case LCSAttributes::Absolute:
          SNPRINTF(tmpStr, 1000, "%sabsTolSizeType = %sAbsolute  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      case LCSAttributes::FractionOfBBox:
          SNPRINTF(tmpStr, 1000, "%sabsTolSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sabsTolAbsolute = %g\n", prefix, atts->GetAbsTolAbsolute());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sabsTolBBox = %g\n", prefix, atts->GetAbsTolBBox());
    str += tmpStr;
    const char *fieldType_names = "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
        "NektarPPField, NIMRODField";
    switch (atts->GetFieldType())
    {
      case LCSAttributes::Default:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sDefault  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::FlashField:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sFlashField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::M3DC12DField:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sM3DC12DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::M3DC13DField:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sM3DC13DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Nek5000Field:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sNek5000Field  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::NektarPPField:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sNektarPPField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case LCSAttributes::NIMRODField:
          SNPRINTF(tmpStr, 1000, "%sfieldType = %sNIMRODField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sfieldConstant = %g\n", prefix, atts->GetFieldConstant());
    str += tmpStr;
    {   const double *velocitySource = atts->GetVelocitySource();
        SNPRINTF(tmpStr, 1000, "%svelocitySource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", velocitySource[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *integrationType_names = "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
        "M3DC12DIntegrator";
    switch (atts->GetIntegrationType())
    {
      case LCSAttributes::Euler:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sEuler  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::Leapfrog:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sLeapfrog  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::DormandPrince:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::AdamsBashforth:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::RK4:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sRK4  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case LCSAttributes::M3DC12DIntegrator:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sM3DC12DIntegrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetClampLogValues())
        SNPRINTF(tmpStr, 1000, "%sclampLogValues = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sclampLogValues = 0\n", prefix);
    str += tmpStr;
    const char *parallelizationAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects";
    switch (atts->GetParallelizationAlgorithmType())
    {
      case LCSAttributes::LoadOnDemand:
          SNPRINTF(tmpStr, 1000, "%sparallelizationAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LCSAttributes::ParallelStaticDomains:
          SNPRINTF(tmpStr, 1000, "%sparallelizationAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LCSAttributes::MasterSlave:
          SNPRINTF(tmpStr, 1000, "%sparallelizationAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case LCSAttributes::VisItSelects:
          SNPRINTF(tmpStr, 1000, "%sparallelizationAlgorithmType = %sVisItSelects  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxProcessCount = %d\n", prefix, atts->GetMaxProcessCount());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    if(atts->GetPathlines())
        SNPRINTF(tmpStr, 1000, "%spathlines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spathlines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPathlinesOverrideStartingTimeFlag())
        SNPRINTF(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spathlinesOverrideStartingTime = %g\n", prefix, atts->GetPathlinesOverrideStartingTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spathlinesPeriod = %g\n", prefix, atts->GetPathlinesPeriod());
    str += tmpStr;
    const char *pathlinesCMFE_names = "CONN_CMFE, POS_CMFE";
    switch (atts->GetPathlinesCMFE())
    {
      case LCSAttributes::CONN_CMFE:
          SNPRINTF(tmpStr, 1000, "%spathlinesCMFE = %sCONN_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      case LCSAttributes::POS_CMFE:
          SNPRINTF(tmpStr, 1000, "%spathlinesCMFE = %sPOS_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sthresholdLimit = %g\n", prefix, atts->GetThresholdLimit());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradialLimit = %g\n", prefix, atts->GetRadialLimit());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sboundaryLimit = %g\n", prefix, atts->GetBoundaryLimit());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sseedLimit = %d\n", prefix, atts->GetSeedLimit());
    str += tmpStr;
    if(atts->GetIssueAdvectionWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueAdvectionWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueAdvectionWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueBoundaryWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueBoundaryWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueBoundaryWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueTerminationWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueTerminationWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueTerminationWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStepsizeWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueStepsizeWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueStepsizeWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStiffnessWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueStiffnessWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueStiffnessWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueCriticalPointsWarnings())
        SNPRINTF(tmpStr, 1000, "%sissueCriticalPointsWarnings = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sissueCriticalPointsWarnings = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scriticalPointThreshold = %g\n", prefix, atts->GetCriticalPointThreshold());
    str += tmpStr;
    return str;
}

static PyObject *
LCSAttributes_Notify(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSourceType(LCSAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "NativeMesh, RegularGrid.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetResolution(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int *ivals = obj->data->GetResolution();
    if(!PyArg_ParseTuple(args, "iii", &ivals[0], &ivals[1], &ivals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the Resolution in the object as modified.
    obj->data->SelectResolution();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetResolution(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the Resolution.
    PyObject *retval = PyTuple_New(3);
    const int *Resolution = obj->data->GetResolution();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(Resolution[i])));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetUseDataSetStart(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the UseDataSetStart in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetUseDataSetStart(LCSAttributes::Extents(ival));
    else
    {
        fprintf(stderr, "An invalid UseDataSetStart value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Full, Subset.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetUseDataSetStart(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetUseDataSetStart()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetStartPosition(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double *dvals = obj->data->GetStartPosition();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the StartPosition in the object as modified.
    obj->data->SelectStartPosition();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetStartPosition(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the StartPosition.
    PyObject *retval = PyTuple_New(3);
    const double *StartPosition = obj->data->GetStartPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(StartPosition[i]));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetUseDataSetEnd(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the UseDataSetEnd in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetUseDataSetEnd(LCSAttributes::Extents(ival));
    else
    {
        fprintf(stderr, "An invalid UseDataSetEnd value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Full, Subset.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetUseDataSetEnd(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetUseDataSetEnd()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetEndPosition(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double *dvals = obj->data->GetEndPosition();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the EndPosition in the object as modified.
    obj->data->SelectEndPosition();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetEndPosition(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the EndPosition.
    PyObject *retval = PyTuple_New(3);
    const double *EndPosition = obj->data->GetEndPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(EndPosition[i]));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIntegrationDirection(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationDirection in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetIntegrationDirection(LCSAttributes::IntegrationDirection(ival));
    else
    {
        fprintf(stderr, "An invalid integrationDirection value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Forward, Backward, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIntegrationDirection(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationDirection()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetAuxiliaryGrid(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the auxiliaryGrid in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetAuxiliaryGrid(LCSAttributes::AuxiliaryGrid(ival));
    else
    {
        fprintf(stderr, "An invalid auxiliaryGrid value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, TwoDim, ThreeDim.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetAuxiliaryGrid(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAuxiliaryGrid()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetAuxiliaryGridSpacing(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the auxiliaryGridSpacing in the object.
    obj->data->SetAuxiliaryGridSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetAuxiliaryGridSpacing(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAuxiliaryGridSpacing());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetMaxSteps(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSteps in the object.
    obj->data->SetMaxSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetMaxSteps(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSteps()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetOperationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the operationType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetOperationType(LCSAttributes::OperationType(ival));
    else
    {
        fprintf(stderr, "An invalid operationType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "IntegrationTime, ArcLength, AverageDistanceFromSeed, EigenValue, EigenVector, "
                        "Lyapunov.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetOperationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOperationType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetCauchyGreenTensor(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cauchyGreenTensor in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCauchyGreenTensor(LCSAttributes::CauchyGreenTensor(ival));
    else
    {
        fprintf(stderr, "An invalid cauchyGreenTensor value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Left, Right.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetCauchyGreenTensor(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCauchyGreenTensor()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetEigenComponent(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the eigenComponent in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetEigenComponent(LCSAttributes::EigenComponent(ival));
    else
    {
        fprintf(stderr, "An invalid eigenComponent value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Smallest, Intermediate, Largest, PosShearVector, NegShearVector, "
                        "PosLambdaShearVector, NegLambdaShearVector.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetEigenComponent(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEigenComponent()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetEigenWeight(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the eigenWeight in the object.
    obj->data->SetEigenWeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetEigenWeight(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEigenWeight());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetOperatorType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the operatorType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOperatorType(LCSAttributes::OperatorType(ival));
    else
    {
        fprintf(stderr, "An invalid operatorType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "BaseValue, Gradient.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetOperatorType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOperatorType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTerminationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminationType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTerminationType(LCSAttributes::TerminationType(ival));
    else
    {
        fprintf(stderr, "An invalid terminationType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Time, Distance, Size.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTerminationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTerminationType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTerminateBySize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateBySize in the object.
    obj->data->SetTerminateBySize(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTerminateBySize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateBySize()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTermSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termSize in the object.
    obj->data->SetTermSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTermSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermSize());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTerminateByDistance(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByDistance in the object.
    obj->data->SetTerminateByDistance(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTerminateByDistance(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByDistance()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTermDistance(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termDistance in the object.
    obj->data->SetTermDistance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTermDistance(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermDistance());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTerminateByTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByTime in the object.
    obj->data->SetTerminateByTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTerminateByTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetTermTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termTime in the object.
    obj->data->SetTermTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetTermTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermTime());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitMaximumTimestep in the object.
    obj->data->SetLimitMaximumTimestep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLimitMaximumTimestep()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetMaxTimeStep(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTimeStep in the object.
    obj->data->SetMaxTimeStep(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetMaxTimeStep(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTimeStep());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetAbsTolSizeType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the absTolSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAbsTolSizeType(LCSAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid absTolSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetAbsTolSizeType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAbsTolSizeType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolAbsolute in the object.
    obj->data->SetAbsTolAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolAbsolute());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetAbsTolBBox(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolBBox in the object.
    obj->data->SetAbsTolBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetAbsTolBBox(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolBBox());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetFieldType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fieldType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetFieldType(LCSAttributes::FieldType(ival));
    else
    {
        fprintf(stderr, "An invalid fieldType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
                        "NektarPPField, NIMRODField.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetFieldType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFieldType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetFieldConstant(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the fieldConstant in the object.
    obj->data->SetFieldConstant(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetFieldConstant(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFieldConstant());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetVelocitySource(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double *dvals = obj->data->GetVelocitySource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the velocitySource in the object as modified.
    obj->data->SelectVelocitySource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetVelocitySource(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the velocitySource.
    PyObject *retval = PyTuple_New(3);
    const double *velocitySource = obj->data->GetVelocitySource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(velocitySource[i]));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationType(LCSAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
                        "M3DC12DIntegrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetClampLogValues(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clampLogValues in the object.
    obj->data->SetClampLogValues(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetClampLogValues(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetClampLogValues()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallelizationAlgorithmType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetParallelizationAlgorithmType(LCSAttributes::ParallelizationAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid parallelizationAlgorithmType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetParallelizationAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetMaxProcessCount(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxProcessCount in the object.
    obj->data->SetMaxProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetMaxProcessCount(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxProcessCount()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetPathlines(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlines in the object.
    obj->data->SetPathlines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetPathlines(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesOverrideStartingTimeFlag in the object.
    obj->data->SetPathlinesOverrideStartingTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlinesOverrideStartingTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesOverrideStartingTime in the object.
    obj->data->SetPathlinesOverrideStartingTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesOverrideStartingTime());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetPathlinesPeriod(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesPeriod in the object.
    obj->data->SetPathlinesPeriod(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetPathlinesPeriod(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesPeriod());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetPathlinesCMFE(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesCMFE in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPathlinesCMFE(LCSAttributes::PathlinesCMFE(ival));
    else
    {
        fprintf(stderr, "An invalid pathlinesCMFE value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CONN_CMFE, POS_CMFE.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetPathlinesCMFE(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPathlinesCMFE()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetThresholdLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the thresholdLimit in the object.
    obj->data->SetThresholdLimit(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetThresholdLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThresholdLimit());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetRadialLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radialLimit in the object.
    obj->data->SetRadialLimit(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetRadialLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadialLimit());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetBoundaryLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the boundaryLimit in the object.
    obj->data->SetBoundaryLimit(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetBoundaryLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetBoundaryLimit());
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetSeedLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the seedLimit in the object.
    obj->data->SetSeedLimit((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetSeedLimit(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSeedLimit()));
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueAdvectionWarnings in the object.
    obj->data->SetIssueAdvectionWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueAdvectionWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueAdvectionWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueBoundaryWarnings in the object.
    obj->data->SetIssueBoundaryWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueBoundaryWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueBoundaryWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueTerminationWarnings in the object.
    obj->data->SetIssueTerminationWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueTerminationWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStepsizeWarnings in the object.
    obj->data->SetIssueStepsizeWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStepsizeWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStiffnessWarnings in the object.
    obj->data->SetIssueStiffnessWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStiffnessWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueCriticalPointsWarnings in the object.
    obj->data->SetIssueCriticalPointsWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueCriticalPointsWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LCSAttributes_SetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the criticalPointThreshold in the object.
    obj->data->SetCriticalPointThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LCSAttributes_GetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCriticalPointThreshold());
    return retval;
}



PyMethodDef PyLCSAttributes_methods[LCSATTRIBUTES_NMETH] = {
    {"Notify", LCSAttributes_Notify, METH_VARARGS},
    {"SetSourceType", LCSAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", LCSAttributes_GetSourceType, METH_VARARGS},
    {"SetResolution", LCSAttributes_SetResolution, METH_VARARGS},
    {"GetResolution", LCSAttributes_GetResolution, METH_VARARGS},
    {"SetUseDataSetStart", LCSAttributes_SetUseDataSetStart, METH_VARARGS},
    {"GetUseDataSetStart", LCSAttributes_GetUseDataSetStart, METH_VARARGS},
    {"SetStartPosition", LCSAttributes_SetStartPosition, METH_VARARGS},
    {"GetStartPosition", LCSAttributes_GetStartPosition, METH_VARARGS},
    {"SetUseDataSetEnd", LCSAttributes_SetUseDataSetEnd, METH_VARARGS},
    {"GetUseDataSetEnd", LCSAttributes_GetUseDataSetEnd, METH_VARARGS},
    {"SetEndPosition", LCSAttributes_SetEndPosition, METH_VARARGS},
    {"GetEndPosition", LCSAttributes_GetEndPosition, METH_VARARGS},
    {"SetIntegrationDirection", LCSAttributes_SetIntegrationDirection, METH_VARARGS},
    {"GetIntegrationDirection", LCSAttributes_GetIntegrationDirection, METH_VARARGS},
    {"SetAuxiliaryGrid", LCSAttributes_SetAuxiliaryGrid, METH_VARARGS},
    {"GetAuxiliaryGrid", LCSAttributes_GetAuxiliaryGrid, METH_VARARGS},
    {"SetAuxiliaryGridSpacing", LCSAttributes_SetAuxiliaryGridSpacing, METH_VARARGS},
    {"GetAuxiliaryGridSpacing", LCSAttributes_GetAuxiliaryGridSpacing, METH_VARARGS},
    {"SetMaxSteps", LCSAttributes_SetMaxSteps, METH_VARARGS},
    {"GetMaxSteps", LCSAttributes_GetMaxSteps, METH_VARARGS},
    {"SetOperationType", LCSAttributes_SetOperationType, METH_VARARGS},
    {"GetOperationType", LCSAttributes_GetOperationType, METH_VARARGS},
    {"SetCauchyGreenTensor", LCSAttributes_SetCauchyGreenTensor, METH_VARARGS},
    {"GetCauchyGreenTensor", LCSAttributes_GetCauchyGreenTensor, METH_VARARGS},
    {"SetEigenComponent", LCSAttributes_SetEigenComponent, METH_VARARGS},
    {"GetEigenComponent", LCSAttributes_GetEigenComponent, METH_VARARGS},
    {"SetEigenWeight", LCSAttributes_SetEigenWeight, METH_VARARGS},
    {"GetEigenWeight", LCSAttributes_GetEigenWeight, METH_VARARGS},
    {"SetOperatorType", LCSAttributes_SetOperatorType, METH_VARARGS},
    {"GetOperatorType", LCSAttributes_GetOperatorType, METH_VARARGS},
    {"SetTerminationType", LCSAttributes_SetTerminationType, METH_VARARGS},
    {"GetTerminationType", LCSAttributes_GetTerminationType, METH_VARARGS},
    {"SetTerminateBySize", LCSAttributes_SetTerminateBySize, METH_VARARGS},
    {"GetTerminateBySize", LCSAttributes_GetTerminateBySize, METH_VARARGS},
    {"SetTermSize", LCSAttributes_SetTermSize, METH_VARARGS},
    {"GetTermSize", LCSAttributes_GetTermSize, METH_VARARGS},
    {"SetTerminateByDistance", LCSAttributes_SetTerminateByDistance, METH_VARARGS},
    {"GetTerminateByDistance", LCSAttributes_GetTerminateByDistance, METH_VARARGS},
    {"SetTermDistance", LCSAttributes_SetTermDistance, METH_VARARGS},
    {"GetTermDistance", LCSAttributes_GetTermDistance, METH_VARARGS},
    {"SetTerminateByTime", LCSAttributes_SetTerminateByTime, METH_VARARGS},
    {"GetTerminateByTime", LCSAttributes_GetTerminateByTime, METH_VARARGS},
    {"SetTermTime", LCSAttributes_SetTermTime, METH_VARARGS},
    {"GetTermTime", LCSAttributes_GetTermTime, METH_VARARGS},
    {"SetMaxStepLength", LCSAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", LCSAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetLimitMaximumTimestep", LCSAttributes_SetLimitMaximumTimestep, METH_VARARGS},
    {"GetLimitMaximumTimestep", LCSAttributes_GetLimitMaximumTimestep, METH_VARARGS},
    {"SetMaxTimeStep", LCSAttributes_SetMaxTimeStep, METH_VARARGS},
    {"GetMaxTimeStep", LCSAttributes_GetMaxTimeStep, METH_VARARGS},
    {"SetRelTol", LCSAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", LCSAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTolSizeType", LCSAttributes_SetAbsTolSizeType, METH_VARARGS},
    {"GetAbsTolSizeType", LCSAttributes_GetAbsTolSizeType, METH_VARARGS},
    {"SetAbsTolAbsolute", LCSAttributes_SetAbsTolAbsolute, METH_VARARGS},
    {"GetAbsTolAbsolute", LCSAttributes_GetAbsTolAbsolute, METH_VARARGS},
    {"SetAbsTolBBox", LCSAttributes_SetAbsTolBBox, METH_VARARGS},
    {"GetAbsTolBBox", LCSAttributes_GetAbsTolBBox, METH_VARARGS},
    {"SetFieldType", LCSAttributes_SetFieldType, METH_VARARGS},
    {"GetFieldType", LCSAttributes_GetFieldType, METH_VARARGS},
    {"SetFieldConstant", LCSAttributes_SetFieldConstant, METH_VARARGS},
    {"GetFieldConstant", LCSAttributes_GetFieldConstant, METH_VARARGS},
    {"SetVelocitySource", LCSAttributes_SetVelocitySource, METH_VARARGS},
    {"GetVelocitySource", LCSAttributes_GetVelocitySource, METH_VARARGS},
    {"SetIntegrationType", LCSAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", LCSAttributes_GetIntegrationType, METH_VARARGS},
    {"SetClampLogValues", LCSAttributes_SetClampLogValues, METH_VARARGS},
    {"GetClampLogValues", LCSAttributes_GetClampLogValues, METH_VARARGS},
    {"SetParallelizationAlgorithmType", LCSAttributes_SetParallelizationAlgorithmType, METH_VARARGS},
    {"GetParallelizationAlgorithmType", LCSAttributes_GetParallelizationAlgorithmType, METH_VARARGS},
    {"SetMaxProcessCount", LCSAttributes_SetMaxProcessCount, METH_VARARGS},
    {"GetMaxProcessCount", LCSAttributes_GetMaxProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", LCSAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", LCSAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", LCSAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", LCSAttributes_GetWorkGroupSize, METH_VARARGS},
    {"SetPathlines", LCSAttributes_SetPathlines, METH_VARARGS},
    {"GetPathlines", LCSAttributes_GetPathlines, METH_VARARGS},
    {"SetPathlinesOverrideStartingTimeFlag", LCSAttributes_SetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"GetPathlinesOverrideStartingTimeFlag", LCSAttributes_GetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"SetPathlinesOverrideStartingTime", LCSAttributes_SetPathlinesOverrideStartingTime, METH_VARARGS},
    {"GetPathlinesOverrideStartingTime", LCSAttributes_GetPathlinesOverrideStartingTime, METH_VARARGS},
    {"SetPathlinesPeriod", LCSAttributes_SetPathlinesPeriod, METH_VARARGS},
    {"GetPathlinesPeriod", LCSAttributes_GetPathlinesPeriod, METH_VARARGS},
    {"SetPathlinesCMFE", LCSAttributes_SetPathlinesCMFE, METH_VARARGS},
    {"GetPathlinesCMFE", LCSAttributes_GetPathlinesCMFE, METH_VARARGS},
    {"SetThresholdLimit", LCSAttributes_SetThresholdLimit, METH_VARARGS},
    {"GetThresholdLimit", LCSAttributes_GetThresholdLimit, METH_VARARGS},
    {"SetRadialLimit", LCSAttributes_SetRadialLimit, METH_VARARGS},
    {"GetRadialLimit", LCSAttributes_GetRadialLimit, METH_VARARGS},
    {"SetBoundaryLimit", LCSAttributes_SetBoundaryLimit, METH_VARARGS},
    {"GetBoundaryLimit", LCSAttributes_GetBoundaryLimit, METH_VARARGS},
    {"SetSeedLimit", LCSAttributes_SetSeedLimit, METH_VARARGS},
    {"GetSeedLimit", LCSAttributes_GetSeedLimit, METH_VARARGS},
    {"SetIssueAdvectionWarnings", LCSAttributes_SetIssueAdvectionWarnings, METH_VARARGS},
    {"GetIssueAdvectionWarnings", LCSAttributes_GetIssueAdvectionWarnings, METH_VARARGS},
    {"SetIssueBoundaryWarnings", LCSAttributes_SetIssueBoundaryWarnings, METH_VARARGS},
    {"GetIssueBoundaryWarnings", LCSAttributes_GetIssueBoundaryWarnings, METH_VARARGS},
    {"SetIssueTerminationWarnings", LCSAttributes_SetIssueTerminationWarnings, METH_VARARGS},
    {"GetIssueTerminationWarnings", LCSAttributes_GetIssueTerminationWarnings, METH_VARARGS},
    {"SetIssueStepsizeWarnings", LCSAttributes_SetIssueStepsizeWarnings, METH_VARARGS},
    {"GetIssueStepsizeWarnings", LCSAttributes_GetIssueStepsizeWarnings, METH_VARARGS},
    {"SetIssueStiffnessWarnings", LCSAttributes_SetIssueStiffnessWarnings, METH_VARARGS},
    {"GetIssueStiffnessWarnings", LCSAttributes_GetIssueStiffnessWarnings, METH_VARARGS},
    {"SetIssueCriticalPointsWarnings", LCSAttributes_SetIssueCriticalPointsWarnings, METH_VARARGS},
    {"GetIssueCriticalPointsWarnings", LCSAttributes_GetIssueCriticalPointsWarnings, METH_VARARGS},
    {"SetCriticalPointThreshold", LCSAttributes_SetCriticalPointThreshold, METH_VARARGS},
    {"GetCriticalPointThreshold", LCSAttributes_GetCriticalPointThreshold, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LCSAttributes_dealloc(PyObject *v)
{
   LCSAttributesObject *obj = (LCSAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LCSAttributes_compare(PyObject *v, PyObject *w)
{
    LCSAttributes *a = ((LCSAttributesObject *)v)->data;
    LCSAttributes *b = ((LCSAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLCSAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return LCSAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "NativeMesh") == 0)
        return PyInt_FromLong(long(LCSAttributes::NativeMesh));
    if(strcmp(name, "RegularGrid") == 0)
        return PyInt_FromLong(long(LCSAttributes::RegularGrid));

    if(strcmp(name, "Resolution") == 0)
        return LCSAttributes_GetResolution(self, NULL);
    if(strcmp(name, "UseDataSetStart") == 0)
        return LCSAttributes_GetUseDataSetStart(self, NULL);
    if(strcmp(name, "Full") == 0)
        return PyInt_FromLong(long(LCSAttributes::Full));
    if(strcmp(name, "Subset") == 0)
        return PyInt_FromLong(long(LCSAttributes::Subset));

    if(strcmp(name, "StartPosition") == 0)
        return LCSAttributes_GetStartPosition(self, NULL);
    if(strcmp(name, "UseDataSetEnd") == 0)
        return LCSAttributes_GetUseDataSetEnd(self, NULL);
    if(strcmp(name, "Full") == 0)
        return PyInt_FromLong(long(LCSAttributes::Full));
    if(strcmp(name, "Subset") == 0)
        return PyInt_FromLong(long(LCSAttributes::Subset));

    if(strcmp(name, "EndPosition") == 0)
        return LCSAttributes_GetEndPosition(self, NULL);
    if(strcmp(name, "integrationDirection") == 0)
        return LCSAttributes_GetIntegrationDirection(self, NULL);
    if(strcmp(name, "Forward") == 0)
        return PyInt_FromLong(long(LCSAttributes::Forward));
    if(strcmp(name, "Backward") == 0)
        return PyInt_FromLong(long(LCSAttributes::Backward));
    if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(LCSAttributes::Both));

    if(strcmp(name, "auxiliaryGrid") == 0)
        return LCSAttributes_GetAuxiliaryGrid(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(LCSAttributes::None));
    if(strcmp(name, "TwoDim") == 0)
        return PyInt_FromLong(long(LCSAttributes::TwoDim));
    if(strcmp(name, "ThreeDim") == 0)
        return PyInt_FromLong(long(LCSAttributes::ThreeDim));

    if(strcmp(name, "auxiliaryGridSpacing") == 0)
        return LCSAttributes_GetAuxiliaryGridSpacing(self, NULL);
    if(strcmp(name, "maxSteps") == 0)
        return LCSAttributes_GetMaxSteps(self, NULL);
    if(strcmp(name, "operationType") == 0)
        return LCSAttributes_GetOperationType(self, NULL);
    if(strcmp(name, "IntegrationTime") == 0)
        return PyInt_FromLong(long(LCSAttributes::IntegrationTime));
    if(strcmp(name, "ArcLength") == 0)
        return PyInt_FromLong(long(LCSAttributes::ArcLength));
    if(strcmp(name, "AverageDistanceFromSeed") == 0)
        return PyInt_FromLong(long(LCSAttributes::AverageDistanceFromSeed));
    if(strcmp(name, "EigenValue") == 0)
        return PyInt_FromLong(long(LCSAttributes::EigenValue));
    if(strcmp(name, "EigenVector") == 0)
        return PyInt_FromLong(long(LCSAttributes::EigenVector));
    if(strcmp(name, "Lyapunov") == 0)
        return PyInt_FromLong(long(LCSAttributes::Lyapunov));

    if(strcmp(name, "cauchyGreenTensor") == 0)
        return LCSAttributes_GetCauchyGreenTensor(self, NULL);
    if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(LCSAttributes::Left));
    if(strcmp(name, "Right") == 0)
        return PyInt_FromLong(long(LCSAttributes::Right));

    if(strcmp(name, "eigenComponent") == 0)
        return LCSAttributes_GetEigenComponent(self, NULL);
    if(strcmp(name, "Smallest") == 0)
        return PyInt_FromLong(long(LCSAttributes::Smallest));
    if(strcmp(name, "Intermediate") == 0)
        return PyInt_FromLong(long(LCSAttributes::Intermediate));
    if(strcmp(name, "Largest") == 0)
        return PyInt_FromLong(long(LCSAttributes::Largest));
    if(strcmp(name, "PosShearVector") == 0)
        return PyInt_FromLong(long(LCSAttributes::PosShearVector));
    if(strcmp(name, "NegShearVector") == 0)
        return PyInt_FromLong(long(LCSAttributes::NegShearVector));
    if(strcmp(name, "PosLambdaShearVector") == 0)
        return PyInt_FromLong(long(LCSAttributes::PosLambdaShearVector));
    if(strcmp(name, "NegLambdaShearVector") == 0)
        return PyInt_FromLong(long(LCSAttributes::NegLambdaShearVector));

    if(strcmp(name, "eigenWeight") == 0)
        return LCSAttributes_GetEigenWeight(self, NULL);
    if(strcmp(name, "operatorType") == 0)
        return LCSAttributes_GetOperatorType(self, NULL);
    if(strcmp(name, "BaseValue") == 0)
        return PyInt_FromLong(long(LCSAttributes::BaseValue));
    if(strcmp(name, "Gradient") == 0)
        return PyInt_FromLong(long(LCSAttributes::Gradient));

    if(strcmp(name, "terminationType") == 0)
        return LCSAttributes_GetTerminationType(self, NULL);
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(LCSAttributes::Time));
    if(strcmp(name, "Distance") == 0)
        return PyInt_FromLong(long(LCSAttributes::Distance));
    if(strcmp(name, "Size") == 0)
        return PyInt_FromLong(long(LCSAttributes::Size));

    if(strcmp(name, "terminateBySize") == 0)
        return LCSAttributes_GetTerminateBySize(self, NULL);
    if(strcmp(name, "termSize") == 0)
        return LCSAttributes_GetTermSize(self, NULL);
    if(strcmp(name, "terminateByDistance") == 0)
        return LCSAttributes_GetTerminateByDistance(self, NULL);
    if(strcmp(name, "termDistance") == 0)
        return LCSAttributes_GetTermDistance(self, NULL);
    if(strcmp(name, "terminateByTime") == 0)
        return LCSAttributes_GetTerminateByTime(self, NULL);
    if(strcmp(name, "termTime") == 0)
        return LCSAttributes_GetTermTime(self, NULL);
    if(strcmp(name, "maxStepLength") == 0)
        return LCSAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "limitMaximumTimestep") == 0)
        return LCSAttributes_GetLimitMaximumTimestep(self, NULL);
    if(strcmp(name, "maxTimeStep") == 0)
        return LCSAttributes_GetMaxTimeStep(self, NULL);
    if(strcmp(name, "relTol") == 0)
        return LCSAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTolSizeType") == 0)
        return LCSAttributes_GetAbsTolSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(LCSAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(LCSAttributes::FractionOfBBox));

    if(strcmp(name, "absTolAbsolute") == 0)
        return LCSAttributes_GetAbsTolAbsolute(self, NULL);
    if(strcmp(name, "absTolBBox") == 0)
        return LCSAttributes_GetAbsTolBBox(self, NULL);
    if(strcmp(name, "fieldType") == 0)
        return LCSAttributes_GetFieldType(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(LCSAttributes::Default));
    if(strcmp(name, "FlashField") == 0)
        return PyInt_FromLong(long(LCSAttributes::FlashField));
    if(strcmp(name, "M3DC12DField") == 0)
        return PyInt_FromLong(long(LCSAttributes::M3DC12DField));
    if(strcmp(name, "M3DC13DField") == 0)
        return PyInt_FromLong(long(LCSAttributes::M3DC13DField));
    if(strcmp(name, "Nek5000Field") == 0)
        return PyInt_FromLong(long(LCSAttributes::Nek5000Field));
    if(strcmp(name, "NektarPPField") == 0)
        return PyInt_FromLong(long(LCSAttributes::NektarPPField));
    if(strcmp(name, "NIMRODField") == 0)
        return PyInt_FromLong(long(LCSAttributes::NIMRODField));

    if(strcmp(name, "fieldConstant") == 0)
        return LCSAttributes_GetFieldConstant(self, NULL);
    if(strcmp(name, "velocitySource") == 0)
        return LCSAttributes_GetVelocitySource(self, NULL);
    if(strcmp(name, "integrationType") == 0)
        return LCSAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "Euler") == 0)
        return PyInt_FromLong(long(LCSAttributes::Euler));
    if(strcmp(name, "Leapfrog") == 0)
        return PyInt_FromLong(long(LCSAttributes::Leapfrog));
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(LCSAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(LCSAttributes::AdamsBashforth));
    if(strcmp(name, "RK4") == 0)
        return PyInt_FromLong(long(LCSAttributes::RK4));
    if(strcmp(name, "M3DC12DIntegrator") == 0)
        return PyInt_FromLong(long(LCSAttributes::M3DC12DIntegrator));

    if(strcmp(name, "clampLogValues") == 0)
        return LCSAttributes_GetClampLogValues(self, NULL);
    if(strcmp(name, "parallelizationAlgorithmType") == 0)
        return LCSAttributes_GetParallelizationAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(LCSAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(LCSAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(LCSAttributes::MasterSlave));
    if(strcmp(name, "VisItSelects") == 0)
        return PyInt_FromLong(long(LCSAttributes::VisItSelects));

    if(strcmp(name, "maxProcessCount") == 0)
        return LCSAttributes_GetMaxProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return LCSAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return LCSAttributes_GetWorkGroupSize(self, NULL);
    if(strcmp(name, "pathlines") == 0)
        return LCSAttributes_GetPathlines(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        return LCSAttributes_GetPathlinesOverrideStartingTimeFlag(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        return LCSAttributes_GetPathlinesOverrideStartingTime(self, NULL);
    if(strcmp(name, "pathlinesPeriod") == 0)
        return LCSAttributes_GetPathlinesPeriod(self, NULL);
    if(strcmp(name, "pathlinesCMFE") == 0)
        return LCSAttributes_GetPathlinesCMFE(self, NULL);
    if(strcmp(name, "CONN_CMFE") == 0)
        return PyInt_FromLong(long(LCSAttributes::CONN_CMFE));
    if(strcmp(name, "POS_CMFE") == 0)
        return PyInt_FromLong(long(LCSAttributes::POS_CMFE));

    if(strcmp(name, "thresholdLimit") == 0)
        return LCSAttributes_GetThresholdLimit(self, NULL);
    if(strcmp(name, "radialLimit") == 0)
        return LCSAttributes_GetRadialLimit(self, NULL);
    if(strcmp(name, "boundaryLimit") == 0)
        return LCSAttributes_GetBoundaryLimit(self, NULL);
    if(strcmp(name, "seedLimit") == 0)
        return LCSAttributes_GetSeedLimit(self, NULL);
    if(strcmp(name, "issueAdvectionWarnings") == 0)
        return LCSAttributes_GetIssueAdvectionWarnings(self, NULL);
    if(strcmp(name, "issueBoundaryWarnings") == 0)
        return LCSAttributes_GetIssueBoundaryWarnings(self, NULL);
    if(strcmp(name, "issueTerminationWarnings") == 0)
        return LCSAttributes_GetIssueTerminationWarnings(self, NULL);
    if(strcmp(name, "issueStepsizeWarnings") == 0)
        return LCSAttributes_GetIssueStepsizeWarnings(self, NULL);
    if(strcmp(name, "issueStiffnessWarnings") == 0)
        return LCSAttributes_GetIssueStiffnessWarnings(self, NULL);
    if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        return LCSAttributes_GetIssueCriticalPointsWarnings(self, NULL);
    if(strcmp(name, "criticalPointThreshold") == 0)
        return LCSAttributes_GetCriticalPointThreshold(self, NULL);

    return Py_FindMethod(PyLCSAttributes_methods, self, name);
}

int
PyLCSAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "sourceType") == 0)
        obj = LCSAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "Resolution") == 0)
        obj = LCSAttributes_SetResolution(self, tuple);
    else if(strcmp(name, "UseDataSetStart") == 0)
        obj = LCSAttributes_SetUseDataSetStart(self, tuple);
    else if(strcmp(name, "StartPosition") == 0)
        obj = LCSAttributes_SetStartPosition(self, tuple);
    else if(strcmp(name, "UseDataSetEnd") == 0)
        obj = LCSAttributes_SetUseDataSetEnd(self, tuple);
    else if(strcmp(name, "EndPosition") == 0)
        obj = LCSAttributes_SetEndPosition(self, tuple);
    else if(strcmp(name, "integrationDirection") == 0)
        obj = LCSAttributes_SetIntegrationDirection(self, tuple);
    else if(strcmp(name, "auxiliaryGrid") == 0)
        obj = LCSAttributes_SetAuxiliaryGrid(self, tuple);
    else if(strcmp(name, "auxiliaryGridSpacing") == 0)
        obj = LCSAttributes_SetAuxiliaryGridSpacing(self, tuple);
    else if(strcmp(name, "maxSteps") == 0)
        obj = LCSAttributes_SetMaxSteps(self, tuple);
    else if(strcmp(name, "operationType") == 0)
        obj = LCSAttributes_SetOperationType(self, tuple);
    else if(strcmp(name, "cauchyGreenTensor") == 0)
        obj = LCSAttributes_SetCauchyGreenTensor(self, tuple);
    else if(strcmp(name, "eigenComponent") == 0)
        obj = LCSAttributes_SetEigenComponent(self, tuple);
    else if(strcmp(name, "eigenWeight") == 0)
        obj = LCSAttributes_SetEigenWeight(self, tuple);
    else if(strcmp(name, "operatorType") == 0)
        obj = LCSAttributes_SetOperatorType(self, tuple);
    else if(strcmp(name, "terminationType") == 0)
        obj = LCSAttributes_SetTerminationType(self, tuple);
    else if(strcmp(name, "terminateBySize") == 0)
        obj = LCSAttributes_SetTerminateBySize(self, tuple);
    else if(strcmp(name, "termSize") == 0)
        obj = LCSAttributes_SetTermSize(self, tuple);
    else if(strcmp(name, "terminateByDistance") == 0)
        obj = LCSAttributes_SetTerminateByDistance(self, tuple);
    else if(strcmp(name, "termDistance") == 0)
        obj = LCSAttributes_SetTermDistance(self, tuple);
    else if(strcmp(name, "terminateByTime") == 0)
        obj = LCSAttributes_SetTerminateByTime(self, tuple);
    else if(strcmp(name, "termTime") == 0)
        obj = LCSAttributes_SetTermTime(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = LCSAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "limitMaximumTimestep") == 0)
        obj = LCSAttributes_SetLimitMaximumTimestep(self, tuple);
    else if(strcmp(name, "maxTimeStep") == 0)
        obj = LCSAttributes_SetMaxTimeStep(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = LCSAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTolSizeType") == 0)
        obj = LCSAttributes_SetAbsTolSizeType(self, tuple);
    else if(strcmp(name, "absTolAbsolute") == 0)
        obj = LCSAttributes_SetAbsTolAbsolute(self, tuple);
    else if(strcmp(name, "absTolBBox") == 0)
        obj = LCSAttributes_SetAbsTolBBox(self, tuple);
    else if(strcmp(name, "fieldType") == 0)
        obj = LCSAttributes_SetFieldType(self, tuple);
    else if(strcmp(name, "fieldConstant") == 0)
        obj = LCSAttributes_SetFieldConstant(self, tuple);
    else if(strcmp(name, "velocitySource") == 0)
        obj = LCSAttributes_SetVelocitySource(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = LCSAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "clampLogValues") == 0)
        obj = LCSAttributes_SetClampLogValues(self, tuple);
    else if(strcmp(name, "parallelizationAlgorithmType") == 0)
        obj = LCSAttributes_SetParallelizationAlgorithmType(self, tuple);
    else if(strcmp(name, "maxProcessCount") == 0)
        obj = LCSAttributes_SetMaxProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = LCSAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = LCSAttributes_SetWorkGroupSize(self, tuple);
    else if(strcmp(name, "pathlines") == 0)
        obj = LCSAttributes_SetPathlines(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        obj = LCSAttributes_SetPathlinesOverrideStartingTimeFlag(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        obj = LCSAttributes_SetPathlinesOverrideStartingTime(self, tuple);
    else if(strcmp(name, "pathlinesPeriod") == 0)
        obj = LCSAttributes_SetPathlinesPeriod(self, tuple);
    else if(strcmp(name, "pathlinesCMFE") == 0)
        obj = LCSAttributes_SetPathlinesCMFE(self, tuple);
    else if(strcmp(name, "thresholdLimit") == 0)
        obj = LCSAttributes_SetThresholdLimit(self, tuple);
    else if(strcmp(name, "radialLimit") == 0)
        obj = LCSAttributes_SetRadialLimit(self, tuple);
    else if(strcmp(name, "boundaryLimit") == 0)
        obj = LCSAttributes_SetBoundaryLimit(self, tuple);
    else if(strcmp(name, "seedLimit") == 0)
        obj = LCSAttributes_SetSeedLimit(self, tuple);
    else if(strcmp(name, "issueAdvectionWarnings") == 0)
        obj = LCSAttributes_SetIssueAdvectionWarnings(self, tuple);
    else if(strcmp(name, "issueBoundaryWarnings") == 0)
        obj = LCSAttributes_SetIssueBoundaryWarnings(self, tuple);
    else if(strcmp(name, "issueTerminationWarnings") == 0)
        obj = LCSAttributes_SetIssueTerminationWarnings(self, tuple);
    else if(strcmp(name, "issueStepsizeWarnings") == 0)
        obj = LCSAttributes_SetIssueStepsizeWarnings(self, tuple);
    else if(strcmp(name, "issueStiffnessWarnings") == 0)
        obj = LCSAttributes_SetIssueStiffnessWarnings(self, tuple);
    else if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        obj = LCSAttributes_SetIssueCriticalPointsWarnings(self, tuple);
    else if(strcmp(name, "criticalPointThreshold") == 0)
        obj = LCSAttributes_SetCriticalPointThreshold(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LCSAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)v;
    fprintf(fp, "%s", PyLCSAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LCSAttributes_str(PyObject *v)
{
    LCSAttributesObject *obj = (LCSAttributesObject *)v;
    return PyString_FromString(PyLCSAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LCSAttributes_Purpose = "Attributes for LCS";
#else
static char *LCSAttributes_Purpose = "Attributes for LCS";
#endif

//
// The type description structure
//
static PyTypeObject LCSAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LCSAttributes",                    // tp_name
    sizeof(LCSAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LCSAttributes_dealloc,  // tp_dealloc
    (printfunc)LCSAttributes_print,     // tp_print
    (getattrfunc)PyLCSAttributes_getattr, // tp_getattr
    (setattrfunc)PyLCSAttributes_setattr, // tp_setattr
    (cmpfunc)LCSAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LCSAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LCSAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LCSAttributes *defaultAtts = 0;
static LCSAttributes *currentAtts = 0;

static PyObject *
NewLCSAttributes(int useCurrent)
{
    LCSAttributesObject *newObject;
    newObject = PyObject_NEW(LCSAttributesObject, &LCSAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LCSAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LCSAttributes(*defaultAtts);
    else
        newObject->data = new LCSAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLCSAttributes(const LCSAttributes *attr)
{
    LCSAttributesObject *newObject;
    newObject = PyObject_NEW(LCSAttributesObject, &LCSAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LCSAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LCSAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLCSAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LCSAttributesMethods[] = {
    {"LCSAttributes", LCSAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LCSAttributesObserver = 0;

std::string
PyLCSAttributes_GetLogString()
{
    std::string s("LCSAtts = LCSAttributes()\n");
    if(currentAtts != 0)
        s += PyLCSAttributes_ToString(currentAtts, "LCSAtts.");
    return s;
}

static void
PyLCSAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LCSAtts = LCSAttributes()\n");
        s += PyLCSAttributes_ToString(currentAtts, "LCSAtts.");
        cb(s);
    }
}

void
PyLCSAttributes_StartUp(LCSAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLCSAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LCSAttributesObserver == 0)
    {
        LCSAttributesObserver = new ObserverToCallback(subj,
            PyLCSAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLCSAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LCSAttributesObserver;
    LCSAttributesObserver = 0;
}

PyMethodDef *
PyLCSAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LCSAttributesMethods;
}

bool
PyLCSAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LCSAttributesType);
}

LCSAttributes *
PyLCSAttributes_FromPyObject(PyObject *obj)
{
    LCSAttributesObject *obj2 = (LCSAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLCSAttributes_New()
{
    return NewLCSAttributes(0);
}

PyObject *
PyLCSAttributes_Wrap(const LCSAttributes *attr)
{
    return WrapLCSAttributes(attr);
}

void
PyLCSAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LCSAttributesObject *obj2 = (LCSAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLCSAttributes_SetDefaults(const LCSAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LCSAttributes(*atts);
}

