/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyExtrudeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyExtrudeAttributes
//
// Purpose: 
//   This class contains attributes for the extrude operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ExtrudeAttributes.
//
struct ExtrudeAttributesObject
{
    PyObject_HEAD
    ExtrudeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewExtrudeAttributes(int);

std::string
PyExtrudeAttributes_ToString(const ExtrudeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *axis = atts->GetAxis();
        SNPRINTF(tmpStr, 1000, "%saxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", axis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%slength = %g\n", prefix, atts->GetLength());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssteps = %d\n", prefix, atts->GetSteps());
    str += tmpStr;
    if(atts->GetPreserveOriginalCellNumbers())
        SNPRINTF(tmpStr, 1000, "%spreserveOriginalCellNumbers = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spreserveOriginalCellNumbers = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ExtrudeAttributes_Notify(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtrudeAttributes_SetAxis(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;

    double *dvals = obj->data->GetAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the axis in the object as modified.
    obj->data->SelectAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtrudeAttributes_GetAxis(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the axis.
    PyObject *retval = PyTuple_New(3);
    const double *axis = obj->data->GetAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(axis[i]));
    return retval;
}

/*static*/ PyObject *
ExtrudeAttributes_SetLength(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the length in the object.
    obj->data->SetLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtrudeAttributes_GetLength(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLength());
    return retval;
}

/*static*/ PyObject *
ExtrudeAttributes_SetSteps(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the steps in the object.
    obj->data->SetSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtrudeAttributes_GetSteps(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSteps()));
    return retval;
}

/*static*/ PyObject *
ExtrudeAttributes_SetPreserveOriginalCellNumbers(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the preserveOriginalCellNumbers in the object.
    obj->data->SetPreserveOriginalCellNumbers(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ExtrudeAttributes_GetPreserveOriginalCellNumbers(PyObject *self, PyObject *args)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPreserveOriginalCellNumbers()?1L:0L);
    return retval;
}



PyMethodDef PyExtrudeAttributes_methods[EXTRUDEATTRIBUTES_NMETH] = {
    {"Notify", ExtrudeAttributes_Notify, METH_VARARGS},
    {"SetAxis", ExtrudeAttributes_SetAxis, METH_VARARGS},
    {"GetAxis", ExtrudeAttributes_GetAxis, METH_VARARGS},
    {"SetLength", ExtrudeAttributes_SetLength, METH_VARARGS},
    {"GetLength", ExtrudeAttributes_GetLength, METH_VARARGS},
    {"SetSteps", ExtrudeAttributes_SetSteps, METH_VARARGS},
    {"GetSteps", ExtrudeAttributes_GetSteps, METH_VARARGS},
    {"SetPreserveOriginalCellNumbers", ExtrudeAttributes_SetPreserveOriginalCellNumbers, METH_VARARGS},
    {"GetPreserveOriginalCellNumbers", ExtrudeAttributes_GetPreserveOriginalCellNumbers, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ExtrudeAttributes_dealloc(PyObject *v)
{
   ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ExtrudeAttributes_compare(PyObject *v, PyObject *w)
{
    ExtrudeAttributes *a = ((ExtrudeAttributesObject *)v)->data;
    ExtrudeAttributes *b = ((ExtrudeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyExtrudeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "axis") == 0)
        return ExtrudeAttributes_GetAxis(self, NULL);
    if(strcmp(name, "length") == 0)
        return ExtrudeAttributes_GetLength(self, NULL);
    if(strcmp(name, "steps") == 0)
        return ExtrudeAttributes_GetSteps(self, NULL);
    if(strcmp(name, "preserveOriginalCellNumbers") == 0)
        return ExtrudeAttributes_GetPreserveOriginalCellNumbers(self, NULL);

    return Py_FindMethod(PyExtrudeAttributes_methods, self, name);
}

int
PyExtrudeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "axis") == 0)
        obj = ExtrudeAttributes_SetAxis(self, tuple);
    else if(strcmp(name, "length") == 0)
        obj = ExtrudeAttributes_SetLength(self, tuple);
    else if(strcmp(name, "steps") == 0)
        obj = ExtrudeAttributes_SetSteps(self, tuple);
    else if(strcmp(name, "preserveOriginalCellNumbers") == 0)
        obj = ExtrudeAttributes_SetPreserveOriginalCellNumbers(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ExtrudeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)v;
    fprintf(fp, "%s", PyExtrudeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ExtrudeAttributes_str(PyObject *v)
{
    ExtrudeAttributesObject *obj = (ExtrudeAttributesObject *)v;
    return PyString_FromString(PyExtrudeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ExtrudeAttributes_Purpose = "This class contains attributes for the extrude operator.";
#else
static char *ExtrudeAttributes_Purpose = "This class contains attributes for the extrude operator.";
#endif

//
// The type description structure
//
static PyTypeObject ExtrudeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ExtrudeAttributes",                    // tp_name
    sizeof(ExtrudeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ExtrudeAttributes_dealloc,  // tp_dealloc
    (printfunc)ExtrudeAttributes_print,     // tp_print
    (getattrfunc)PyExtrudeAttributes_getattr, // tp_getattr
    (setattrfunc)PyExtrudeAttributes_setattr, // tp_setattr
    (cmpfunc)ExtrudeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ExtrudeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ExtrudeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ExtrudeAttributes *defaultAtts = 0;
static ExtrudeAttributes *currentAtts = 0;

static PyObject *
NewExtrudeAttributes(int useCurrent)
{
    ExtrudeAttributesObject *newObject;
    newObject = PyObject_NEW(ExtrudeAttributesObject, &ExtrudeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ExtrudeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ExtrudeAttributes(*defaultAtts);
    else
        newObject->data = new ExtrudeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapExtrudeAttributes(const ExtrudeAttributes *attr)
{
    ExtrudeAttributesObject *newObject;
    newObject = PyObject_NEW(ExtrudeAttributesObject, &ExtrudeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ExtrudeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ExtrudeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewExtrudeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExtrudeAttributesMethods[] = {
    {"ExtrudeAttributes", ExtrudeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExtrudeAttributesObserver = 0;

std::string
PyExtrudeAttributes_GetLogString()
{
    std::string s("ExtrudeAtts = ExtrudeAttributes()\n");
    if(currentAtts != 0)
        s += PyExtrudeAttributes_ToString(currentAtts, "ExtrudeAtts.");
    return s;
}

static void
PyExtrudeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ExtrudeAtts = ExtrudeAttributes()\n");
        s += PyExtrudeAttributes_ToString(currentAtts, "ExtrudeAtts.");
        cb(s);
    }
}

void
PyExtrudeAttributes_StartUp(ExtrudeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyExtrudeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExtrudeAttributesObserver == 0)
    {
        ExtrudeAttributesObserver = new ObserverToCallback(subj,
            PyExtrudeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyExtrudeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExtrudeAttributesObserver;
    ExtrudeAttributesObserver = 0;
}

PyMethodDef *
PyExtrudeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExtrudeAttributesMethods;
}

bool
PyExtrudeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ExtrudeAttributesType);
}

ExtrudeAttributes *
PyExtrudeAttributes_FromPyObject(PyObject *obj)
{
    ExtrudeAttributesObject *obj2 = (ExtrudeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyExtrudeAttributes_New()
{
    return NewExtrudeAttributes(0);
}

PyObject *
PyExtrudeAttributes_Wrap(const ExtrudeAttributes *attr)
{
    return WrapExtrudeAttributes(attr);
}

void
PyExtrudeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ExtrudeAttributesObject *obj2 = (ExtrudeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyExtrudeAttributes_SetDefaults(const ExtrudeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ExtrudeAttributes(*atts);
}

