/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SelectionList.h>
#include <DataNode.h>
#include <SelectionProperties.h>
#include <SelectionSummary.h>

// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Init utility for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SelectionList::Init()
{
    autoApplyUpdates = false;

    SelectionList::SelectAll();
}

// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Copy utility for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SelectionList::Copy(const SelectionList &obj)
{
    AttributeGroupVector::const_iterator pos;

    autoApplyUpdates = obj.autoApplyUpdates;
    // *** Copy the selections field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = selections.begin(); pos != selections.end(); ++pos)
        delete *pos;
    selections.clear();
    if(obj.selections.size() > 0)
        selections.reserve(obj.selections.size());
    // Duplicate the selections from obj.
    for(pos = obj.selections.begin(); pos != obj.selections.end(); ++pos)
    {
        SelectionProperties *oldSelectionProperties = (SelectionProperties *)(*pos);
        SelectionProperties *newSelectionProperties = new SelectionProperties(*oldSelectionProperties);
        selections.push_back(newSelectionProperties);
    }

    // *** Copy the selectionSummary field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = selectionSummary.begin(); pos != selectionSummary.end(); ++pos)
        delete *pos;
    selectionSummary.clear();
    if(obj.selectionSummary.size() > 0)
        selectionSummary.reserve(obj.selectionSummary.size());
    // Duplicate the selectionSummary from obj.
    for(pos = obj.selectionSummary.begin(); pos != obj.selectionSummary.end(); ++pos)
    {
        SelectionSummary *oldSelectionSummary = (SelectionSummary *)(*pos);
        SelectionSummary *newSelectionSummary = new SelectionSummary(*oldSelectionSummary);
        selectionSummary.push_back(newSelectionSummary);
    }


    SelectionList::SelectAll();
}

// Type map format string
const char *SelectionList::TypeMapFormatString = SELECTIONLIST_TMFS;
const AttributeGroup::private_tmfs_t SelectionList::TmfsStruct = {SELECTIONLIST_TMFS};


// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Default constructor for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList::SelectionList() : 
    AttributeSubject(SelectionList::TypeMapFormatString)
{
    SelectionList::Init();
}

// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Constructor for the derived classes of SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList::SelectionList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SelectionList::Init();
}

// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Copy constructor for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList::SelectionList(const SelectionList &obj) : 
    AttributeSubject(SelectionList::TypeMapFormatString)
{
    SelectionList::Copy(obj);
}

// ****************************************************************************
// Method: SelectionList::SelectionList
//
// Purpose: 
//   Copy constructor for derived classes of the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList::SelectionList(const SelectionList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SelectionList::Copy(obj);
}

// ****************************************************************************
// Method: SelectionList::~SelectionList
//
// Purpose: 
//   Destructor for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList::~SelectionList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the selections field.
    for(pos = selections.begin(); pos != selections.end(); ++pos)
        delete *pos;
    // Destroy the selectionSummary field.
    for(pos = selectionSummary.begin(); pos != selectionSummary.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: SelectionList::operator = 
//
// Purpose: 
//   Assignment operator for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionList& 
SelectionList::operator = (const SelectionList &obj)
{
    if (this == &obj) return *this;

    SelectionList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SelectionList::operator == 
//
// Purpose: 
//   Comparison operator == for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionList::operator == (const SelectionList &obj) const
{
    bool selections_equal = (obj.selections.size() == selections.size());
    for(size_t i = 0; (i < selections.size()) && selections_equal; ++i)
    {
        // Make references to SelectionProperties from AttributeGroup *.
        const SelectionProperties &selections1 = *((const SelectionProperties *)(selections[i]));
        const SelectionProperties &selections2 = *((const SelectionProperties *)(obj.selections[i]));
        selections_equal = (selections1 == selections2);
    }

    bool selectionSummary_equal = (obj.selectionSummary.size() == selectionSummary.size());
    for(size_t i = 0; (i < selectionSummary.size()) && selectionSummary_equal; ++i)
    {
        // Make references to SelectionSummary from AttributeGroup *.
        const SelectionSummary &selectionSummary1 = *((const SelectionSummary *)(selectionSummary[i]));
        const SelectionSummary &selectionSummary2 = *((const SelectionSummary *)(obj.selectionSummary[i]));
        selectionSummary_equal = (selectionSummary1 == selectionSummary2);
    }

    // Create the return value
    return ((autoApplyUpdates == obj.autoApplyUpdates) &&
            selections_equal &&
            selectionSummary_equal);
}

// ****************************************************************************
// Method: SelectionList::operator != 
//
// Purpose: 
//   Comparison operator != for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionList::operator != (const SelectionList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SelectionList::TypeName
//
// Purpose: 
//   Type name method for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SelectionList::TypeName() const
{
    return "SelectionList";
}

// ****************************************************************************
// Method: SelectionList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SelectionList *tmp = (const SelectionList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SelectionList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SelectionList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SelectionList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SelectionList::NewInstance
//
// Purpose: 
//   NewInstance method for the SelectionList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SelectionList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SelectionList(*this);
    else
        retval = new SelectionList;

    return retval;
}

// ****************************************************************************
// Method: SelectionList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::SelectAll()
{
    Select(ID_autoApplyUpdates, (void *)&autoApplyUpdates);
    Select(ID_selections,       (void *)&selections);
    Select(ID_selectionSummary, (void *)&selectionSummary);
}

// ****************************************************************************
// Method: SelectionList::CreateSubAttributeGroup
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
SelectionList::CreateSubAttributeGroup(int attr_id)
{
    AttributeGroup *retval = 0;
    switch(attr_id)
    {
    case ID_selections:
        retval = new SelectionProperties;
        break;
    case ID_selectionSummary:
        retval = new SelectionSummary;
        break;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   Brad Whitlock
//   Do not save the selection summary list.
//
// ****************************************************************************

bool
SelectionList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SelectionList defaultObject;
    bool addToParent = false;
    // Create a node for SelectionList.
    DataNode *node = new DataNode("SelectionList");

    if(completeSave || !FieldsEqual(ID_autoApplyUpdates, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoApplyUpdates", autoApplyUpdates));
    }

    if(completeSave)
    {
        addToParent = true;
        for(size_t i = 0; i < selections.size(); ++i)
            selections[i]->CreateNode(node, completeSave, true);
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: SelectionList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   Brad Whitlock
//   Do not use the selection summary list.
//
// ****************************************************************************

void
SelectionList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SelectionList");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    if((node = searchNode->GetNode("autoApplyUpdates")) != 0)
        SetAutoApplyUpdates(node->AsBool());

    // Clear all the SelectionPropertiess if we got any.
    bool clearedSelections = false;
    // Go through all of the children and construct a new
    // SelectionProperties for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("SelectionProperties"))
            {
                if (!clearedSelections)
                {
                    ClearSelections();
                    clearedSelections = true;
                }
                SelectionProperties temp;
                temp.SetFromNode(children[i]);
                AddSelections(temp);
            }
        }
    }

    // Clear all the SelectionSummary list.
    ClearSelectionSummarys();
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionList::SetAutoApplyUpdates(bool autoApplyUpdates_)
{
    autoApplyUpdates = autoApplyUpdates_;
    Select(ID_autoApplyUpdates, (void *)&autoApplyUpdates);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
SelectionList::GetAutoApplyUpdates() const
{
    return autoApplyUpdates;
}

const AttributeGroupVector &
SelectionList::GetSelections() const
{
    return selections;
}

AttributeGroupVector &
SelectionList::GetSelections()
{
    return selections;
}

const AttributeGroupVector &
SelectionList::GetSelectionSummary() const
{
    return selectionSummary;
}

AttributeGroupVector &
SelectionList::GetSelectionSummary()
{
    return selectionSummary;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SelectionList::SelectSelections()
{
    Select(ID_selections, (void *)&selections);
}

void
SelectionList::SelectSelectionSummary()
{
    Select(ID_selectionSummary, (void *)&selectionSummary);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionList::AddSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::AddSelections(const SelectionProperties &obj)
{
    SelectionProperties *newSelectionProperties = new SelectionProperties(obj);
    selections.push_back(newSelectionProperties);

    // Indicate that things have changed by selecting it.
    Select(ID_selections, (void *)&selections);
}

// ****************************************************************************
// Method: SelectionList::ClearSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::ClearSelections()
{
    AttributeGroupVector::iterator pos;

    for(pos = selections.begin(); pos != selections.end(); ++pos)
        delete *pos;
    selections.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_selections, (void *)&selections);
}

// ****************************************************************************
// Method: SelectionList::RemoveSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::RemoveSelections(int index)
{
    AttributeGroupVector::iterator pos = selections.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != selections.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != selections.end())
    {
        delete *pos;
        selections.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_selections, (void *)&selections);
}

// ****************************************************************************
// Method: SelectionList::GetNumSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SelectionList::GetNumSelections() const
{
    return (int)selections.size();
}

// ****************************************************************************
// Method: SelectionList::GetSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionProperties &
SelectionList::GetSelections(int i)
{
    return *((SelectionProperties *)selections[i]);
}

// ****************************************************************************
// Method: SelectionList::GetSelections
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SelectionProperties &
SelectionList::GetSelections(int i) const
{
    return *((SelectionProperties *)selections[i]);
}

// ****************************************************************************
// Method: SelectionList::AddSelectionSummary
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::AddSelectionSummary(const SelectionSummary &obj)
{
    SelectionSummary *newSelectionSummary = new SelectionSummary(obj);
    selectionSummary.push_back(newSelectionSummary);

    // Indicate that things have changed by selecting it.
    Select(ID_selectionSummary, (void *)&selectionSummary);
}

// ****************************************************************************
// Method: SelectionList::ClearSelectionSummarys
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::ClearSelectionSummarys()
{
    AttributeGroupVector::iterator pos;

    for(pos = selectionSummary.begin(); pos != selectionSummary.end(); ++pos)
        delete *pos;
    selectionSummary.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_selectionSummary, (void *)&selectionSummary);
}

// ****************************************************************************
// Method: SelectionList::RemoveSelectionSummary
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SelectionList::RemoveSelectionSummary(int index)
{
    AttributeGroupVector::iterator pos = selectionSummary.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != selectionSummary.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != selectionSummary.end())
    {
        delete *pos;
        selectionSummary.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_selectionSummary, (void *)&selectionSummary);
}

// ****************************************************************************
// Method: SelectionList::GetNumSelectionSummarys
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
SelectionList::GetNumSelectionSummarys() const
{
    return (int)selectionSummary.size();
}

// ****************************************************************************
// Method: SelectionList::GetSelectionSummary
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SelectionSummary &
SelectionList::GetSelectionSummary(int i)
{
    return *((SelectionSummary *)selectionSummary[i]);
}

// ****************************************************************************
// Method: SelectionList::GetSelectionSummary
//
// Purpose: 
//   Contains a list of SelectionProperties objects.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const SelectionSummary &
SelectionList::GetSelectionSummary(int i) const
{
    return *((SelectionSummary *)selectionSummary[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SelectionList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SelectionList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_autoApplyUpdates: return "autoApplyUpdates";
    case ID_selections:       return "selections";
    case ID_selectionSummary: return "selectionSummary";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SelectionList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SelectionList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_autoApplyUpdates: return FieldType_bool;
    case ID_selections:       return FieldType_attVector;
    case ID_selectionSummary: return FieldType_attVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SelectionList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SelectionList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_autoApplyUpdates: return "bool";
    case ID_selections:       return "attVector";
    case ID_selectionSummary: return "attVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SelectionList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SelectionList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SelectionList &obj = *((const SelectionList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_autoApplyUpdates:
        {  // new scope
        retval = (autoApplyUpdates == obj.autoApplyUpdates);
        }
        break;
    case ID_selections:
        {  // new scope
        bool selections_equal = (obj.selections.size() == selections.size());
        for(size_t i = 0; (i < selections.size()) && selections_equal; ++i)
        {
            // Make references to SelectionProperties from AttributeGroup *.
            const SelectionProperties &selections1 = *((const SelectionProperties *)(selections[i]));
            const SelectionProperties &selections2 = *((const SelectionProperties *)(obj.selections[i]));
            selections_equal = (selections1 == selections2);
        }

        retval = selections_equal;
        }
        break;
    case ID_selectionSummary:
        {  // new scope
        bool selectionSummary_equal = (obj.selectionSummary.size() == selectionSummary.size());
        for(size_t i = 0; (i < selectionSummary.size()) && selectionSummary_equal; ++i)
        {
            // Make references to SelectionSummary from AttributeGroup *.
            const SelectionSummary &selectionSummary1 = *((const SelectionSummary *)(selectionSummary[i]));
            const SelectionSummary &selectionSummary2 = *((const SelectionSummary *)(obj.selectionSummary[i]));
            selectionSummary_equal = (selectionSummary1 == selectionSummary2);
        }

        retval = selectionSummary_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

int
SelectionList::GetSelection(const std::string &name) const
{
    int retval = -1;
    for(int i = 0; i < GetNumSelections(); ++i)
    {
        if(GetSelections(i).GetName() == name)
        {
            retval = i;
            break;
        }
    }
    return retval;
}

int
SelectionList::GetSelectionSummary(const std::string &name) const
{
    int retval = -1;
    for(int i = 0; i < GetNumSelectionSummarys(); ++i)
    {
        if(GetSelectionSummary(i).GetName() == name)
        {
            retval = i;
            break;
        }
    }
    return retval;
}

