# MEVA-Data-Repo DIVA Phase 2 annotations

These are annotations of the released MEVA video data.

## Activity Names

In February 2020, the DIVA project rationalized the activity names (the definitions have **not** changed). The new activity names can be found [here](../../../documents/activity-names.txt); a file mapping from old activity names to new can be found [here](../../../documents/activity-name-mapping.csv).

## Naming conventions for MEVA video clips and annotations

Each video clip (nominally five minutes in length) is named according to the pattern

> date.start-time.end-time.site.camera

...for example, the file **2018-03-07.17-35-06.17-40-06.school.G339.types.yml** contains the KPF object type information for the clip **2018-03-07.17-35-06.17-40-06.school.G339**, which has the following components:

* date: **2018-03-07**
* start-time: **17-35-06** *(local time)*
* end-time: **17-40-06**
* site: **school** *(This is the where the camera was located, NOT necessarily what the camera is looking at)*
* camera: **G339**

## How to contribute annotations

We welcome your contributions, either as corrections to existing annotations or as additional annotations.

**PLEASE NOTE** that any corrections or new annotations will be subject to the same [license](../../../LICENSE) as this overall annotation repository.

### Submitting a correction

1. File an issue on the gitlab repository issue board. Please be as precise as possible, identifying the specific file(s) and ID(s) affected.

2. Set the assignee to @collinsr.

### Submitting new annotations

1. Fork this repo to your gitlab account.

2. Create a new branch from master for your annotations.

2. Create a new subdirectory in [contrib](contrib) to hold your annotaitons.

3. Copy the [contribution template](contrib-template.md) to use as your readme; please fill out all the fields.

4. Add your annotations to the subdirectory. Please use the KPF (preferred) or NIST json formats if possible; if not, please include documentation describing your annotation schema.

5. git add your files, and push the branch.

6. File a merge request for your branch; set the assignee to @collinsr.

## Available annotations

This directory contains:

* [kitware](kitware) - Annotations generated by Kitware using the same process used to annotate the sequestered data used in the ActEV evaluation. This data is **evaluation**-level; all instances of the 37 ActEV activities should be annotated.

* [nist](nist) - Annotations generated by NIST based on the Kitware annotations; these are in the json format used by the ActEV scoring software.

* [contrib](contrib) - These are annotations contributed by third parties; each directory has an instance of the [contribution template](contrib/template.md) filled out as its readme.

