/*=========================================================================

  Module:    vtkKWMenuButton.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __vtkKWMenuButton_h
#define __vtkKWMenuButton_h

#include "vtkKWCoreWidget.h"

class vtkKWMenu;

class KWWIDGETS_EXPORT vtkKWMenuButton : public vtkKWCoreWidget
{
public:
  static vtkKWMenuButton* New();
  vtkTypeRevisionMacro(vtkKWMenuButton, vtkKWCoreWidget);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Create the widget.
  virtual void Create(vtkKWApplication *app);

  // Description:
  // Set/Get the current entry of this option menu.
  // This can be an image name if any entry in the menu uses an image
  // instead of a label.
  virtual const char *GetValue();
  virtual void SetValue(const char *name);

  // Description:
  // Add text to the button
  void SetButtonText(const char *text);
  const char* GetButtonText();
  
  // Description: 
  // Append a standard menu item and command to the current menu.
  void AddCommand(const char* label, vtkKWObject* Object,
                  const char* MethodAndArgString , const char* help = 0);
  
  // Description: 
  // Access to the menu
  vtkKWMenu* GetMenu();
  
  // Description
  // Set the indicator On/Off. To be called after creation.
  void IndicatorOn();
  void IndicatorOff();

  // Description:
  // Update the "enable" state of the object and its internal parts.
  // Depending on different Ivars (this->Enabled, the application's 
  // Limited Edition Mode, etc.), the "enable" state of the object is updated
  // and propagated to its internal parts/subwidgets. This will, for example,
  // enable/disable parts of the widget UI, enable/disable the visibility
  // of 3D widgets, etc.
  virtual void UpdateEnableState();

  // Description:
  // Convenience method to set the button width (in chars if text, 
  // in pixels if image).
  void SetWidth(int width);

protected:
  vtkKWMenuButton();
  ~vtkKWMenuButton();
  

  vtkGetStringMacro(CurrentValue);
  vtkSetStringMacro(CurrentValue);

  char      *CurrentValue;  
  vtkKWMenu *Menu;

private:
  vtkKWMenuButton(const vtkKWMenuButton&); // Not implemented
  void operator=(const vtkKWMenuButton&); // Not implemented
};

#endif

