/*=========================================================================

Copyright (c) 1998-2003 Kitware Inc. 469 Clifton Corporate Parkway,
Clifton Park, NY, 12065, USA.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither the name of Kitware nor the names of any contributors may be used
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
# Copyright (c) 1998-2003, Bryan Oakley
# All Rights Reservered
#
# Bryan Oakley
# oakley@bardo.clearlight.com
#
# combobox v2.3 August 16, 2003
#
# a combobox / dropdown listbox (pick your favorite name) widget 
# written in pure tcl
#
# this code is freely distributable without restriction, but is 
# provided as-is with no warranty expressed or implied. 
#
# thanks to the following people who provided beta test support or
# patches to the code (in no particular order):
#
# Scott Beasley     Alexandre Ferrieux      Todd Helfter
# Matt Gushee       Laurent Duperval        John Jackson
# Fred Rapp         Christopher Nelson
# Eric Galluzzo     Jean-Francois Moine      Oliver Bienert
#
# A special thanks to Martin M. Hunt who provided several good ideas, 
# and always with a patch to implement them. Jean-Francois Moine, 
# Todd Helfter and John Jackson were also kind enough to send in some 
# code patches.
#
# ... and many others over the years.

package require Tk 8.0
package provide combobox 2.3
*/

const char* vtkcomboboxwidget1 =
"namespace eval ::combobox {\n"
"\n"
"    # this is the public interface\n"
"    namespace export combobox\n"
"\n"
"    # these contain references to available options\n"
"    variable widgetOptions\n"
"\n"
"    # these contain references to available commands and subcommands\n"
"    variable widgetCommands\n"
"    variable scanCommands\n"
"    variable listCommands\n"
"}\n"
"\n"
"# ::combobox::combobox --\n"
"#\n"
"#     This is the command that gets exported. It creates a new\n"
"#     combobox widget.\n"
"#\n"
"# Arguments:\n"
"#\n"
"#     w        path of new widget to create\n"
"#     args     additional option/value pairs (eg: -background white, etc.)\n"
"#\n"
"# Results:\n"
"#\n"
"#     It creates the widget and sets up all of the default bindings\n"
"#\n"
"# Returns:\n"
"#\n"
"#     The name of the newly create widget\n"
"\n"
"proc ::combobox::combobox {w args} {\n"
"    variable widgetOptions\n"
"    variable widgetCommands\n"
"    variable scanCommands\n"
"    variable listCommands\n"
"\n"
"    # perform a one time initialization\n"
"    if {![info exists widgetOptions]} {\n"
"  Init\n"
"    }\n"
"\n"
"    # build it...\n"
"    eval Build $w $args\n"
"\n"
"    # set some bindings...\n"
"    SetBindings $w\n"
"\n"
"    # and we are done!\n"
"    return $w\n"
"}\n"
"\n"
"\n"
"# ::combobox::Init --\n"
"#\n"
"#     Initialize the namespace variables. This should only be called\n"
"#     once, immediately prior to creating the first instance of the\n"
"#     widget\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    none\n"
"#\n"
"# Results:\n"
"#\n"
"#     All state variables are set to their default values; all of \n"
"#     the option database entries will exist.\n"
"#\n"
"# Returns:\n"
"# \n"
"#     empty string\n"
"\n"
"proc ::combobox::Init {} {\n"
"    variable widgetOptions\n"
"    variable widgetCommands\n"
"    variable scanCommands\n"
"    variable listCommands\n"
"    variable defaultEntryCursor\n"
"\n"
"    array set widgetOptions [list "
"      -background          {background          Background} "
"      -bd                  -borderwidth "
"      -bg                  -background "
"      -borderwidth         {borderWidth         BorderWidth} "
"      -buttonbackground    {buttonBackground    Background} "
"      -command             {command             Command} "
"      -commandstate        {commandState        State} "
"      -cursor              {cursor              Cursor} "
"      -disabledbackground  {disabledBackground  DisabledBackground} "
"      -disabledforeground  {disabledForeground  DisabledForeground} "
"            -dropdownwidth       {dropdownWidth       DropdownWidth} "
"      -editable            {editable            Editable} "
"      -elementborderwidth  {elementBorderWidth  BorderWidth} "
"      -fg                  -foreground "
"      -font                {font                Font} "
"      -foreground          {foreground          Foreground} "
"      -height              {height              Height} "
"      -highlightbackground {highlightBackground HighlightBackground} "
"      -highlightcolor      {highlightColor      HighlightColor} "
"      -highlightthickness  {highlightThickness  HighlightThickness} "
"      -image               {image               Image} "
"      -listvar             {listVariable        Variable} "
"      -maxheight           {maxHeight           Height} "
"      -opencommand         {opencommand         Command} "
"      -relief              {relief              Relief} "
"      -selectbackground    {selectBackground    Foreground} "
"      -selectborderwidth   {selectBorderWidth   BorderWidth} "
"      -selectforeground    {selectForeground    Background} "
"      -state               {state               State} "
"      -takefocus           {takeFocus           TakeFocus} "
"      -textvariable        {textVariable        Variable} "
"      -value               {value               Value} "
"      -width               {width               Width} "
"      -xscrollcommand      {xScrollCommand      ScrollCommand} "
"    ]\n"
"\n"
"\n"
"    set widgetCommands [list "
"      bbox      cget     configure    curselection "
"      delete    get      icursor      index        "
"      insert    list     scan         selection    "
"      xview     select   toggle       open         "
"            close    subwidget  "
"    ]\n"
"\n"
"    set listCommands [list "
"      delete       get      "
"            index        insert       size "
"    ]\n"
"\n"
"    set scanCommands [list mark dragto]\n"
"\n"
"    # why check for the Tk package? This lets us be sourced into \n"
"    # an interpreter that doesn't have Tk loaded, such as the slave\n"
"    # interpreter used by pkg_mkIndex. In theory it should have no\n"
"    # side effects when run \n"
"    if {[lsearch -exact [package names] \"Tk\"] != -1} {\n"
"\n"
"  ##################################################################\n"
"  #- this initializes the option database. Kinda gross, but it works\n"
"  #- (I think). \n"
"  ##################################################################\n"
"\n"
"  # the image used for the button...\n"
"  if {$::tcl_platform(platform) == \"windows\"} {\n"
"      image create bitmap ::combobox::bimage -data {\n"
"    #define down_arrow_width 12\n"
"    #define down_arrow_height 12\n"
"    static char down_arrow_bits[] = {\n"
"        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\n"
"        0xfc,0xf1,0xf8,0xf0,0x70,0xf0,0x20,0xf0,\n"
"        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00;\n"
"    }\n"
"      }\n"
"  } else {\n"
"      image create bitmap ::combobox::bimage -data  {\n"
"    #define down_arrow_width 15\n"
"    #define down_arrow_height 15\n"
"    static char down_arrow_bits[] = {\n"
"        0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,\n"
"        0x00,0x80,0xf8,0x8f,0xf0,0x87,0xe0,0x83,\n"
"        0xc0,0x81,0x80,0x80,0x00,0x80,0x00,0x80,\n"
"        0x00,0x80,0x00,0x80,0x00,0x80\n"
"    }\n"
"      }\n"
"  }\n"
"\n"
"  # compute a widget name we can use to create a temporary widget\n"
"  set tmpWidget \".__tmp__\"\n"
"  set count 0\n"
"  while {[winfo exists $tmpWidget] == 1} {\n"
"      set tmpWidget \".__tmp__$count\"\n"
"      incr count\n"
"  }\n"
"\n"
"  # get the scrollbar width. Because we try to be clever and draw our\n"
"  # own button instead of using a tk widget, we need to know what size\n"
"  # button to create. This little hack tells us the width of a scroll\n"
"  # bar.\n"
"  #\n"
"  # NB: we need to be sure and pick a window  that doesn't already\n"
"  # exist... \n"
"  scrollbar $tmpWidget\n"
"  set sb_width [winfo reqwidth $tmpWidget]\n"
"  set bbg [$tmpWidget cget -background]\n"
"  destroy $tmpWidget\n"
"\n"
"  # steal options from the entry widget\n"
"  # we want darn near all options, so we'll go ahead and do\n"
"  # them all. No harm done in adding the one or two that we\n"
"  # don't use.\n"
"  entry $tmpWidget \n"
"  foreach foo [$tmpWidget configure] {\n"
"      # the cursor option is special, so we'll save it in\n"
"      # a special way\n"
"      if {[lindex $foo 0] == \"-cursor\"} {\n"
"    set defaultEntryCursor [lindex $foo 4]\n"
"      }\n"
"      if {[llength $foo] == 5} {\n"
"    set option [lindex $foo 1]\n"
"    set value [lindex $foo 4]\n"
"    option add *Combobox.$option $value widgetDefault\n"
"\n"
"    # these options also apply to the dropdown listbox\n"
"    if {[string compare $option \"foreground\"] == 0 "
"      || [string compare $option \"background\"] == 0 "
"      || [string compare $option \"font\"] == 0} {\n"
"        option add *Combobox*ComboboxListbox.$option $value "
"          widgetDefault\n"
"    }\n"
"      }\n"
"  }\n"
"  destroy $tmpWidget\n"
"\n"
"  # these are unique to us...\n"
"  option add *Combobox.elementBorderWidth  1  widgetDefault\n"
"  option add *Combobox.buttonBackground    $bbg  widgetDefault\n"
"  option add *Combobox.dropdownWidth       {}     widgetDefault\n"
"  option add *Combobox.openCommand         {}     widgetDefault\n"
"  option add *Combobox.cursor              {}     widgetDefault\n"
"  option add *Combobox.commandState        normal widgetDefault\n"
"  option add *Combobox.editable            1      widgetDefault\n"
"  option add *Combobox.maxHeight           10     widgetDefault\n"
"  option add *Combobox.height              0\n"
"    }\n"
"\n"
"    # set class bindings\n"
"    SetClassBindings\n"
"}\n"
"\n"
"# ::combobox::SetClassBindings --\n"
"#\n"
"#    Sets up the default bindings for the widget class\n"
"#\n"
"#    this proc exists since it's The Right Thing To Do, but\n"
"#    I haven't had the time to figure out how to do all the\n"
"#    binding stuff on a class level. The main problem is that\n"
"#    the entry widget must have focus for the insertion cursor\n"
"#    to be visible. So, I either have to have the entry widget\n"
"#    have the Combobox bindtag, or do some fancy juggling of\n"
"#    events or some such. What a pain.\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    none\n"
"#\n"
"# Returns:\n"
"#\n"
"#    empty string\n"
"\n"
"proc ::combobox::SetClassBindings {} {\n"
"\n"
"    # make sure we clean up after ourselves...\n"
"    bind Combobox <Destroy> [list ::combobox::DestroyHandler %W]\n"
"\n"
"    # this will (hopefully) close (and lose the grab on) the\n"
"    # listbox if the user clicks anywhere outside of it. Note\n"
"    # that on Windows, you can click on some other app and\n"
"    # the listbox will still be there, because tcl won't see\n"
"    # that button click\n"
"    set this {[::combobox::convert %W -W]}\n"
"    bind Combobox <Any-ButtonPress>   \"$this close\"\n"
"    bind Combobox <Any-ButtonRelease> \"$this close\"\n"
"\n"
"    # this helps (but doesn't fully solve) focus issues. The general\n"
"    # idea is, whenever the frame gets focus it gets passed on to\n"
"    # the entry widget\n"
"    bind Combobox <FocusIn> {::combobox::tkTabToWindow "
"         [::combobox::convert %W -W].entry}\n"
"\n"
"    # this closes the listbox if we get hidden\n"
"    bind Combobox <Unmap> {[::combobox::convert %W -W] close}\n"
"\n"
"    return \"\"\n"
"}\n"
"\n"
"# ::combobox::SetBindings --\n"
"#\n"
"#    here's where we do most of the binding foo. I think there's probably\n"
"#    a few bindings I ought to add that I just haven't thought\n"
"#    about...\n"
"#\n"
"#    I'm not convinced these are the proper bindings. Ideally all\n"
"#    bindings should be on \"Combobox\", but because of my juggling of\n"
"#    bindtags I'm not convinced thats what I want to do. But, it all\n"
"#    seems to work, its just not as robust as it could be.\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w    widget pathname\n"
"#\n"
"# Returns:\n"
"#\n"
"#    empty string\n"
"\n"
"proc ::combobox::SetBindings {w} {\n"
"    upvar ::combobox::${w}::widgets  widgets\n"
"    upvar ::combobox::${w}::options  options\n"
"\n"
"    # juggle the bindtags. The basic idea here is to associate the\n"
"    # widget name with the entry widget, so if a user does a bind\n"
"    # on the combobox it will get handled properly since it is\n"
"    # the entry widget that has keyboard focus.\n"
"    bindtags $widgets(entry) "
"      [concat $widgets(this) [bindtags $widgets(entry)]]\n"
"\n"
"    bindtags $widgets(button) "
"      [concat $widgets(this) [bindtags $widgets(button)]]\n"
"\n"
"    # override the default bindings for tab and shift-tab. The\n"
"    # focus procs take a widget as their only parameter and we\n"
"    # want to make sure the right window gets used (for shift-\n"
"    # tab we want it to appear as if the event was generated\n"
"    # on the frame rather than the entry. \n"
"    bind $widgets(entry) <Tab> "
"      \"::combobox::tkTabToWindow \\[tk_focusNext $widgets(entry)\\]; break\"\n"
"    bind $widgets(entry) <Shift-Tab> "
"      \"::combobox::tkTabToWindow \\[tk_focusPrev $widgets(this)\\]; break\"\n"
"    \n"
"    # this makes our \"button\" (which is actually a label)\n"
"    # do the right thing\n"
"    bind $widgets(button) <ButtonPress-1> [list $widgets(this) toggle]\n"
"\n"
"    # this lets the autoscan of the listbox work, even if they\n"
"    # move the cursor over the entry widget.\n"
"    bind $widgets(entry) <B1-Enter> \"break\"\n"
"\n"
"    bind $widgets(listbox) <ButtonRelease-1> "
"        \"::combobox::Select [list $widgets(this)] "
"         \\[$widgets(listbox) nearest %y\\]; break\"\n"
"\n"
"    bind $widgets(vsb) <ButtonPress-1>   {continue}\n"
"    bind $widgets(vsb) <ButtonRelease-1> {continue}\n"
"\n"
"    bind $widgets(listbox) <Any-Motion> {\n"
"  %W selection clear 0 end\n"
"  %W activate @%x,%y\n"
"  %W selection anchor @%x,%y\n"
"  %W selection set @%x,%y @%x,%y\n"
"  # need to do a yview if the cursor goes off the top\n"
"  # or bottom of the window... (or do we?)\n"
"    }\n"
"\n"
"    # these events need to be passed from the entry widget\n"
"    # to the listbox, or otherwise need some sort of special\n"
"    # handling. \n"
"    foreach event [list <Up> <Down> <Tab> <Return> <Escape> "
"      <Next> <Prior> <Double-1> <1> <Any-KeyPress> "
"      <FocusIn> <FocusOut>] {\n"
"  bind $widgets(entry) $event "
"            [list ::combobox::HandleEvent $widgets(this) $event]\n"
"    }\n"
"\n"
"    # like the other events, <MouseWheel> needs to be passed from\n"
"    # the entry widget to the listbox. However, in this case we\n"
"    # need to add an additional parameter\n"
"    catch {\n"
"  bind $widgets(entry) <MouseWheel> "
"      [list ::combobox::HandleEvent $widgets(this) <MouseWheel> %D]\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::Build --\n"
"#\n"
"#    This does all of the work necessary to create the basic\n"
"#    combobox. \n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w        widget name\n"
"#    args     additional option/value pairs\n"
"#\n"
"# Results:\n"
"#\n"
"#    Creates a new widget with the given name. Also creates a new\n"
"#    namespace patterened after the widget name, as a child namespace\n"
"#    to ::combobox\n"
"#\n"
"# Returns:\n"
"#\n"
"#    the name of the widget\n"
"\n"
"proc ::combobox::Build {w args } {\n"
"    variable widgetOptions\n"
"\n"
"    if {[winfo exists $w]} {\n"
"  error \"window name \\\"$w\\\" already exists\"\n"
"    }\n"
"\n"
"    # create the namespace for this instance, and define a few\n"
"    # variables\n"
"    namespace eval ::combobox::$w {\n"
"\n"
"  variable ignoreTrace 0\n"
"  variable oldFocus    {}\n"
"  variable oldGrab     {}\n"
"  variable oldValue    {}\n"
"  variable options\n"
"  variable this\n"
"  variable widgets\n"
"\n"
"  set widgets(foo) foo  ;# coerce into an array\n"
"  set options(foo) foo  ;# coerce into an array\n"
"\n"
"  unset widgets(foo)\n"
"  unset options(foo)\n"
"    }\n"
"\n"
"    # import the widgets and options arrays into this proc so\n"
"    # we don't have to use fully qualified names, which is a\n"
"    # pain.\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    # this is our widget -- a frame of class Combobox. Naturally,\n"
"    # it will contain other widgets. We create it here because\n"
"    # we need it in order to set some default options.\n"
"    set widgets(this)   [frame  $w -class Combobox -takefocus 0]\n"
"    set widgets(entry)  [entry  $w.entry -takefocus 1]\n"
"    set widgets(button) [label  $w.button -takefocus 0] \n"
"\n"
"    # this defines all of the default options. We get the\n"
"    # values from the option database. Note that if an array\n"
"    # value is a list of length one it is an alias to another\n"
"    # option, so we just ignore it\n"
"    foreach name [array names widgetOptions] {\n"
"  if {[llength $widgetOptions($name)] == 1} continue\n"
"\n"
"  set optName  [lindex $widgetOptions($name) 0]\n"
"  set optClass [lindex $widgetOptions($name) 1]\n"
"\n"
"  set value [option get $w $optName $optClass]\n"
"  set options($name) $value\n"
"    }\n"
"\n"
"    # a couple options aren't available in earlier versions of\n"
"    # tcl, so we'll set them to sane values. For that matter, if\n"
"    # they exist but are empty, set them to sane values.\n"
"    if {[string length $options(-disabledforeground)] == 0} {\n"
"        set options(-disabledforeground) $options(-foreground)\n"
"    }\n"
"    if {[string length $options(-disabledbackground)] == 0} {\n"
"        set options(-disabledbackground) $options(-background)\n"
"    }\n"
"\n"
"    # if -value is set to null, we'll remove it from our\n"
"    # local array. The assumption is, if the user sets it from\n"
"    # the option database, they will set it to something other\n"
"    # than null (since it's impossible to determine the difference\n"
"    # between a null value and no value at all).\n"
"    if {[info exists options(-value)] "
"      && [string length $options(-value)] == 0} {\n"
"  unset options(-value)\n"
"    }\n"
"\n"
"    # we will later rename the frame's widget proc to be our\n"
"    # own custom widget proc. We need to keep track of this\n"
"    # new name, so we'll define and store it here...\n"
"    set widgets(frame) ::combobox::${w}::$w\n"
"\n"
"    # gotta do this sooner or later. Might as well do it now\n"
"    pack $widgets(button) -side right -fill y    -expand no\n"
"    pack $widgets(entry)  -side left  -fill both -expand yes\n"
"\n"
"    # I should probably do this in a catch, but for now it's\n"
"    # good enough... What it does, obviously, is put all of\n"
"    # the option/values pairs into an array. Make them easier\n"
"    # to handle later on...\n"
"    array set options $args\n"
"\n"
"    # now, the dropdown list... the same renaming nonsense\n"
"    # must go on here as well...\n"
"    set widgets(dropdown)   [toplevel  $w.top]\n"
"    set widgets(listbox) [listbox   $w.top.list]\n"
"    set widgets(vsb)     [scrollbar $w.top.vsb]\n"
"\n"
"    pack $widgets(listbox) -side left -fill both -expand y\n"
"\n"
"    # fine tune the widgets based on the options (and a few\n"
"    # arbitrary values...)\n"
"\n"
"    # NB: we are going to use the frame to handle the relief\n"
"    # of the widget as a whole, so the entry widget will be \n"
"    # flat. This makes the button which drops down the list\n"
"    # to appear \"inside\" the entry widget.\n"
"\n"
"    $widgets(vsb) configure "
"      -borderwidth 1 "
"      -command \"$widgets(listbox) yview\" "
"      -highlightthickness 0\n"
"\n"
"    $widgets(button) configure "
"      -background $options(-buttonbackground) "
"      -highlightthickness 0 "
"      -borderwidth $options(-elementborderwidth) "
"      -relief raised "
"      -width [expr {[winfo reqwidth $widgets(vsb)] - 2}]\n"
"\n"
"    $widgets(entry) configure "
"      -borderwidth 0 "
"      -relief flat "
"      -highlightthickness 0 \n"
"\n"
"    $widgets(dropdown) configure "
"      -borderwidth $options(-elementborderwidth) "
"      -relief sunken\n"
"\n"
"    $widgets(listbox) configure "
"      -selectmode browse "
"      -background [$widgets(entry) cget -bg] "
"      -yscrollcommand \"$widgets(vsb) set\" "
"      -exportselection false "
"      -borderwidth 0\n"
"\n"
"\n"
"#    trace variable ::combobox::${w}::entryTextVariable w "
"#      [list ::combobox::EntryTrace $w]\n"
"  \n"
"    # do some window management foo on the dropdown window\n"
"    wm overrideredirect $widgets(dropdown) 1\n"
"    wm transient        $widgets(dropdown) [winfo toplevel $w]\n"
"    wm group            $widgets(dropdown) [winfo parent $w]\n"
"    wm resizable        $widgets(dropdown) 0 0\n"
"    wm withdraw         $widgets(dropdown)\n"
"    \n"
"    # this moves the original frame widget proc into our\n"
"    # namespace and gives it a handy name\n"
"    rename ::$w $widgets(frame)\n"
"\n"
"    # now, create our widget proc. Obviously (?) it goes in\n"
"    # the global namespace. All combobox widgets will actually\n"
"    # share the same widget proc to cut down on the amount of\n"
"    # bloat. \n"
"    proc ::$w {command args} "
"        \"eval ::combobox::WidgetProc $w \\$command \\$args\"\n"
"\n"
"\n"
"    # ok, the thing exists... let's do a bit more configuration. \n"
"    if {[catch \"::combobox::Configure [list $widgets(this)] [array get options]\" error]} {\n"
"  catch {destroy $w}\n"
"  error \"internal error: $error\"\n"
"    }\n"
"\n"
"    return \"\"\n"
"\n"
"}\n"
"\n"
"# ::combobox::HandleEvent --\n"
"#\n"
"#    this proc handles events from the entry widget that we want\n"
"#    handled specially (typically, to allow navigation of the list\n"
"#    even though the focus is in the entry widget)\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w       widget pathname\n"
"#    event   a string representing the event (not necessarily an\n"
"#            actual event)\n"
"#    args    additional arguments required by particular events\n"
"\n"
"proc ::combobox::HandleEvent {w event args} {\n"
"    upvar ::combobox::${w}::widgets  widgets\n"
"    upvar ::combobox::${w}::options  options\n"
"    upvar ::combobox::${w}::oldValue oldValue\n"
"\n"
"    # for all of these events, if we have a special action we'll\n"
"    # do that and do a \"return -code break\" to keep additional \n"
"    # bindings from firing. Otherwise we'll let the event fall\n"
"    # on through. \n"
"    switch $event {\n"
"\n"
"        \"<MouseWheel>\" {\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"                set D [lindex $args 0]\n"
"                # the '120' number in the following expression has\n"
"                # it's genesis in the tk bind manpage, which suggests\n"
"                # that the smallest value of %D for mousewheel events\n"
"                # will be 120. The intent is to scroll one line at a time.\n"
"                $widgets(listbox) yview scroll [expr {-($D/120)}] units\n"
"            }\n"
"        } \n"
"\n"
"  \"<Any-KeyPress>\" {\n"
"      # if the widget is editable, clear the selection. \n"
"      # this makes it more obvious what will happen if the \n"
"      # user presses <Return> (and helps our code know what\n"
"      # to do if the user presses return)\n"
"      if {$options(-editable)} {\n"
"    $widgets(listbox) see 0\n"
"    $widgets(listbox) selection clear 0 end\n"
"    $widgets(listbox) selection anchor 0\n"
"    $widgets(listbox) activate 0\n"
"      }\n"
"  }\n"
"\n"
"  \"<FocusIn>\" {\n"
"      set oldValue [$widgets(entry) get]\n"
"  }\n"
"\n"
"  \"<FocusOut>\" {\n"
"      if {![winfo ismapped $widgets(dropdown)]} {\n"
"    # did the value change?\n"
"    set newValue [$widgets(entry) get]\n"
"    if {$oldValue != $newValue} {\n"
"        CallCommand $widgets(this) $newValue\n"
"    }\n"
"      }\n"
"  }\n"
"\n"
"  \"<1>\" {\n"
"      set editable [::combobox::GetBoolean $options(-editable)]\n"
"      if {!$editable} {\n"
"    if {[winfo ismapped $widgets(dropdown)]} {\n"
"        $widgets(this) close\n"
"        return -code break;\n"
"\n"
"    } else {\n"
"        if {$options(-state) != \"disabled\"} {\n"
"      $widgets(this) open\n"
"      return -code break;\n"
"        }\n"
"    }\n"
"      }\n"
"  }\n"
"\n"
"  \"<Double-1>\" {\n"
"      if {$options(-state) != \"disabled\"} {\n"
"    $widgets(this) toggle\n"
"    return -code break;\n"
"      }\n"
"  }\n"
"\n"
"  \"<Tab>\" {\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    ::combobox::Find $widgets(this) 0\n"
"    return -code break;\n"
"      } else {\n"
"    ::combobox::SetValue $widgets(this) [$widgets(this) get]\n"
"      }\n"
"  }\n"
"\n"
"  \"<Escape>\" {\n"
"#      $widgets(entry) delete 0 end\n"
"#      $widgets(entry) insert 0 $oldValue\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    $widgets(this) close\n"
"    return -code break;\n"
"      }\n"
"  }\n"
"\n"
"  \"<Return>\" {\n"
"      # did the value change?\n"
"      set newValue [$widgets(entry) get]\n"
"      if {$oldValue != $newValue} {\n"
"    CallCommand $widgets(this) $newValue\n"
"      }\n"
"\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    ::combobox::Select $widgets(this) "
"      [$widgets(listbox) curselection]\n"
"    return -code break;\n"
"      } \n"
"\n"
"  }\n"
"\n"
"  \"<Next>\" {\n"
"      $widgets(listbox) yview scroll 1 pages\n"
"      set index [$widgets(listbox) index @0,0]\n"
"      $widgets(listbox) see $index\n"
"      $widgets(listbox) activate $index\n"
"      $widgets(listbox) selection clear 0 end\n"
"      $widgets(listbox) selection anchor $index\n"
"      $widgets(listbox) selection set $index\n"
"\n"
"  }\n"
"\n"
"  \"<Prior>\" {\n"
"      $widgets(listbox) yview scroll -1 pages\n"
"      set index [$widgets(listbox) index @0,0]\n"
"      $widgets(listbox) activate $index\n"
"      $widgets(listbox) see $index\n"
"      $widgets(listbox) selection clear 0 end\n"
"      $widgets(listbox) selection anchor $index\n"
"      $widgets(listbox) selection set $index\n"
"  }\n"
"\n"
"  \"<Down>\" {\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    ::combobox::tkListboxUpDown $widgets(listbox) 1\n"
"    return -code break;\n"
"\n"
"      } else {\n"
"    if {$options(-state) != \"disabled\"} {\n"
"        $widgets(this) open\n"
"        return -code break;\n"
"    }\n"
"      }\n"
"  }\n"
"  \"<Up>\" {\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    ::combobox::tkListboxUpDown $widgets(listbox) -1\n"
"    return -code break;\n"
"\n"
"      } else {\n"
"    if {$options(-state) != \"disabled\"} {\n"
"        $widgets(this) open\n"
"        return -code break;\n"
"    }\n"
"      }\n"
"  }\n"
"    }\n"
"\n"
"    return \"\"\n"
"}\n"
"\n"
"# ::combobox::DestroyHandler {w} --\n"
"# \n"
"#    Cleans up after a combobox widget is destroyed\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w    widget pathname\n"
"#\n"
"# Results:\n"
"#\n"
"#    The namespace that was created for the widget is deleted,\n"
"#    and the widget proc is removed.\n"
"\n"
"proc ::combobox::DestroyHandler {w} {\n"
"\n"
"    catch {\n"
"  # if the widget actually being destroyed is of class Combobox,\n"
"  # remove the namespace and associated proc.\n"
"  if {[string compare [winfo class $w] \"Combobox\"] == 0} {\n"
"      # delete the namespace and the proc which represents\n"
"      # our widget\n"
"      namespace delete ::combobox::$w\n"
"      rename $w {}\n"
"  }   \n"
"    }\n"
"    return \"\"\n"
"}\n"
"\n"
"# ::combobox::Find\n"
"#\n"
"#    finds something in the listbox that matches the pattern in the\n"
"#    entry widget and selects it\n"
"#\n"
"#    N.B. I'm not convinced this is working the way it ought to. It\n"
"#    works, but is the behavior what is expected? I've also got a gut\n"
"#    feeling that there's a better way to do this, but I'm too lazy to\n"
"#    figure it out...\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w      widget pathname\n"
"#    exact  boolean; if true an exact match is desired\n"
"#\n"
"# Returns:\n"
"#\n"
"#    Empty string\n"
"\n"
"proc ::combobox::Find {w {exact 0}} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    ## *sigh* this logic is rather gross and convoluted. Surely\n"
"    ## there is a more simple, straight-forward way to implement\n"
"    ## all this. As the saying goes, I lack the time to make it\n"
"    ## shorter...\n"
"\n"
"    # use what is already in the entry widget as a pattern\n"
"    set pattern [$widgets(entry) get]\n"
"\n"
"    if {[string length $pattern] == 0} {\n"
"  # clear the current selection\n"
"  $widgets(listbox) see 0\n"
"  $widgets(listbox) selection clear 0 end\n"
"  $widgets(listbox) selection anchor 0\n"
"  $widgets(listbox) activate 0\n"
"  return\n"
"    }\n"
"\n"
"    # we're going to be searching this list...\n"
"    set list [$widgets(listbox) get 0 end]\n"
"\n"
"    # if we are doing an exact match, try to find,\n"
"    # well, an exact match\n"
"    set exactMatch -1\n"
"    if {$exact} {\n"
"  set exactMatch [lsearch -exact $list $pattern]\n"
"    }\n"
"\n"
"    # search for it. We'll try to be clever and not only\n"
"    # search for a match for what they typed, but a match for\n"
"    # something close to what they typed. We'll keep removing one\n"
"    # character at a time from the pattern until we find a match\n"
"    # of some sort.\n"
"    set index -1\n"
"    while {$index == -1 && [string length $pattern]} {\n"
"  set index [lsearch -glob $list \"$pattern*\"]\n"
"  if {$index == -1} {\n"
"      regsub {.$} $pattern {} pattern\n"
"  }\n"
"    }\n"
"\n"
"    # this is the item that most closely matches...\n"
"    set thisItem [lindex $list $index]\n"
"\n"
"    # did we find a match? If so, do some additional munging...\n"
"    if {$index != -1} {\n"
"\n"
"  # we need to find the part of the first item that is \n"
"  # unique WRT the second... I know there's probably a\n"
"  # simpler way to do this... \n"
"\n"
"  set nextIndex [expr {$index + 1}]\n"
"  set nextItem [lindex $list $nextIndex]\n"
"\n"
"  # we don't really need to do much if the next\n"
"  # item doesn't match our pattern...\n"
"  if {[string match $pattern* $nextItem]} {\n"
"      # ok, the next item matches our pattern, too\n"
"      # now the trick is to find the first character\n"
"      # where they *don't* match...\n"
"      set marker [string length $pattern]\n"
"      while {$marker <= [string length $pattern]} {\n"
"    set a [string index $thisItem $marker]\n"
"    set b [string index $nextItem $marker]\n"
"    if {[string compare $a $b] == 0} {\n"
"        append pattern $a\n"
"        incr marker\n"
"    } else {\n"
"        break\n"
"    }\n"
"      }\n"
"  } else {\n"
"      set marker [string length $pattern]\n"
"  }\n"
"  \n"
"    } else {\n"
"  set marker end\n"
"  set index 0\n"
"    }\n"
"\n"
"    # ok, we know the pattern and what part is unique;\n"
"    # update the entry widget and listbox appropriately\n"
"    if {$exact && $exactMatch == -1} {\n"
"  # this means we didn't find an exact match\n"
"  $widgets(listbox) selection clear 0 end\n"
"  $widgets(listbox) see $index\n"
"\n"
"    } elseif {!$exact}  {\n"
"  # this means we found something, but it isn't an exact\n"
"  # match. If we find something that *is* an exact match we\n"
"  # don't need to do the following, since it would merely \n"
"  # be replacing the data in the entry widget with itself\n"
"  set oldstate [$widgets(entry) cget -state]\n"
"  $widgets(entry) configure -state normal\n"
"  $widgets(entry) delete 0 end\n"
"  $widgets(entry) insert end $thisItem\n"
"  $widgets(entry) selection clear\n"
"  $widgets(entry) selection range $marker end\n"
"  $widgets(listbox) activate $index\n"
"  $widgets(listbox) selection clear 0 end\n"
"  $widgets(listbox) selection anchor $index\n"
"  $widgets(listbox) selection set $index\n"
"  $widgets(listbox) see $index\n"
"  $widgets(entry) configure -state $oldstate\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::Select --\n"
"#\n"
"#    selects an item from the list and sets the value of the combobox\n"
"#    to that value\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w      widget pathname\n"
"#    index  listbox index of item to be selected\n"
"#\n"
"# Returns:\n"
"#\n"
"#    empty string\n"
"\n"
"proc ::combobox::Select {w index} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    # the catch is because I'm sloppy -- presumably, the only time\n"
"    # an error will be caught is if there is no selection. \n"
"    if {![catch {set data [$widgets(listbox) get [lindex $index 0]]}]} {\n"
"  ::combobox::SetValue $widgets(this) $data\n"
"\n"
"  $widgets(listbox) selection clear 0 end\n"
"  $widgets(listbox) selection anchor $index\n"
"  $widgets(listbox) selection set $index\n"
"\n"
"    }\n"
"    $widgets(entry) selection range 0 end\n"
"    $widgets(entry) icursor end\n"
"\n"
"    $widgets(this) close\n"
"\n"
"    return \"\"\n"
"}\n"
"\n"
"# ::combobox::HandleScrollbar --\n"
"# \n"
"#    causes the scrollbar of the dropdown list to appear or disappear\n"
"#    based on the contents of the dropdown listbox\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w       widget pathname\n"
"#    action  the action to perform on the scrollbar\n"
"#\n"
"# Returns:\n"
"#\n"
"#    an empty string\n"
"\n"
"proc ::combobox::HandleScrollbar {w {action \"unknown\"}} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    if {$options(-height) == 0} {\n"
"  set hlimit $options(-maxheight)\n"
"    } else {\n"
"  set hlimit $options(-height)\n"
"    }        \n"
"\n"
"    switch $action {\n"
"  \"grow\" {\n"
"      if {$hlimit > 0 && [$widgets(listbox) size] > $hlimit} {\n"
"    pack forget $widgets(listbox)\n"
"    pack $widgets(vsb) -side right -fill y -expand n\n"
"    pack $widgets(listbox) -side left -fill both -expand y\n"
"      }\n"
"  }\n"
"\n"
"  \"shrink\" {\n"
"      if {$hlimit > 0 && [$widgets(listbox) size] <= $hlimit} {\n"
"    pack forget $widgets(vsb)\n"
"      }\n"
"  }\n"
"\n"
"  \"crop\" {\n"
"      # this means the window was cropped and we definitely \n"
"      # need a scrollbar no matter what the user wants\n"
"      pack forget $widgets(listbox)\n"
"      pack $widgets(vsb) -side right -fill y -expand n\n"
"      pack $widgets(listbox) -side left -fill both -expand y\n"
"  }\n"
"\n"
"  default {\n"
"      if {$hlimit > 0 && [$widgets(listbox) size] > $hlimit} {\n"
"    pack forget $widgets(listbox)\n"
"    pack $widgets(vsb) -side right -fill y -expand n\n"
"    pack $widgets(listbox) -side left -fill both -expand y\n"
"      } else {\n"
"    pack forget $widgets(vsb)\n"
"      }\n"
"  }\n"
"    }\n"
"\n"
"    return \"\"\n"
"}\n"
"\n";

const char* vtkcomboboxwidget2 =
"# ::combobox::ComputeGeometry --\n"
"#\n"
"#    computes the geometry of the dropdown list based on the size of the\n"
"#    combobox...\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w     widget pathname\n"
"#\n"
"# Returns:\n"
"#\n"
"#    the desired geometry of the listbox\n"
"\n"
"proc ::combobox::ComputeGeometry {w} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"    \n"
"    if {$options(-height) == 0 && $options(-maxheight) != \"0\"} {\n"
"  # if this is the case, count the items and see if\n"
"  # it exceeds our maxheight. If so, set the listbox\n"
"  # size to maxheight...\n"
"  set nitems [$widgets(listbox) size]\n"
"  if {$nitems > $options(-maxheight)} {\n"
"      # tweak the height of the listbox\n"
"      $widgets(listbox) configure -height $options(-maxheight)\n"
"  } else {\n"
"      # un-tweak the height of the listbox\n"
"      $widgets(listbox) configure -height 0\n"
"  }\n"
"  update idletasks\n"
"    }\n"
"\n"
"    # compute height and width of the dropdown list\n"
"    set bd [$widgets(dropdown) cget -borderwidth]\n"
"    set height [expr {[winfo reqheight $widgets(dropdown)] + $bd + $bd}]\n"
"    if {[string length $options(-dropdownwidth)] == 0 || \n"
"        $options(-dropdownwidth) == 0} {\n"
"        set width [winfo width $widgets(this)]\n"
"    } else {\n"
"        set m [font measure [$widgets(listbox) cget -font] \"m\"]\n"
"        set width [expr {$options(-dropdownwidth) * $m}]\n"
"    }\n"
"\n"
"    # figure out where to place it on the screen, trying to take into\n"
"    # account we may be running under some virtual window manager\n"
"    set screenWidth  [winfo screenwidth $widgets(this)]\n"
"    set screenHeight [winfo screenheight $widgets(this)]\n"
"    set rootx        [winfo rootx $widgets(this)]\n"
"    set rooty        [winfo rooty $widgets(this)]\n"
"    set vrootx       [winfo vrootx $widgets(this)]\n"
"    set vrooty       [winfo vrooty $widgets(this)]\n"
"\n"
"    # the x coordinate is simply the rootx of our widget, adjusted for\n"
"    # the virtual window. We won't worry about whether the window will\n"
"    # be offscreen to the left or right -- we want the illusion that it\n"
"    # is part of the entry widget, so if part of the entry widget is off-\n"
"    # screen, so will the list. If you want to change the behavior,\n"
"    # simply change the if statement... (and be sure to update this\n"
"    # comment!)\n"
"    set x  [expr {$rootx + $vrootx}]\n"
"    if {0} { \n"
"  set rightEdge [expr {$x + $width}]\n"
"  if {$rightEdge > $screenWidth} {\n"
"      set x [expr {$screenWidth - $width}]\n"
"  }\n"
"  if {$x < 0} {set x 0}\n"
"    }\n"
"\n"
"    # the y coordinate is the rooty plus vrooty offset plus \n"
"    # the height of the static part of the widget plus 1 for a \n"
"    # tiny bit of visual separation...\n"
"    set y [expr {$rooty + $vrooty + [winfo reqheight $widgets(this)] + 1}]\n"
"    set bottomEdge [expr {$y + $height}]\n"
"\n"
"    if {$bottomEdge >= $screenHeight} {\n"
"  # ok. Fine. Pop it up above the entry widget isntead of\n"
"  # below.\n"
"  set y [expr {($rooty - $height - 1) + $vrooty}]\n"
"\n"
"  if {$y < 0} {\n"
"      # this means it extends beyond our screen. How annoying.\n"
"      # Now we'll try to be real clever and either pop it up or\n"
"      # down, depending on which way gives us the biggest list. \n"
"      # then, we'll trim the list to fit and force the use of\n"
"      # a scrollbar\n"
"\n"
"      # (sadly, for windows users this measurement doesn't\n"
"      # take into consideration the height of the taskbar,\n"
"      # but don't blame me -- there isn't any way to detect\n"
"      # it or figure out its dimensions. The same probably\n"
"      # applies to any window manager with some magic windows\n"
"      # glued to the top or bottom of the screen)\n"
"\n"
"      if {$rooty > [expr {$screenHeight / 2}]} {\n"
"    # we are in the lower half of the screen -- \n"
"    # pop it up. Y is zero; that parts easy. The height\n"
"    # is simply the y coordinate of our widget, minus\n"
"    # a pixel for some visual separation. The y coordinate\n"
"    # will be the topof the screen.\n"
"    set y 1\n"
"    set height [expr {$rooty - 1 - $y}]\n"
"\n"
"      } else {\n"
"    # we are in the upper half of the screen --\n"
"    # pop it down\n"
"    set y [expr {$rooty + $vrooty + "
"      [winfo reqheight $widgets(this)] + 1}]\n"
"    set height [expr {$screenHeight - $y}]\n"
"\n"
"      }\n"
"\n"
"      # force a scrollbar\n"
"      HandleScrollbar $widgets(this) crop\n"
"  }     \n"
"    }\n"
"\n"
"    if {$y < 0} {\n"
"  # hmmm. Bummer.\n"
"  set y 0\n"
"  set height $screenheight\n"
"    }\n"
"\n"
"    set geometry [format \"=%dx%d+%d+%d\" $width $height $x $y]\n"
"\n"
"    return $geometry\n"
"}\n"
"\n"
"# ::combobox::DoInternalWidgetCommand --\n"
"#\n"
"#    perform an internal widget command, then mung any error results\n"
"#    to look like it came from our megawidget. A lot of work just to\n"
"#    give the illusion that our megawidget is an atomic widget\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w           widget pathname\n"
"#    subwidget   pathname of the subwidget \n"
"#    command     subwidget command to be executed\n"
"#    args        arguments to the command\n"
"#\n"
"# Returns:\n"
"#\n"
"#    The result of the subwidget command, or an error\n"
"\n"
"proc ::combobox::DoInternalWidgetCommand {w subwidget command args} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    set subcommand $command\n"
"    set command [concat $widgets($subwidget) $command $args]\n"
"    if {[catch $command result]} {\n"
"  # replace the subwidget name with the megawidget name\n"
"  regsub $widgets($subwidget) $result $widgets(this) result\n"
"\n"
"  # replace specific instances of the subwidget command\n"
"  # with our megawidget command\n"
"  switch $subwidget,$subcommand {\n"
"      listbox,index  {regsub \"index\"  $result \"list index\"  result}\n"
"      listbox,insert {regsub \"insert\" $result \"list insert\" result}\n"
"      listbox,delete {regsub \"delete\" $result \"list delete\" result}\n"
"      listbox,get    {regsub \"get\"    $result \"list get\"    result}\n"
"      listbox,size   {regsub \"size\"   $result \"list size\"   result}\n"
"  }\n"
"  error $result\n"
"\n"
"    } else {\n"
"  return $result\n"
"    }\n"
"}\n"
"\n"
"\n"
"# ::combobox::WidgetProc --\n"
"#\n"
"#    This gets uses as the widgetproc for an combobox widget. \n"
"#    Notice where the widget is created and you'll see that the\n"
"#    actual widget proc merely evals this proc with all of the\n"
"#    arguments intact.\n"
"#\n"
"#    Note that some widget commands are defined \"inline\" (ie:\n"
"#    within this proc), and some do most of their work in \n"
"#    separate procs. This is merely because sometimes it was\n"
"#    easier to do it one way or the other.\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w         widget pathname\n"
"#    command   widget subcommand\n"
"#    args      additional arguments; varies with the subcommand\n"
"#\n"
"# Results:\n"
"#\n"
"#    Performs the requested widget command\n"
"\n"
"proc ::combobox::WidgetProc {w command args} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"    upvar ::combobox::${w}::oldFocus oldFocus\n"
"    upvar ::combobox::${w}::oldFocus oldGrab\n"
"\n"
"    set command [::combobox::Canonize $w command $command]\n"
"\n"
"    # this is just shorthand notation...\n"
"    set doWidgetCommand "
"      [list ::combobox::DoInternalWidgetCommand $widgets(this)]\n"
"\n"
"    if {$command == \"list\"} {\n"
"  # ok, the next argument is a list command; we'll \n"
"  # rip it from args and append it to command to\n"
"  # create a unique internal command\n"
"  #\n"
"  # NB: because of the sloppy way we are doing this,\n"
"  # we'll also let the user enter our secret command\n"
"  # directly (eg: listinsert, listdelete), but we\n"
"  # won't document that fact\n"
"  set command \"list-[lindex $args 0]\"\n"
"  set args [lrange $args 1 end]\n"
"    }\n"
"\n"
"    set result \"\"\n"
"\n"
"    # many of these commands are just synonyms for specific\n"
"    # commands in one of the subwidgets. We'll get them out\n"
"    # of the way first, then do the custom commands.\n"
"    switch $command {\n"
"  bbox -\n"
"  delete -\n"
"  get -\n"
"  icursor -\n"
"  index -\n"
"  insert -\n"
"  scan -\n"
"  selection -\n"
"  xview {\n"
"      set result [eval $doWidgetCommand entry $command $args]\n"
"  }\n"
"  list-get   {set result [eval $doWidgetCommand listbox get $args]}\n"
"  list-index   {set result [eval $doWidgetCommand listbox index $args]}\n"
"  list-size   {set result [eval $doWidgetCommand listbox size $args]}\n"
"\n"
"  select {\n"
"      if {[llength $args] == 1} {\n"
"    set index [lindex $args 0]\n"
"    set result [Select $widgets(this) $index]\n"
"      } else {\n"
"    error \"usage: $w select index\"\n"
"      }\n"
"  }\n"
"\n"
"  subwidget {\n"
"      set knownWidgets [list button entry listbox dropdown vsb]\n"
"      if {[llength $args] == 0} {\n"
"    return $knownWidgets\n"
"      }\n"
"\n"
"      set name [lindex $args 0]\n"
"      if {[lsearch $knownWidgets $name] != -1} {\n"
"    set result $widgets($name)\n"
"      } else {\n"
"    error \"unknown subwidget $name\"\n"
"      }\n"
"  }\n"
"\n"
"  curselection {\n"
"      set result [eval $doWidgetCommand listbox curselection]\n"
"  }\n"
"\n"
"  list-insert {\n"
"      eval $doWidgetCommand listbox insert $args\n"
"      set result [HandleScrollbar $w \"grow\"]\n"
"  }\n"
"\n"
"  list-delete {\n"
"      eval $doWidgetCommand listbox delete $args\n"
"      set result [HandleScrollbar $w \"shrink\"]\n"
"  }\n"
"\n"
"  toggle {\n"
"      # ignore this command if the widget is disabled...\n"
"      if {$options(-state) == \"disabled\"} return\n"
"\n"
"      # pops down the list if it is not, hides it\n"
"      # if it is...\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    set result [$widgets(this) close]\n"
"      } else {\n"
"    set result [$widgets(this) open]\n"
"      }\n"
"  }\n"
"\n"
"  open {\n"
"\n"
"      # if this is an editable combobox, the focus should\n"
"      # be set to the entry widget\n"
"      if {$options(-editable)} {\n"
"    focus $widgets(entry)\n"
"    $widgets(entry) select range 0 end\n"
"    $widgets(entry) icursor end\n"
"      }\n"
"\n"
"      # if we are disabled, we won't allow this to happen\n"
"      if {$options(-state) == \"disabled\"} {\n"
"    return 0\n"
"      }\n"
"\n"
"      # if there is a -opencommand, execute it now\n"
"      if {[string length $options(-opencommand)] > 0} {\n"
"    # hmmm... should I do a catch, or just let the normal\n"
"    # error handling handle any errors? For now, the latter...\n"
"    uplevel \\#0 $options(-opencommand)\n"
"      }\n"
"\n"
"      # compute the geometry of the window to pop up, and set\n"
"      # it, and force the window manager to take notice\n"
"      # (even if it is not presently visible).\n"
"      #\n"
"      # this isn't strictly necessary if the window is already\n"
"      # mapped, but we'll go ahead and set the geometry here\n"
"      # since its harmless and *may* actually reset the geometry\n"
"      # to something better in some weird case.\n"
"      set geometry [::combobox::ComputeGeometry $widgets(this)]\n"
"      wm geometry $widgets(dropdown) $geometry\n"
"      update idletasks\n"
"\n"
"      # if we are already open, there's nothing else to do\n"
"      if {[winfo ismapped $widgets(dropdown)]} {\n"
"    return 0\n"
"      }\n"
"\n"
"      # save the widget that currently has the focus; we'll restore\n"
"      # the focus there when we're done\n"
"      set oldFocus [focus]\n"
"\n"
"      # ok, tweak the visual appearance of things and \n"
"      # make the list pop up\n"
"      $widgets(button) configure -relief sunken\n"
"      wm deiconify $widgets(dropdown) \n"
"      update idletasks\n"
"      raise $widgets(dropdown) \n"
"\n"
"      # force focus to the entry widget so we can handle keypress\n"
"      # events for traversal\n"
"      focus -force $widgets(entry)\n"
"\n"
"      # select something by default, but only if its an\n"
"      # exact match...\n"
"      ::combobox::Find $widgets(this) 1\n"
"\n"
"      # save the current grab state for the display containing\n"
"      # this widget. We'll restore it when we close the dropdown\n"
"      # list\n"
"      set status \"none\"\n"
"      set grab [grab current $widgets(this)]\n"
"      if {$grab != \"\"} {set status [grab status $grab]}\n"
"      set oldGrab [list $grab $status]\n"
"      unset grab status\n"
"\n"
"      # *gasp* do a global grab!!! Mom always told me not to\n"
"      # do things like this, but sometimes a man's gotta do\n"
"      # what a man's gotta do.\n"
"      grab -global $widgets(this)\n"
"\n"
"      # fake the listbox into thinking it has focus. This is \n"
"      # necessary to get scanning initialized properly in the\n"
"      # listbox.\n"
"      event generate $widgets(listbox) <B1-Enter>\n"
"\n"
"      return 1\n"
"  }\n"
"\n"
"  close {\n"
"      # if we are already closed, don't do anything...\n"
"      if {![winfo ismapped $widgets(dropdown)]} {\n"
"    return 0\n"
"      }\n"
"\n"
"      # restore the focus and grab, but ignore any errors...\n"
"      # we're going to be paranoid and release the grab before\n"
"      # trying to set any other grab because we really really\n"
"      # really want to make sure the grab is released.\n"
"      catch {focus $oldFocus} result\n"
"      catch {grab release $widgets(this)}\n"
"      catch {\n"
"    set status [lindex $oldGrab 1]\n"
"    if {$status == \"global\"} {\n"
"        grab -global [lindex $oldGrab 0]\n"
"    } elseif {$status == \"local\"} {\n"
"        grab [lindex $oldGrab 0]\n"
"    }\n"
"    unset status\n"
"      }\n"
"\n"
"      # hides the listbox\n"
"      $widgets(button) configure -relief raised\n"
"      wm withdraw $widgets(dropdown) \n"
"\n"
"      # select the data in the entry widget. Not sure\n"
"      # why, other than observation seems to suggest that's\n"
"      # what windows widgets do.\n"
"      set editable [::combobox::GetBoolean $options(-editable)]\n"
"      if {$editable} {\n"
"    $widgets(entry) selection range 0 end\n"
"    $widgets(button) configure -relief raised\n"
"      }\n"
"\n"
"\n"
"      # magic tcl stuff (see tk.tcl in the distribution \n"
"      # lib directory)\n"
"      ::combobox::tkCancelRepeat\n"
"\n"
"      return 1\n"
"  }\n"
"\n"
"  cget {\n"
"      if {[llength $args] != 1} {\n"
"    error \"wrong # args: should be $w cget option\"\n"
"      }\n"
"      set opt [::combobox::Canonize $w option [lindex $args 0]]\n"
"\n"
"      if {$opt == \"-value\"} {\n"
"    set result [$widgets(entry) get]\n"
"      } else {\n"
"    set result $options($opt)\n"
"      }\n"
"  }\n"
"\n"
"  configure {\n"
"      set result [eval ::combobox::Configure {$w} $args]\n"
"  }\n"
"\n"
"  default {\n"
"      error \"bad option \\\"$command\\\"\"\n"
"  }\n"
"    }\n"
"\n"
"    return $result\n"
"}\n"
"\n"
"# ::combobox::Configure --\n"
"#\n"
"#    Implements the \"configure\" widget subcommand\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w      widget pathname\n"
"#    args   zero or more option/value pairs (or a single option)\n"
"#\n"
"# Results:\n"
"#    \n"
"#    Performs typcial \"configure\" type requests on the widget\n"
"\n"
"proc ::combobox::Configure {w args} {\n"
"    variable widgetOptions\n"
"    variable defaultEntryCursor\n"
"\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"\n"
"    if {[llength $args] == 0} {\n"
"  # hmmm. User must be wanting all configuration information\n"
"  # note that if the value of an array element is of length\n"
"  # one it is an alias, which needs to be handled slightly\n"
"  # differently\n"
"  set results {}\n"
"  foreach opt [lsort [array names widgetOptions]] {\n"
"      if {[llength $widgetOptions($opt)] == 1} {\n"
"    set alias $widgetOptions($opt)\n"
"    set optName $widgetOptions($alias)\n"
"    lappend results [list $opt $optName]\n"
"      } else {\n"
"    set optName  [lindex $widgetOptions($opt) 0]\n"
"    set optClass [lindex $widgetOptions($opt) 1]\n"
"    set default [option get $w $optName $optClass]\n"
"    if {[info exists options($opt)]} {\n"
"        lappend results [list $opt $optName $optClass "
"          $default $options($opt)]\n"
"    } else {\n"
"        lappend results [list $opt $optName $optClass "
"          $default \"\"]\n"
"    }\n"
"      }\n"
"  }\n"
"\n"
"  return $results\n"
"    }\n"
"    \n"
"    # one argument means we are looking for configuration\n"
"    # information on a single option\n"
"    if {[llength $args] == 1} {\n"
"  set opt [::combobox::Canonize $w option [lindex $args 0]]\n"
"\n"
"  set optName  [lindex $widgetOptions($opt) 0]\n"
"  set optClass [lindex $widgetOptions($opt) 1]\n"
"  set default [option get $w $optName $optClass]\n"
"  set results [list $opt $optName $optClass "
"    $default $options($opt)]\n"
"  return $results\n"
"    }\n"
"\n"
"    # if we have an odd number of values, bail. \n"
"    if {[expr {[llength $args]%2}] == 1} {\n"
"  # hmmm. An odd number of elements in args\n"
"  error \"value for \\\"[lindex $args end]\\\" missing\"\n"
"    }\n"
"    \n"
"    # Great. An even number of options. Let's make sure they \n"
"    # are all valid before we do anything. Note that Canonize\n"
"    # will generate an error if it finds a bogus option; otherwise\n"
"    # it returns the canonical option name\n"
"    foreach {name value} $args {\n"
"  set name [::combobox::Canonize $w option $name]\n"
"  set opts($name) $value\n"
"    }\n"
"\n"
"    # process all of the configuration options\n"
"    # some (actually, most) options require us to\n"
"    # do something, like change the attributes of\n"
"    # a widget or two. Here's where we do that...\n"
"    #\n"
"    # note that the handling of disabledforeground and\n"
"    # disabledbackground is a little wonky. First, we have\n"
"    # to deal with backwards compatibility (ie: tk 8.3 and below\n"
"    # didn't have such options for the entry widget), and\n"
"    # we have to deal with the fact we might want to disable\n"
"    # the entry widget but use the normal foreground/background\n"
"    # for when the combobox is not disabled, but not editable either.\n"
"\n"
"    set updateVisual 0\n"
"    foreach option [array names opts] {\n"
"  set newValue $opts($option)\n"
"  if {[info exists options($option)]} {\n"
"      set oldValue $options($option)\n"
"  }\n"
"\n"
"  switch -- $option {\n"
"      -buttonbackground {\n"
"    $widgets(button) configure -background $newValue\n"
"      }\n"
"      -background {\n"
"    set updateVisual 1\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -borderwidth {\n"
"    $widgets(frame) configure -borderwidth $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -command {\n"
"    # nothing else to do...\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -commandstate {\n"
"    # do some value checking...\n"
"    if {$newValue != \"normal\" && $newValue != \"disabled\"} {\n"
"        set options($option) $oldValue\n"
"        set message \"bad state value \\\"$newValue\\\";\"\n"
"        append message \" must be normal or disabled\"\n"
"        error $message\n"
"    }\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -cursor {\n"
"    $widgets(frame) configure -cursor $newValue\n"
"    $widgets(entry) configure -cursor $newValue\n"
"    $widgets(listbox) configure -cursor $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -disabledforeground {\n"
"    set updateVisual 1\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -disabledbackground {\n"
"    set updateVisual 1\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"            -dropdownwidth {\n"
"                set options($option) $newValue\n"
"            }\n"
"\n"
"      -editable {\n"
"    set updateVisual 1\n"
"     if {$newValue} {\n"
"         # it's editable...\n"
"         $widgets(entry) configure "
"           -state normal "
"           -cursor $defaultEntryCursor\n"
"     } else {\n"
"         $widgets(entry) configure "
"           -state disabled "
"           -cursor $options(-cursor)\n"
"     }\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -elementborderwidth {\n"
"    $widgets(button) configure -borderwidth $newValue\n"
"    $widgets(vsb) configure -borderwidth $newValue\n"
"    $widgets(dropdown) configure -borderwidth $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -font {\n"
"    $widgets(entry) configure -font $newValue\n"
"    $widgets(listbox) configure -font $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -foreground {\n"
"    set updateVisual 1\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -height {\n"
"    $widgets(listbox) configure -height $newValue\n"
"    HandleScrollbar $w\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -highlightbackground {\n"
"    $widgets(frame) configure -highlightbackground $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -highlightcolor {\n"
"    $widgets(frame) configure -highlightcolor $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -highlightthickness {\n"
"    $widgets(frame) configure -highlightthickness $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"      \n"
"      -image {\n"
"    if {[string length $newValue] > 0} {\n"
"        puts \"old button width: [$widgets(button) cget -width]\"\n"
"        $widgets(button) configure "
"      -image $newValue "
"      -width [expr {[image width $newValue] + 2}]\n"
"        puts \"new button width: [$widgets(button) cget -width]\"\n"
"        \n"
"    } else {\n"
"        $widgets(button) configure -image ::combobox::bimage\n"
"    }\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -listvar {\n"
"    if {[catch {$widgets(listbox) cget -listvar}]} {\n"
"        return -code error "
"      \"-listvar not supported with this version of tk\"\n"
"    }\n"
"    $widgets(listbox) configure -listvar $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -maxheight {\n"
"    # ComputeGeometry may dork with the actual height\n"
"    # of the listbox, so let's undork it\n"
"    $widgets(listbox) configure -height $options(-height)\n"
"    HandleScrollbar $w\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -opencommand {\n"
"    # nothing else to do...\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -relief {\n"
"    $widgets(frame) configure -relief $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -selectbackground {\n"
"    $widgets(entry) configure -selectbackground $newValue\n"
"    $widgets(listbox) configure -selectbackground $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -selectborderwidth {\n"
"    $widgets(entry) configure -selectborderwidth $newValue\n"
"    $widgets(listbox) configure -selectborderwidth $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -selectforeground {\n"
"    $widgets(entry) configure -selectforeground $newValue\n"
"    $widgets(listbox) configure -selectforeground $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -state {\n"
"    if {$newValue == \"normal\"} {\n"
"        set updateVisual 1\n"
"        # it's enabled\n"
"\n"
"        set editable [::combobox::GetBoolean "
"          $options(-editable)]\n"
"        if {$editable} {\n"
"      $widgets(entry) configure -state normal\n"
"      $widgets(entry) configure -takefocus 1\n"
"        }\n"
"\n"
"                    # note that $widgets(button) is actually a label,\n"
"                    # not a button. And being able to disable labels\n"
"                    # wasn't possible until tk 8.3. (makes me wonder\n"
"        # why I chose to use a label, but that answer is\n"
"        # lost to antiquity)\n"
"                    if {[info patchlevel] >= 8.3} {\n"
"                        $widgets(button) configure -state normal\n"
"                    }\n"
"\n"
"    } elseif {$newValue == \"disabled\"}  {\n"
"        set updateVisual 1\n"
"        # it's disabled\n"
"        $widgets(entry) configure -state disabled\n"
"        $widgets(entry) configure -takefocus 0\n"
"                    # note that $widgets(button) is actually a label,\n"
"                    # not a button. And being able to disable labels\n"
"                    # wasn't possible until tk 8.3. (makes me wonder\n"
"        # why I chose to use a label, but that answer is\n"
"        # lost to antiquity)\n"
"                    if {$::tcl_version >= 8.3} {\n"
"                        $widgets(button) configure -state disabled \n"
"                    }\n"
"\n"
"    } else {\n"
"        set options($option) $oldValue\n"
"        set message \"bad state value \\\"$newValue\\\";\"\n"
"        append message \" must be normal or disabled\"\n"
"        error $message\n"
"    }\n"
"\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -takefocus {\n"
"    $widgets(entry) configure -takefocus $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -textvariable {\n"
"    $widgets(entry) configure -textvariable $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -value {\n"
"    ::combobox::SetValue $widgets(this) $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -width {\n"
"    $widgets(entry) configure -width $newValue\n"
"    $widgets(listbox) configure -width $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"\n"
"      -xscrollcommand {\n"
"    $widgets(entry) configure -xscrollcommand $newValue\n"
"    set options($option) $newValue\n"
"      }\n"
"  }      \n"
"\n"
"  if {$updateVisual} {UpdateVisualAttributes $w}\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::UpdateVisualAttributes --\n"
"#\n"
"# sets the visual attributes (foreground, background mostly) \n"
"# based on the current state of the widget (normal/disabled, \n"
"# editable/non-editable)\n"
"#\n"
"# why a proc for such a simple thing? Well, in addition to the\n"
"# various states of the widget, we also have to consider the \n"
"# version of tk being used -- versions from 8.4 and beyond have\n"
"# the notion of disabled foreground/background options for various\n"
"# widgets. All of the permutations can get nasty, so we encapsulate\n"
"# it all in one spot.\n"
"#\n"
"# note also that we don't handle all visual attributes here; just\n"
"# the ones that depend on the state of the widget. The rest are \n"
"# handled on a case by case basis\n"
"#\n"
"# Arguments:\n"
"#    w    widget pathname\n"
"#\n"
"# Returns:\n"
"#    empty string\n"
"\n"
"proc ::combobox::UpdateVisualAttributes {w} {\n"
"\n"
"    upvar ::combobox::${w}::widgets     widgets\n"
"    upvar ::combobox::${w}::options     options\n"
"\n"
"    if {$options(-state) == \"normal\"} {\n"
"\n"
"  set foreground $options(-foreground)\n"
"  set background $options(-background)\n"
"  \n"
"    } elseif {$options(-state) == \"disabled\"} {\n"
"\n"
"  set foreground $options(-disabledforeground)\n"
"  set background $options(-disabledbackground)\n"
"    }\n"
"\n"
"    $widgets(entry)   configure -foreground $foreground -background $background\n"
"    $widgets(listbox) configure -foreground $foreground -background $background\n"
"    $widgets(button)  configure -foreground $foreground \n"
"    $widgets(vsb)     configure -background $background -troughcolor $background\n"
"    $widgets(frame)   configure -background $background\n"
"\n"
"    # we need to set the disabled colors in case our widget is disabled. \n"
"    # We could actually check for disabled-ness, but we also need to \n"
"    # check whether we're enabled but not editable, in which case the \n"
"    # entry widget is disabled but we still want the enabled colors. It's\n"
"    # easier just to set everything and be done with it.\n"
"    \n"
"    if {$::tcl_version >= 8.4} {\n"
"  $widgets(entry) configure "
"      -disabledforeground $foreground "
"      -disabledbackground $background\n"
"  $widgets(button)  configure -disabledforeground $foreground\n"
"  $widgets(listbox) configure -disabledforeground $foreground\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::SetValue --\n"
"#\n"
"#    sets the value of the combobox and calls the -command, \n"
"#    if defined\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w          widget pathname\n"
"#    newValue   the new value of the combobox\n"
"#\n"
"# Returns\n"
"#\n"
"#    Empty string\n"
"\n"
"proc ::combobox::SetValue {w newValue} {\n"
"\n"
"    upvar ::combobox::${w}::widgets     widgets\n"
"    upvar ::combobox::${w}::options     options\n"
"    upvar ::combobox::${w}::ignoreTrace ignoreTrace\n"
"    upvar ::combobox::${w}::oldValue    oldValue\n"
"\n"
"    if {[info exists options(-textvariable)] "
"      && [string length $options(-textvariable)] > 0} {\n"
"  set variable ::$options(-textvariable)\n"
"  set $variable $newValue\n"
"    } else {\n"
"  set oldstate [$widgets(entry) cget -state]\n"
"  $widgets(entry) configure -state normal\n"
"  $widgets(entry) delete 0 end\n"
"  $widgets(entry) insert 0 $newValue\n"
"  $widgets(entry) configure -state $oldstate\n"
"    }\n"
"\n"
"    # set our internal textvariable; this will cause any public\n"
"    # textvariable (ie: defined by the user) to be updated as\n"
"    # well\n"
"#    set ::combobox::${w}::entryTextVariable $newValue\n"
"\n"
"    # redefine our concept of the \"old value\". Do it before running\n"
"    # any associated command so we can be sure it happens even\n"
"    # if the command somehow fails.\n"
"    set oldValue $newValue\n"
"\n"
"\n"
"    # call the associated command. The proc will handle whether or \n"
"    # not to actually call it, and with what args\n"
"    CallCommand $w $newValue\n"
"\n"
"    return \"\"\n"
"}\n"
"\n"
"# ::combobox::CallCommand --\n"
"#\n"
"#   calls the associated command, if any, appending the new\n"
"#   value to the command to be called.\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w         widget pathname\n"
"#    newValue  the new value of the combobox\n"
"#\n"
"# Returns\n"
"#\n"
"#    empty string\n"
"\n"
"proc ::combobox::CallCommand {w newValue} {\n"
"    upvar ::combobox::${w}::widgets widgets\n"
"    upvar ::combobox::${w}::options options\n"
"    \n"
"    # call the associated command, if defined and -commandstate is\n"
"    # set to \"normal\"\n"
"    if {$options(-commandstate) == \"normal\" && "
"      [string length $options(-command)] > 0} {\n"
"  set args [list $widgets(this) $newValue]\n"
"  uplevel \\#0 $options(-command) $args\n"
"    }\n"
"}\n"
"\n"
"\n"
"# ::combobox::GetBoolean --\n"
"#\n"
"#     returns the value of a (presumably) boolean string (ie: it should\n"
"#     do the right thing if the string is \"yes\", \"no\", \"true\", 1, etc\n"
"#\n"
"# Arguments:\n"
"#\n"
"#     value       value to be converted \n"
"#     errorValue  a default value to be returned in case of an error\n"
"#\n"
"# Returns:\n"
"#\n"
"#     a 1 or zero, or the value of errorValue if the string isn't\n"
"#     a proper boolean value\n"
"\n"
"proc ::combobox::GetBoolean {value {errorValue 1}} {\n"
"    if {[catch {expr {([string trim $value])?1:0}} res]} {\n"
"  return $errorValue\n"
"    } else {\n"
"  return $res\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::convert --\n"
"#\n"
"#     public routine to convert %x, %y and %W binding substitutions.\n"
"#     Given an x, y and or %W value relative to a given widget, this\n"
"#     routine will convert the values to be relative to the combobox\n"
"#     widget. For example, it could be used in a binding like this:\n"
"#\n"
"#     bind .combobox <blah> {doSomething [::combobox::convert %W -x %x]}\n"
"#\n"
"#     Note that this procedure is *not* exported, but is intended for\n"
"#     public use. It is not exported because the name could easily \n"
"#     clash with existing commands. \n"
"#\n"
"# Arguments:\n"
"#\n"
"#     w     a widget path; typically the actual result of a %W \n"
"#           substitution in a binding. It should be either a\n"
"#           combobox widget or one of its subwidgets\n"
"#\n"
"#     args  should one or more of the following arguments or \n"
"#           pairs of arguments:\n"
"#\n"
"#           -x <x>      will convert the value <x>; typically <x> will\n"
"#                       be the result of a %x substitution\n"
"#           -y <y>      will convert the value <y>; typically <y> will\n"
"#                       be the result of a %y substitution\n"
"#           -W (or -w)  will return the name of the combobox widget\n"
"#                       which is the parent of $w\n"
"#\n"
"# Returns:\n"
"#\n"
"#     a list of the requested values. For example, a single -w will\n"
"#     result in a list of one items, the name of the combobox widget.\n"
"#     Supplying \"-x 10 -y 20 -W\" (in any order) will return a list of\n"
"#     three values: the converted x and y values, and the name of \n"
"#     the combobox widget.\n"
"\n"
"proc ::combobox::convert {w args} {\n"
"    set result {}\n"
"    if {![winfo exists $w]} {\n"
"  error \"window \\\"$w\\\" doesn't exist\"\n"
"    }\n"
"\n"
"    while {[llength $args] > 0} {\n"
"  set option [lindex $args 0]\n"
"  set args [lrange $args 1 end]\n"
"\n"
"  switch -exact -- $option {\n"
"      -x {\n"
"    set value [lindex $args 0]\n"
"    set args [lrange $args 1 end]\n"
"    set win $w\n"
"    while {[winfo class $win] != \"Combobox\"} {\n"
"        incr value [winfo x $win]\n"
"        set win [winfo parent $win]\n"
"        if {$win == \".\"} break\n"
"    }\n"
"    lappend result $value\n"
"      }\n"
"\n"
"      -y {\n"
"    set value [lindex $args 0]\n"
"    set args [lrange $args 1 end]\n"
"    set win $w\n"
"    while {[winfo class $win] != \"Combobox\"} {\n"
"        incr value [winfo y $win]\n"
"        set win [winfo parent $win]\n"
"        if {$win == \".\"} break\n"
"    }\n"
"    lappend result $value\n"
"      }\n"
"\n"
"      -w -\n"
"      -W {\n"
"    set win $w\n"
"    while {[winfo class $win] != \"Combobox\"} {\n"
"        set win [winfo parent $win]\n"
"        if {$win == \".\"} break;\n"
"    }\n"
"    lappend result $win\n"
"      }\n"
"  }\n"
"    }\n"
"    return $result\n"
"}\n"
"\n";

const char* vtkcomboboxwidget3 =
"# ::combobox::Canonize --\n"
"#\n"
"#    takes a (possibly abbreviated) option or command name and either \n"
"#    returns the canonical name or an error\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    w        widget pathname\n"
"#    object   type of object to canonize; must be one of \"command\",\n"
"#             \"option\", \"scan command\" or \"list command\"\n"
"#    opt      the option (or command) to be canonized\n"
"#\n"
"# Returns:\n"
"#\n"
"#    Returns either the canonical form of an option or command,\n"
"#    or raises an error if the option or command is unknown or\n"
"#    ambiguous.\n"
"\n"
"proc ::combobox::Canonize {w object opt} {\n"
"    variable widgetOptions\n"
"    variable columnOptions\n"
"    variable widgetCommands\n"
"    variable listCommands\n"
"    variable scanCommands\n"
"\n"
"    switch $object {\n"
"  command {\n"
"      if {[lsearch -exact $widgetCommands $opt] >= 0} {\n"
"    return $opt\n"
"      }\n"
"\n"
"      # command names aren't stored in an array, and there\n"
"      # isn't a way to get all the matches in a list, so\n"
"      # we'll stuff the commands in a temporary array so\n"
"      # we can use [array names]\n"
"      set list $widgetCommands\n"
"      foreach element $list {\n"
"    set tmp($element) \"\"\n"
"      }\n"
"      set matches [array names tmp ${opt}*]\n"
"  }\n"
"\n"
"  {list command} {\n"
"      if {[lsearch -exact $listCommands $opt] >= 0} {\n"
"    return $opt\n"
"      }\n"
"\n"
"      # command names aren't stored in an array, and there\n"
"      # isn't a way to get all the matches in a list, so\n"
"      # we'll stuff the commands in a temporary array so\n"
"      # we can use [array names]\n"
"      set list $listCommands\n"
"      foreach element $list {\n"
"    set tmp($element) \"\"\n"
"      }\n"
"      set matches [array names tmp ${opt}*]\n"
"  }\n"
"\n"
"  {scan command} {\n"
"      if {[lsearch -exact $scanCommands $opt] >= 0} {\n"
"    return $opt\n"
"      }\n"
"\n"
"      # command names aren't stored in an array, and there\n"
"      # isn't a way to get all the matches in a list, so\n"
"      # we'll stuff the commands in a temporary array so\n"
"      # we can use [array names]\n"
"      set list $scanCommands\n"
"      foreach element $list {\n"
"    set tmp($element) \"\"\n"
"      }\n"
"      set matches [array names tmp ${opt}*]\n"
"  }\n"
"\n"
"  option {\n"
"      if {[info exists widgetOptions($opt)] "
"        && [llength $widgetOptions($opt)] == 2} {\n"
"    return $opt\n"
"      }\n"
"      set list [array names widgetOptions]\n"
"      set matches [array names widgetOptions ${opt}*]\n"
"  }\n"
"\n"
"    }\n"
"\n"
"    if {[llength $matches] == 0} {\n"
"  set choices [HumanizeList $list]\n"
"  error \"unknown $object \\\"$opt\\\"; must be one of $choices\"\n"
"\n"
"    } elseif {[llength $matches] == 1} {\n"
"  set opt [lindex $matches 0]\n"
"\n"
"  # deal with option aliases\n"
"  switch $object {\n"
"      option {\n"
"    set opt [lindex $matches 0]\n"
"    if {[llength $widgetOptions($opt)] == 1} {\n"
"        set opt $widgetOptions($opt)\n"
"    }\n"
"      }\n"
"  }\n"
"\n"
"  return $opt\n"
"\n"
"    } else {\n"
"  set choices [HumanizeList $list]\n"
"  error \"ambiguous $object \\\"$opt\\\"; must be one of $choices\"\n"
"    }\n"
"}\n"
"\n"
"# ::combobox::HumanizeList --\n"
"#\n"
"#    Returns a human-readable form of a list by separating items\n"
"#    by columns, but separating the last two elements with \"or\"\n"
"#    (eg: foo, bar or baz)\n"
"#\n"
"# Arguments:\n"
"#\n"
"#    list    a valid tcl list\n"
"#\n"
"# Results:\n"
"#\n"
"#    A string which as all of the elements joined with \", \" or \n"
"#    the word \" or \"\n"
"\n"
"proc ::combobox::HumanizeList {list} {\n"
"\n"
"    if {[llength $list] == 1} {\n"
"  return [lindex $list 0]\n"
"    } else {\n"
"  set list [lsort $list]\n"
"  set secondToLast [expr {[llength $list] -2}]\n"
"  set most [lrange $list 0 $secondToLast]\n"
"  set last [lindex $list end]\n"
"\n"
"  return \"[join $most {, }] or $last\"\n"
"    }\n"
"}\n"
"\n"
"# This is some backwards-compatibility code to handle TIP 44\n"
"# (http://purl.org/tcl/tip/44.html). For all private tk commands\n"
"# used by this widget, we'll make duplicates of the procs in the\n"
"# combobox namespace. \n"
"#\n"
"# I'm not entirely convinced this is the right thing to do. I probably\n"
"# shouldn't even be using the private commands. Then again, maybe the\n"
"# private commands really should be public. Oh well; it works so it\n"
"# must be OK...\n"
"foreach command {TabToWindow CancelRepeat ListboxUpDown} {\n"
"    if {[llength [info commands ::combobox::tk$command]] == 1} break;\n"
"\n"
"    set tmp [info commands tk$command]\n"
"    set proc ::combobox::tk$command\n"
"    if {[llength [info commands tk$command]] == 1} {\n"
"        set command [namespace which [lindex $tmp 0]]\n"
"        proc $proc {args} \"uplevel $command \\$args\"\n"
"    } else {\n"
"        if {[llength [info commands ::tk::$command]] == 1} {\n"
"            proc $proc {args} \"uplevel ::tk::$command \\$args\"\n"
"        }\n"
"    }\n"
"}\n"
"\n"
"# end of combobox.tcl\n"
"namespace import combobox::*\n";
