/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkPVDefaultModules.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
// .NAME 
// .SECTION Description

#ifndef __vtkPVDefaultModules_h
#define __vtkPVDefaultModules_h

#include "vtkToolkits.h"

// Define the standard reader interfaces.
const char* vtkPVInitialize::StandardReaderInterfaces =
"<ModuleInterfaces>\n"
"  <Module name=\"pvtkfile\" class=\"vtkPVDataSetReaderModule\" root_name=\"PVTKFile\"\n"
"          output=\"vtkDataSet\" module_type=\"Reader\"\n"
"          extensions=\".pvtk\" file_description=\"Parallel VTK Files\">\n"
"    <Source type=\"vtkPDataSetReader\"/>\n"
"  </Module>\n"
"  <Module name=\"vtkfile\" class=\"vtkPVDataSetReaderModule\" root_name=\"VTKFile\" \n"
"          output=\"vtkDataSet\" module_type=\"Reader\"\n"
"          extensions=\".vtk\" file_description=\"VTK Files\">\n"
"    <Source type=\"vtkPDataSetReader\"/>\n"
"  </Module>\n"
"  <Module name=\"stlreader\" class=\"vtkPVReaderModule\" root_name=\"STL\" \n"
"          output=\"vtkPolyData\" module_type=\"Reader\"\n"
"          extensions=\".stl\" file_description=\"Stereo Lithography\">\n"
"    <Source type=\"vtkSTLReader\"/>\n"
"  </Module>\n"
"  <Module name=\"byureader\" class=\"vtkPVReaderModule\" root_name=\"BYU\" \n"
"          output=\"vtkPolyData\" module_type=\"Reader\"\n"
"          extensions=\".g\" file_description=\"BYU Files\">\n"
"    <Source type=\"vtkBYUReader\"/>\n"
"  </Module>\n"
"  <Module name=\"popreader\" class=\"vtkPVAdvancedReaderModule\" \n"
"          root_name=\"POP\" output=\"vtkStructuredGrid\"\n"
"          module_type=\"Reader\"\n"
"          extensions=\".pop\" file_description=\"POP Ocean Files\">\n"
"    <Source type=\"vtkPOPReader\"/>\n"
"    <VectorEntry variable=\"Radius\" trace_name=\"Radius\" type=\"float\" \n"
"                 help=\"Set the radius of the data set\"/>\n"
"    <VectorEntry label=\"Clip Extent\" variable=\"ClipExtent\" type=\"int\" \n"
"                 length=\"6\" \n"
"                 help=\"For reading a smaller extent.\"/>\n"
"    <VectorEntry label=\"Ghost Levels\" trace_name=\"NumberOfGhostLevels\" variable=\"NumberOfGhostLevels\" \n"
"                 type=\"int\" \n"
"                 help=\"Set the number of ghost levels to read.\"/>\n"
"  </Module>\n"
"  <Module name=\"ensight\" class=\"vtkPVEnSightReaderModule\" root_name=\"Ensight\" \n"
"          output=\"vtkDataSet\" module_type=\"Reader\"\n"
"          extensions=\".case .sos\" file_description=\"EnSight Files\">\n"
"    <Source type=\"vtkGenericEnSightReader\"/>\n"
"  </Module>\n"
"  <Module name=\"P3DReader\" class=\"vtkPVPLOT3DReaderModule\"\n"
"          root_name=\"Plot3D\"\n"
"          output=\"vtkStructuredGrid\" module_type=\"Reader\"\n"
"          extensions=\".xyz\" file_description=\"PLOT3D Files\">\n"
"    <Source type=\"vtkPLOT3DReader\"/>\n"
"    <FileEntry label=\"Q File\" trace_name=\"QFileName\" variable=\"QFileName\" extension=\"q\" \n"
"               help=\"Set the plot3d q file to read.\"/>\n"
"    <LabeledToggle label=\"Binary\" trace_name=\"BinaryFile\" variable=\"BinaryFile\" \n"
"                   help=\"Is this a binary file?\"/>\n"
"    <LabeledToggle label=\"Multi-block\" trace_name=\"MultiGrid\" variable=\"MultiGrid\" \n"
"       help=\"Does this file have multiple block information\"/>\n"
"    <LabeledToggle label=\"Fortran byte count\" trace_name=\"HasByteCount\" variable=\"HasByteCount\" \n"
"       help=\"Does this file use Fortran leading-trailing byte counts\"/>\n"
"    <LabeledToggle label=\"I blanking\" trace_name=\"IBlanking\" variable=\"IBlanking\"\n"
"                    help=\"Any visibility information?\"/>\n"
"    <LabeledToggle label=\"2D geometry\" trace_name=\"TwoDimensionalGeometry\" variable=\"TwoDimensionalGeometry\"\n"
"                    help=\"Is there only data for two dimensions?\"/>\n"
"    <LabeledToggle label=\"Force read\" trace_name=\"ForceRead\" variable=\"ForceRead\"\n"
"              help=\"Read even if file looks corrupt?\"/>\n"
"  <SelectionList label=\"Byte order\" trace_name=\"ByteOrder\" variable=\"ByteOrder\"\n"
"         help=\"Select the byte order of the binary file\">\n"
"    <Item name=\"big endian\" value=\"0\"/>\n"
"    <Item name=\"little endian\" value=\"1\"/>\n"
"  </SelectionList>\n"
"  </Module>\n"
"</ModuleInterfaces>\n";

// Define the standard source interfaces.
const char* vtkPVInitialize::StandardSourceInterfaces =
"<ModuleInterfaces>\n"
"<Module name=\"VectorText\" menu_name=\"3D Text\" root_name=\"VectorText\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D geometric representation of a text string.\" \n"
"        short_help=\"Create a 3D text object\">\n"
"  <Source type=\"vtkVectorText\"/>\n"
"  <StringEntry variable=\"Text\" trace_name=\"Text\" help=\"Enter the text to display\"/>\n"
"</Module>\n"
"\n"
"\n"
"<Module name=\"ArrowSource\" menu_name=\"Arrow\" root_name=\"Arrow\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D arrow with a long cylindrical shaft and a cone for the tip.\" \n"
"        short_help=\"Create a 3D arrow\">\n"
"  <Source type=\"vtkArrowSource\"/>\n"
"  <VectorEntry label=\"Tip resolution\" trace_name=\"TipResolution\" variable=\"TipResolution\" type=\"int\" help=\"Set the number of faces on the tip.\"/>\n"
"  <VectorEntry label=\"Tip radius\" trace_name=\"TipRadius\" variable=\"TipRadius\" type=\"float\" help=\"Set the radius of the widest part of the tip.\"/>\n"
"  <VectorEntry label=\"Tip length\" trace_name=\"TipLength\" variable=\"TipLength\" type=\"float\" help=\"Set the length of the tip (the whole arrow is length 1)\"/>\n"
"  <VectorEntry label=\"Shaft resolution\" trace_name=\"ShaftResolution\" variable=\"ShaftResolution\" type=\"int\" help=\"Set the number of faces on shaft\"/>\n"
"  <VectorEntry label=\"Shaft radius\" trace_name=\"ShaftRadius\" variable=\"ShaftRadius\" type=\"float\" help=\"Set the radius of the shaft\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"Axes\" root_name=\"Axes\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"Three lines representing the axes - red line along X, green line along Y, and blue line along Z.\" \n"
"        short_help=\"Create three lines representing X, Y and Z axes\">\n"
"  <Source type=\"vtkAxes\"/>\n"
"  <VectorEntry label=\"Scale\" trace_name=\"ScaleFactor\" variable=\"ScaleFactor\" type=\"float\" help=\"Set the size of the axes\"/>\n"
"  <VectorEntry variable=\"Origin\" trace_name=\"Origin\"  type=\"float\" length=\"3\" help=\"Set the x, y, z coordinates of the origin of the axes\"/>\n"
"  <LabeledToggle variable=\"Symmetric\" trace_name=\"Symmetric\" help=\"Select whether to display the negative axes\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"CubeSource\" menu_name=\"Box\" root_name=\"Cube\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D box with specified X, Y, and Z lengths.\" \n"
"        short_help=\"Create a box with specified X, Y, and Z lengths.\">\n"
"  <Source type=\"vtkCubeSource\"/>\n"
"  <VectorEntry label=\"X length\" trace_name=\"XLength\" variable=\"XLength\" type=\"int\" help=\"The length of the cube in the x direction.\"/>\n"
"  <VectorEntry label=\"Y length\" trace_name=\"YLength\" variable=\"YLength\" type=\"int\" help=\"The length of the cube in the y direction.\"/>\n"
"  <VectorEntry label=\"Z length\" trace_name=\"ZLength\" variable=\"ZLength\" type=\"int\" help=\"The length of the cube in the z direction.\"/>\n"
"  <VectorEntry variable=\"Center\" trace_name=\"Center\" type=\"float\" length=\"3\" help=\"Set the center of the cube.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ConeSource\" menu_name=\"Cone\" root_name=\"Cone\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D cone of a given radius and height.\" \n"
"        short_help=\"Create a 3D cone of a given radius and height\">\n"
"  <Source type=\"vtkConeSource\"/>\n"
"  <VectorEntry variable=\"Resolution\" trace_name=\"Resolution\" type=\"int\" help=\"Set the number of faces on this cone\"/>\n"
"  <VectorEntry variable=\"Radius\" trace_name=\"Radius\" type=\"float\" help=\"Set the radius of the widest part of the cone\"/>\n"
"  <VectorEntry variable=\"Height\" trace_name=\"Height\" type=\"float\" help=\"Set the height of the cone\"/>\n"
"  <LabeledToggle variable=\"Capping\" trace_name=\"Capping\" help=\"Set whether to draw the base of the cone\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"CylinderSource\" menu_name=\"Cylinder\" root_name=\"Cyl\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D cylinder of a given radius and height.\" \n"
"        short_help=\"Create a 3D cylinder of a given radius and height\">\n"
"  <Source type=\"vtkCylinderSource\"/>\n"
"  <VectorEntry variable=\"Resolution\" trace_name=\"Resolution\" type=\"int\" help=\"The number of facets used to define the cylinder.\"/>\n"
"  <VectorEntry variable=\"Height\" trace_name=\"Height\" type=\"float\" help=\"The height of the cylinder (along the y axis).\"/>\n"
"  <VectorEntry variable=\"Radius\" trace_name=\"Radius\" type=\"float\" help=\"The radius of the cylinder.\"/>\n"
"  <VectorEntry variable=\"Center\" trace_name=\"Center\" type=\"float\" length=\"3\" help=\"Set the center of the cylinder.\"/>\n"
"  <LabeledToggle variable=\"Capping\" trace_name=\"Capping\" help=\"Set whether to draw the ends of the cylinder\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"LineSource\" menu_name=\"Line\" root_name=\"Line\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"Line between two points. The resolution indicates how many segments are in the line.\" \n"
"        short_help=\"Create a line between two points\">\n"
"  <Source type=\"vtkLineSource\"/>\n"
"  <LineWidget trace_name=\"Line\" point1_variable=\"Point1\" point2_variable=\"Point2\" "
"              point1_label=\"Point 1\" point2_label=\"Point 2\" "
"              show_resolution=\"0\" "
"              help=\"Set the start and end point for the line\"/>\n"
"  <VectorEntry variable=\"Resolution\" trace_name=\"Resolution\" type=\"int\" help=\"The number of pieces that divide the line into.\"/>\n"
"</Module>\n"
"<Module name=\"ImageMandelbrotSource\" menu_name=\"Mandelbrot\" root_name=\"Fractal\" output=\"vtkImageData\" module_type=\"Source\" \n"
"        long_help=\"Representation (unsigned char ) of the Mandlebrot set in up to 3 dimensions.\" \n"
"        short_help=\"Create a Mandelbrot representation\">\n"
"  <Source type=\"vtkImageMandelbrotSource\"/>\n"
"  <VectorEntry label=\"Extent\" trace_name=\"Extent\" variable=\"WholeExtent\" type=\"int\" length=\"6\" help=\"Set the min and max values of the data in each dimension\"/>\n"
"  <VectorEntry label=\"Sub-space\" variable=\"ProjectionAxes\" type=\"int\" length=\"3\" help=\"Choose which axes of the data set to display\"/>\n"
"  <VectorEntry label=\"Origin\" trace_name=\"Origin\" variable=\"OriginCX\" type=\"float\" length=\"4\" help=\"Set the imaginary and real values for C (constant) and X (initial value)\"/>\n"
"  <VectorEntry label=\"Size\" trace_name=\"Size\" variable=\"SizeCX\" type=\"float\" length=\"4\" help=\"Set the inaginary and real values for the world size of the volume for C (constant) and X (initial value)\"/>\n"
"  <VectorEntry label=\"Max. iterations\" trace_name=\"MaxIterations\" variable=\"MaximumNumberOfIterations\" type=\"int\" help=\"The limit on computational iterations. Values less than 2.0 after this many iterations are considered in the set.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"PlaneSource\" menu_name=\"Plane\" root_name=\"Plane\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"Parallelogram given an origin and two points. The resolution indicates the number of division along each axis of the plane.\" \n"
"        short_help=\"Create a parallelogram from an origin and two points\">\n"
"  <Source type=\"vtkPlaneSource\"/>\n"
"  <VectorEntry variable=\"Origin\" trace_name=\"Origin\" type=\"float\" length=\"3\" help=\"Set the position of the origin of the plane.\"/>\n"
"  <VectorEntry label=\"First point\" variable=\"Point1\" trace_name=\"Point1\" type=\"float\" length=\"3\" help=\"Set the position of the point defining the first axis.\"/>\n"
"  <VectorEntry label=\"Second point\" variable=\"Point2\" trace_name=\"Point2\" type=\"float\" length=\"3\" help=\"Set the position of the point defining the second axis.\"/>\n"
"  <VectorEntry label=\"X resolution\" trace_name=\"XResolution\" variable=\"XResolution\" type=\"int\" help=\"The number of x pieces that divide the plane into.\"/>\n"
"  <VectorEntry label=\"Y resolution\" trace_name=\"YResolution\" variable=\"YResolution\" type=\"int\" help=\"The number of y pieces that divide the plane into.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ImageReader\" menu_name=\"Raw File Reader\" root_name=\"ImageRead\" output=\"vtkImageData\" module_type=\"Source\" \n"
"        long_help=\"Read raw regular rectilinear grid data from a file. The dimensions and type of the data must be specified.\" \n"
"        short_help=\"Read raw regular rectilinear grid data from a file\">\n"
"  <Source type=\"vtkImageReader\"/>\n"
"  <FileEntry label=\"File prefix\" trace_name=\"FilePrefix\" variable=\"FilePrefix\" extension=\"\" help=\"Set the file root. Used with file pattern to format a file name. (Make sure that you remove the extension from the name you enter here)\"/>  \n"
"  <StringEntry label=\"File pattern\" trace_name=\"FilePattern\" variable=\"FilePattern\" help=\"Set the format string.\"/>\n"
"  <SelectionList label=\"Data type\" trace_name=\"DataScalarType\" variable=\"DataScalarType\" help=\"Select the pixel type in the file: short, int, float ...\">\n"
"    <Item name=\"char\" value=\"1\"/>\n"
"    <Item name=\"unsigned char\" value=\"2\"/>\n"
"    <Item name=\"short\" value=\"3\"/>\n"
"    <Item name=\"unsigned short\" value=\"4\"/>\n"
"    <Item name=\"int\" value=\"5\"/>\n"
"    <Item name=\"unsigned int\" value=\"6\"/>\n"
"    <Item name=\"long\" value=\"7\"/>\n"
"    <Item name=\"unsigned long\" value=\"9\"/>\n"
"    <Item name=\"float\" value=\"10\"/>\n"
"    <Item name=\"double\" value=\"11\"/>\n"
"  </SelectionList>\n"
"  <SelectionList label=\"Byte order\" trace_name=\"DataByteOrder\" variable=\"DataByteOrder\" help=\"Select the byte order of the binary file\">\n"
"    <Item name=\"big endian\" value=\"0\"/>\n"
"    <Item name=\"little endian\" value=\"1\"/>\n"
"  </SelectionList>\n"
"  <VectorEntry label=\"Origin\" trace_name=\"Origin\" variable=\"DataOrigin\" type=\"float\" length=\"3\" help=\"Set the position of the point with index (0,0,0)\"/>\n"
"  <VectorEntry label=\"Spacing\" trace_name=\"Spacing\" variable=\"DataSpacing\" type=\"float\" length=\"3\" help=\"Set the size of a voxel in each dimension.\"/>\n"
"  <VectorEntry label=\"Extent\" trace_name=\"Extent\" variable=\"DataExtent\" type=\"int\" length=\"6\" help=\"Set the min and max values of the data in each dimension\"/>\n"
"  <VectorEntry label=\"Num. components\" trace_name=\"NumberOfScalarComponents\" variable=\"NumberOfScalarComponents\" type=\"int\" help=\"How many componenets does each pixel have. (i.e. RGB would be 3.)\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"SphereSource\" menu_name=\"Sphere\" root_name=\"Sphere\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"3D sphere given a center and radius.\" \n"
"        short_help=\"Create a 3D sphere\">\n"
"  <Source type=\"vtkSphereSource\"/>\n"
"  <VectorEntry variable=\"Center\" trace_name=\"Center\" type=\"float\" length=\"3\" help=\"Set the coordinates for the center of the sphere.\"/>\n"
"  <VectorEntry variable=\"Radius\" trace_name=\"Radius\" type=\"float\" help=\"Set the radius of the sphere\"/>\n"
"  <VectorEntry label=\"Theta Resolution\" trace_name=\"Theta Resolution\" variable=\"ThetaResolution\" type=\"int\" help=\"Set the number of points in the longitude direction (ranging from Start Theta to End Theta)\"/>\n"
"  <VectorEntry label=\"Start Theta\" trace_name=\"Start Theta\" variable=\"StartTheta\" type=\"float\" help=\"Set the starting angle in the longitude direction\"/>\n"
"  <VectorEntry label=\"End Theta\" trace_name=\"End Theta\" variable=\"EndTheta\" type=\"float\" help=\"Set the ending angle in the longitude direction\"/>\n"
"  <VectorEntry label=\"Phi Resolution\" trace_name=\"Phi Resolution\" variable=\"PhiResolution\" type=\"int\" help=\"Set the number of points in the latitude direction (ranging from Start Phi to End Phi)\"/>\n"
"  <VectorEntry label=\"Start Phi\" trace_name=\"Start Phi\" variable=\"StartPhi\" type=\"float\" help=\"Set the starting angle in the latitude direction\"/>\n"
"  <VectorEntry label=\"End Phi\" trace_name=\"End Phi\" variable=\"EndPhi\" type=\"float\" help=\"Set the ending angle in the latitude direction\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"SuperquadricSource\" menu_name=\"Superquadric\" root_name=\"SQuad\" output=\"vtkPolyData\" module_type=\"Source\" \n"
"        long_help=\"Superquadric according to the theta and phi roundness parameters. This one function can generate a wide variety of 3D objects including a box, a sphere, or a torus.\" \n"
"        short_help=\"Create a superquadric according to the theta and phi roundness parameters\">\n"
"  <Source type=\"vtkSuperquadricSource\"/>\n"
"  <VectorEntry variable=\"Center\" trace_name=\"Center\" type=\"float\" length=\"3\" help=\"Set the center of the superquadric\"/>\n"
"  <VectorEntry variable=\"Scale\" trace_name=\"Scale\" type=\"float\" length=\"3\" help=\"Set the scale of the superquadric\"/>\n"
"  <VectorEntry label=\"Theta resolution\" trace_name=\"ThetaResolution\" variable=\"ThetaResolution\" type=\"int\" help=\"The number of points in the longitude direction.\"/>\n"
"  <VectorEntry variable=\"PhiResolution\" trace_name=\"PhiResolution\" type=\"int\" help=\"The number of points in the latitude direction.\"/>\n"
"  <VectorEntry variable=\"Thickness\" trace_name=\"Thickness\" type=\"float\" help=\"Changing thickness maintains the outside diameter of the toroid.\"/>\n"
"  <VectorEntry label=\"Theta roundness\" trace_name=\"ThetaRoundness\" variable=\"ThetaRoundness\" type=\"float\" help=\"Values range from 0 (rectangular) to 1 (circular) to higher order.\"/>\n"
"  <VectorEntry label=\"Phi roundness\" trace_name=\"PhiRoundness\" variable=\"PhiRoundness\" type=\"float\" help=\"Values range from 0 (rectangular) to 1 (circular) to higher order.\"/>\n"
"  <VectorEntry variable=\"Size\" trace_name=\"Size\" type=\"float\" help=\"Isotropic size\"/>\n"
"  <LabeledToggle variable=\"Toroidal\" trace_name=\"Toroidal\" help=\"Whether or not the superquadric is toroidal or ellipsoidal\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"RTAnalyticSource\" menu_name=\"Wavelet\" root_name=\"RTSource\" output=\"vtkImageData\" module_type=\"Source\" \n"
"        long_help=\"Regular rectilinear grid in up to three dimensions with values varying according to a periodic function.\">\n"
"  <Source type=\"vtkRTAnalyticSource\"/>\n"
"  <VectorEntry label=\"Extent\" trace_name=\"WholeExtent\" variable=\"WholeExtent\" type=\"int\" length=\"6\" help=\"Extent (dimensions) of the function.\"/>\n"
"  <VectorEntry variable=\"Center\" trace_name=\"Center\" type=\"int\" length=\"3\" help=\"Center of the function.\"/>\n"
"  <VectorEntry variable=\"Maximum\" trace_name=\"Maximum\" type=\"float\" help=\"Maximum value of the function\"/>\n"
"  <VectorEntry label=\"X Freq.\" trace_name=\"XFreq\" variable=\"XFreq\" type=\"float\" help=\"Frequency in X\"/>\n"
"  <VectorEntry label=\"Y Freq.\" trace_name=\"YFreq\" variable=\"YFreq\" type=\"float\" help=\"Frequency in Y\"/>\n"
"  <VectorEntry label=\"Z Freq.\" trace_name=\"ZFreq\" variable=\"ZFreq\" type=\"float\" help=\"Frequency in Z\"/>\n"
"  <VectorEntry label=\"X Mag.\" trace_name=\"XMag\" variable=\"XMag\" type=\"float\" help=\"Wave amplitude in X\"/>\n"
"  <VectorEntry label=\"Y Mag.\" trace_name=\"YMag\" variable=\"YMag\" type=\"float\" help=\"Wave amplitude in Y\"/>\n"
"  <VectorEntry label=\"Z Mag.\" trace_name=\"ZMag\" variable=\"ZMag\" type=\"float\" help=\"Wave amplitude in Z\"/>\n"
"  <VectorEntry label=\"Standard dev.\" trace_name=\"StandardDeviation\" variable=\"StandardDeviation\" type=\"float\" help=\"Standard deviation of the gaussian\"/>\n"
"</Module>\n"
"\n"
"</ModuleInterfaces>\n";

// Define the standard filter interfaces.
const char* vtkPVInitialize::StandardFilterInterfaces=
"<ModuleInterfaces>\n"
"<Module name=\"Balance\" root_name=\"Balance\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" multiprocess_support=\"multiple_processes\" \n"
"        long_help=\"Balance data among available processes.\" \n"
"        short_help=\"Load balance filter.\">\n"
"  <Filter type=\"vtkBalancedRedistributePolyData\"/>\n"
"  <InputMenu label=\"Input\" help=\"Balance the number of cells on all processes.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"AllToN\" root_name=\"AllToN\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" multiprocess_support=\"multiple_processes\"\n"
"        long_help=\"Redistribute data to a subset of available processes.\" \n"
"        short_help=\"Repartition data filter.\">\n"
"  <Filter type=\"vtkAllToNRedistributePolyData\"/>\n"
"  <InputMenu label=\"Input\" \n"
"             help=\"Redistribute polydata to a subset of processes.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry trace_name=\"NumberOfProcesses\" variable=\"NumberOfProcesses\" type=\"int\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"CellCenters\" menu_name=\"Cell Centers\" root_name=\"Centers\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"        long_help=\"Create a point (no geometry) at the center of each input cell.\" \n"
"        short_help=\"Convert cells to vertices.\">\n"
"  <Filter type=\"vtkCellCenters\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <LabeledToggle label=\"Generate vertices\" trace_name=\"VertexCells\" variable=\"VertexCells\" help=\"Generate vertex as geometry of just points.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"CellDataToPointData\" root_name=\"CellToPoint\" input=\"vtkDataSet\" output=\"vtkDataSet\" module_type=\"Filter\" \n"
"        long_help=\"Create point attributes by averaging cell attributes.\" \n"
"        short_help=\"Convert cell data to point data.\">\n"
"  <Filter type=\"vtkPCellDataToPointData\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <LabeledToggle label=\"Pass cell data\" trace_name=\"PassCellData\" variable=\"PassCellData\" help=\" Control whether the input cell data is to be passed to the output. If on, then the input cell data is passed through to the output; otherwise, only generated point data is placed into the output.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"CleanPolyData\" menu_name=\"Clean\" root_name=\"CleanPD\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"Merge coincident points if they do not meet a feature edge critera.\" \n"
"        short_help=\"Merge coincident points.\">\n"
"  <Filter type=\"vtkCleanPolyData\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <LabeledToggle label=\"Piece invariant\" trace_name=\"PieceInvariant\" variable=\"PieceInvariant\" help=\"Turn this on to remove seams when running in parallel.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"PVConnectivityFilter\" menu_name=\"Connectivity\" root_name=\"Connect\" input=\"vtkDataSet\" output=\"vtkUnstructuredGrid\" module_type=\"Filter\" \n"
"        long_help=\"Mark connected components with integer point attribute array.\" \n"
"        short_help=\"Find connected components.\">\n"
"  <Filter type=\"vtkPVConnectivityFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"</Module>\n"
"<Module name=\"ImageClip\" menu_name=\"Crop\" root_name=\"ImageClip\" input=\"vtkImageData\" output=\"vtkImageData\" module_type=\"Filter\" replace_input=\"0\" \n"
"        long_help=\"Efficiently extract an area/volume of interest from a 2-d image or 3-d volume.\" \n"
"        short_help=\"Extract a volume of interest.\">\n"
"  <Filter type=\"vtkImageClip\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkImageData\"/>\n"
"  <ExtentEntry label=\"Extent to crop\" trace_name=\"OutputWholeExtent\" variable=\"OutputWholeExtent\" input_menu=\"im\" help=\"Set the min/max extents in each dimension of the output\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"DecimatePro\" menu_name=\"Decimate\" root_name=\"Deci\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"Simplify a polygonal model using an adaptive edge collapse algorithm.  This filter works with triangles only.\" \n"
"        short_help=\"Reduce the number of triangles in a model.\">\n"
"  <Filter type=\"vtkDecimatePro\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Reduction target\" trace_name=\"TargetReduction\" variable=\"TargetReduction\" type=\"float\" help=\"Value between 0 and 1. Desired reduction of the total number of triangles.\"/>\n"
"  <LabeledToggle label=\"Preserve topology\" trace_name=\"PreserveTopology\" variable=\"PreserveTopology\" help=\"If off, better reduction can occur, but model may break up.\"/>\n"
"  <VectorEntry label=\"Feature angle\" trace_name=\"FeatureAngle\" variable=\"FeatureAngle\" type=\"float\" help=\"This angle is used to define a feature edge. (i.e., if the surface normal between two adjacent triangles is >= Feature angle, an edge exists). Topology can be split along feature edges.\"/>\n"
"  <LabeledToggle label=\"Boundary deletable\" trace_name=\"BoundaryVertexDeletion\" variable=\"BoundaryVertexDeletion\" help=\"If off, decimate will not remove points on the boundary.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ElevationFilter\" menu_name=\"Elevation\" root_name=\"Elevation\" input=\"vtkDataSet\" output=\"vtkDataSet\" module_type=\"Filter\"\n"
"        long_help=\"Create point attribute array by projecting points onto an elevation vector.\" \n"
"        short_help=\"Create a point array representing elevation.\">\n"
"  <Filter type=\"vtkElevationFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <VectorEntry label=\"Scalar range\" trace_name=\"ScalarRange\" variable=\"ScalarRange\" type=\"float\" length=\"2\" help=\"Set the range of scalar values to generate\"/>\n"
"  <LineWidget trace_name=\"Line\" point1_variable=\"LowPoint\" point2_variable=\"HighPoint\" "
"              point1_label=\"Low Point\" point2_label=\"High Point\" "
"              use_label=\"0\" show_resolution=\"0\""
"              help=\"Set the minimum and maximum point for elevation\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ExtractEdges\" menu_name=\"Extract Edges\" root_name=\"ExtractEdges\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"        long_help=\"Extract edges of 2-d and 3-d cells as lines.\" \n"
"        short_help=\"Covert data to wireframe.\">\n"
"  <Filter type=\"vtkExtractEdges\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ExtractGrid\" root_name=\"ExtractGrid\" input=\"vtkStructuredGrid vtkImageData vtkStructuredPoints vtkRectilinearGrid\" output=\"vtkStructuredGrid\" module_type=\"Filter\" replace_input=\"0\"\n"
"        long_help=\"Extract a subgrid from a curvilinear grid with the option of setting subsample strides.\" \n"
"        short_help=\"Extract a subgrid or subsample.\">\n"
"  <Filter type=\"vtkExtractGrid\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkStructuredGrid\"/>\n"
"  <ExtentEntry variable=\"VOI\" trace_name=\"VOI\" input_menu=\"im\" help=\"Set the min/max values of the volume of interest (VOI). The output will have the (I,J,K) extent specified here.\"/>\n"
"  <VectorEntry label=\"Sample rate\" trace_name=\"SampleRate\" variable=\"SampleRate\" type=\"int\" length=\"3\" help=\"Set the sampling rate for each dimension\"/>\n"
"  <LabeledToggle label=\"Include boundary\" variable=\"IncludeBoundary\" help=\"Select whether to always include the boundary of the grid in the output\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ExtractVOI\" root_name=\"ExtractVOI\" input=\"vtkImageData vtkStructuredPoints\" output=\"vtkImageData\" module_type=\"Filter\" replace_input=\"0\"\n"
"        long_help=\"Extract a subgrid from a volume/image with the option of setting subsample strides.\" \n"
"        short_help=\"Extract a subvolume or subsample.\">\n"
"  <Filter type=\"vtkExtractVOI\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkImageData\"/>\n"
"  <ExtentEntry variable=\"VOI\" trace_name=\"VOI\" input_menu=\"im\" help=\"Set the min/max values of the volume of interest (VOI). The output will have the (I,J,K) extent specified here.\"/>\n"
"  <VectorEntry label=\"Sample rate\" trace_name=\"SampleRate\" variable=\"SampleRate\" type=\"int\" length=\"3\" help=\"Set the sampling rate for each dimension\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ExtractRectilinearGrid\" menu_name=\"Extract Grid\" root_name=\"ExtractRGrid\" input=\"vtkRectilinearGrid\" output=\"vtkRectilinearGrid\" module_type=\"Filter\" replace_input=\"0\"\n"
"        long_help=\"Extract a subgrid from a rectilinear grid with the option of setting subsample strides.\" \n"
"        short_help=\"Extract a subgrid or subsample.\">\n"
"  <Filter type=\"vtkExtractRectilinearGrid\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkRectilinearGrid\"/>\n"
"  <ExtentEntry variable=\"VOI\" trace_name=\"VOI\" input_menu=\"im\" help=\"Set the min/max values of the volume of interest (VOI). The output will have the (I,J,K) extent specified here.\"/>\n"
"  <VectorEntry label=\"Sample rate\" trace_name=\"SampleRate\" variable=\"SampleRate\" type=\"int\" length=\"3\" help=\"Set the sampling rate for each dimension\"/>\n"
"  <LabeledToggle label=\"Include boundary\" variable=\"IncludeBoundary\" trace_name=\"IncludeBoundary\" help=\"Select whether to always include the boundary of the grid in the output\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"DataSetSurfaceFilter\" menu_name=\"Extract Surface\" root_name=\"Surface\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"        long_help=\"Extract a 2-d boundary surface using neighbor relations to elimate internal faces.\" \n"
"        short_help=\"Extract 2-d boundary surface.\">\n"
"  <Filter type=\"vtkDataSetSurfaceFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"</Module>\n"
"\n"
"  <Module name=\"ExtractVoids\" menu_name=\"Extract Voids\" class=\"vtkPVExtractGeometryByScalar\" \n"
"          root_name=\"ExtractVoids\"\n"
"          output=\"vtkUnstructuredGrid\" input=\"vtkUnstructuredGrid\" module_type=\"Filter\"\n"
"          long_help=\"This filter works with connectivity filter.  It removes regions based on region id.\" \n"
"          short_help=\"Remove geometry based on integer id array.\">\n"
"    <Filter type=\"vtkKWExtractGeometryByScalar\"/>\n"
"  </Module>\n"
"  <Module name=\"Calculator\" class=\"vtkPVArrayCalculator\"\n"
"          root_name=\"Calc\" button_image=\"PVCalculatorButton\"\n"
"          button_help=\"Create new arrays using mathematical operations and existing arrays.\"\n"
"          output=\"vtkDataSet\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\"\n"
"          long_help=\"Compute new attribute arrays as function of existing arrays.\" \n"
"          short_help=\"Compute new attribute arrays.\">\n"
"    <Filter type=\"vtkArrayCalculator\"/>\n"
"  </Module>\n"
"<Module name=\"FeatureEdges\" menu_name=\"Feature Edges\" root_name=\"FeatureEdges\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" replace_input=\"0\" \n"
"        long_help=\"This filter will extract edges along sharp edges of surfaces or boundaries of surfaces.\" \n"
"        short_help=\"Extract edges that meet the feature critera.\">\n"
"  <Filter type=\"vtkFeatureEdges\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <LabeledToggle label=\"Boundary edges\" trace_name=\"BoundaryEdges\" variable=\"BoundaryEdges\" help=\"Turn this off if you do not want to extract boundary edges.\"/>\n"
"  <LabeledToggle label=\"Feature edges\" trace_name=\"FeatureEdges\" variable=\"FeatureEdges\" help=\"Turn this off if you do not want to extract feature edges.\"/>\n"
"  <LabeledToggle label=\"Non-manifold edges\" trace_name=\"NonManifoldEdges\" variable=\"NonManifoldEdges\" help=\"Turn this off if you do not want to extract non-manifold edges.\"/>\n"
"  <LabeledToggle variable=\"Coloring\" trace_name=\"Coloring\" help=\"Turn this off if you do not want to color the edges by type.\"/>\n"
"  <VectorEntry label=\"Feature angle\" trace_name=\"FeatureAngle\" variable=\"FeatureAngle\" type=\"float\" help=\"This angle is used to define a feature edge. (i.e., if the surface normal between two adjacent triangles is >= Feature angle, an edge exists)..\"/>\n"
"</Module>\n"
"\n"
//"<Module name=\"ImageGaussianSmooth\" menu_name=\"Gaussian Smooth\" root_name=\"GaussSmooth\" input=\"vtkImageData\" output=\"vtkImageData\" module_type=\"Filter\">\n"
//"  <Filter type=\"vtkImageGaussianSmooth\"/>\n"
//"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
//"             input_name=\"PVInput\" input_type=\"vtkImageData\"/>\n"
//"  <VectorEntry label=\"Standard dev.\" trace_name=\"StandardDeviations\" variable=\"StandardDeviations\" type=\"float\" length=\"3\" help=\"Standard deviations for x, y and z axes.\"/>\n"
//"  <VectorEntry label=\"Radius factors\" trace_name=\"RadiusFactors\" variable=\"RadiusFactors\" type=\"float\" length=\"3\" help=\"Kernel size is this factor times standard deviation.\"/>\n"
//"  <SelectionList variable=\"Dimensionality\" trace_name=\"Dimensionality\" help=\"Select whether to perform a 2d or 3d gradient\">\n"
//"    <Item name=\"2\" value=\"0\"/>\n"
//"    <Item name=\"3\" value=\"1\"/>\n"
//"  </SelectionList>\n"
//"</Module>\n"
"<Module name=\"PolyDataNormals\" menu_name=\"Generate Normals\" root_name=\"PDNormals\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"          long_help=\"This filter will produce surface normals used for smooth shading.  Spltting is used to avoid smoothing across feature edges.\" \n"
"          short_help=\"Produce surface point normals.\">\n"
"  <Filter type=\"vtkPPolyDataNormals\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Feature angle\" trace_name=\"FeatureAngle\" variable=\"FeatureAngle\" type=\"float\" help=\"Points are duplicated along features over this angle (0->180)\"/>\n"
"  <LabeledToggle variable=\"Splitting\" trace_name=\"Splitting\" help=\"Turn on/off the splitting of sharp edges.\"/>\n"
"  <LabeledToggle variable=\"Consistency\" trace_name=\"Consistency\" help=\"Turn on/off the enforcement of consistent polygon ordering.\"/>\n"
"  <LabeledToggle label=\"Cell normals\" trace_name=\"ComputeCellNormals\" variable=\"ComputeCellNormals\" help=\"Turn on/off the computation of cell normals.\"/>\n"
"  <LabeledToggle label=\"Flip normals\" trace_name=\"FlipNormals\" variable=\"FlipNormals\" help=\"Flipping reverves the meaning of front and back.\"/>\n"
"  <LabeledToggle label=\"Non-manifold\" trace_name=\"NonManifoldTraversal\" variable=\"NonManifoldTraversal\" help=\"Turn on/off traversal across non-manifold edges. This will prevent problems where the consistency of polygonal ordering is corrupted due to topological loops.\"/>\n"
"  <LabeledToggle label=\"Piece invariant\" trace_name=\"PieceInvariant\" variable=\"PieceInvariant\" help=\"Turn this off if you do not want to process ghost levels and do not mind seams.\"/>\n"
"</Module>\n"
"\n"
"\n"
"<Module name=\"LinearExtrusionFilter\" menu_name=\"Linear Extrusion\" root_name=\"LinExtrude\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"        long_help=\"This filter creates a swept surface defined by translating the input along a vector.\" \n"
"        short_help=\"Generate a linear swept surface.\">\n"
"  <Filter type=\"vtkPLinearExtrusionFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Scale factor\" trace_name=\"ScaleFactor\" variable=\"ScaleFactor\" type=\"float\" help=\"Set the extrusion scale factor\"/>\n"
"  <VectorEntry variable=\"Vector\" trace_name=\"Vector\" type=\"float\" length=\"3\" help=\"Set the direction for the extrusion\"/>\n"
"  <LabeledToggle variable=\"Capping\" trace_name=\"Capping\" help=\"Select whether to draw endcaps\"/>\n"
"  <LabeledToggle label=\"Piece invariant\" trace_name=\"PieceInvariant\" variable=\"PieceInvariant\" help=\"Turn this off if you do want to process ghost levels and do not mind seams.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"LoopSubdivisionFilter\" menu_name=\"Loop Subdivision\" root_name=\"LoopSubDiv\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter iteratively divides each triangle into four triangles.  New points are placed so the output surface is smooth.\" \n"
"        short_help=\"Create a higher resolution and smoother surface.\">\n"
"  <Filter type=\"vtkLoopSubdivisionFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Number of divisions\" trace_name=\"NumberOfSubdivisions\" variable=\"NumberOfSubdivisions\" type=\"int\" help=\"Each subdivision changes single triangles into four triangles.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"MaskPoints\" menu_name=\"Mask Points\" root_name=\"MaskPts\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\"\n"
"        long_help=\"Reduce the number of points.  This filter is often used before glyphing.  Generating vertices is an option.\" \n"
"        short_help=\"Reduce the number of points.\">\n"
"  <Filter type=\"vtkMaskPoints\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <VectorEntry label=\"On ratio\" trace_name=\"OnRation\" variable=\"OnRatio\" type=\"int\" help=\"The ratio of points retained.\"/>\n"
"  <VectorEntry label=\"Max. points\" trace_name=\"MaximumNumberOfPoints\" variable=\"MaximumNumberOfPoints\" type=\"int\" help=\"Limit the number of points.\"/>\n"
"  <VectorEntry variable=\"Offset\" trace_name=\"Offset\" type=\"int\" help=\"Start with this point.\"/>\n"
"  <LabeledToggle label=\"Random\" trace_name=\"Random\" variable=\"RandomMode\" help=\"Select whether to randomly select points, or subsample regularly.\"/>\n"
"  <LabeledToggle label=\"Generate vertices\" trace_name=\"GenerateVertices\" variable=\"GenerateVertices\" help=\"Convienience feature to display points.\"/>\n"
"</Module>\n"
"\n"
//"  <Module name=\"Median\"  root_name=\"Median\" \n"
//"          output=\"vtkImageData\" input=\"vtkImageData\"\n"
//"          module_type=\"Filter\">\n"
//"    <Filter type=\"vtkImageMedian3D\"/>\n"
//"    <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
//"               input_name=\"PVInput\" input_type=\"vtkImageData\"/>\n"
//"    <ArrayMenu input_name=\"Input\" attribute_type=\"Scalars\"\n"
//"               label=\"Scalars\" trace_name=\"Scalars\" input_menu=\"im\" number_of_components=\"1\"\n"
//"               help=\"Select the input scalars to process.\"/>\n"
//"    <VectorEntry label=\"Kernel Size\" trace_name=\"KernelSize\" variable=\"KernelSize\" \n"
//"                 type=\"int\" length=\"3\" \n"
//"                 help=\"Determines the smoothing nieghborhood.\"/>\n"
//"  </Module>\n"
//"\n"
"<Module name=\"StructuredGridOutlineFilter\" menu_name=\"Outline (curvilinear)\" root_name=\"GOutline\" input=\"vtkStructuredGrid\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter creates an outline of a curvilinear-grid dataset.  The generated outline follows the input grid.\" \n"
"        short_help=\"Create an outlint of a curvilinear-grid dataset.\">\n"
"  <Filter type=\"vtkStructuredGridOutlineFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkStructuredGrid\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"OutlineFilter\" menu_name=\"Outline\" root_name=\"Outline\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\" replace_input=\"0\" \n"
"        long_help=\"This filter generates a bounding box representation of the input.\" \n"
"        short_help=\"Generates a bounding box.\">\n"
"  <Filter type=\"vtkPOutlineFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"</Module>\n"
"<Module name=\"OutlineCornerFilter\" menu_name=\"Outline Corners\" root_name=\"COutline\" input=\"vtkDataSet\" output=\"vtkPolyData\" module_type=\"Filter\" replace_input=\"0\" \n"
"        long_help=\"This filter generates a bounding box representation of the input.  It only displays the corners of the bounding box.\" \n"
"        short_help=\"Generates corners of a bounding box.\">\n"
"  <Filter type=\"vtkPOutlineCornerFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <VectorEntry label=\"Corner factor\" trace_name=\"CornerFactor\" variable=\"CornerFactor\" type=\"float\" help=\"The relative size of the corners to the length of the corresponding bounds. (0.001 -> 0.5)\"/>\n"
"</Module>\n"
"\n"
"\n"
"<Module name=\"PieceScalars\" menu_name=\"Process Id Scalars\" root_name=\"ColorPieces\" input=\"vtkDataSet\" output=\"vtkDataSet\" module_type=\"Filter\" multiprocess_support=\"multiple_processes\" \n"
"        long_help=\"This filter uses colors to show how data is partitioned across processes.\" \n"
"        short_help=\"Generate point scalars from process id.\">\n"
"  <Filter type=\"vtkPieceScalars\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <LabeledToggle label=\"Random\" trace_name=\"RandomMode\" variable=\"RandomMode\" help=\"Select whether to use random colors for the various pieces\"/>\n"
"</Module>\n"
"\n"
//"  <Module name=\"Pick\" \n"
//"          root_name=\"Pick\"\n"
//"          button_help=\"Pick cell or point closest to the widget\"\n"
//"          output=\"vtkUnstructuredGrid\" input=\"vtkDataSet\"\n"
//"          module_type=\"Filter\">\n"
//"    <Filter type=\"vtkPickDataSetFilter\"/>\n"
//"  <LabeledToggle label=\"Search cells\" trace_name=\"SearchCells\" variable=\"SearchCells\" help=\"Set when cells are supposed to be searched. Otherwise points will be searched.\"/>\n"
//"  <PointWidget variable=\"SamplePoint\" help=\"Sample point that we are picking.\"/>\n"
//"  </Module>\n"
//"\n"
"<Module name=\"PointDataToCellData\" root_name=\"PointToCell\" input=\"vtkDataSet\" output=\"vtkDataSet\" module_type=\"Filter\"\n"
"        long_help=\"Create cell attributes by averaging point attributes.\" \n"
"        short_help=\"Convert point data to cell data.\">\n"
"  <Filter type=\"vtkPointDataToCellData\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <LabeledToggle label=\"Pass point data\" trace_name=\"PassPointData\" variable=\"PassPointData\" help=\"If on, then the input point data is passed through to the output; otherwise, only generated cell data is placed into the output.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"QuadricClustering\" menu_name=\"Quadric Clustering\" root_name=\"QC\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter is the same filter used to generate level of detail for ParaView.  It uses a structure grid of bins and merges all points contained in each bin.\" \n"
"        short_help=\"Simplify polygonal models.\">\n"
"  <Filter type=\"vtkQuadricClustering\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Spacing\" trace_name=\"DivisionSpacing\" variable=\"DivisionSpacing\" type=\"float\" length=\"3\" help=\"Set the spacing of the bins in each dimension\"/>\n"
"  <LabeledToggle label=\"Use input points\" trace_name=\"UseInputPoints\" variable=\"UseInputPoints\" help=\"Select whether to use points from the input in the output or to calculate optimum representative points for each bin\"/>\n"
"  <LabeledToggle label=\"Use feature edges\" trace_name=\"UseFeatureEdges\" variable=\"UseFeatureEdges\" help=\"Select whether to use feature edge quadrics to match up the boundaries between pieces\"/>\n"
"  <LabeledToggle label=\"Use feature points\" trace_name=\"UseFeaturePoints\" variable=\"UseFeaturePoints\" help=\"Select whether to use feature point quadrics to align piece boundaries\"/>\n"
"  <LabeledToggle label=\"Copy cell data\" trace_name=\"CopyCellData\" variable=\"CopyCellData\" help=\"Should cell data be copied from output to input?\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"BrownianPoints\" menu_name=\"Random Vectors\" root_name=\"BPts\" input=\"vtkDataSet\" output=\"vtkDataSet\" module_type=\"Filter\" \n"
"        long_help=\"This filter creates a new 3 component point data array and sets it as the default vectors.  It uses a random number generator to create values.\" \n"
"        short_help=\"Create a new random vector array.\">\n"
"  <Filter type=\"vtkBrownianPoints\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <VectorEntry label=\"Min. speed\" trace_name=\"MinimumSpeed\" variable=\"MinimumSpeed\" type=\"float\" help=\"The minimum size of the random point vectors generated.\"/>\n"
"  <VectorEntry label=\"Max. speed\" trace_name=\"MaximumSpeed\" variable=\"MaximumSpeed\" type=\"float\" help=\"The maximum size of the random point vectors generated.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ReflectionFilter\" menu_name=\"Reflection\" root_name=\"Reflect\" input=\"vtkDataSet\" output=\"vtkUnstructuredGrid\" module_type=\"Filter\" \n"
"        long_help=\"This filter takes the union of the input and its reflection over an axis alligned plane.\" \n"
"        short_help=\"Reflect input over an axis alligned plane.\">\n"
"  <Filter type=\"vtkReflectionFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <SelectionList variable=\"Plane\" trace_name=\"Plane\" help=\"Select which plane of the bounding box to reflect across\">\n"
"    <Item name=\"X Min\" value=\"0\"/>\n"
"    <Item name=\"Y Min\" value=\"1\"/>\n"
"    <Item name=\"Z Min\" value=\"2\"/>\n"
"    <Item name=\"X Max\" value=\"3\"/>\n"
"    <Item name=\"Y Max\" value=\"4\"/>\n"
"    <Item name=\"Z Max\" value=\"5\"/>\n"
"  </SelectionList>\n"
"</Module>\n"
"\n"
"<Module name=\"RibbonFilter\" menu_name=\"Ribbon\" root_name=\"Ribbon\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter generates ribon surface from lines.  It is useful for displaying streamlines.\" \n"
"        short_help=\"Create ribon surfaces from lines.\">\n"
"  <Filter type=\"vtkRibbonFilter\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <ArrayMenu input_name=\"Input\" trace_name=\"Vectors\" attribute_type=\"Vectors\"\n"
"             label=\"Vectors\" input_menu=\"im\" number_of_components=\"3\"\n"
"             help=\"Select the input normals to process.\"/>\n"
"  <VectorEntry variable=\"Width\" trace_name=\"Width\" type=\"float\" help=\"The half width of the ribbon (or minimum).\"/>\n"
"  <VectorEntry variable=\"Angle\" trace_name=\"Angle\" type=\"float\" help=\"The offset angle of the ribbon from the line normal (0->360).\"/>\n"
"  <VectorEntry label=\"Default normal\" trace_name=\"DefaultNormal\" variable=\"DefaultNormal\" type=\"float\" length=\"3\" help=\"When this option is on, default normals will be calculated if the input contains no normals\"/>\n"
"  <LabeledToggle label=\"Vary width\" trace_name=\"VaryWidth\" variable=\"VaryWidth\" help=\"Turn on/off the variation of ribbon width with scalar value.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"RotationalExtrusionFilter\" menu_name=\"Rotational Extrusion\" root_name=\"RotExtrude\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter generates a swept surface while translates the input along a circular path.\" \n"
"        short_help=\"Generates a swept surface using a rotational path.\">\n"
"  <Filter type=\"vtkRotationalExtrusionFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry variable=\"Resolution\" trace_name=\"Resolution\" type=\"int\"/>\n"
"  <LabeledToggle variable=\"Capping\" trace_name=\"Capping\" />\n"
"  <VectorEntry variable=\"Angle\" trace_name=\"Angle\" type=\"float\" help=\"Set the angle of rotation.\"/>\n"
"  <VectorEntry variable=\"Translation\" trace_name=\"Translation\" type=\"float\" help=\"The total amount of translation along the z-axis.\"/>\n"
"  <VectorEntry label=\"Delta radius\" trace_name=\"DeltaRadius\" variable=\"DeltaRadius\" type=\"float\" help=\"The change in radius during sweep process.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ShrinkFilter\" menu_name=\"Shrink\" root_name=\"Shrink\" input=\"vtkDataSet\" output=\"vtkUnstructuredGrid\" module_type=\"Filter\" \n"
"        long_help=\"This filter shrinks each input cell so they pull away from their neighbors.\" \n"
"        short_help=\"Shrink each input cell.\">\n"
"  <Filter type=\"vtkShrinkFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <VectorEntry label=\"Shrink factor\" trace_name=\"ShrinkFactor\" variable=\"ShrinkFactor\" type=\"float\" help=\"Set the amount to shrink by\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"ShrinkPolyData\" menu_name=\"Shrink (polygons)\" root_name=\"ShrinkPD\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter shrinks each input cell so they pull away from their neighbors.  The output is always of type unstructured grid.\" \n"
"        short_help=\"Shrink each input cell.\">\n"
"  <Filter type=\"vtkShrinkPolyData\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Shrink factor\" trace_name=\"ShrinkFactor\" variable=\"ShrinkFactor\" type=\"float\" help=\"Set the amount to shrink by\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"SmoothPolyDataFilter\" menu_name=\"Smooth\" root_name=\"Smooth\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter smooths a polygonal surface by iteratively moving points toward their neighbors.\" \n"
"        short_help=\"Smooth a polygonal surface without adding more points.\">\n"
"  <Filter type=\"vtkSmoothPolyDataFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Num. iterations\" trace_name=\"NumberOfIterations\" variable=\"NumberOfIterations\" type=\"int\" help=\"Number of iterations. More iterations produces better smoothing.\"/>\n"
"  <VectorEntry variable=\"Convergence\" trace_name=\"Convergence\" type=\"float\" help=\"Convergence criterion for the iteration process. Smaller numbers result in more smoothing iterations (0->1).\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"Stripper\" menu_name=\"Triangle Strips\" root_name=\"Strip\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter uses a greedy algorythm to convert triangles into triangle strips\" \n"
"        short_help=\"Convert triangles into triangle strips.\">\n"
"  <Filter type=\"vtkStripper\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Max. length\" trace_name=\"MaximumLength\" variable=\"MaximumLength\" type=\"int\" help=\"Stop stripping after this many triangles.\"/>\n"
"</Module>\n"
"\n"
"  <Module name=\"Subdivide\" root_name=\"Subdivide\" \n"
"          input=\"vtkPolyData\" output=\"vtkPolyData\"\n"
"          module_type=\"Filter\" \n"
"          button_help=\"Subdivide the poly data into more polygons\"\n"
"          long_help=\"This filter iteratively divide triangles into four smaller triangles.  New points are placed linearly so the output surface matches the input surface.\" \n"
"          short_help=\"Creates a surface with more triangles than the input.\">\n"
"    <VectorEntry label=\"Num. divisions\" trace_name=\"NumberOfSubdivisions\" variable=\"NumberOfSubdivisions\" type=\"int\" \n"
"                 help=\"Set the number of subdivisions\"/>\n"
"    <Filter type=\"vtkLinearSubdivisionFilter\"/>\n"
"  </Module>\n"
"<Module name=\"DataSetTriangleFilter\" menu_name=\"Tetrehedralize\" root_name=\"Tetra\" input=\"vtkDataSet\" output=\"vtkUnstructuredGrid\" module_type=\"Filter\" \n"
"        long_help=\"This filter converts 3-d cells to tetrahedrons and polygons to triangles.  The output is always of type unstructured grid.\" \n"
"        short_help=\"Convert to tetrahedrons and triangles.\">\n"
"  <Filter type=\"vtkDataSetTriangleFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"TriangleFilter\" menu_name=\"Triangulate\" root_name=\"Tri\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"This filter converts polygons and traingle strips to basic triangles.\" \n"
"        short_help=\"Convert polygonal data to triangles.\">\n"
"  <Filter type=\"vtkTriangleFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"TubeFilter\" menu_name=\"Tube\" root_name=\"Tuber\" input=\"vtkPolyData\" output=\"vtkPolyData\" module_type=\"Filter\" \n"
"        long_help=\"Convert lines into tubes.  Normals are used to avoid cracks between tube segments.\" \n"
"        short_help=\"Convert lines into tubes.\">\n"
"  <Filter type=\"vtkTubeFilter\"/>\n"
"  <InputMenu label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPolyData\"/>\n"
"  <VectorEntry label=\"Num. sides\" variable=\"NumberOfSides\" trace_name=\"NumberOfSides\" type=\"int\" help=\"Set the number of sides for the tube\"/>\n"
"  <LabeledToggle variable=\"Capping\" trace_name=\"Capping\" help=\"Select whether to draw endcaps on the tube\"/>\n"
"  <VectorEntry variable=\"Radius\" trace_name=\"Radius\" type=\"float\" help=\"Set the radius of the tube\"/>\n"
"  <SelectionList label=\"Vary radius\" trace_name=\"VaryRadius\" variable=\"VaryRadius\" help=\"Select whether/how to vary the radius of the tube\">\n"
"    <Item name=\"Off\" value=\"0\"/>\n"
"    <Item name=\"ByScalar\" value=\"1\"/>\n"
"    <Item name=\"ByVector\" value=\"2\"/>\n"
"  </SelectionList>\n"
"  <VectorEntry label=\"Radius factor\" trace_name=\"RadiusFactor\" variable=\"RadiusFactor\" type=\"float\" help=\"Set the maximum tube radius in terms of a multiple of the minimum radius\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"WarpScalar\" menu_name=\"Warp\" root_name=\"WarpS\" input=\"vtkPointSet\" output=\"vtkPointSet\" default=\"scalars\" module_type=\"Filter\" \n"
"        long_help=\"This filter moves point coordinates along a vector scaled by a point attribute.  It can be used to produce carpet plots.\" \n"
"        short_help=\"Warp point scalars into a spatial elevation plot.\">\n"
"  <Filter type=\"vtkWarpScalar\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\"\n"
"             help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPointSet\"/>\n"
"  <ArrayMenu input_name=\"Input\" attribute_type=\"Scalars\" trace_name=\"Scalars\" \n"
"             label=\"Scalars\" input_menu=\"im\"\n"
"             help=\"Select the input scalars to process.\"/>\n"
"  <VectorEntry label=\"Scale factor\" variable=\"ScaleFactor\" trace_name=\"ScaleFactor\" type=\"float\" help=\"Displacement is vector times scale.\"/>\n"
"  <VectorEntry variable=\"Normal\" trace_name=\"Normal\" type=\"float\" length=\"3\" help=\"Warp direction.\"/>\n"
"  <LabeledToggle label=\"Use normal\" trace_name=\"UseNormal\" variable=\"UseNormal\" help=\"Use instance model normals rather than instance normal.\"/>\n"
"  <LabeledToggle label=\"X-Y plane\" trace_name=\"XYPlane\" variable=\"XYPlane\" help=\"Z value is used to warp the surface, scalars to color surface.\"/>\n"
"</Module>\n"
"\n"
"<Module name=\"WarpVector\" root_name=\"WarpV\"\n" 
"      button_image=\"PVVectorDisplacementButton\"\n"
"      button_help=\"Warp (displace) the geometry with a given vector field.\"\n"
"      input=\"vtkPointSet\" output=\"vtkPointSet\" default=\"vectors\" \n"
"      module_type=\"Filter\"\n"
"      long_help=\"This filter displaces point coordinates along a vector attribute.  It is useful for showing mechanical deformation.\" \n"
"      short_help=\"Warp (displace) the geometry with a given vector field.\">\n"
"  <Filter type=\"vtkWarpVector\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\"\n"
"             help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkPointSet\"/>\n"
"  <ArrayMenu input_name=\"Input\" attribute_type=\"Vectors\" trace_name=\"Vectors\" \n"
"             label=\"Vectors\" input_menu=\"im\" number_of_components=\"3\"\n"
"             help=\"Select the input vectors to process.\"/>\n"
"  <VectorEntry label=\"Scale factor\" trace_name=\"ScaleFactor\" variable=\"ScaleFactor\" type=\"float\" help=\"Displacement is vector times scale.\"/>\n"
"</Module>\n"
"\n"
"  <Module name=\"Cut\" root_name=\"Cut\" replace_input=\"0\"\n" 
"          output=\"vtkPolyData\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\" button_image=\"PVCutButton\"\n"
"          button_help=\"Cut with an implicit plane or sphere. "
"Cutting typically reduces the dimensionality of the data.\"\n"
"          long_help=\"This filter cuts a data set with a plane or sphere.  Cutting is similar to a contour.  It creates surfaces from volumes and lines from surfaces.\" \n"
"          short_help=\"Cut datasets with planes or spheres.\">\n"
"    <Filter type=\"vtkCutter\"/>\n"
"    <InputMenu id=\"im1\" label=\"Input\" help=\"Set the input to this "
"filter.\"\n"
"               input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"    <BoundsDisplay show_hide_frame=\"1\" label=\"Input Bounds\"\n"
"                   trace_name=\"Input Bounds\" input_menu=\"im1\"/>\n"
"    <SelectWidget use_widget_command=\"1\" label=\"Cut Function\"\n"
"                  trace_name=\"Cut Function\" variable=\"CutFunction\">\n"
"      <Item label=\"Plane\" value=\"GetPlaneTclName\">\n"
"        <ImplicitPlaneWidget trace_name=\"Plane\" use_label=\"0\" "
"               help=\"Adjusts the parameters of the plane to cut with.\"/>\n"
"      </Item>\n"
"      <Item label=\"Sphere\" value=\"GetSphereTclName\">\n"
"        <SphereWidget trace_name=\"Sphere\" use_label=\"0\" "
"               help=\"Adjusts the parameters of the sphere to cut with.\"/>\n"
"      </Item>\n"
"    </SelectWidget>\n"
"    <ContourEntry label=\"Cut Offset Values\" trace_name=\"Cut Values\""
"                  help=\"List of current offset values. This can be used "
"to create multiple cut planes/spheres with different centers. Each entry "
"represents a new cut with center shifted by the offset value.\"/>\n"
"  </Module>\n"
"  <Module name=\"Clip\" root_name=\"Clip\"\n"
"          output=\"vtkUnstructuredGrid\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\" button_image=\"PVClipButton\"\n"
"          button_help=\"Clip with an implicit plane, sphere or with scalars."
" Clipping does not reduce the dimensionality of the data set.\"\n"
"          long_help=\"Clip with an implicit plane, sphere or with scalars. Clipping does not reduce the dimensionality of the data set.  This output data type of this filter is always an unstructured grid.\" \n"
"          short_help=\"Clip with an implicit plane, sphere or with scalars.\">\n"
"    <Filter type=\"vtkClipDataSet\"/>\n"
"    <InputMenu id=\"im1\" label=\"Input\" \n"
"               help=\"Set the input to this filter.\"\n"
"               input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"    <BoundsDisplay show_hide_frame=\"1\" label=\"Input Bounds\"\n"
"                   trace_name=\"Input Bounds\" input_menu=\"im1\"/>\n"
"    <SelectWidget use_widget_command=\"1\" label=\"Clip Function\"\n"
"                  trace_name=\"Clip Function\" variable=\"ClipFunction\">\n"
"      <Item label=\"Plane\" value=\"GetPlaneTclName\">\n"
"        <ImplicitPlaneWidget use_label=\"0\" trace_name=\"Plane\" "
"            help=\"Adjusts the parameters of the plane to clip with.\"/>\n"
"      </Item>\n"
"      <Item label=\"Sphere\" value=\"GetSphereTclName\">\n"
"        <SphereWidget use_label=\"0\" trace_name=\"Sphere\" "
"            help=\"Adjusts the parameters of the sphere to clip with.\"/>\n"
"      </Item>\n"
"      <Item label=\"Scalars\">\n"
"        <ContainerWidget>\n"
"         <Item>\n"
"           <ScalarRangeLabel trace_name=\"ScalarRange\" array_menu=\"it3.am1\"/>\n"
"         </Item>\n"
"         <Item id=\"it3\">\n"
"           <ArrayMenu id=\"am1\" input_name=\"Input\"\n"
"                      attribute_type=\"Scalars\" trace_name=\"Scalars\" \n"
"                      label=\"Scalars\"\n"
"                      help=\"Choose the clipping scalar array.\"\n"
"                      input_menu=\"im1\"/>\n"
"         </Item>\n"
"         <Item>\n"
"           <VectorEntry label=\"Clip value\" trace_name=\"Offset\" "
"                        type=\"float\" variable=\"Value\" "
"                        help=\"Choose the scalar value to clip with\"/>\n"
"         </Item>\n"
"        </ContainerWidget>\n"
"      </Item>\n"
"    </SelectWidget>\n"
"    <LabeledToggle label=\"Inside Out\" trace_name=\"InsideOut\" variable=\"InsideOut\"\n"
"                   help=\"Switches which part to keep.\"/>\n"
"  </Module>\n"
"  <Module name=\"Threshold\" class=\"vtkPVThreshold\" \n"
"          root_name=\"Threshold\" button_image=\"PVThresholdButton\"\n"
"          button_help=\"Extract cells that satisfy a threshold criterion.\"\n"
"          output=\"vtkUnstructuredGrid\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\"\n"
"          long_help=\"This filter extracts cells that have point scalars in the specified range.\" \n"
"          short_help=\"Extract cells that satisfy a threshold criterion.\">\n"
"    <Filter type=\"vtkThreshold\"/>\n"
"  </Module>\n"
"  <Module name=\"Contour\" class=\"vtkPVContour\" \n"
"          root_name=\"Contour\" button_image=\"PVContourButton\"\n"
"          button_help=\"Generate isolines or isosurfaces.\"\n"
"          output=\"vtkPolyData\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\"\n"
"          long_help=\"Generate isolines or isosurfaces using point scalars.\" \n"
"          short_help=\"Generate isolines or isosurfaces.\">\n"
#ifdef VTK_USE_PATENTED
"    <Filter type=\"vtkKitwareContourFilter\"/>\n"
#else
"    <Filter type=\"vtkContourFilter\"/>\n"
#endif
"  </Module>\n"
"  <Module name=\"Glyph\" class=\"vtkPVGlyph3D\" root_name=\"Glyph\" \n"
"          input=\"vtkDataSet\" output=\"vtkPolyData\"\n"
"          module_type=\"Filter\" button_image=\"PVGlyphButton\"\n"
"          button_help=\"Generate a glyph (symbol) at each point of "
"the dataset. These can be colored, scaled and oriented\"\n"
"          long_help=\"This filters generates an arrow, sphere, or cone at each point of the input data set.  The glyphs can be oriented and scale by the input point attributes.\" \n"
"          short_help=\"Generate a glyph symbol at each point of the input data set.\">\n"
"    <Filter type=\"vtkGlyph3D\"/>\n"
"    <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"               input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"    <SelectWidget variable=\"Orient\">\n"
"      <Item label=\"Vector\" value=\"1\">\n"
"        <ArrayMenu input_name=\"Input\" attribute_type=\"Vectors\" trace_name=\"Vectors\" \n"
"                   label=\"Vectors\" input_menu=\"im\" number_of_components=\"3\"\n"
"                   help=\"Select the input vectors used to orient to glyphs.\"/>\n"
"      </Item>\n"
"      <Item label=\"Off\"  value=\"0\">\n"
"        <DummyWidget/>\n"
"      </Item>\n"
"    </SelectWidget>\n"
"    <SelectWidget label=\"Scale Mode\" variable=\"ScaleMode\" trace_name=\"Scale Mode\" >\n"
"      <Item label=\"Scalar\" value=\"0\">\n"
"        <ArrayMenu input_name=\"Input\" attribute_type=\"Scalars\" trace_name=\"Scalars\" \n"
"                   label=\"Scalars\" input_menu=\"im\" number_of_components=\"1\"\n"
"                   help=\"Choose the scalar array used to scale the glyphs.\"/>\n"
"      </Item>\n"
"      <Item label=\"Vector Magnitude\"  value=\"1\">\n"
"        <DummyWidget/>\n"
"      </Item>\n"
"      <Item label=\"Vector Components\"  value=\"2\">\n"
"        <DummyWidget/>\n"
"      </Item>\n"
"      <Item label=\"Data Scaling Off\"  value=\"3\">\n"
"        <DummyWidget/>\n"
"      </Item>\n"
"    </SelectWidget>\n"
"  <VectorEntry label=\"Scale Factor\" trace_name=\"Scale Factor\" variable=\"ScaleFactor\" type=\"float\" help=\"Scale the glyphs by this constant\"/>\n"
"  </Module>\n"
"  <Module name=\"Probe\" class=\"vtkPVProbe\" \n"
"          root_name=\"Probe\" button_image=\"PVProbeButton\"\n"
"          button_help=\"Sample data values at a point or along a"
"line\"\n"
"          output=\"vtkPolyData\" input=\"vtkDataSet\"\n"
"          module_type=\"Filter\"\n"
"          long_help=\"Sample data attributes at a point or along a line.  Probed lines will be displayed in a graph of the attributes.\"\n" 
"          short_help=\"Sample data values at a point or along a line.\">\n"
"    <Filter type=\"vtkPProbeFilter\"/>\n"
"    <SelectWidget use_widget_command=\"1\" label=\"Probe object\"\n"
"                  variable=\"Input\">\n"
"      <Item label=\"Point\" value=\"GetOutputTclName\">\n"
"          <PointSourceWidget trace_name=\"Point\" />\n"
"      </Item>\n"
"      <Item label=\"Line\" value=\"GetOutputTclName\">\n"
"          <LineSourceWidget trace_name=\"Line\" />\n"
"      </Item>\n"
"    </SelectWidget>\n"
"  </Module>\n"
" <Module name=\"StreamTracer\" root_name=\"Stream\" input=\"vtkDataSet\" \n"
"         output=\"vtkPolyData\" multiprocess_support=\"single_process\"\n"
"         module_type=\"Filter\" replace_input=\"0\"\n"
"         button_image=\"PVStreamTracerButton\"\n"
"         button_help=\"Generate streamtraces from a collection of seed points.\" \n"
"         long_help=\"Integrate streamlines in a vector field.\"\n" 
"         short_help=\"Integrate streamlines in a vector field.\">\n"
"  <Filter type=\"vtkStreamTracer\"/>\n"
"  <InputMenu id=\"im\" label=\"Input\" help=\"Set the input to this filter.\"\n"
"             input_name=\"PVInput\" input_type=\"vtkDataSet\"/>\n"
"  <ArrayMenu input_name=\"Input\" attribute_type=\"Vectors\" trace_name=\"Vectors\" \n"
"             label=\"Vectors\" input_menu=\"im\" number_of_components=\"3\"\n"
"             help=\"Select the input vectors to use.\"/>\n"
"  <SelectWidget use_widget_command=\"1\" label=\"Seed\"\n"
"                variable=\"Source\">\n"
"      <Item label=\"Point Cloud\" value=\"GetOutputTclName\">\n"
"          <PointSourceWidget trace_name=\"Point\" />\n"
"      </Item>\n"
"      <Item label=\"Line\" value=\"GetOutputTclName\">\n"
"          <LineSourceWidget trace_name=\"Line\" />\n"
"      </Item>\n"
"  </SelectWidget>\n"
"  <ContainerWidget pack_direction=\"left\" trace_name=\"MaxProp\">\n"
"      <Item>\n"
"        <SelectionList variable=\"MaximumPropagationUnit\" trace_name=\"MaximumPropagationUnit\" \n"
"                       label=\"Max. Propagation\" option_width=\"15\"\n"
"                       help=\"Maximum propagation\">\n"
"          <Item name=\"Time\" value=\"0\"/>\n"
"          <Item name=\"Length\" value=\"1\"/>\n"
"        </SelectionList>\n"
"      </Item>\n"
"      <Item>\n"
"        <VectorEntry label=\"\" variable=\"MaximumPropagation\" type=\"float\"\n"
"                     trace_name=\"MaxPropLen\" help=\"Maximum propagation\"/>\n"
"      </Item>\n"
"  </ContainerWidget>\n"
"\n"
"  <ContainerWidget pack_direction=\"left\" trace_name=\"InitLen\">\n"
"      <Item>\n"
"        <SelectionList trace_name=\"InitialIntegrationStepUnit\" variable=\"InitialIntegrationStepUnit\" \n"
"                       label=\"Init. Step Len.\"  option_width=\"15\"\n"
"                       help=\"Initial step length\">\n"
"          <Item name=\"Time\" value=\"0\"/>\n"
"          <Item name=\"Length\" value=\"1\"/>\n"
"          <Item name=\"Cell Length\" value=\"2\"/>\n"
"        </SelectionList>\n"
"      </Item>\n"
"      <Item>\n"
"        <VectorEntry label=\"\" variable=\"InitialIntegrationStep\" type=\"float\"\n"
"                     trace_name=\"InitLen\" help=\"Initial step length\"/>\n"
"      </Item>\n"
"  </ContainerWidget>\n"
"\n"
"  <SelectionList trace_name=\"IntegrationDirection\" variable=\"IntegrationDirection\"  option_width=\"15\">\n"
"    <Item name=\"FORWARD\"  value=\"0\"/>\n"
"    <Item name=\"BACKWARD\" value=\"1\"/>\n"
"  </SelectionList>\n"
"\n"
"  <SelectWidget variable=\"IntegratorType\" trace_name=\"IntegrationType\" >\n"
"    <Item label=\"Runge-Kutta 2\"  value=\"0\">\n"
"     <DummyWidget/>\n"
"    </Item>\n"
"    <Item label=\"Runge-Kutta 4\" value=\"1\">\n"
"     <DummyWidget/>\n"
"    </Item>\n"
"    <Item label=\"Runge-Kutta 4-5\" value=\"2\">\n"
"     <ContainerWidget>\n"
"      <Item>\n"
"       <ContainerWidget pack_direction=\"left\" trace_name=\"MinLen\">\n"
"        <Item>\n"
"         <SelectionList variable=\"MinimumIntegrationStepUnit\" trace_name=\"MinimumIntegrationStepUnit\" \n"
"                       label=\"Min. Step Len.\"  option_width=\"15\"\n"
"                       help=\"Minimum step length used in the integation\">\n"
"          <Item name=\"Time\" value=\"0\"/>\n"
"          <Item name=\"Length\" value=\"1\"/>\n"
"          <Item name=\"Cell Length\" value=\"2\"/>\n"
"         </SelectionList>\n"
"        </Item>\n"
"        <Item>\n"
"         <VectorEntry label=\"\" variable=\"MinimumIntegrationStep\" type=\"float\"\n"
"                      trace_name=\"MinLen\"  \n"
"                      help=\"Minimum step length  used in the integation\"/>\n"
"        </Item>\n"
"       </ContainerWidget>\n"
"      </Item>\n"
"\n"
"      <Item>\n"
"       <ContainerWidget pack_direction=\"left\" trace_name=\"MaxLen\">\n"
"        <Item>\n"
"         <SelectionList variable=\"MaximumIntegrationStepUnit\" trace_name=\"MaximumIntegrationStepUnit\" \n"
"                        label=\"Max. Step Len.\"  option_width=\"15\"\n"
"                        help=\"Maximum step length used in the integration\">\n"
"           <Item name=\"Time\" value=\"0\"/>\n"
"           <Item name=\"Length\" value=\"1\"/>\n"
"           <Item name=\"Cell Length\" value=\"2\"/>\n"
"         </SelectionList>\n"
"        </Item>\n"
"        <Item>\n"
"         <VectorEntry label=\"\" variable=\"MaximumIntegrationStep\" type=\"float\"\n"
"                      trace_name=\"MaxLen\" \n"
"                      help=\"Maximum step length used in the integration\"/>\n"
"        </Item>\n"
"       </ContainerWidget>\n"
"      </Item>\n"
"      <Item>\n"
"       <VectorEntry label=\"Maximum Error\" trace_name=\"MaximumError\" variable=\"MaximumError\" \n"
"                      type=\"float\" \n"
"                      help=\"Maximum error allowed in the integration\"/>\n"
"      </Item>\n"
"     </ContainerWidget>\n"
"    </Item>\n"
"  </SelectWidget>\n"
"  <VectorEntry label=\"Max. Steps\" trace_name=\"MaximumNumberOfSteps\" variable=\"MaximumNumberOfSteps\" type=\"int\"\n"
"               help=\"Maximum number of steps.\"/>\n"
"  <VectorEntry label=\"Term. Speed\" trace_name=\"TerminalSpeed\" variable=\"TerminalSpeed\" \n"
"               type=\"float\" \n"
"               help=\"Terminal speed. The integration will be stopped if the speed (absolute value) is smaller than this threshold\"/>\n"
"\n"
"\n"
" </Module>\n"
"</ModuleInterfaces>\n";

// Define the standard manipulators.
const char* vtkPVInitialize::StandardManipulators=
"<ModuleInterfaces>\n"
"  <Manipulator name=\"FlyIn\" types=\"3D\" class=\"vtkPVJoystickFlyIn\">\n"
"    <Scale variable=\"FlySpeed\" resolution=\".1\" range=\"1 30\" help=\"Set the speed of the camera in fly-in/out modes.\"/>\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"FlyOut\" types=\"3D\" class=\"vtkPVJoystickFlyOut\">\n"
"    <Scale variable=\"FlySpeed\" resolution=\".1\" range=\"1 30\" help=\"Set the speed of fly-out camera manipulation.\"/>\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"Rotate\" types=\"3D\" class=\"vtkPVTrackballRotate\">\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"Roll\" types=\"2D 3D\" class=\"vtkPVTrackballRoll\">\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"Pan\" types=\"2D 3D\" class=\"vtkPVTrackballPan\">\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"Move\" types=\"2D 3D\" class=\"vtkPVTrackballMoveActor\">\n"
"  </Manipulator>\n"
"\n"
"  <Manipulator name=\"Zoom\" types=\"2D 3D\" class=\"vtkPVTrackballZoom\">\n"
"  </Manipulator>\n"
"\n"
"</ModuleInterfaces>\n";


// Define the standard writers.
const char* vtkPVInitialize::StandardWriters=
"<ModuleInterfaces>\n"
"  <Writer input=\"vtkDataSet\"\n"
"          class=\"vtkPVWriter\"\n"
"          writer=\"vtkDataSetWriter\"\n"
"          data_mode_method=\"SetFileTypeToBinary\"\n"
"          extension=\".vtk\"\n"
"          file_description=\"VTK Files\"/>\n"
"  <Writer input=\"vtkDataSet\"\n"
"          class=\"vtkPVWriter\"\n"
"          writer=\"vtkPDataSetWriter\"\n"
"          data_mode_method=\"SetFileTypeToBinary\"\n"
"          parallel=\"1\"\n"
"          extension=\".pvtk\"\n"
"          file_description=\"PVTK Files\"/>\n"
"</ModuleInterfaces>\n";

#endif
