/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkXMLPDataReader.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkXMLPDataReader - Superclass for PVTK XML file readers.
// .SECTION Description
// vtkXMLPDataReader provides functionality common to all PVTK XML
// file readers.  Concrete subclasses call upon this functionality
// when needed.

// .SECTION See Also
// vtkXMLDataReader

#ifndef __vtkXMLPDataReader_h
#define __vtkXMLPDataReader_h

#include "vtkXMLReader.h"

class vtkDataArray;
class vtkDataSet;
class vtkXMLDataReader;

class VTK_ALTIO_EXPORT vtkXMLPDataReader : public vtkXMLReader
{
public:
  vtkTypeRevisionMacro(vtkXMLPDataReader,vtkXMLReader);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Get the number of pieces from the summary file being read.
  vtkGetMacro(NumberOfPieces, int);  
  
protected:
  vtkXMLPDataReader();
  ~vtkXMLPDataReader();
  
  // Pipeline execute information driver.  Called by vtkXMLReader.
  void ReadXMLInformation();
  int ReadPrimaryElement(vtkXMLDataElement* ePrimary);
  
  vtkDataSet* GetPieceInputAsDataSet(int piece);
  void SetupOutputInformation();
  void SetupOutputData();
  
  virtual vtkXMLDataReader* CreatePieceReader()=0;
  virtual vtkIdType GetNumberOfPoints()=0;
  virtual vtkIdType GetNumberOfCells()=0;
  virtual void CopyArrayForPoints(vtkDataArray* inArray,
                                  vtkDataArray* outArray)=0;
  virtual void CopyArrayForCells(vtkDataArray* inArray,
                                 vtkDataArray* outArray)=0;
  
  virtual void SetupPieces(int numPieces);
  virtual void DestroyPieces();
  int ReadPiece(vtkXMLDataElement* ePiece, int index);
  virtual int ReadPiece(vtkXMLDataElement* ePiece);
  int ReadPieceData(int index);
  virtual int ReadPieceData();
  int CanReadPiece(int index);
  
  char* CreatePieceFileName(const char* fileName);
  void SplitFileName();
  
  // Pieces from the input summary file.
  int NumberOfPieces;
  
  // The ghost level available on each input piece.
  int GhostLevel;
  
  // The piece currently being read.
  int Piece;
  
  // The path to the input file without the file name.
  char* PathName;
  
  // Information per-piece.
  vtkXMLDataElement** PieceElements;
  vtkXMLDataReader** PieceReaders;
  int* CanReadPieceFlag;
  
  // The PPointData and PCellData element representations.
  vtkXMLDataElement* PPointDataElement;
  vtkXMLDataElement* PCellDataElement;
  
private:
  vtkXMLPDataReader(const vtkXMLPDataReader&);  // Not implemented.
  void operator=(const vtkXMLPDataReader&);  // Not implemented.
};

#endif
