/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.draw;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.SVGTexturePaint;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.PathGradientPaint;
import org.apache.poi.util.Internal;
import org.w3c.dom.Element;

@Internal
public class SVGRenderExtension
extends DefaultExtensionHandler {
    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext generatorContext) {
        if (paint instanceof LinearGradientPaint) {
            return this.getLgpDescriptor((LinearGradientPaint)paint, generatorContext);
        }
        if (paint instanceof RadialGradientPaint) {
            return this.getRgpDescriptor((RadialGradientPaint)paint, generatorContext);
        }
        if (paint instanceof PathGradientPaint) {
            return this.getPathDescriptor((PathGradientPaint)paint, generatorContext);
        }
        return super.handlePaint(paint, generatorContext);
    }

    private SVGPaintDescriptor getPathDescriptor(PathGradientPaint gradient, SVGGeneratorContext genCtx) {
        RenderingHints hints = genCtx.getGraphicContextDefaults().getRenderingHints();
        Shape shape = (Shape)hints.get(Drawable.GRADIENT_SHAPE);
        if (shape == null) {
            return null;
        }
        PathGradientPaint.PathGradientContext context = gradient.createContext(ColorModel.getRGBdefault(), shape.getBounds(), shape.getBounds2D(), new AffineTransform(), hints);
        WritableRaster raster = context.createRaster();
        BufferedImage img = new BufferedImage(context.getColorModel(), raster, false, null);
        SVGTexturePaint texturePaint = new SVGTexturePaint(genCtx);
        TexturePaint tp = new TexturePaint(img, shape.getBounds2D());
        return texturePaint.toSVG(tp);
    }

    private SVGPaintDescriptor getRgpDescriptor(RadialGradientPaint gradient, SVGGeneratorContext genCtx) {
        Element gradElem = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        String id = genCtx.getIDGenerator().generateID("gradient");
        gradElem.setAttribute("id", id);
        SVGRenderExtension.setPoint(gradElem, gradient.getCenterPoint(), "cx", "cy");
        SVGRenderExtension.setPoint(gradElem, gradient.getFocusPoint(), "fx", "fy");
        gradElem.setAttribute("r", String.valueOf(gradient.getRadius()));
        this.addMgpAttributes(gradElem, genCtx, gradient);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradElem);
    }

    private SVGPaintDescriptor getLgpDescriptor(LinearGradientPaint gradient, SVGGeneratorContext genCtx) {
        Element gradElem = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        String id = genCtx.getIDGenerator().generateID("gradient");
        gradElem.setAttribute("id", id);
        SVGRenderExtension.setPoint(gradElem, gradient.getStartPoint(), "x1", "y1");
        SVGRenderExtension.setPoint(gradElem, gradient.getEndPoint(), "x2", "y2");
        this.addMgpAttributes(gradElem, genCtx, gradient);
        return new SVGPaintDescriptor("url(#" + id + ")", "1", gradElem);
    }

    private void addMgpAttributes(Element gradElem, SVGGeneratorContext genCtx, MultipleGradientPaint gradient) {
        String cycleVal;
        gradElem.setAttribute("gradientUnits", "userSpaceOnUse");
        switch (gradient.getCycleMethod()) {
            case REFLECT: {
                cycleVal = "reflect";
                break;
            }
            case REPEAT: {
                cycleVal = "repeat";
                break;
            }
            default: {
                cycleVal = "pad";
            }
        }
        gradElem.setAttribute("spreadMethod", cycleVal);
        String colorSpace = gradient.getColorSpace() == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB ? "linearRGB" : "sRGB";
        gradElem.setAttribute("color-interpolation", colorSpace);
        AffineTransform tf = gradient.getTransform();
        if (!tf.isIdentity()) {
            String matrix = "matrix(" + tf.getScaleX() + " " + tf.getShearY() + " " + tf.getShearX() + " " + tf.getScaleY() + " " + tf.getTranslateX() + " " + tf.getTranslateY() + ")";
            gradElem.setAttribute("gradientTransform", matrix);
        }
        Color[] colors = gradient.getColors();
        float[] fracs = gradient.getFractions();
        for (int i = 0; i < colors.length; ++i) {
            Element stop = genCtx.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "stop");
            SVGPaintDescriptor pd = SVGColor.toSVG((Color)colors[i], (SVGGeneratorContext)genCtx);
            stop.setAttribute("offset", (int)(fracs[i] * 100.0f) + "%");
            stop.setAttribute("stop-color", pd.getPaintValue());
            if (colors[i].getAlpha() != 255) {
                stop.setAttribute("stop-opacity", pd.getOpacityValue());
            }
            gradElem.appendChild(stop);
        }
    }

    private static void setPoint(Element gradElem, Point2D point, String x, String y) {
        gradElem.setAttribute(x, Double.toString(point.getX()));
        gradElem.setAttribute(y, Double.toString(point.getY()));
    }
}

