set_variable(FOO VALUES)
set_variable(BAR VALUES "bar")
set_variable(BAZ VALUES "baz")
set_variable(BOO VALUES "boo")

function(parent_scope)
    set_variable(FOO SCOPE PARENT VALUES "foo")
    set_variable(BAR SCOPE PARENT VALUES "")
    set_variable(BAZ SCOPE PARENT VALUES)
    unset_variable(BOO SCOPE PARENT)

    if(NOT DEFINED FOO)
      message(FATAL_ERROR "in function: FOO not defined")
    elseif(NOT "${FOO}" STREQUAL "")
      message(FATAL_ERROR "in function: FOO should be \"\", not \"${FOO}\"")
    endif()

    if(NOT DEFINED BAR)
      message(FATAL_ERROR "in function: BAR not defined")
    elseif(NOT "${BAR}" STREQUAL "bar")
      message(FATAL_ERROR "in function: BAR should be \"bar\", not \"${BAR}\"")
    endif()

    if(NOT DEFINED BAZ)
      message(FATAL_ERROR "in function: BAZ not defined")
    elseif(NOT "${BAZ}" STREQUAL "baz")
      message(FATAL_ERROR "in function: BAZ should be \"baz\", not \"${BAZ}\"")
    endif()

    if(NOT DEFINED BOO)
      message(FATAL_ERROR "in function: BOO not defined")
    elseif(NOT "${BOO}" STREQUAL "boo")
      message(FATAL_ERROR "in function: BOO should be \"boo\", not \"${BOO}\"")
    endif()
endfunction()

parent_scope()

if(NOT DEFINED FOO)
  message(FATAL_ERROR "FOO not defined")
elseif(NOT "${FOO}" STREQUAL "foo")
  message(FATAL_ERROR "FOO should be \"foo\", not \"${FOO}\"")
endif()

if(NOT DEFINED BAR)
  message(FATAL_ERROR "BAR not defined")
elseif(NOT "${BAR}" STREQUAL "")
  message(FATAL_ERROR "BAR should be an empty string, not \"${BAR}\"")
endif()

if(NOT DEFINED BAZ)
  message(FATAL_ERROR "BAZ not defined")
elseif(NOT "${BAZ}" STREQUAL "")
  message(FATAL_ERROR "BAZ should be an empty string, not \"${BAZ}\"")
endif()

if(DEFINED BOO)
  message(FATAL_ERROR "BOO defined")
endif()
