include(Compiler/GNU)
__compiler_gnu(Ada)

set(CMAKE_Ada_OUTPUT_EXTENSION .o)

# object extension must be only ${CMAKE_Ada_OUTPUT_EXTENSION}
set(CMAKE_Ada_OUTPUT_EXTENSION_REPLACE 1)

set(CMAKE_Ada_COMPILE_OPTIONS_EXPLICIT_LANGUAGE -x ada)

# to enfore warnings as errors
set(CMAKE_Ada_COMPILE_OPTIONS_WARNING_AS_ERROR "-gnatwe")

# To active partial support of the next Ada standard
set(CMAKE_Ada_EXTENSION_COMPILE_OPTION -gnatX)

# Ada language does not support extensions to standard
set(CMAKE_Ada_EXTENSIONS OFF)

set(CMAKE_Ada83_STANDARD_COMPILE_OPTION "-gnat83")
set(CMAKE_Ada83_EXTENSION_COMPILE_OPTION)

set(CMAKE_Ada95_STANDARD_COMPILE_OPTION "-gnat95")
set(CMAKE_Ada95_EXTENSION_COMPILE_OPTION)

set(CMAKE_Ada2005_STANDARD_COMPILE_OPTION "-gnat2005")
set(CMAKE_Ada2005_EXTENSION_COMPILE_OPTION)

set(CMAKE_Ada2012_STANDARD_COMPILE_OPTION "-gnat2012")
set(CMAKE_Ada2012_EXTENSION_COMPILE_OPTION)

if(NOT CMAKE_Ada_COMPILER_VERSION VERSION_LESS 12.0)
  set(CMAKE_Ada2022_STANDARD_COMPILE_OPTION "-gnat2022")
  set(CMAKE_Ada2022_EXTENSION_COMPILE_OPTION)
endif()

__compiler_check_default_language_standard(Ada 1.0 83)

#
# GNU Ada compiler use a front-end to handle various steps of compilation/bind/link
# So redefine various commands to compile ada sources
#

set(CMAKE_INCLUDE_FLAG_Ada "-aI")

# Each source file generates also an "ali" file
set(CMAKE_Ada_EXTRA_COMPILE_EXTENSIONS .ali)

# object file directories handling
set(CMAKE_Ada_OBJECT_FILE_DIR_FLAG "-aO")


# Dependencies cannot be generated as part of the compilation step,
# so remove related flags
set(CMAKE_DEPFILE_FLAGS_Ada)
# Add an extra step for dependencies generation
set(CMAKE_Ada_DEPENDS_EXTRA_COMMANDS "<CMAKE_Ada_COMPILER> make -M -u -D <OBJECT_FILE_DIR> <INCLUDES> <SOURCE> > <DEP_FILE>")
set(CMAKE_Ada_DEPFILE_FORMAT gcc)
set(CMAKE_Ada_DEPENDS_USE_COMPILER TRUE)

# compile an Ada file into an object file
set(CMAKE_Ada_COMPILE_OBJECT
  "<CMAKE_Ada_COMPILER> make -c -u -D <OBJECT_FILE_DIR> <INCLUDES> <SOURCE> -cargs <DEFINES> <FLAGS>")

# create a shared library
set(CMAKE_Ada_CREATE_SHARED_LIBRARY
      "<CMAKE_Ada_BACKEND_COMPILER> <CMAKE_SHARED_LIBRARY_Ada_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_Ada_FLAGS> <SONAME_FLAG><TARGET_SONAME> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")

set(CMAKE_Ada_LINK_EXECUTABLE
  "<CMAKE_Ada_COMPILER> make -b -l -o <TARGET> <MAIN_NAME> <Ada_OBJECT_FILE_DIRS> -cargs <FLAGS> -bargs -shared <CMAKE_Ada_BIND_FLAGS> <BIND_FLAGS> -largs <CMAKE_Ada_LINK_FLAGS> <LINK_FLAGS> <LINK_LIBRARIES>")
