# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.


if(CMAKE_Ada_COMPILER_FORCED)
  # The compiler configuration was forced by the user.
  # Assume the user has configured all compiler information.
  set(CMAKE_Ada_COMPILER_WORKS TRUE)
  return()
endif()

include(CMakeTestCompilerCommon)

# Remove any cached result from an older CMake version.
# We now store this in CMakeCXXCompiler.cmake.
unset(CMAKE_Ada_COMPILER_WORKS CACHE)

# Try to identify the ABI and configure it into CMakeCXXCompiler.cmake
include(${CMAKE_ROOT}/Modules/CMakeDetermineCompilerABI.cmake)
cmake_determine_compiler_abi(Ada ${CMAKE_ROOT}/Modules/CMakeAdaCompilerABI.adb)
if(CMAKE_Ada_ABI_COMPILED)
  # convert data pointer value from ASCII character to numeric
  string(HEX "${CMAKE_Ada_SIZEOF_DATA_PTR}" CMAKE_Ada_SIZEOF_DATA_PTR)
  math(EXPR CMAKE_Ada_SIZEOF_DATA_PTR "0x${CMAKE_Ada_SIZEOF_DATA_PTR}/8"  OUTPUT_FORMAT DECIMAL)
  # The compiler worked so skip dedicated test below.
  set(CMAKE_Ada_COMPILER_WORKS TRUE)
  message(STATUS "Check for working Ada compiler: ${CMAKE_Ada_COMPILER} - skipped")
endif()

# This file is used by EnableLanguage in cmGlobalGenerator to
# determine that the selected Ada compiler can actually compile
# and link the most basic of programs.   If not, a fatal error
# is set and cmake stops processing commands and will not generate
# any makefiles or projects.
if(NOT CMAKE_Ada_COMPILER_WORKS)
  PrintTestCompilerStatus("Ada")
  file(WRITE ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testAdaCompiler.adb
    "procedure testAdaCompiler is\n"
    "begin\n"
    "  null;"
    "end;")
  try_compile(CMAKE_Ada_COMPILER_WORKS
    SOURCES "${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testAdaCompiler.adb"
    OUTPUT_VARIABLE __CMAKE_Ada_COMPILER_OUTPUT)
  # Move result from cache to normal variable.
  set(CMAKE_Ada_COMPILER_WORKS ${CMAKE_Ada_COMPILER_WORKS})
  unset(CMAKE_Ada_COMPILER_WORKS CACHE)

  if(NOT CMAKE_Ada_COMPILER_WORKS)
    PrintTestCompilerResult(CHECK_FAIL "broken")
    file(APPEND ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeError.log
      "Determining if the Ada compiler works failed with "
      "the following output:\n${__CMAKE_Ada_COMPILER_OUTPUT}\n\n")
    string(REPLACE "\n" "\n  " _output "${__CMAKE_Ada_COMPILER_OUTPUT}")
    message(FATAL_ERROR "The Ada compiler\n  \"${CMAKE_Ada_COMPILER}\"\n"
      "is not able to compile a simple test program.\nIt fails "
      "with the following output:\n  ${_output}\n\n"
      "CMake will not be able to correctly generate this project.")
  endif()
  PrintTestCompilerResult(CHECK_PASS "works")
  file(APPEND ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeOutput.log
    "Determining if the Ada compiler works passed with "
    "the following output:\n${__CMAKE_Ada_COMPILER_OUTPUT}\n\n")
endif()

# Try to identify the compiler features
include(${CMAKE_ROOT}/Modules/CMakeDetermineCompileFeatures.cmake)
cmake_determine_compile_features(Ada)

# Re-configure to save learned information.
configure_file(
  ${CMAKE_ROOT}/Modules/CMakeAdaCompiler.cmake.in
  ${CMAKE_PLATFORM_INFO_DIR}/CMakeAdaCompiler.cmake
  @ONLY
  )
include(${CMAKE_PLATFORM_INFO_DIR}/CMakeAdaCompiler.cmake)

if(CMAKE_Ada_SIZEOF_DATA_PTR)
  foreach(f ${CMAKE_Ada_ABI_FILES})
    include(${f})
  endforeach()
  unset(CMAKE_Ada_ABI_FILES)
endif()

unset(__CMAKE_Ada_COMPILER_OUTPUT)
