//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2015 Sandia Corporation.
//  Copyright 2015 UT-Battelle, LLC.
//  Copyright 2015 Los Alamos National Security.
//
//  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
//  the U.S. Government retains certain rights in this software.
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//
//=============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by FunctionInterfaceDetailPre.h.in

#ifndef vtk_m_Math_h
#define vtk_m_Math_h

#include <vtkm/Types.h>
#include <vtkm/TypeTraits.h>
#include <vtkm/VecTraits.h>

#ifndef VTKM_CUDA
#include <limits.h>
#include <math.h>
#include <stdlib.h>

// The nonfinite and sign test functions are usually defined as macros, and
// boost seems to want to undefine those macros so that it can implement the
// C99 templates and other implementations of the same name. Get around the
// problem by using the boost version when compiling for a CPU.
#include <boost/math/special_functions/fpclassify.hpp>
#include <boost/math/special_functions/sign.hpp>
#include <cmath>
#define VTKM_USE_BOOST_CLASSIFY
#define VTKM_USE_BOOST_SIGN
#endif // !VTKM_CUDA

#if defined(VTKM_MSVC) && !defined(VTKM_CUDA)
#include <boost/math/special_functions/acosh.hpp>
#include <boost/math/special_functions/asinh.hpp>
#include <boost/math/special_functions/atanh.hpp>
#include <boost/math/special_functions/cbrt.hpp>
#include <boost/math/special_functions/expm1.hpp>
#include <boost/math/special_functions/log1p.hpp>
#include <boost/math/special_functions/round.hpp>
#define VTKM_USE_BOOST_MATH
#if _MSC_VER <= 1600
#define VTKM_USE_STL_MIN_MAX
#include <algorithm>
#endif
#endif

#define VTKM_SYS_MATH_FUNCTION_32(func) func ## f
#define VTKM_SYS_MATH_FUNCTION_64(func) func









namespace vtkm {

//-----------------------------------------------------------------------------
/// Returns the constant Pi.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Pi()
{
  return 3.14159265358979323846264338327950288;
}

/// Compute the sine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Sin(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(sin)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Sin(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(sin)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Sin(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Sin(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Sin(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Sin(x[0]),
                        vtkm::Sin(x[1]),
                        vtkm::Sin(x[2]),
                        vtkm::Sin(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Sin(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Sin(x[0]),
                        vtkm::Sin(x[1]),
                        vtkm::Sin(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Sin(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Sin(x[0]),
                        vtkm::Sin(x[1]));
}

/// Compute the cosine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Cos(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(cos)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Cos(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(cos)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Cos(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Cos(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Cos(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Cos(x[0]),
                        vtkm::Cos(x[1]),
                        vtkm::Cos(x[2]),
                        vtkm::Cos(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Cos(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Cos(x[0]),
                        vtkm::Cos(x[1]),
                        vtkm::Cos(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Cos(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Cos(x[0]),
                        vtkm::Cos(x[1]));
}

/// Compute the tangent of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Tan(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(tan)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Tan(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(tan)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Tan(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Tan(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Tan(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Tan(x[0]),
                        vtkm::Tan(x[1]),
                        vtkm::Tan(x[2]),
                        vtkm::Tan(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Tan(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Tan(x[0]),
                        vtkm::Tan(x[1]),
                        vtkm::Tan(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Tan(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Tan(x[0]),
                        vtkm::Tan(x[1]));
}

/// Compute the arc sine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ASin(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(asin)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ASin(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(asin)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ASin(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ASin(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ASin(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ASin(x[0]),
                        vtkm::ASin(x[1]),
                        vtkm::ASin(x[2]),
                        vtkm::ASin(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ASin(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ASin(x[0]),
                        vtkm::ASin(x[1]),
                        vtkm::ASin(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ASin(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ASin(x[0]),
                        vtkm::ASin(x[1]));
}

/// Compute the arc cosine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ACos(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(acos)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ACos(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(acos)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ACos(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ACos(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ACos(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ACos(x[0]),
                        vtkm::ACos(x[1]),
                        vtkm::ACos(x[2]),
                        vtkm::ACos(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ACos(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ACos(x[0]),
                        vtkm::ACos(x[1]),
                        vtkm::ACos(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ACos(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ACos(x[0]),
                        vtkm::ACos(x[1]));
}

/// Compute the arc tangent of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ATan(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(atan)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ATan(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(atan)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ATan(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ATan(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ATan(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ATan(x[0]),
                        vtkm::ATan(x[1]),
                        vtkm::ATan(x[2]),
                        vtkm::ATan(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ATan(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ATan(x[0]),
                        vtkm::ATan(x[1]),
                        vtkm::ATan(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ATan(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ATan(x[0]),
                        vtkm::ATan(x[1]));
}

/// Compute the arc tangent of \p x / \p y using the signs of both arguments
/// to determine the quadrant of the return value.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ATan2(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(atan2)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ATan2(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(atan2)(x,y);
}

/// Compute the hyperbolic sine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 SinH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(sinh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 SinH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(sinh)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> SinH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::SinH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> SinH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::SinH(x[0]),
                        vtkm::SinH(x[1]),
                        vtkm::SinH(x[2]),
                        vtkm::SinH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> SinH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::SinH(x[0]),
                        vtkm::SinH(x[1]),
                        vtkm::SinH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> SinH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::SinH(x[0]),
                        vtkm::SinH(x[1]));
}

/// Compute the hyperbolic cosine of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 CosH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(cosh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 CosH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(cosh)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> CosH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::CosH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> CosH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::CosH(x[0]),
                        vtkm::CosH(x[1]),
                        vtkm::CosH(x[2]),
                        vtkm::CosH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> CosH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::CosH(x[0]),
                        vtkm::CosH(x[1]),
                        vtkm::CosH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> CosH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::CosH(x[0]),
                        vtkm::CosH(x[1]));
}

/// Compute the hyperbolic tangent of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 TanH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(tanh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 TanH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(tanh)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> TanH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::TanH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> TanH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::TanH(x[0]),
                        vtkm::TanH(x[1]),
                        vtkm::TanH(x[2]),
                        vtkm::TanH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> TanH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::TanH(x[0]),
                        vtkm::TanH(x[1]),
                        vtkm::TanH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> TanH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::TanH(x[0]),
                        vtkm::TanH(x[1]));
}

/// Compute the hyperbolic arc sine of \p x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ASinH(vtkm::Float32 x) {
  return boost::math::asinh(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ASinH(vtkm::Float64 x) {
  return boost::math::asinh(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ASinH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(asinh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ASinH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(asinh)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ASinH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ASinH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ASinH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ASinH(x[0]),
                        vtkm::ASinH(x[1]),
                        vtkm::ASinH(x[2]),
                        vtkm::ASinH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ASinH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ASinH(x[0]),
                        vtkm::ASinH(x[1]),
                        vtkm::ASinH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ASinH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ASinH(x[0]),
                        vtkm::ASinH(x[1]));
}

/// Compute the hyperbolic arc cosine of \p x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ACosH(vtkm::Float32 x) {
  return boost::math::acosh(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ACosH(vtkm::Float64 x) {
  return boost::math::acosh(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ACosH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(acosh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ACosH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(acosh)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ACosH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ACosH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ACosH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ACosH(x[0]),
                        vtkm::ACosH(x[1]),
                        vtkm::ACosH(x[2]),
                        vtkm::ACosH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ACosH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ACosH(x[0]),
                        vtkm::ACosH(x[1]),
                        vtkm::ACosH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ACosH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ACosH(x[0]),
                        vtkm::ACosH(x[1]));
}

/// Compute the hyperbolic arc tangent of \p x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ATanH(vtkm::Float32 x) {
  return boost::math::atanh(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ATanH(vtkm::Float64 x) {
  return boost::math::atanh(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ATanH(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(atanh)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ATanH(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(atanh)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ATanH(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ATanH(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ATanH(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ATanH(x[0]),
                        vtkm::ATanH(x[1]),
                        vtkm::ATanH(x[2]),
                        vtkm::ATanH(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ATanH(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ATanH(x[0]),
                        vtkm::ATanH(x[1]),
                        vtkm::ATanH(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ATanH(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ATanH(x[0]),
                        vtkm::ATanH(x[1]));
}

//-----------------------------------------------------------------------------
/// Computes \p x raised to the power of \p y.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Pow(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(pow)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Pow(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(pow)(x,y);
}

/// Compute the square root of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Sqrt(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(sqrt)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Sqrt(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(sqrt)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Sqrt(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Sqrt(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Sqrt(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Sqrt(x[0]),
                        vtkm::Sqrt(x[1]),
                        vtkm::Sqrt(x[2]),
                        vtkm::Sqrt(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Sqrt(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Sqrt(x[0]),
                        vtkm::Sqrt(x[1]),
                        vtkm::Sqrt(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Sqrt(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Sqrt(x[0]),
                        vtkm::Sqrt(x[1]));
}

/// Compute the reciprocal square root of \p x. The result of this function is
/// equivalent to <tt>1/Sqrt(x)</tt>. However, on some devices it is faster to
/// compute the reciprocal square root than the regular square root. Thus, you
/// should use this function whenever dividing by the square root.
///
#ifdef VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 RSqrt(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(rsqrt)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 RSqrt(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(rsqrt)(x);
}
#else // !VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 RSqrt(vtkm::Float32 x) {
  return 1/vtkm::Sqrt(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 RSqrt(vtkm::Float64 x) {
  return 1/vtkm::Sqrt(x);
}
#endif // !VTKM_CUDA
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> RSqrt(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::RSqrt(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> RSqrt(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::RSqrt(x[0]),
                        vtkm::RSqrt(x[1]),
                        vtkm::RSqrt(x[2]),
                        vtkm::RSqrt(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> RSqrt(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::RSqrt(x[0]),
                        vtkm::RSqrt(x[1]),
                        vtkm::RSqrt(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> RSqrt(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::RSqrt(x[0]),
                        vtkm::RSqrt(x[1]));
}

/// Compute the cube root of \p x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Cbrt(vtkm::Float32 x) {
  return boost::math::cbrt(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Cbrt(vtkm::Float64 x) {
  return boost::math::cbrt(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Cbrt(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(cbrt)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Cbrt(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(cbrt)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Cbrt(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Cbrt(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Cbrt(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Cbrt(x[0]),
                        vtkm::Cbrt(x[1]),
                        vtkm::Cbrt(x[2]),
                        vtkm::Cbrt(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Cbrt(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Cbrt(x[0]),
                        vtkm::Cbrt(x[1]),
                        vtkm::Cbrt(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Cbrt(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Cbrt(x[0]),
                        vtkm::Cbrt(x[1]));
}

/// Compute the reciprocal cube root of \p x. The result of this function is
/// equivalent to <tt>1/Cbrt(x)</tt>. However, on some devices it is faster to
/// compute the reciprocal cube root than the regular cube root. Thus, you
/// should use this function whenever dividing by the cube root.
///
#ifdef VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 RCbrt(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(rcbrt)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 RCbrt(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(rcbrt)(x);
}
#else // !VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 RCbrt(vtkm::Float32 x) {
  return 1/vtkm::Cbrt(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 RCbrt(vtkm::Float64 x) {
  return 1/vtkm::Cbrt(x);
}
#endif // !VTKM_CUDA
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> RCbrt(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::RCbrt(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> RCbrt(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::RCbrt(x[0]),
                        vtkm::RCbrt(x[1]),
                        vtkm::RCbrt(x[2]),
                        vtkm::RCbrt(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> RCbrt(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::RCbrt(x[0]),
                        vtkm::RCbrt(x[1]),
                        vtkm::RCbrt(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> RCbrt(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::RCbrt(x[0]),
                        vtkm::RCbrt(x[1]));
}

/// Computes e**\p x, the base-e exponential of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Exp(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(exp)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Exp(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(exp)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Exp(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Exp(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Exp(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Exp(x[0]),
                        vtkm::Exp(x[1]),
                        vtkm::Exp(x[2]),
                        vtkm::Exp(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Exp(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Exp(x[0]),
                        vtkm::Exp(x[1]),
                        vtkm::Exp(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Exp(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Exp(x[0]),
                        vtkm::Exp(x[1]));
}

/// Computes 2**\p x, the base-2 exponential of \p x.
///
#ifdef VTKM_MSVC
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Exp2(vtkm::Float32 x) {
  return vtkm::Pow(2,x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Exp2(vtkm::Float64 x) {
  return vtkm::Pow(2,x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Exp2(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(exp2)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Exp2(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(exp2)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Exp2(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Exp2(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Exp2(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Exp2(x[0]),
                        vtkm::Exp2(x[1]),
                        vtkm::Exp2(x[2]),
                        vtkm::Exp2(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Exp2(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Exp2(x[0]),
                        vtkm::Exp2(x[1]),
                        vtkm::Exp2(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Exp2(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Exp2(x[0]),
                        vtkm::Exp2(x[1]));
}

/// Computes (e**\p x) - 1, the of base-e exponental of \p x then minus 1. The
/// accuracy of this function is good even for very small values of x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ExpM1(vtkm::Float32 x) {
  return boost::math::expm1(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ExpM1(vtkm::Float64 x) {
  return boost::math::expm1(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ExpM1(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(expm1)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ExpM1(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(expm1)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> ExpM1(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::ExpM1(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> ExpM1(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::ExpM1(x[0]),
                        vtkm::ExpM1(x[1]),
                        vtkm::ExpM1(x[2]),
                        vtkm::ExpM1(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> ExpM1(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::ExpM1(x[0]),
                        vtkm::ExpM1(x[1]),
                        vtkm::ExpM1(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> ExpM1(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::ExpM1(x[0]),
                        vtkm::ExpM1(x[1]));
}

/// Computes 10**\p x, the base-10 exponential of \p x.
///
#ifdef VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Exp10(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(exp10)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Exp10(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(exp10)(x);
}
#else // !VTKM_CUDA
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Exp10(vtkm::Float32 x) {
  return vtkm::Pow(10, x);;
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Exp10(vtkm::Float64 x) {
  return vtkm::Pow(10, x);;
}
#endif // !VTKM_CUDA
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Exp10(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Exp10(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Exp10(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Exp10(x[0]),
                        vtkm::Exp10(x[1]),
                        vtkm::Exp10(x[2]),
                        vtkm::Exp10(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Exp10(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Exp10(x[0]),
                        vtkm::Exp10(x[1]),
                        vtkm::Exp10(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Exp10(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Exp10(x[0]),
                        vtkm::Exp10(x[1]));
}

/// Computes the natural logarithm of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(log)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(log)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Log(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Log(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Log(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Log(x[0]),
                        vtkm::Log(x[1]),
                        vtkm::Log(x[2]),
                        vtkm::Log(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Log(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Log(x[0]),
                        vtkm::Log(x[1]),
                        vtkm::Log(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Log(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Log(x[0]),
                        vtkm::Log(x[1]));
}

/// Computes the logarithm base 2 of \p x.
///
#ifdef VTKM_MSVC
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log2(vtkm::Float32 x) {
  //windows and boost don't provide log2
  //0.6931471805599453 is the constant value of log(2)
  const vtkm::Float32 log2v = 0.6931471805599453f;
  return vtkm::Log(x)/log2v;
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log2(vtkm::Float64 x) {
  //windows and boost don't provide log2
  //0.6931471805599453 is the constant value of log(2)
  const vtkm::Float64 log2v = 0.6931471805599453;
  return vtkm::Log(x)/log2v;
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log2(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(log2)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log2(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(log2)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Log2(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Log2(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Log2(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Log2(x[0]),
                        vtkm::Log2(x[1]),
                        vtkm::Log2(x[2]),
                        vtkm::Log2(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Log2(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Log2(x[0]),
                        vtkm::Log2(x[1]),
                        vtkm::Log2(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Log2(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Log2(x[0]),
                        vtkm::Log2(x[1]));
}

/// Computes the logarithm base 10 of \p x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log10(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(log10)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log10(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(log10)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Log10(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Log10(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Log10(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Log10(x[0]),
                        vtkm::Log10(x[1]),
                        vtkm::Log10(x[2]),
                        vtkm::Log10(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Log10(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Log10(x[0]),
                        vtkm::Log10(x[1]),
                        vtkm::Log10(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Log10(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Log10(x[0]),
                        vtkm::Log10(x[1]));
}

/// Computes the value of log(1+x) accurately for very small values of x.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log1P(vtkm::Float32 x) {
  return boost::math::log1p(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log1P(vtkm::Float64 x) {
  return boost::math::log1p(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Log1P(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(log1p)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Log1P(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(log1p)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Log1P(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Log1P(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Log1P(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Log1P(x[0]),
                        vtkm::Log1P(x[1]),
                        vtkm::Log1P(x[2]),
                        vtkm::Log1P(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Log1P(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Log1P(x[0]),
                        vtkm::Log1P(x[1]),
                        vtkm::Log1P(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Log1P(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Log1P(x[0]),
                        vtkm::Log1P(x[1]));
}

//-----------------------------------------------------------------------------
/// Returns \p x or \p y, whichever is larger.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Max(const T &x, const T &y);
#ifdef VTKM_USE_STL_MIN_MAX
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Max(vtkm::Float32 x, vtkm::Float32 y) {
  return (std::max)(x, y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Max(vtkm::Float64 x, vtkm::Float64 y) {
  return (std::max)(x, y);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Max(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(fmax)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Max(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(fmax)(x,y);
}
#endif // !VTKM_USE_BOOST_MATH

/// Returns \p x or \p y, whichever is smaller.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Min(const T &x, const T &y);
#ifdef VTKM_USE_STL_MIN_MAX
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Min(vtkm::Float32 x, vtkm::Float32 y) {
  return (std::min)(x, y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Min(vtkm::Float64 x, vtkm::Float64 y) {
  return (std::min)(x, y);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Min(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(fmin)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Min(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(fmin)(x,y);
}
#endif // !VTKM_USE_BOOST_MATH

namespace detail {

template<typename T>
VTKM_EXEC_CONT_EXPORT
T Max(T x, T y, vtkm::TypeTraitsScalarTag)
{
  return (x < y) ? y : x;
}

template<typename T>
VTKM_EXEC_CONT_EXPORT
T Max(const T &x, const T &y, vtkm::TypeTraitsVectorTag)
{
  typedef vtkm::VecTraits<T> Traits;
  T result;
  for (vtkm::IdComponent index = 0; index < Traits::NUM_COMPONENTS; index++)
  {
    Traits::SetComponent(result,
                         index,
                         vtkm::Max(Traits::GetComponent(x, index),
                                   Traits::GetComponent(y, index)));
  }
  return result;
}

template<typename T>
VTKM_EXEC_CONT_EXPORT
T Min(T x, T y, vtkm::TypeTraitsScalarTag)
{
  return (x < y) ? x : y;
}

template<typename T>
VTKM_EXEC_CONT_EXPORT
T Min(const T &x, const T &y, vtkm::TypeTraitsVectorTag)
{
  typedef vtkm::VecTraits<T> Traits;
  T result;
  for (vtkm::IdComponent index = 0; index < Traits::NUM_COMPONENTS; index++)
  {
    Traits::SetComponent(result,
                         index,
                         vtkm::Min(Traits::GetComponent(x, index),
                                   Traits::GetComponent(y, index)));
  }
  return result;
}

} // namespace detail

/// Returns \p x or \p y, whichever is larger.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Max(const T &x, const T &y) {
  return detail::Max(x, y, typename vtkm::TypeTraits<T>::DimensionalityTag());
}

/// Returns \p x or \p y, whichever is smaller.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Min(const T &x, const T &y) {
  return detail::Min(x, y, typename vtkm::TypeTraits<T>::DimensionalityTag());
}


//-----------------------------------------------------------------------------

//#ifdef VTKM_CUDA
#define VTKM_USE_IEEE_NONFINITE
//#endif

#ifdef VTKM_USE_IEEE_NONFINITE

namespace detail {

union IEEE754Bits32 {
  vtkm::UInt32 bits;
  vtkm::Float32 scalar;
};
#define VTKM_NAN_BITS_32      0x7FC00000
#define VTKM_INF_BITS_32      0x7F800000
#define VTKM_NEG_INF_BITS_32  0xFF800000
#define VTKM_EPSILON_32       1e-5f

union IEEE754Bits64 {
  vtkm::UInt64 bits;
  vtkm::Float64 scalar;
};
#define VTKM_NAN_BITS_64      0x7FF8000000000000LL
#define VTKM_INF_BITS_64      0x7FF0000000000000LL
#define VTKM_NEG_INF_BITS_64  0xFFF0000000000000LL
#define VTKM_EPSILON_64       1e-9

template<typename T> struct FloatLimits;

template<>
struct FloatLimits<vtkm::Float32>
{
  typedef vtkm::detail::IEEE754Bits32 BitsType;

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float32 Nan() {
    BitsType nan = {VTKM_NAN_BITS_32};
    return nan.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float32 Infinity() {
    BitsType inf = {VTKM_INF_BITS_32};
    return inf.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float32 NegativeInfinity() {
    BitsType neginf = {VTKM_NEG_INF_BITS_32};
    return neginf.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float32 Epsilon() {
    return VTKM_EPSILON_32;
  }
};

template<>
struct FloatLimits<vtkm::Float64>
{
  typedef vtkm::detail::IEEE754Bits64 BitsType;

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float64 Nan() {
    BitsType nan = {VTKM_NAN_BITS_64};
    return nan.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float64 Infinity() {
    BitsType inf = {VTKM_INF_BITS_64};
    return inf.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float64 NegativeInfinity() {
    BitsType neginf = {VTKM_NEG_INF_BITS_64};
    return neginf.scalar;
  }

  VTKM_EXEC_CONT_EXPORT
  static vtkm::Float64 Epsilon() {
    return VTKM_EPSILON_64;
  }
};

#undef VTKM_NAN_BITS_32
#undef VTKM_INF_BITS_32
#undef VTKM_NEG_INF_BITS_32
#undef VTKM_EPSILON_32
#undef VTKM_NAN_BITS_64
#undef VTKM_INF_BITS_64
#undef VTKM_NEG_INF_BITS_64
#undef VTKM_EPSILON_64

} // namespace detail

/// Returns the representation for not-a-number (NaN).
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Nan()
{
  return detail::FloatLimits<T>::Nan();
}

/// Returns the representation for infinity.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Infinity()
{
  return detail::FloatLimits<T>::Infinity();
}

/// Returns the representation for negative infinity.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T NegativeInfinity()
{
  return detail::FloatLimits<T>::NegativeInfinity();
}

/// Returns the difference between 1 and the least value greater than 1
/// that is representable.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Epsilon()
{
  return detail::FloatLimits<T>::Epsilon();
}

#else // !VTKM_USE_IEEE_NONFINITE

/// Returns the representation for not-a-number (NaN).
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Nan()
{
  return std::numeric_limits<T>::quiet_NaN();
}

/// Returns the representation for infinity.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Infinity()
{
  return std::numeric_limits<T>::infinity();
}

/// Returns the representation for negative infinity.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T NegativeInfinity()
{
  return -std::numeric_limits<T>::infinity();
}

/// Returns the difference between 1 and the least value greater than 1
/// that is representable.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Epsilon()
{
  return std::numeric_limits<T>::epsilon();
}
#endif // !VTKM_USE_IEEE_NONFINITE

/// Returns the representation for not-a-number (NaN).
///
VTKM_EXEC_CONT_EXPORT vtkm::Float32 Nan32() {
  return vtkm::Nan<vtkm::Float32>();
}
VTKM_EXEC_CONT_EXPORT vtkm::Float64 Nan64() {
  return vtkm::Nan<vtkm::Float64>();
}

/// Returns the representation for infinity.
///
VTKM_EXEC_CONT_EXPORT vtkm::Float32 Infinity32() {
  return vtkm::Infinity<vtkm::Float32>();
}
VTKM_EXEC_CONT_EXPORT vtkm::Float64 Infinity64() {
  return vtkm::Infinity<vtkm::Float64>();
}

/// Returns the representation for negative infinity.
///
VTKM_EXEC_CONT_EXPORT vtkm::Float32 NegativeInfinity32() {
  return vtkm::NegativeInfinity<vtkm::Float32>();
}
VTKM_EXEC_CONT_EXPORT vtkm::Float64 NegativeInfinity64() {
  return vtkm::NegativeInfinity<vtkm::Float64>();
}

/// Returns the difference between 1 and the least value greater than 1
/// that is representable.
///
VTKM_EXEC_CONT_EXPORT vtkm::Float32 Epsilon32()
{
  return vtkm::Epsilon<vtkm::Float32>();
}
VTKM_EXEC_CONT_EXPORT vtkm::Float64 Epsilon64()
{
  return vtkm::Epsilon<vtkm::Float64>();
}

//-----------------------------------------------------------------------------
/// Returns true if \p x is not a number.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
bool IsNan(T x)
{
#ifdef VTKM_USE_BOOST_CLASSIFY
  using boost::math::isnan;
#endif
  return (isnan(x) != 0);
}

/// Returns true if \p x is positive or negative infinity.
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
bool IsInf(T x)
{
#ifdef VTKM_USE_BOOST_CLASSIFY
  using boost::math::isinf;
#endif
  return (isinf(x) != 0);
}

/// Returns true if \p x is a normal number (not NaN or infinite).
///
template<typename T>
VTKM_EXEC_CONT_EXPORT
bool IsFinite(T x)
{
#ifdef VTKM_USE_BOOST_CLASSIFY
  using boost::math::isfinite;
#endif
  return (isfinite(x) != 0);
}

//-----------------------------------------------------------------------------
/// Round \p x to the smallest integer value not less than x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Ceil(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(ceil)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Ceil(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(ceil)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Ceil(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Ceil(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Ceil(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Ceil(x[0]),
                        vtkm::Ceil(x[1]),
                        vtkm::Ceil(x[2]),
                        vtkm::Ceil(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Ceil(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Ceil(x[0]),
                        vtkm::Ceil(x[1]),
                        vtkm::Ceil(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Ceil(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Ceil(x[0]),
                        vtkm::Ceil(x[1]));
}

/// Round \p x to the largest integer value not greater than x.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Floor(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(floor)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Floor(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(floor)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Floor(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Floor(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Floor(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Floor(x[0]),
                        vtkm::Floor(x[1]),
                        vtkm::Floor(x[2]),
                        vtkm::Floor(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Floor(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Floor(x[0]),
                        vtkm::Floor(x[1]),
                        vtkm::Floor(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Floor(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Floor(x[0]),
                        vtkm::Floor(x[1]));
}

/// Round \p x to the nearest integral value.
///
#ifdef VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Round(vtkm::Float32 x) {
  return boost::math::round(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Round(vtkm::Float64 x) {
  return boost::math::round(x);
}
#else // !VTKM_USE_BOOST_MATH
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Round(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(round)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Round(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(round)(x);
}
#endif // !VTKM_USE_BOOST_MATH
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Round(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Round(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Round(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Round(x[0]),
                        vtkm::Round(x[1]),
                        vtkm::Round(x[2]),
                        vtkm::Round(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Round(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Round(x[0]),
                        vtkm::Round(x[1]),
                        vtkm::Round(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Round(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Round(x[0]),
                        vtkm::Round(x[1]));
}

//-----------------------------------------------------------------------------
/// Computes the remainder on division of 2 floating point numbers. The return
/// value is \p numerator - n \p denominator, where n is the quotient of \p
/// numerator divided by \p denominator rounded towards zero to an integer. For
/// example, <tt>FMod(6.5, 2.3)</tt> returns 1.9, which is 6.5 - 2*2.3.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 FMod(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(fmod)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 FMod(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(fmod)(x,y);
}

/// Computes the remainder on division of 2 floating point numbers. The return
/// value is \p numerator - n \p denominator, where n is the quotient of \p
/// numerator divided by \p denominator rounded towards the nearest integer
/// (instead of toward zero like FMod). For example, <tt>FMod(6.5, 2.3)</tt>
/// returns -0.4, which is 6.5 - 3*2.3.
///
#ifdef VTKM_MSVC
template<typename T>
VTKM_EXEC_CONT_EXPORT
T Remainder(T numerator, T denominator)
{
  T quotient = vtkm::Round(numerator/denominator);
  return numerator - quotient*denominator;
}
#else // !VTKM_MSVC
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Remainder(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(remainder)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Remainder(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(remainder)(x,y);
}
#endif // !VTKM_MSVC

/// Returns the remainder on division of 2 floating point numbers just like
/// Remainder. In addition, this function also returns the \c quotient used to
/// get that remainder.
///
template<typename QType>
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 RemainderQuotient(vtkm::Float32 numerator,
                                vtkm::Float32 denominator,
                                QType &quotient)
{
#ifdef VTKM_USE_BOOST_MATH
  quotient = static_cast<QType>(boost::math::round(numerator/denominator));
  return vtkm::Remainder(numerator, denominator);
#else
  int iQuotient;
  vtkm::Float32 result =
      VTKM_SYS_MATH_FUNCTION_32(remquo)(numerator, denominator, &iQuotient);
  quotient = iQuotient;
  return result;
#endif
}
template<typename QType>
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 RemainderQuotient(vtkm::Float64 numerator,
                                vtkm::Float64 denominator,
                                QType &quotient)
{
#ifdef VTKM_USE_BOOST_MATH
  quotient = static_cast<QType>(boost::math::round(numerator/denominator));
  return vtkm::Remainder(numerator, denominator);
#else
  int iQuotient;
  vtkm::Float64 result =
      VTKM_SYS_MATH_FUNCTION_64(remquo)(numerator, denominator, &iQuotient);
  quotient = iQuotient;
  return result;
#endif
}

/// Gets the integral and fractional parts of \c x. The return value is the
/// fractional part and \c integral is set to the integral part.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 ModF(vtkm::Float32 x, vtkm::Float32 &integral)
{
  return VTKM_SYS_MATH_FUNCTION_32(modf)(x, &integral);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 ModF(vtkm::Float64 x, vtkm::Float64 &integral)
{
  return VTKM_SYS_MATH_FUNCTION_64(modf)(x, &integral);
}

//-----------------------------------------------------------------------------
/// Return the absolute value of \p x. That is, return \p x if it is positive or
/// \p -x if it is negative.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Int32 Abs(vtkm::Int32 x)
{
#if VTKM_SIZE_INT == 4
  return abs(x);
#else
#error Unknown size of Int32.
#endif
}
VTKM_EXEC_CONT_EXPORT
vtkm::Int64 Abs(vtkm::Int64 x)
{
#if VTKM_SIZE_LONG == 8
  return labs(x);
#elif VTKM_SIZE_LONG_LONG == 8
  return llabs(x);
#else
#error Unknown size of Int64.
#endif
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 Abs(vtkm::Float32 x) {
  return VTKM_SYS_MATH_FUNCTION_32(fabs)(x);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 Abs(vtkm::Float64 x) {
  return VTKM_SYS_MATH_FUNCTION_64(fabs)(x);
}
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> Abs(const vtkm::Vec<T,N> &x) {
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::Abs(x[index]);
  }
  return result;
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,4> Abs(const vtkm::Vec<T,4> &x) {
  return vtkm::Vec<T,4>(vtkm::Abs(x[0]),
                        vtkm::Abs(x[1]),
                        vtkm::Abs(x[2]),
                        vtkm::Abs(x[3]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,3> Abs(const vtkm::Vec<T,3> &x) {
  return vtkm::Vec<T,3>(vtkm::Abs(x[0]),
                        vtkm::Abs(x[1]),
                        vtkm::Abs(x[2]));
}
template<typename T>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,2> Abs(const vtkm::Vec<T,2> &x) {
  return vtkm::Vec<T,2>(vtkm::Abs(x[0]),
                        vtkm::Abs(x[1]));
}

/// Returns a nonzero value if \p x is negative.
///
VTKM_EXEC_CONT_EXPORT
vtkm::Int32 SignBit(vtkm::Float32 x) {
#ifdef VTKM_USE_BOOST_SIGN
  using boost::math::signbit;
#endif
  return static_cast<vtkm::Int32>(signbit(x));
}
VTKM_EXEC_CONT_EXPORT
vtkm::Int32 SignBit(vtkm::Float64 x) {
#ifdef VTKM_USE_BOOST_SIGN
  using boost::math::signbit;
#endif
  return static_cast<vtkm::Int32>(signbit(x));
}

/// Returns true if \p x is less than zero, false otherwise.
///
VTKM_EXEC_CONT_EXPORT
bool IsNegative(vtkm::Float32 x) {
  return (vtkm::SignBit(x) != 0);
}
VTKM_EXEC_CONT_EXPORT
bool IsNegative(vtkm::Float64 x) {
  return (vtkm::SignBit(x) != 0);
}

/// Copies the sign of \p y onto \p x.  If \p y is positive, returns Abs(\p x).
/// If \p y is negative, returns -Abs(\p x).
///
#ifdef VTKM_USE_BOOST_SIGN
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 CopySign(vtkm::Float32 x, vtkm::Float32 y) {
  return boost::math::copysign(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 CopySign(vtkm::Float64 x, vtkm::Float64 y) {
  return boost::math::copysign(x,y);
}
#else // !VTKM_USE_BOOST_SIGN
VTKM_EXEC_CONT_EXPORT
vtkm::Float32 CopySign(vtkm::Float32 x, vtkm::Float32 y) {
  return VTKM_SYS_MATH_FUNCTION_32(copysign)(x,y);
}
VTKM_EXEC_CONT_EXPORT
vtkm::Float64 CopySign(vtkm::Float64 x, vtkm::Float64 y) {
  return VTKM_SYS_MATH_FUNCTION_64(copysign)(x,y);
}
#endif // !VTKM_USE_BOOST_SIGN
template<typename T, vtkm::IdComponent N>
VTKM_EXEC_CONT_EXPORT
vtkm::Vec<T,N> CopySign(const vtkm::Vec<T,N> &x, const vtkm::Vec<T,N> &y)
{
  vtkm::Vec<T,N> result;
  for (vtkm::IdComponent index = 0; index < N; index++)
  {
    result[index] = vtkm::CopySign(x[index], y[index]);
  }
  return result;
}

} // namespace vtkm

#endif //vtk_m_Math_h
