// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkCellArray.h"
#include "vtkCellData.h"
#include "vtkEmptyCell.h"
#include "vtkFloatArray.h"
#include "vtkIdList.h"
#include "vtkPointData.h"
#include "vtkPointLocator.h"
#include "vtkPoints.h"

#include <sstream>

#include "vtkDebugLeaks.h"

#include <iostream>

void TestOEC(ostream& strm)
{
  vtkEmptyCell* cell = vtkEmptyCell::New();
  vtkCell* cell2 = cell->NewInstance();
  cell2->DeepCopy(cell);
  vtkIdList* ids = vtkIdList::New();
  vtkPoints* pts = vtkPoints::New();
  double v = 0.0;
  vtkFloatArray* cellScalars = vtkFloatArray::New();
  vtkPointLocator* locator = vtkPointLocator::New();
  vtkCellArray* verts = vtkCellArray::New();
  vtkCellArray* lines = vtkCellArray::New();
  vtkCellArray* polys = vtkCellArray::New();
  vtkPointData* inPd = vtkPointData::New();
  vtkPointData* outPd = vtkPointData::New();
  vtkCellData* inCd = vtkCellData::New();
  vtkCellData* outCd = vtkCellData::New();
  int cellId = 0;
  int inOut = 0;
  double t, tol = 0.0;
  double x[3];
  double c[3];
  double p[3];
  double d;
  double w[3];
  int s;

  strm << "Testing EmptyCell" << std::endl;
  strm << "Cell Type is: " << cell2->GetCellType() << std::endl;
  strm << "Cell Dimension is: " << cell2->GetCellDimension() << std::endl;
  strm << "Cell NumberOfEdges is: " << cell2->GetNumberOfEdges() << std::endl;
  strm << "Cell NumberOfFaces is: " << cell2->GetNumberOfFaces() << std::endl;
  strm << "Cell GetEdge(0) is: " << cell2->GetEdge(0) << std::endl;
  strm << "Cell GetFace(0) is: " << cell2->GetFace(0) << std::endl;
  strm << "Cell CellBoundary(0,p,ids) is: " << cell2->CellBoundary(0, p, ids) << std::endl;
  strm << "Cell EvaluatePosition(x, c, s, p, d, w)" << std::endl;
  cell2->EvaluatePosition(x, c, s, p, d, w);
  strm << "Cell EvaluateLocation(s, p, x, w)" << std::endl;
  cell2->EvaluateLocation(s, p, x, w);
  strm << "Cell Contour" << std::endl;
  cell2->Contour(v, cellScalars, locator, verts, lines, polys, inPd, outPd, inCd, cellId, outCd);
  strm << "Cell Clip" << std::endl;
  cell2->Clip(v, cellScalars, locator, verts, inPd, outPd, inCd, cellId, outCd, inOut);
  strm << "Cell IntersectWithLine" << std::endl;
  cell2->IntersectWithLine(x, x, tol, t, x, p, s);
  strm << "Cell Triangulate" << std::endl;
  cell2->Triangulate(s, ids, pts);
  strm << "Cell Derivatives" << std::endl;
  cell2->Derivatives(s, p, x, inOut, w);

  // clean up
  cell->Delete();
  cell2->Delete();
  ids->Delete();
  pts->Delete();
  cellScalars->Delete();
  locator->Delete();
  verts->Delete();
  lines->Delete();
  polys->Delete();
  inPd->Delete();
  outPd->Delete();
  inCd->Delete();
  outCd->Delete();
  strm << "Testing EmptyCell Complete" << std::endl;
}

int otherEmptyCell(int, char*[])
{
  std::ostringstream vtkmsg_with_warning_C4701;
  TestOEC(vtkmsg_with_warning_C4701);

  return 0;
}
