/*=========================================================================

  Program:   ParaView
  Module:    $RCSfile$

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkMarkSelectedRows
 *
 * vtkMarkSelectedRows is used by vtkSpreadSheetView to marks rows from the
 * vtkTable generated by vtkSortedTableStreamer or vtkBlockDeliveryPreprocessor
 * as selected (done by adding a new vtkCharArray named "vtkIsSelected__").
 * It has two input ports:
 * \li 0 : vtkTable
 * \li 1 : vtkTable (the extracted selection).
 * Alternatively, for composite datasets, both inputs can be composite datasets
 * with vtkTable leaf nodes with identical structure.
*/

#ifndef vtkMarkSelectedRows_h
#define vtkMarkSelectedRows_h

#include "vtkDataObjectAlgorithm.h"
#include "vtkPVVTKExtensionsRenderingModule.h" // needed for export macro

class vtkTable;

class VTKPVVTKEXTENSIONSRENDERING_EXPORT vtkMarkSelectedRows : public vtkDataObjectAlgorithm
{
public:
  static vtkMarkSelectedRows* New();
  vtkTypeMacro(vtkMarkSelectedRows, vtkDataObjectAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent);

  //@{
  /**
   * Select the field to process. Only selection associated with the chosen
   * field are considered.
   * Accepted values are
   * \li vtkDataObject::FIELD_ASSOCIATION_POINTS,
   * \li vtkDataObject::FIELD_ASSOCIATION_CELLS,
   * \li vtkDataObject::FIELD_ASSOCIATION_NONE,
   * \li vtkDataObject::FIELD_ASSOCIATION_VERTICES,
   * \li vtkDataObject::FIELD_ASSOCIATION_EDGES,
   * \li vtkDataObject::FIELD_ASSOCIATION_ROWS
   * If value is vtkDataObject::FIELD_ASSOCIATION_NONE, then FieldData
   * associated with the input dataobject is extracted.
   */
  vtkSetMacro(FieldAssociation, int);
  vtkGetMacro(FieldAssociation, int);
  //@}

protected:
  vtkMarkSelectedRows();
  ~vtkMarkSelectedRows();

  virtual int FillInputPortInformation(int port, vtkInformation* info);
  virtual int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*);

  /**
   * Overridden to create a vtkTable or vtkMultiBlockDataSet as the output based
   * on  the input type.
   */
  virtual int RequestDataObject(vtkInformation*, vtkInformationVector**, vtkInformationVector*);

  /**
   * Operates on vtkTable instances. RequestData() handles composite datasets
   * by iterating over the leaves and calling this method.
   */
  int RequestDataInternal(vtkTable* input, vtkTable* extractedInput, vtkTable* output);

  int FieldAssociation;

private:
  vtkMarkSelectedRows(const vtkMarkSelectedRows&) VTK_DELETE_FUNCTION;
  void operator=(const vtkMarkSelectedRows&) VTK_DELETE_FUNCTION;
};

#endif
