/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkXMLPPolyDataWriter.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkXMLPPolyDataWriter - Write PVTK XML PolyData files.
// .SECTION Description
// vtkXMLPPolyDataWriter writes the PVTK XML PolyData file format.
// One poly data input can be written into a parallel file format with
// any number of pieces spread across files.  The standard extension
// for this writer's file format is "pvtp".  This writer uses
// vtkXMLPolyDataWriter to write the individual piece files.

// .SECTION See Also
// vtkXMLPolyDataWriter

#ifndef __vtkXMLPPolyDataWriter_h
#define __vtkXMLPPolyDataWriter_h

#include "vtkXMLPUnstructuredDataWriter.h"

class vtkPolyData;

class VTK_ALTIO_EXPORT vtkXMLPPolyDataWriter : public vtkXMLPUnstructuredDataWriter
{
public:
  static vtkXMLPPolyDataWriter* New();
  vtkTypeRevisionMacro(vtkXMLPPolyDataWriter,vtkXMLPUnstructuredDataWriter);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Get/Set the writer's input.
  void SetInput(vtkPolyData* input);
  vtkPolyData* GetInput();
  
  // Description:
  // Get the default file extension for files written by this writer.
  const char* GetDefaultFileExtension();
  
protected:
  vtkXMLPPolyDataWriter();
  ~vtkXMLPPolyDataWriter();
  
  const char* GetDataSetName();
  vtkXMLUnstructuredDataWriter* CreateUnstructuredPieceWriter(); 
  
private:
  vtkXMLPPolyDataWriter(const vtkXMLPPolyDataWriter&);  // Not implemented.
  void operator=(const vtkXMLPPolyDataWriter&);  // Not implemented.
};

#endif
