/*=========================================================================

  Program:   ParaView
  Module:    vtkPVImageChartRepresentation.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkPVImageChartRepresentation
 * @brief   representation for "Image Chart View".
 *
 * TODO LUCAS G.
 */

#ifndef vtkPVImageChartRepresentation_h
#define vtkPVImageChartRepresentation_h

#include "vtkChartRepresentation.h"
#include "vtkNew.h"

class vtkChartHistogram2D;
class vtkImageData;
class vtkScalarsToColors;

class VTKREMOTINGVIEWS_EXPORT vtkPVImageChartRepresentation : public vtkChartRepresentation
{
public:
  static vtkPVImageChartRepresentation* New();
  vtkTypeMacro(vtkPVImageChartRepresentation, vtkChartRepresentation);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * Set the input data arrays that this algorithm will process. Overridden to
   * pass the array selection to the mapper.
   */
  void SetInputArrayToProcess(
    int idx, int port, int connection, int fieldAssociation, const char* name) override;

  /**
   * Set visibility of the representation.
   */
  void SetVisibility(bool visible) override;

  /**
   * Provides access to the underlying VTK representation.
   */
  vtkChartHistogram2D* GetChart();

  //@{
  /**
   * Set/get the color to used for the points in the plot.
   */
  void SetLookupTable(vtkScalarsToColors* lut);
  //@}

protected:
  vtkPVImageChartRepresentation();
  ~vtkPVImageChartRepresentation() override;

  void PrepareForRendering() override;

  bool AddToView(vtkView* view) override;

  bool RemoveFromView(vtkView* view) override;

  vtkSmartPointer<vtkDataObject> ReduceDataToRoot(vtkDataObject* data) override;

private:
  vtkPVImageChartRepresentation(const vtkPVImageChartRepresentation&) = delete;
  void operator=(const vtkPVImageChartRepresentation&) = delete;

  vtkSmartPointer<vtkImageData> LocalGrid;

  vtkScalarsToColors* LookupTable;
};

#endif
