/*=========================================================================

  Program:   ParaView
  Module:    adiosCatalyst.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.adios.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include <catalyst.h>
#include <catalyst_api.h>
#include <catalyst_conduit.hpp>
#include <catalyst_conduit_blueprint.hpp>
#include <catalyst_stub.h>

#include <adios2.h>

#include "catalyst_impl_adios.h"

enum adios_catalyst_status
{
  adios_catalyst_status_invalid_node = 100,
  adios_catalyst_status_results = 101,
};
#define pvcatalyst_err(name) static_cast<enum catalyst_status>(adios_catalyst_status_##name)

//-----------------------------------------------------------------------------
enum catalyst_status catalyst_initialize_adios(const conduit_node* params)
{
  // TODO : here we simply should pass the pipeline script
  std::cout << "catalyst_status catalyst_initialize_adios(const conduit_node* params)\n";

  return catalyst_status_ok;
}

//-----------------------------------------------------------------------------
enum catalyst_status catalyst_execute_adios(const conduit_node* params)
{
  // TODO : wrap data part to the conduit node
  std::cout << "catalyst_status catalyst_execute_adios(const conduit_node* params)\n";
  
  return catalyst_status_ok;
}

//-----------------------------------------------------------------------------
enum catalyst_status catalyst_finalize_adios(const conduit_node* params)
{
  // TODO : cleanup all it should be done
  std::cout << "catalyst_status catalyst_finalize_adios(const conduit_node* params)\n";

  return catalyst_status_ok;
}

//-----------------------------------------------------------------------------
enum catalyst_status catalyst_about_adios(conduit_node* params)
{
  // TODO : get catlyst lib info
  std::cout << "catalyst_status catalyst_about_adios(conduit_node* params)\n";

  catalyst_status status = catalyst_stub_about(params);
  conduit_node_set_path_char8_str(params, "catalyst/implementation", "adios");

  return status;
}

//-----------------------------------------------------------------------------
enum catalyst_status catalyst_results_adios(conduit_node* params)
{
  // TODO : get the information here for the live visualization
  std::cout << "catalyst_status catalyst_results_adios(conduit_node* params)\n";

  return catalyst_status_ok;
}
