//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================

#include <vtkm/filter/geometry_refinement/Dual.h>
#include <vtkm/filter/geometry_refinement/worklet/Dual.h>

namespace
{
VTKM_CONT bool DoMapField(vtkm::cont::DataSet& result,
                          const vtkm::cont::Field& inputField)
{
return false;
}
} // anonymous namespace

namespace vtkm
{
namespace filter
{
namespace geometry_refinement
{
VTKM_CONT vtkm::cont::DataSet Dual::DoExecute(const vtkm::cont::DataSet& input)
{
  // Convert points to cells
  const vtkm::cont::UnknownCellSet& inCellSet = input.GetCellSet();
  const auto& oldCoords = input.GetCoordinateSystem().GetDataAsMultiplexer();

  vtkm::cont::ArrayHandle<vtkm::Vec3f> newCoords;
  vtkm::cont::CellSetExplicit<> newCellset;
  vtkm::worklet::Dual worklet;

  worklet.Run(inCellSet, oldCoords, newCoords, newCellset);

  auto mapper = [&](auto& result, const auto& f) { DoMapField(result, f); };

  vtkm::cont::CoordinateSystem activeCoordSystem = input.GetCoordinateSystem();
  activeCoordSystem = vtkm::cont::CoordinateSystem(activeCoordSystem.GetName(), newCoords);

  return this->CreateResultCoordinateSystem(input, newCellset, activeCoordSystem, mapper);

  // Assign point fields to cells and reciprocally
}
} // namespace geometry_refinement
} // namespace filter
} // namespace vtkm
