function(foreachTest result list_var_1 list_var_2 list_var_3)
    set(_options MUTE)
    set(_one_value_args)
    set(_multi_value_args)
    cmake_parse_arguments(PARSE_ARGV 3 _arg "${_options}" "${_one_value_args}" "${_multi_value_args}")

    set(_has_any_output FALSE)
    list(APPEND CMAKE_MESSAGE_INDENT "| ")
    foreach(num IN ZIP_LISTS ${list_var_1} ${list_var_2} ${list_var_3})
        foreach(i RANGE 2)
            if(NOT num_${i})
                set(num_${i} "[undefiend]")
            endif()
        endforeach()
        if(NOT _arg_MUTE)
            message(STATUS "${num_0}, ${num_1}, ${num_2}")
        endif()
        set(_has_any_output TRUE)
    endforeach()
    set(${result} ${_has_any_output} PARENT_SCOPE)
endfunction()

function(foreachTestDecorated list_var_1 list_var_2 list_var_3)
    list(APPEND CMAKE_MESSAGE_INDENT "  ")
    message(STATUS "Begin output")
    foreachTest(_has_any_output ${list_var_1} ${list_var_2} ${list_var_3})
    if(NOT _has_any_output)
        message(STATUS "--> empty-output <--")
    endif()
    message(STATUS "End output")
endfunction()

message(STATUS "foreach(IN ZIP_LISTS):")
list(APPEND CMAKE_MESSAGE_INDENT "  ")

set(english)
set(bahasa)
set(russian)

message(STATUS "<<< empty lists case >>>")
foreachTestDecorated(english bahasa russian)

list(APPEND english one two three)
list(APPEND bahasa satu dua tiga)
list(APPEND russian raz dva tri)

message(STATUS "<<< same lengths lists case >>>")
foreachTestDecorated(english bahasa russian)

list(APPEND bahasa empat)

message(STATUS "<<< different lengths lists case >>>")
foreachTestDecorated(english bahasa russian)

set(num_0 "old-0")
set(num_1 "old-1")
set(num_2 "old-2")
foreachTest(_ english bahasa russian MUTE)
set(check PASSED)
foreach(i RANGE 2)
    if(NOT "${num_${i}}" STREQUAL "old-${i}")
        message(SEND_ERROR "num_${i} value is corrupted")
        set(check FAILED)
    endif()
endforeach()
message(STATUS "<<< test variable value restored -- ${check} >>>")

list(POP_BACK CMAKE_MESSAGE_INDENT)
