/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCPackIFWCommon.h"

#include "cmCPackGenerator.h"
#include "cmCPackIFWGenerator.h"
#include "cmCPackLog.h" // IWYU pragma: keep
#include "cmSystemTools.h"
#include "cmTimestamp.h"
#include "cmVersionConfig.h"
#include "cmXMLWriter.h"

#include <sstream>

cmCPackIFWCommon::cmCPackIFWCommon()
  : Generator(CM_NULLPTR)
{
}

const char* cmCPackIFWCommon::GetOption(const std::string& op) const
{
  return Generator ? Generator->cmCPackGenerator::GetOption(op) : CM_NULLPTR;
}

bool cmCPackIFWCommon::IsOn(const std::string& op) const
{
  return Generator ? Generator->cmCPackGenerator::IsOn(op) : false;
}

bool cmCPackIFWCommon::IsSetToOff(const std::string& op) const
{
  return Generator ? Generator->cmCPackGenerator::IsSetToOff(op) : false;
}

bool cmCPackIFWCommon::IsSetToEmpty(const std::string& op) const
{
  return Generator ? Generator->cmCPackGenerator::IsSetToEmpty(op) : false;
}

bool cmCPackIFWCommon::IsVersionLess(const char* version)
{
  if (!Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_LESS, Generator->FrameworkVersion.data(), version);
}

bool cmCPackIFWCommon::IsVersionGreater(const char* version)
{
  if (!Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_GREATER, Generator->FrameworkVersion.data(), version);
}

bool cmCPackIFWCommon::IsVersionEqual(const char* version)
{
  if (!Generator) {
    return false;
  }

  return cmSystemTools::VersionCompare(
    cmSystemTools::OP_EQUAL, Generator->FrameworkVersion.data(), version);
}

void cmCPackIFWCommon::WriteGeneratedByToStrim(cmXMLWriter& xout)
{
  if (!Generator) {
    return;
  }

  std::ostringstream comment;
  comment << "Generated by CPack " << CMake_VERSION << " IFW generator "
          << "for QtIFW ";
  if (IsVersionEqual("1.9.9")) {
    comment << "less 2.0";
  } else {
    comment << Generator->FrameworkVersion;
  }
  comment << " tools at " << cmTimestamp().CurrentTime("", true);
  xout.Comment(comment.str().c_str());
}
