#ifndef SOFTMAX_LAYER_H
#define SOFTMAX_LAYER_H
#include "params.h"
#include "layer.h"

typedef layer softmax_layer;

void softmax_array(float *input, int n, float *output);
softmax_layer make_softmax_layer(int batch, int inputs, int groups);
void forward_softmax_layer(const softmax_layer l, network_state state);
void backward_softmax_layer(const softmax_layer l, network_state state);

#ifdef GPU
void pull_softmax_layer_output(const softmax_layer l);
void forward_softmax_layer_gpu(const softmax_layer l, network_state state);
void backward_softmax_layer_gpu(const softmax_layer l, network_state state);
#endif

#endif
