# DockerFile for ACT

The folder contains the docker file to build ACT with DIVA

## Dependencies
1. [Docker CE](https://docs.docker.com/install/linux/docker-ce/ubuntu/)
2. [Nvidia Docker 2](https://github.com/NVIDIA/nvidia-docker)

## Build
### ACT for Activity Detection
    nvidia-docker build -t act-stable -f Dockerfile.AD .
### ACT for Activity Object Detection
    nvidia-docker build -t act-aod-stable -f Dockerfile.AOD .

## Run The Container
### ACT for Activity Detection
    nvidia-docker run -ti --name act-ad \
          --mount type=bind,source=<path to activity-index directory>,target=/data \
          act-stable:latest
### ACT for Activity Object Detection
    nvidia-docker run -ti --name act-aod \
          --mount type=bind,source=<path to activity-index directory>,target=/data \
          act-aod-stable:latest

### Note: modify the source in --mount to the directory with activity-index.json.


### Note: Further instructions related to virat based experiments are available in virat-act-detector-scripts on kitware/master.
