// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
// This test verifies that dynamic scene (vary number of objects)
// contents work acceptably
//
// The command line arguments are:
// -I        => run in interactive mode; unless this is used, the program will
//              not allow interaction and exit

// TODO: test broken by pre SC15 ospray caching

#include "vtkActor.h"
#include "vtkCamera.h"
#include "vtkOSPRayPass.h"
#include "vtkOSPRayRendererNode.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkSphereSource.h"

#include <map>

#include <iostream>

int TestOSPRayDynamicScene(int argc, char* argv[])
{
  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  vtkSmartPointer<vtkRenderWindow> renWin = vtkSmartPointer<vtkRenderWindow>::New();
  iren->SetRenderWindow(renWin);
  vtkSmartPointer<vtkRenderer> renderer = vtkSmartPointer<vtkRenderer>::New();
  renWin->AddRenderer(renderer);
  renderer->SetBackground(0.0, 0.0, 0.0);
  renWin->SetSize(400, 400);
  renWin->Render();

  vtkSmartPointer<vtkOSPRayPass> ospray = vtkSmartPointer<vtkOSPRayPass>::New();
  renderer->SetPass(ospray);

  for (int i = 0; i < argc; ++i)
  {
    if (!strcmp(argv[i], "--OptiX"))
    {
      vtkOSPRayRendererNode::SetRendererType("optix pathtracer", renderer);
      break;
    }
  }

#define GRIDDIM 3
  vtkSmartPointer<vtkCamera> camera = vtkSmartPointer<vtkCamera>::New();
  camera->SetPosition(GRIDDIM * 3, GRIDDIM * 3, GRIDDIM * 4);
  renderer->SetActiveCamera(camera);

  std::cerr << "ADD" << std::endl;
  std::map<int, vtkActor*> actors;
  for (int i = 0; i < GRIDDIM; i++)
  {
    for (int j = 0; j < GRIDDIM; j++)
    {
      for (int k = 0; k < GRIDDIM; k++)
      {
        vtkSmartPointer<vtkSphereSource> sphere = vtkSmartPointer<vtkSphereSource>::New();
        sphere->SetCenter(i, j, k);
        sphere->SetPhiResolution(10);
        sphere->SetThetaResolution(10);
        vtkSmartPointer<vtkPolyDataMapper> mapper = vtkSmartPointer<vtkPolyDataMapper>::New();
        mapper->SetInputConnection(sphere->GetOutputPort());
        vtkActor* actor = vtkActor::New();
        renderer->AddActor(actor);
        actor->SetMapper(mapper);
        actors[i * GRIDDIM * GRIDDIM + j * GRIDDIM + k] = actor;
        renWin->Render();
      }
    }
  }

  std::cerr << "HIDE" << std::endl;
  for (int i = 0; i < GRIDDIM; i++)
  {
    for (int j = 0; j < GRIDDIM; j++)
    {
      for (int k = 0; k < GRIDDIM; k++)
      {
        vtkActor* actor = actors[i * GRIDDIM * GRIDDIM + j * GRIDDIM + k];
        actor->VisibilityOff();
        renWin->Render();
      }
    }
  }

  std::cerr << "SHOW" << std::endl;
  for (int i = 0; i < GRIDDIM; i++)
  {
    for (int j = 0; j < GRIDDIM; j++)
    {
      for (int k = 0; k < GRIDDIM; k++)
      {
        vtkActor* actor = actors[i * GRIDDIM * GRIDDIM + j * GRIDDIM + k];
        actor->VisibilityOn();
        renWin->Render();
      }
    }
  }

  std::cerr << "REMOVE" << std::endl;
  for (int i = 0; i < GRIDDIM; i++)
  {
    for (int j = 0; j < GRIDDIM; j++)
    {
      for (int k = 0; k < GRIDDIM; k++)
      {
        vtkActor* actor = actors[i * GRIDDIM * GRIDDIM + j * GRIDDIM + k];
        // leaving one to have a decent image to compare against
        bool killme = !(i == 0 && j == 1 && k == 0);
        if (killme)
        {
          renderer->RemoveActor(actor);
          actor->Delete();
          renWin->Render();
        }
      }
    }
  }

  iren->Start();

  renderer->RemoveActor(actors[0 * GRIDDIM * GRIDDIM + 1 * GRIDDIM + 0]);
  actors[0 * GRIDDIM * GRIDDIM + 1 * GRIDDIM + 0]->Delete();

  return 0;
}
