//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
#ifndef vtk_m_exec_internal_WorkletInvokeFunctor_h
#define vtk_m_exec_internal_WorkletInvokeFunctor_h

#include <vtkm/exec/internal/ErrorMessageBuffer.h>
#include <vtkm/exec/internal/WorkletInvokeFunctorDetail.h>

namespace vtkm
{
namespace exec
{
namespace internal
{

template <typename WorkletType>
struct WorkletInvokeFunctor
{
  WorkletType Worklet;

  WorkletInvokeFunctor(const WorkletType& worklet)
    : Worklet(worklet)
  {
  }

  template <typename IndexType, typename InvocationType>
  VTKM_EXEC void operator()(IndexType&& index,
                            InvocationType&& invocation,
                            vtkm::Id globalIndexOffset) const
  {
    vtkm::exec::internal::detail::DoWorkletInvokeFunctor(
      this->Worklet,
      std::forward<InvocationType>(invocation),
      this->Worklet.GetThreadIndices(std::forward<IndexType>(index),
                                     invocation.OutputToInputMap,
                                     invocation.VisitArray,
                                     invocation.ThreadToOutputMap,
                                     invocation.GetInputDomain(),
                                     globalIndexOffset));
  }

  VTKM_CONT void SetErrorMessageBuffer(const vtkm::exec::internal::ErrorMessageBuffer& buffer)
  {
    this->Worklet.SetErrorMessageBuffer(buffer);
  }
};
}
}
} // namespace vtkm::exec::internal

#endif //vtk_m_exec_internal_WorkletInvokeFunctor_h
