#!/usr/bin/env bash

echo "---------- BEGIN PVSERVER LAUNCHER ----------"
date +"%F %T"
echo "---------------------------------------------"

source "${BASE_DIR}/../Common/pvserver_jobsub.functions"
source "${CONF_PATH}"

if [ -n "${PARAVIEW_MODULE_DIRS}" ]; then
    for path in ${PARAVIEW_MODULE_DIRS}; do
        module use ${path}
    done
fi

# ParaView client has the ability to launch a server with a different patch number
if [[ -v PV_VERSION_PATCH && "$PV_VERSION_PATCH" != "CLIENT" ]]; then
    PV_VERSION_FULL=${PV_VERSION}.${PV_VERSION_PATCH}
fi

# ParaView version >= 6 uses the same build for EGL/OSMesa and specifies which to
# use with --opengl-window-backend
# HEADLESS_API is also used on frontier to specify the separate builds for vtkm: rocm or none
# in this case the headless API is always OSMesa.
PV_VERSION_MAJOR="${PV_VERSION_FULL%%.*}"
if [[ ${PV_VERSION_MAJOR} -lt 6 ]]; then
    HEADLESS_API_PARAM=
else
    if [[ -v HEADLESS_API_COMPUTE && ${HEADLESS_API_COMPUTE} -eq 1 ]]; then
        HEADLESS_API_PARAM="--opengl-window-backend OSMesa"
    else
        case $HEADLESS_API in
            "egl")
                BACKEND="EGL"
                ;;
            "osmesa")
                BACKEND="OSMesa"
                ;;
            *)
                echo "Invalid opengl-window-backend $HEADLESS_API"
                BACKEND="Invalid"
                ;;
        esac
        HEADLESS_API_PARAM="--opengl-window-backend $BACKEND"
        # one build for EGL and OSMesa
        HEADLESS_API=none
    fi
fi


if false ; then
if [ "$HEADLESS_API" == "none" ]; then
    if ! module load "paraview/${PV_VERSION_FULL}"; then
        echo "Module does not exist: paraview/${PV_VERSION_FULL}"
        exit 1
    fi
else
    if ! module load "paraview/${PV_VERSION_FULL}-${HEADLESS_API}"; then
        echo "Module does not exist: paraview/${PV_VERSION_FULL}-${HEADLESS_API}"
        exit 1
    fi
fi
# good for debugging
module list
else
#set -x
paraview_install_dir=${BASE_DIR}/../../paraview-v${PV_VERSION_FULL}/install
export PATH=$paraview_install_dir/bin:$PATH
echo $PATH
module load Core/25.04
module load gcc/9.3.0
module load openmpi/4.0.4
module list
fi

if ! setup_tunnel_socat ${SUB_IF} ${PV_SERVER_HOST} ${PV_SERVER_PORT} .paraview/pvserver-socat-launch.log
then
  echo "Failed to setup tunnel on submission host"
  exit 1
fi
export PV_SERVER_HOST=${IP}
echo "Setting ${THREADS_PER_CORE} threads per process"

if [ "${DRIVER}" = "swr" ]
then
  export GALLIUM_DRIVER=swr
  export KNOB_MAX_WORKER_THREADS=${THREADS_PER_CORE}
else
  export GALLIUM_DRIVER=llvmpipe
  export LP_NUM_THREADS=${THREADS_PER_CORE}
fi
export OSPRAY_THREADS=${THREADS_PER_CORE}
export OMP_NUM_THREADS=${THREADS_PER_CORE}
export KMP_NUM_THREADS=${THREADS_PER_CORE}

exec_pvserver
