## Introducing ANARI rendering integration in ParaView

This change introduces ANARI rendering in ParaView and a dynamic
properties feature used to generate user interface based on JSON
properties description generated by each ANARI renderer.

To access, enable the CMake configure time option `PARAVIEW_ENABLE_RAYTRACING`
and `PARAVIEW_ENABLE_ANARI`. That would automatically enable the `vtkRenderingRayTracing`
and `vtkRenderingAnari` modules.

![ANARI integration](anari_in_paraview.png)

The current integration uses a simple approach to delegate ray-traced rendering
to ANARI. The `Properties Panel` presents the user with a choice between the
original `Enable Ray Tracing` (with OSPRay) and `Enable Rendering with ANARI`.

When that option is checked, the panel presents the user with a list of
options dynamically generated for each renderer including:

- ANARI Library: A choice between `visrtx`, `helide`, and `environment`. The
last option uses the library set using the environment variable
`ANARI_LIBRARY`.
- Renderers: Depend on the library chosen. For example following renderers are available when using the visrtx library:
    - `default`: The default renderer for the ANARI library.
    - `ao`: The `ao` (Ambient occlusion) renderer.
    - `dpt`: The `dpt` (Directional path tracing) renderer.
    - `debug`: The debug renderer
- Additional properties: depend on the renderer chosen.
