/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.AbstractScene;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLLayerSetNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLScene;

class ReplaceWorldVRMLScene
extends AbstractScene
implements VRMLScene {
    private VRMLLayerSetNodeType layerSet;
    private HashSet routeSet;
    private HashMap exportMap;
    private VRMLProtoDeclare firstProto;
    private HashMap protos = new HashMap();
    private HashMap externprotos = new HashMap();

    public ReplaceWorldVRMLScene(int n, int n2, VRMLNodeType vRMLNodeType, String string) {
        super(n, n2);
        this.routeSet = new HashSet();
        this.setRootNode(vRMLNodeType);
        this.setWorldRootURL(string);
    }

    public VRMLProtoDeclare getFirstProto() {
        return this.firstProto;
    }

    public VRMLLayerSetNodeType getFirstLayerSet() {
        return this.layerSet;
    }

    public Map getProtos() {
        return this.protos;
    }

    public Map getExternProtos() {
        return this.externprotos;
    }

    public Map getExports() {
        return this.exportMap;
    }

    public void addNode(VRMLNode vRMLNode) {
        int n;
        super.addNode(vRMLNode);
        if (this.layerSet == null && (n = vRMLNode.getPrimaryType()) == 90) {
            this.layerSet = (VRMLLayerSetNodeType)vRMLNode;
        }
    }

    public void removeNode(VRMLNode vRMLNode) {
        super.removeNode(vRMLNode);
        if (vRMLNode == this.layerSet) {
            ArrayList arrayList = this.getByPrimaryType(90);
            this.layerSet = arrayList.size() == 0 ? null : (VRMLLayerSetNodeType)arrayList.get(0);
        }
    }

    public void setMetaData(SceneMetaData sceneMetaData) {
        this.metaData = sceneMetaData;
    }

    public void addRoute(ROUTE rOUTE) {
        if (rOUTE != null && !this.routeSet.contains(rOUTE)) {
            this.routeSet.add(rOUTE);
            this.routeList.add(rOUTE);
        }
    }

    public void removeRoute(ROUTE rOUTE) {
        this.routeList.remove(rOUTE);
        this.routeSet.remove(rOUTE);
    }

    public void addProto(VRMLProtoDeclare vRMLProtoDeclare) {
        if (vRMLProtoDeclare != null) {
            this.protos.put(vRMLProtoDeclare.getVRMLNodeName(), vRMLProtoDeclare);
            if (this.firstProto == null) {
                this.firstProto = vRMLProtoDeclare;
            }
        }
    }

    public void removeProto(VRMLProtoDeclare vRMLProtoDeclare) {
        if (this.firstProto == vRMLProtoDeclare) {
            this.firstProto = null;
        }
        this.protos.remove(vRMLProtoDeclare.getVRMLNodeName());
    }

    public VRMLProtoDeclare getProto(String string) {
        return (VRMLProtoDeclare)this.protos.get(string);
    }

    public void addExternProto(VRMLExternProtoDeclare vRMLExternProtoDeclare) {
        if (vRMLExternProtoDeclare != null) {
            this.externprotos.put(vRMLExternProtoDeclare.getVRMLNodeName(), vRMLExternProtoDeclare);
        }
    }

    public void removeExternProto(VRMLExternProtoDeclare vRMLExternProtoDeclare) {
        this.externprotos.remove(vRMLExternProtoDeclare.getVRMLNodeName());
    }

    public VRMLExternProtoDeclare getExternProto(String string) {
        return (VRMLExternProtoDeclare)this.externprotos.get(string);
    }
}

