import h5py as h5
import generate_poly_data as gpd
import generate_unstructured_grid as gud
import generate_image_data as gid
import sys

# -----------------------------------------------------------------
def generate_temporal_composite_dataset():
  f = h5.File('composite_temporal2.vtkhdf', 'w')

  if len(sys.argv) != 2:
    print("usage: python temporal_composite.py vtk external data dir")
    exit(1)

  # Generate the root content which will have the Version and Type attributes
  root = f.create_group('VTKHDF', track_order=True)
  root.attrs['Version'] = (2,1)
  ascii_type = 'PartitionedDataSetCollection'.encode('ascii')
  root.attrs.create('Type', ascii_type, dtype=h5.string_dtype('ascii', len(ascii_type)))

  # Poly data
  # blockPD = root.create_group('blockPD')
  with h5.File(f'{sys.argv[1]}/Testing/Data/test_transient_poly_data.hdf','r') as pd:
    pd.copy(pd['VTKHDF'], root, "blockPD")

  # Unstructured Grid
  with h5.File(f'{sys.argv[1]}/Testing/Data/transient_sphere.hdf','r') as ug:
    ug.copy(ug['VTKHDF'], root, "blockUG")

  # Image Data
  with h5.File(f'{sys.argv[1]}/Testing/Data/transient_wavelet.hdf','r') as id:
    id.copy(id['VTKHDF'], root, "blockID")


  # Assembly
  assembly = root.create_group('Assembly', track_order=True)
  assembly["block0/blockPD"] = h5.SoftLink("/VTKHDF/blockPD")
  assembly["block0/blockPD"].attrs['Index'] = 0

  group0 = assembly.create_group('groupName0', track_order=True)
  group0.attrs['Index'] = 1
  group0["block1/blockUG"] = h5.SoftLink("/VTKHDF/blockUG")
  group0["block1/blockUG"].attrs['Index'] = 1

  assembly["block2/blockID"] = h5.SoftLink("/VTKHDF/blockID")
  assembly["block2/blockID"].attrs['Index'] = 2
  f.close()


# -----------------------------------------------------------------
if __name__ == "__main__":
  generate_temporal_composite_dataset()
