from src.animtovtkhdf import AnimToVTKHDF
from vtkmodules.vtkIOHDF import vtkHDFReader


def test_sph():
    filename = "testing/data/ImpactA048"
    output_filename = "testing/data/impact.vtkhdf"
    AnimToVTKHDF(verbose=False, static=False).convert([filename], output_filename)

    reader = vtkHDFReader()
    reader.SetFileName(output_filename)
    reader.Update()

    mesh = reader.GetOutputDataObject(0)

    sph_part = mesh.GetPartition(3,0)

    assert sph_part.GetNumberOfPoints() == 15000
    assert sph_part.GetNumberOfCells() == 15000


