from src.animtovtkhdf import AnimToVTKHDF
from vtkmodules.vtkIOHDF import vtkHDFReader


def test_read_and_write():
    filenames = ["testing/data/cube_TYPE7A001","testing/data/cube_TYPE7A684"]
    filename_vtkhdf = f"{filenames[0]}.vtkhdf"
    AnimToVTKHDF(verbose=True, static=True).convert(filenames, filename_vtkhdf)
    reader = vtkHDFReader()
    reader.SetFileName(filename_vtkhdf)
    reader.Update()
    
    assert reader.GetNumberOfSteps() == 2
    assert reader.GetStep() == 0

    mesh = reader.GetOutputDataObject(0)
    NB_PARTS = 5
    assert mesh.GetNumberOfPartitionedDataSets() == NB_PARTS

    for part in range(NB_PARTS):
        assert mesh.GetNumberOfPartitions(part) == 1

    quads = mesh.GetPartition(0, 0)
    assert quads.GetNumberOfCells() == 20
    assert quads.GetNumberOfPoints() == 45

    hexa1 = mesh.GetPartition(1, 0)
    assert hexa1.GetNumberOfCells() == 12
    assert hexa1.GetNumberOfPoints() == 52
    
    pd = hexa1.GetPointData()
    assert pd.GetNumberOfArrays() == 3
    assert pd.GetArrayName(0) == "NODE_ID"
    assert pd.GetArrayName(1) == "Velocity"
    assert pd.GetArrayName(2) == "Contact Forces"
    assert pd.GetArray(0).GetNumberOfTuples() == 52
    
    cd = hexa1.GetCellData()
    assert cd.GetNumberOfArrays() == 5
    assert cd.GetArrayName(0) == "Plastic Strain_3D"
    assert cd.GetArrayName(1) == "Stress_3D"
    assert cd.GetArrayName(2) == "Erosion_status"
    assert cd.GetArrayName(3) == "Part_ID"
    assert cd.GetArrayName(4) == "Element_ID"
    assert cd.GetArray(0).GetNumberOfTuples() == 12    
    
    hexa2 = mesh.GetPartition(2, 0)
    assert hexa2.GetNumberOfCells() == 8
    assert hexa2.GetNumberOfPoints() == 27
    
    hexa3 = mesh.GetPartition(3, 0)
    assert hexa3.GetNumberOfCells() == 19
    assert hexa3.GetNumberOfPoints() == 80
    
    lines = mesh.GetPartition(4, 0)
    assert lines.GetNumberOfCells() == 45
    assert lines.GetNumberOfPoints() == 46
    
    reader.SetStep(1)
    mesh2 = reader.GetOutputDataObject(0)
    assert mesh2.GetNumberOfPoints() == mesh.GetNumberOfPoints()
    assert mesh2.GetNumberOfCells() == mesh.GetNumberOfCells()
    assert mesh2.GetNumberOfPartitionedDataSets() == mesh.GetNumberOfPartitionedDataSets()
    
